<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onlabellist() {
		$this->powercheck(183, 184);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}
		$db_table = db_prefix . 'bbs_label';

		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? ($this->CON['is_alonelng'] && !empty($this->CON['home_lng'])) ? $this->CON['home_lng'] : $this->CON['default_lng'] : $lng;
		if (!empty($lng)) {
			$db_where = ' WHERE lng=\'' . $lng . '\'';
		} else {
			$db_where = ' WHERE lng=\'' . $this->CON['default_lng'] . '\'';
		}
		$isclass = intval($this->fun->accept('isclass', 'R'));
		if (!empty($isclass)) {
			if ($isclass == 2) $isclass = 0;
			$db_where.=' AND isclass=' . $isclass;
		}

		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}

		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'blid' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;

		$sql = 'SELECT blid,pid,lng,isclass,labelname FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$array[] = $rsList;
		}
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$this->ectemplates->display('forum/forum_label_list');
	}

	function onlabeladd() {
		$this->powercheck(183, 185);
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->display('forum/forum_label_add');
	}

	function onlabeledit() {
		$this->powercheck(183, 190);
		parent::start_template();
		$db_table = db_prefix . 'bbs_label';
		$type = $this->fun->accept('type', 'G');
		$blid = intval($this->fun->accept('blid', 'G'));
		$db_where = 'blid=' . $blid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
		$this->ectemplates->assign('tab', 'true');
		$this->ectemplates->assign('read', $read);
		$this->ectemplates->assign('type', $type);
		$this->ectemplates->display('forum/forum_label_edit');
	}

	function onsave() {
		parent::start_template();
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$labelname = $this->fun->accept('labelname', 'P');
		$db_table = db_prefix . 'bbs_label';
		$date = time();
		if ($inputclass == 'add') {
			$this->powercheck(183, 185);
			$db_field = 'pid,lng,isclass,labelname';
			$db_values = "50,'$lng',1,'$labelname'";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['forumlabel_add_log'], $this->lng['log_extra_ok'] . ' labelname=' . $labelname);
			$this->dbcache->clearcache('bbs_label_array_' . $lng, true);
			exit('true');
		} elseif ($inputclass == 'edit') {
			$this->powercheck(183, 190);
			$blid = $this->fun->accept('blid', 'P');
			$db_where = 'blid=' . $blid;
			$db_set = "labelname='$labelname'";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['forumlabel_edit_log'], $this->lng['log_extra_ok'] . ' labelname=' . $labelname . ' blid=' . $blid);
			$this->dbcache->clearcache('bbs_label_array_' . $lng, true);
			exit('true');
		}
	}

	function ondel() {
		$this->powercheck(183, 191);
		$db_table = db_prefix . 'bbs_label';
		$selectinfoid = $this->fun->accept('selectinfoid', 'P');
		if (empty($selectinfoid)) exit('false');
		$infoarray = explode(',', $selectinfoid);
		$count = count($infoarray) - 1;
		if ($count <= 0) exit('false');
		for ($i = 0; $i < $count; $i++) {
			$db_where = "blid=$infoarray[$i]";
			$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		}
		$this->writelog($this->lng['forumlabel_del_log'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		$this->dbcache->clearcache('forumlabel_array', true);
		exit('true');
	}

	function onsort() {
		$this->powercheck(183, 192);
		$db_table = db_prefix . 'bbs_label';
		$id = $this->fun->accept('infoid', 'P');
		$pid = $this->fun->accept('pid', 'P');
		$idArray = explode(',', $id);
		$pidArray = explode(',', $pid);
		foreach ($idArray as $key => $value) {
			if (!empty($value)) {
				$db_where = "blid=$value";
				$pid = intval($pidArray[$key]);
				$db_set = "pid=$pid";
				$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			}
		}
		$this->writelog($this->lng['forumlabel_sort_log'], $this->lng['log_extra_ok']);
		$this->dbcache->clearcache('bbs_label_array', true);
		exit('true');
	}

	function onsetting() {
		$this->powercheck(183, 190);
		$db_table = db_prefix . 'bbs_label';
		$selectinfoid = $this->fun->accept('selectinfoid', 'P');
		$selectinfoid = $selectinfoid . '0';
		if (empty($selectinfoid)) exit('false');
		$value = $this->fun->accept('value', 'P');
		$dbname = $this->fun->accept('dbname', 'P');
		$db_set = "$dbname=$value";
		$db_where = "blid IN ( $selectinfoid )";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$this->writelog($this->lng['forumlabel_istype_log'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		$this->dbcache->clearcache('bbs_typelist', true);
		exit('true');
	}

}
?>