<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onforumtypelist() {
		$this->powercheck(180, 181);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}
		$db_table = db_prefix . 'bbs_typelist';

		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? ($this->CON['is_alonelng'] && !empty($this->CON['home_lng'])) ? $this->CON['home_lng'] : $this->CON['default_lng'] : $lng;
		if (!empty($lng)) {
			$db_where = ' WHERE lng=\'' . $lng . '\'';
		} else {
			$db_where = ' WHERE lng=\'' . $this->CON['default_lng'] . '\'';
		}
		$purview = $this->fun->accept('purview', 'R');
		if (!empty($purview)) {
			$db_where.=' AND purview=' . $purview;
		}
		$isclass = intval($this->fun->accept('isclass', 'R'));
		if (!empty($isclass)) {
			if ($isclass == 2) $isclass = 0;
			$db_where.=' AND isclass=' . $isclass;
		}

		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}

		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'btid' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;

		$sql = 'SELECT btid,pid,lng,typename,content,purview,isclass,addtime FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$puvname = $this->get_member_purview($rsList['purview'], 'rankname');
			$rsList['puvname'] = empty($puvname) ? $this->lng['puv_no'] : $puvname;
			$array[] = $rsList;
		}
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$this->ectemplates->display('forum/forum_type_list');
	}

	function onforumtypeadd() {
		$this->powercheck(180, 182);
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);

		$memberpuv = $this->get_member_purview_array();
		$this->ectemplates->assign('memberpuvlist', $memberpuv['list']);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->display('forum/forum_type_add');
	}

	function onforumtypeedit() {
		$this->powercheck(180, 188);
		parent::start_template();
		$db_table = db_prefix . 'bbs_typelist';
		$btid = intval($this->fun->accept('btid', 'G'));
		$db_where = 'btid=' . $btid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);

		$memberpuv = $this->get_member_purview_array($read['purview']);
		$this->ectemplates->assign('memberpuvlist', $memberpuv['list']);
		$this->ectemplates->assign('tab', 'true');
		$this->ectemplates->assign('read', $read);
		$this->ectemplates->display('forum/forum_type_edit');
	}

	function onsave() {
		parent::start_template();
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		$typename = $this->fun->accept('typename', 'P');
		$content = $this->fun->accept('content', 'P');
		$purview = $this->fun->accept('purview', 'P');
		$db_table = db_prefix . 'bbs_typelist';
		$date = time();
		if ($inputclass == 'add') {
			$this->powercheck(180, 182);
			$db_field = 'pid,lng,typename,content,purview,isclass,addtime';
			$db_values = "50,'$lng','$typename','$content',$purview,1,$date";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['forumtype_add_log'], $this->lng['log_extra_ok'] . ' typename=' . $typename);
			$this->dbcache->clearcache('bbs_typelist_array_' . $lng, true);
			exit('true');
		} elseif ($inputclass == 'edit') {
			$this->powercheck(180, 188);
			$btid = $this->fun->accept('btid', 'P');
			$db_where = 'btid=' . $btid;
			$db_set = "typename='$typename',content='$content',purview=$purview";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['forumtype_edit_log'], $this->lng['log_extra_ok'] . ' typename=' . $typename . ' id=' . $btid);
			$this->dbcache->clearcache('bbs_typelist_view_' . $btid, true);
			$this->dbcache->clearcache('bbs_typelist_array_' . $lng, true);
			exit('true');
		}
	}

	function ondel() {
		$this->powercheck(180, 187);

		$db_table = db_prefix . 'bbs_typelist';
		$db_table2 = db_prefix . 'bbs';
		$db_table3 = db_prefix . 'bbs_content';
		$btid = $this->fun->accept('btid', 'R');
		if (empty($btid)) exit('false');
		$db_where = 'btid=' . $btid;
		$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);

		$sql = 'SELECT bid FROM ' . $db_table2 . ' WHERE ' . $db_where;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$this->dbcache->clearcache('bbs_view_' . $rsList['bid'], true);
			$this->dbcache->clearcache('bbs_array_' . $rsList['bid'], true);
		}
		$this->db->query('DELETE FROM ' . $db_table3 . ' WHERE ' . $db_where);
		$this->db->query('DELETE FROM ' . $db_table2 . ' WHERE ' . $db_where);
		$this->writelog($this->lng['forumtype_del_log'], $this->lng['log_extra_ok'] . ' id=' . $btid);
		$this->dbcache->clearcache('bbs_list_array_' . $btid, true);
		$this->dbcache->clearcache('bbs_typelist_view_' . $btid, true);
		$this->dbcache->clearcache('bbs_typelist_array', true);
		exit('true');
	}

	function onsort() {
		$this->powercheck(180, 186);
		$db_table = db_prefix . 'bbs_typelist';
		$id = $this->fun->accept('infoid', 'P');
		$pid = $this->fun->accept('pid', 'P');
		$idArray = explode(',', $id);
		$pidArray = explode(',', $pid);
		foreach ($idArray as $key => $value) {
			if (!empty($value)) {
				$db_where = "btid=$value";
				$pid = intval($pidArray[$key]);
				$db_set = "pid=$pid";
				$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
				$this->dbcache->clearcache('bbs_typelist_view_' . $value, true);
			}
		}
		$this->writelog($this->lng['forumtype_log_sort'], $this->lng['log_extra_ok']);
		$this->dbcache->clearcache('bbs_typelist_array', true);
		exit('true');
	}

	function onsetting() {
		$this->powercheck(180, 189);
		$db_table = db_prefix . 'bbs_typelist';
		$selectinfoid = $this->fun->accept('selectinfoid', 'P');
		$selectinfoid = $selectinfoid . '0';
		if (empty($selectinfoid)) exit('false');
		$value = $this->fun->accept('value', 'P');
		$dbname = $this->fun->accept('dbname', 'P');
		$db_set = "$dbname=$value";
		$db_where = "btid IN ( $selectinfoid )";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$this->writelog($this->lng['forumtype_log_istype'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		$this->dbcache->clearcache('bbs_typelist', true);
		exit('true');
	}

}
?>