<?php
/**
 * 邮件发送类 ,邮件发送模板 ***_templates 表
 * @author hcflyy
 *
 */
class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onemailtemplatelist() {
		$this->powercheck(201, 202);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}
		$lng = $this->fun->accept('lng', 'R');
		if (!empty($lng)) {
			$db_where = ' WHERE styleclass=3 and lng=\'' . $lng . '\'';
		} else {
			$db_where = ' WHERE styleclass=3 and lng=\'' . $this->CON['default_lng'] . '\'';
		}
		$typeclass = $this->fun->accept('typeclass', 'R');
		if (!empty($typeclass)) {
			$db_where.=" AND typeclass='$typeclass'";
		}
		$fileclass = $this->fun->accept('fileclass', 'R');
		if (!empty($fileclass)) {
			$db_where.=" AND fileclass='$fileclass'";
		}
		$lockin = $this->fun->accept('lockin', 'R');
		if (!empty($lockin)) {
			if ($lockin == 2) $lockin = 0;
			$db_where.=' AND lockin=' . $lockin;
		}

		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'tmid' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;
		$db_table = db_prefix . 'templates';
		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}
		$sql = 'SELECT tmid,lng,templatename,templatecode,title,pic,typeclass,fileclass,styleclass,lockin,addtime FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$array[] = $rsList;
		}
		$this->fun->setcookie($this->fun->noncefile() . 'pgid', $page_id, 600);
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$this->ectemplates->display('template/mailtemplate_list');
	}

	function onmailtemplateadd() {
		$this->powercheck(201, 220);
		include_once admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		include_once admin_ROOT . adminfile . '/include/inc_formtypelist.php';
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);

		$typeclass = array();
		foreach ($MAILTEMPLATETYPE as $key => $value) {
			$typeclassname = $this->lng[$value['name']];
			$typeclass[$key]['key'] = $value['key'];
			$typeclass[$key]['name'] = $typeclassname;
		}
		$this->ectemplates->assign('typeclass', $typeclass);
		$this->ectemplates->assign('order', $replacemail);
		$this->ectemplates->assign('member', $member_replacemail);
		$this->ectemplates->assign('bbs', $bbs_replacemail);
		$this->ectemplates->assign('form', $form_replacemail);
		$this->ectemplates->assign('public', $public_replacemail);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->display('template/mailtemplate_add');
	}

	function onmailtemplateedit() {
		$this->powercheck(201, 222);
		include_once admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		include_once admin_ROOT . adminfile . '/include/inc_formtypelist.php';
		parent::start_template();
		$db_table = db_prefix . 'templates';
		$tmid = intval($this->fun->accept('tmid', 'G'));
		$type = $this->fun->accept('type', 'G');
		$db_where = 'tmid=' . $tmid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);

		$typeclass = array();
		foreach ($MAILTEMPLATETYPE as $key => $value) {
			$typeclassname = $this->lng[$value['name']];
			$typeclass[$key]['key'] = $value['key'];
			$typeclass[$key]['name'] = $typeclassname;
			$typeclass[$key]['selected'] = $read['typeclass'] == $value['key'] ? 'selected' : '';
		}
		$lnglist = $this->get_lng_array($read['lng']);
		$this->ectemplates->assign('lnglist', $lnglist['list']);
		$this->ectemplates->assign('typeclass', $typeclass);
		$this->ectemplates->assign('order', $replacemail);
		$this->ectemplates->assign('member', $member_replacemail);
		$this->ectemplates->assign('bbs', $bbs_replacemail);
		$this->ectemplates->assign('form', $form_replacemail);
		$this->ectemplates->assign('public', $public_replacemail);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->assign('read', $read);
		$tempfile = $type == 'edit' ? 'template/mailtemplate_edit' : 'template/mailtemplate_copy';
		$this->ectemplates->display($tempfile);
	}

	function onsave() {
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$templatename = $this->fun->accept('templatename', 'P');
		$templatecontent = $this->fun->accept('content', 'P');
		if (empty($templatecontent)) {
			exit('false');
		}
		$title = $this->fun->accept('title', 'P');
		$templatecode = $this->fun->accept('templatecode', 'P');
		$typeclass = $this->fun->accept('typeclass', 'P');
		$styleclass = $this->fun->accept('styleclass', 'P');
		$db_table = db_prefix . 'templates';
		$date = time();
		if ($inputclass == 'add') {
			$this->powercheck(201, 220);
			$db_field = 'lng,templatename,templatecode,title,templatecontent,pic,typeclass,fileclass,styleclass,lockin,addtime';
			$db_values = "'$lng','$templatename','$templatecode','$title','$templatecontent','$pic','$typeclass','$fileclass',$styleclass,0,$date";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['mailtemplatemain_add_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			$this->dbcache->clearcache('templates_array_' . $lng . '_' . $styleclass, true);
			exit('true');
		} elseif ($inputclass == 'edit') {
			$this->powercheck(201, 222);
			$tmid = $this->fun->accept('tmid', 'P');
			$db_where = 'tmid=' . $tmid;
			$db_set = "templatename='$templatename',title='$title',templatecontent='$templatecontent'";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['mailtemplatemain_edit_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			$this->dbcache->clearcache('templates_view_' . $tmid, true);
			$this->dbcache->clearcache('templates_array_' . $lng . '_' . $styleclass, true);
			exit('true');
		} elseif ($inputclass == 'copy') {
			$this->powercheck(201, 224);
			$db_field = 'lng,templatename,templatecode,title,templatecontent,pic,typeclass,fileclass,styleclass,lockin,addtime';
			$db_values = "'$lng','$templatename','$templatecode','$title','$templatecontent','$pic','$typeclass','$fileclass',$styleclass,0,$date";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['mailtemplatemain_copy_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			$this->dbcache->clearcache('templates_array_' . $lng . '_' . $styleclass, true);
			exit('true');
		}
	}

	function ondel() {
		$this->powercheck(201, 223);
		$db_table = db_prefix . 'templates';
		$tmid = $this->fun->accept('tmid', 'R');
		if (empty($tmid)) exit('false');
		$db_where = "tmid=$tmid and lockin=0";
		$typeclass = $this->fun->accept('typeclass', 'R');
		$styleclass = $this->fun->accept('styleclass', 'R');
		$lng = $this->fun->accept('lng', 'R');
		if (empty($styleclass) || empty($typeclass) || empty($lng)) {
			exit('false');
		}
		$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		$this->writelog($this->lng['mailtemplatemain_del_log'], $this->lng['log_extra_ok'] . ' id=' . $tmid);
		$this->dbcache->clearcache('templates_view_' . $tmid, true);
		$this->dbcache->clearcache('templates_array_' . $lng . '_' . $styleclass, true);
		exit('true');
	}

	function onmaildemo() {
		$mailsendtitle = $this->lng['mailtemplatemain_demo_title'];
		$mailsendcontent = $this->lng['mailtemplatemain_demo_content'];
		$email = $this->CON['admine_mail'];
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $email);
		if ($sendtype) {
			exit('true');
		} else {
			exit('false');
		}
	}

	function oncheckcode() {
		$templatecode = $this->fun->accept('templatecode', 'R');
		$typeclass = $this->fun->accept('typeclass', 'R');
		$db_table = db_prefix . 'templates';
		$db_where = " WHERE templatecode='$templatecode' AND styleclass=3";
		$countnum = $this->db_numrows($db_table, $db_where);
		if ($countnum > 0) {
			$exportAjax = 'false';
		} else {
			$exportAjax = 'true';
		}
		exit($exportAjax);
	}

}
?>