<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onorderlist() {
		$this->powercheck(135, 136);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}
		$db_where = " WHERE ID>0";
		$orderstate = $this->fun->accept('orderstate', 'R'); //订单状态
		if (!empty($orderstate)) {
			$db_where.=' AND OrderState=' . $orderstate;
		}
		$hotelorderid = $this->fun->accept('hotelorderid', 'R');  //订单ID
		if (!empty($hotelorderid)) {
			$db_where.=' AND HotelOrderID=\'' . $hotelorderid .'\'';
		}
		$checkindate = $this->fun->accept('tm1', 'R');   //入住时间
		$checkoutdate = $this->fun->accept('tm2', 'R');
		if (!empty($checkindate) && !empty($checkoutdate)) {
			$db_where.= ' AND CheckInDate BETWEEN '. strtotime($checkindate) . " AND " . strtotime($checkoutdate);
		}
		$ordertimestart = $this->fun->accept('yd1', 'R');  //预订时间
		$ordertimeend = $this->fun->accept('yd2', 'R');
		if (!empty($ordertimestart) && !empty($ordertimeend)) {
			$db_where.= ' AND OrderDatetime BETWEEN '. strtotime($ordertimestart) . " AND " . strtotime($ordertimeend);
		} else if(empty($ordertimestart) && !empty($ordertimeend)){
			$db_where.= ' AND OrderDatetime <=' . strtotime($ordertimeend);  //今日之前订单
		}
		$hotelname = $this->fun->accept('hotelname', 'R');
		if (!empty($hotelname)) {
			$db_where.=" AND HotelName like '%$hotelname%'";
		}
		$hotelstar = $this->fun->accept('hotelstar', 'R');
		if (!empty($hotelstar)) {
			$db_where.=" AND HotelStar =$hotelstar";
		}
		$citythree = $this->fun->accept('citythree', 'R');   //城市
		if (!empty($citythree)) {
			$db_where.=" AND HotelinCity =$citythree";
		}
		$district = $this->fun->accept('district', 'R');   //区县
		if (!empty($district)) {
			$db_where.=" AND HotelinArea =$district";
		}
		$pricerange = $this->fun->accept('pricerange', 'R');
		if (!empty($pricerange)) {
			if(strpos($pricerange,',')) {
				$parr = explode(',',$pricerange);
				$db_where.=" AND RoomPrice BETWEEN ".$parr[0]." AND ".$parr[1];
			}
		}
		$roomprice = $this->fun->accept('roomprice', 'R');
		if (!empty($roomprice)) {
			$db_where.=" AND RoomPrice =$roomprice";
		}
		$hotelincompany = $this->fun->accept('hotelincompany', 'R');
		if (!empty($hotelincompany)) {
			$db_where.=" AND HotelinCompany =$hotelincompany";
		}
		$guestname = $this->fun->accept('guestname', 'R');
		if (!empty($guestname)) {
			$db_where.=" AND Guest_Name like '%$guestname%'";
		}
		$guestphone = $this->fun->accept('guestphone', 'R');
		if (!empty($guestphone)) {
			$db_where.=" AND Contacter_Mobile ='$guestphone'";
		}
		$userid = $this->fun->accept('userid', 'R');
		if (!empty($userid)) {
			$db_where.=" AND UserId =$userid";
		}
		$hotelmembers = $this->fun->accept('hotelmembers', 'R');
		if (!empty($hotelmembers)) {
			$db_where.=" AND HotelMembers =$hotelmembers";
		}
		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'ID' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;
		$db_table = db_prefix . 'hotel_order';
		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}
		$db_field = "ID,HotelOrderID,TotalPrice,IsIntegral,UserId,OrderState,OrderDatetime,OrderType,HotelName,RoomTypeName,RoomAmount,CheckInDate,CheckOutDate,Guest_Name,Guest_Mobile";
		$sql = 'SELECT '.$db_field.' FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql); $status = "";
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$status .= $rsList['HotelOrderID'] . ",";
			$rsList['OrderDatetime'] = date('Y-m-d H:i:s',$rsList['OrderDatetime']);
			$rsList['OrderType'] = ($rsList['OrderType']==1)?$this->lng['ordermain_text_webyding']:$this->lng['ordermain_text_ordertype10'];
			$rsList['CheckInDate'] = date('Y-m-d',$rsList['CheckInDate']);
			$rsList['CheckOutDate'] = date('Y-m-d',$rsList['CheckOutDate']);
			$array[] = $rsList;
		}
		$noup = "5,6,8,10,11"; $arrnoup = explode(",",$noup);
		if($status) {
			$status = substr($status,0,(strlen($status)-1));
			$statusarr = $this->get_orderstatus($status);
			
			foreach($array as $k=>$v) {
				$isorder = false;
				foreach ($statusarr as $key=>$value) {
					if($v['HotelOrderID'] == $value['OrderId']) {
						$isorder = true;
						if(!in_array(strval($v['OrderState']),$arrnoup)) {
							$this->db->query("UPDATE $db_table SET OrderState=".$value['Status']." WHERE ID=".$v['ID']);
						}
						$array[$k]['OrderState'] = $this->get_ordertype($value['Status']);

						if($v['IsIntegral']==0 && $v['OrderState']==8) { //已离店并且没更新过积分
							$this->get_user_Integral($v['TotalPrice'],$v['UserId'],$v['HotelOrderID']);
						}
						if($value['Status'] == 1) {
							$array[$k]['neworder'] = 1;
						} else {
							$array[$k]['neworder'] = 2;
						}
					}
				}
				if(!$isorder) {
					$array[$k]['OrderState'] = $this->get_ordertype(-1);
				}
			}
		}
		$this->fun->setcookie($this->fun->noncefile() . 'pgid', $page_id, 600);
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$this->ectemplates->display('order/order_list');
	}

	function onsearch() {
		parent::start_template();
		$tab = $this->fun->accept('tab', 'R');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		$companyarray = $this->get_company_array(0,$lng);
		$memarray = $this->get_admember_list(0,$lng);
		$this->ectemplates->assign('companyarray', $companyarray['list']);
		$this->ectemplates->assign('memarray', $memarray['list']);
		$this->ectemplates->assign('power_136250', $this->getpower(136,250));
		$this->ectemplates->display("order/order_search");
	}
	//订单设置
	function onsetting() {
		$this->powercheck(136, 163);
		$db_table = db_prefix . 'hotel_order';
		$selectinfoid = $this->fun->accept('orderselectinfoid', 'P');
		$selectinfoid = $selectinfoid . '0';
		if (empty($selectinfoid)) exit('false');
		$value = $this->fun->accept('value', 'P');
		$dbname = $this->fun->accept('dbname', 'P');
		if($dbname == "OrderState") { //订单状态
			
		}
		if($dbname == "HotelMembers") { //预订员变更
			$this->powercheck(136, 249);
			
		}
		$db_set = "$dbname=$value";
		$db_where = "ID IN ( $selectinfoid )";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$this->writelog($this->lng['article_setting_log'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		exit('true');
	}

	function onaddwindow() {
		$this->powercheck(135, 137);
		parent::start_template();
		$tab = $this->fun->accept('tab', 'R');
		$tab = empty($tab) ? 'true' : $tab;
		$this->ectemplates->assign('lng', $lng);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->display('order/order_add_window');
	}

	function onsearchdoc() {
		$this->powercheck(135, 137);
		parent::start_template();
/**
		$mid = $this->fun->accept('mid', 'R');
		$mid = empty($mid) ? 0 : $mid;

		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);

		$modelarray = $this->get_model(0, $lng, 1);
		$this->ectemplates->assign('modelarray', $modelarray['list']);
**/
		$this->ectemplates->display('order/order_add_search');
	}

	function oncookiesave() {
		$orderdid = $this->fun->accept('orderdid', 'R');
		$tsn = $this->fun->accept('tsn', 'R');
		if (!is_array($orderdid) || count($orderdid) < 1 || empty($orderdid)) {
			exit('false');
		}
		$amountArray = array();
		foreach ($orderdid as $key => $value) {
			$amountArray[$key] = $this->fun->accept('orderhow' . $value, 'R');
		}
		$didlist = implode(',', $orderdid);
		$tsn = implode(',', $tsn);
		$amountlist = implode(',', $amountArray);
		$this->fun->setcookie("esp_order_didlist", $didlist);
		$this->fun->setcookie("esp_order_tsn", $tsn);
		$this->fun->setcookie("esp_order_amountlist", $amountlist);
		exit('true');
	}

	function onorderadd() {
		$this->powercheck(135, 137);
		parent::start_template();
		$didlist = $this->fun->accept('esp_order_didlist', 'C');
		$amountlist = $this->fun->accept('esp_order_amountlist', 'C');
		if (empty($didlist) || empty($amountlist)) exit('err');
		$didarray = explode(',', $didlist);
		$amountarray = explode(',', $amountlist);
		$amountnewarray = array();
		foreach ($didarray as $key => $value) {
			$amountnewarray[$value] = $amountarray[$key];
		}

		$db_where = ' WHERE did IN (' . $didlist . ')';
		$db_table = db_prefix . 'document';
		$sql = 'SELECT * FROM ' . $db_table . $db_where . ' ORDER BY did DESC';
		$rs = $this->db->query($sql);
		$productmoney = 0;
		while ($rsList = $this->db->fetch_assoc($rs)) {

			$countprice = sprintf("%01.2f", $amountnewarray[$rsList['did']] * $rsList['bprice']);
			$rsList['countprice'] = $countprice;
			$rsList['amount'] = $amountnewarray[$rsList['did']];

			$productmoney = $productmoney + $countprice;
			$array[] = $rsList;
		}

		$order_discount = $this->CON['order_discount'];
		$discountmoney = 0;
		if ($order_discount > 0) {

			$discountmoney = $productmoney > 0 ? $productmoney - ($order_discount / 100) * $productmoney : 0;
		}

		$discount_productmoney = $productmoney - $discountmoney;

		$payplug = $this->get_payplug_array($this->CON['order_pay']);
		$shipplug = $this->get_shipplug_array($this->CON['order_shipping']);

		$this->ectemplates->assign('discount', $order_discount);

		$this->ectemplates->assign('productmoney', $productmoney);

		$this->ectemplates->assign('discount_productmoney', $discount_productmoney);

		$this->ectemplates->assign('discountmoney', $discountmoney);
		$this->ectemplates->assign('discount_productmoney_f', number_format($discount_productmoney, 2, '.', ','));
		$this->ectemplates->assign('productmoney_f', number_format($productmoney, 2, '.', ','));
		$this->ectemplates->assign('discountmoney_f', number_format($discountmoney, 2, '.', ','));
		$this->ectemplates->assign('payplug', $payplug['list']);
		$this->ectemplates->assign('shipplug', $shipplug['list']);
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->display('order/order_add');
	}

	function oncheckusername() {
		$username = $this->fun->accept('username', 'R');
		if (empty($username)) {
			exit('{"postvlue":"false"}');
		}
		$info = $this->get_member($username);
		if (!is_array($info)) {
			exit('{"postvlue":"false"}');
		}

		$str = '{';
		$str.= '"postvlue":"true","alias":"' . $info['alias'] . '",';
		$str.= '"userid":"' . $info['userid'] . '",';
		$str.= '"tel":"' . $info['tel'] . '",';
		$str.= '"mobile":"' . $info['mobile'] . '",';
		$str.= '"email":"' . $info['email'] . '",';
		$str.= '"country":"' . $info['country'] . '",';
		$str.= '"province":"' . $info['province'] . '",';
		$str.= '"city":"' . $info['city'] . '",';
		$str.= '"district":"' . $info['district'] . '",';
		$str.= '"address":"' . $info['address'] . '",';
		$str.= '"zipcode":"' . $info['zipcode'] . '"';
		$str.= '}';
		exit($str);
	}

	function onorderedit() {
		parent::start_template();
		$type = $this->fun->accept('type', 'G');
		$oid = $this->fun->accept('id', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		if(!$oid) {
			exit('param_err');
		}
		$db_table = db_prefix . 'hotel_order';
		$db_where = 'ID=' . $oid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
		if (empty($read['UserId'])) {
			$read['UserId'] = '';
		}
		$statusarr = $this->get_orderstatus($read['HotelOrderID']);
		$read['OrderState'] = $statusarr[0]['Status'];
		$read['OrderStateText'] = $this->get_ordertype($read['OrderState']);
		
		$admember_arr = $this->get_admember('', $read['HotelMembers'], 'username,name');
		$read['HotelMembersValue'] = empty($admember_arr['name']) ? $admember_arr['username'] : $admember_arr['name'];
		$read['HotelMembersValue'] = empty($read['HotelMembersValue']) ? $this->lng['select_text_no'] : $read['HotelMembersValue'];
		$memarray = $this->get_admember_list($read['HotelMembers'],$lng);
		$companyarray = $this->get_company_array($read['HotelinCompany'],$lng);
		$read['OrderUpTime'] = date('Y-m-d H:i:s',$read['OrderUpTime']);
		$read['OrderDatetime'] = date('Y-m-d H:i:s',$read['OrderDatetime']);
		$read['CheckInDate'] = date('Y-m-d',$read['CheckInDate']);
		$read['CheckOutDate'] = date('Y-m-d',$read['CheckOutDate']);
		$read['ArrivalEarlyTime'] = date('H:i',$read['ArrivalEarlyTime']);
		$read['ArrivalLateTime'] = date('H:i',$read['ArrivalLateTime']);
		$guest = $contacter = array();
		if(!empty($read['Guests_Guest'])) {
			$guest = unserialize($read['Guests_Guest']);
		}
		unset($read['Guests_Guest']);
		if(!empty($read['Contacters_Contacter'])) {
			$contacter = unserialize($read['Contacters_Contacter']);
		}
		unset($read['Contacters_Contacter']);
		if(!empty($read['CreditCard'])) {
			$cardarr = unserialize($read['CreditCard']);
		}
		unset($read['CreditCard']);
		$roomarray = $this->get_roomtype_array($read['RoomTypeId'],$lng);
		$sms = $this->lng['ordermain_text_smstext'];
		$sms = str_replace('{#hotelname#}',$read['HotelName'],$sms);
		$sms = str_replace('{#hoteladdr#}',$read['HotelAddr'],$sms);
		$sms = str_replace('{#hoteltel#}',$read['HotelPhone'],$sms);
		$sms = str_replace('{#date1#}',date('m月d日',$read['CheckInDate']),$sms);
		$sms = str_replace('{#date2#}',date('m月d日',$read['CheckOutDate']),$sms);
		$sms = str_replace('{#roomamount#}',$read['RoomAmount'],$sms);
		$sms = str_replace('{#roomprice#}',$read['RoomPrice'],$sms);
		$read['SMS'] = $sms;
		
		$this->writelog($this->lng['ordermain_text_read_botton_title'],$this->lng['ordermain_text_read_botton_title'],'',$oid);
		$power_136250 = $this->getpower(136,250);
		$power_139163  = $this->getpower(139,163);
		$power_139251  = $this->getpower(139,251);
		$this->ectemplates->assign('power_136250', $power_136250);
		$this->ectemplates->assign('power_139163', $power_139163);
		$this->ectemplates->assign('power_139251', $power_139251);
		
		$this->ectemplates->assign('memarray', $memarray['list']);
		$this->ectemplates->assign('roomarray', $roomarray['list']);
		$this->ectemplates->assign('companyarray', $companyarray['list']);
		$this->ectemplates->assign('guest', $guest);
		$this->ectemplates->assign('contacter', $contacter);
		$this->ectemplates->assign('cardarr', $cardarr);
		$this->ectemplates->assign('read', $read);
		$this->ectemplates->assign('tab', 'true');
		$this->ectemplates->assign('admin_userid',$this->esp_adminuserid);
		$this->ectemplates->display('order/order_edit');
	}

	function onsave() {
		$inputclass = $this->fun->accept('inputclass', 'P');
		$IsIntegral = $this->fun->accept('IsIntegral', 'P');
		$NoteofGuest = $this->fun->accept('noteofguest', 'R');
		$HotelId = $this->fun->accept('hotelid', 'R');
		$ConfirmTypeCode = $this->fun->accept('confirmtypecode', 'R');
		$HotelName = $this->fun->accept('hotelname', 'R');
		$HotelStar = $this->fun->accept('hotelstar', 'R');
		$HotelinProvince = $this->fun->accept('citytwo', 'R');
		$HotelinCity = $this->fun->accept('citythree', 'R');
		$HotelinArea = $this->fun->accept('district', 'R');
		$HotelAddr = $this->fun->accept('hoteladdr', 'R');
		$HotelPhone = $this->fun->accept('hotelphone', 'R');
		$RoomTypeId = $this->fun->accept('roomtype', 'R');
		$HotelinCompany = $this->fun->accept('hotelincompany', 'R');
		$RoomTypeInfo = $this->fun->accept('roomtypeinfo', 'R');
		$in = $this->fun->accept('checkindate', 'R');
		$out = $this->fun->accept('checkoutdate', 'R');
		
		$late = $this->fun->accept('arrivallatetime', 'R');
		$CheckInDate = strtotime($in);
		$CheckOutDate = strtotime($out);
		
		if(intval($late) < 9) {
			$ArrivalLateTime = strtotime(date('Y-m-d',($CheckInDate + 86400))." ".$late);
		} else {
			$ArrivalLateTime = strtotime($in." ".$late);		
		}
		$RoomPrice = $this->fun->accept('roomprice', 'R');
		$RoomAmount = $this->fun->accept('roomamount', 'R');
		$GuestAmount = $this->fun->accept('guestamount', 'R');
		$TotalPrice = $this->fun->accept('totalprice', 'R');
		$CurrencyCode = $this->fun->accept('currencycode', 'R');

		$db_table = db_prefix . 'hotel_order';
		if ($inputclass == 'add') {
			$this->powercheck(135, 137);
			//get_citylist($union_id='')  从接口抓取城市区域字段信息 从而得到 本系统得到城市区域值
			$citycode_arr = array();
			$citycode_arr = $this->get_convercity($HotelinProvince,$HotelinCity,$HotelinArea);  //返回本系统的city值
			$OrderDatetime = strtotime('now');
			$OrderState = 1;
			
			$order_snfont = $this->CON['order_snfont'];
			$ordersn = $order_snfont . date('YmdHis') . rand(100, 9999);  //订单格式
			$HotelOrderID = $ordersn;

			$guestname = $this->fun->accept('guestname', 'R');
			$contactername = $this->fun->accept('contactername', 'R');
			$contacterttel = $this->fun->accept('contacterttel', 'R');
			$contacterphone = $this->fun->accept('contacterphone', 'R');
			$contactermail = $this->fun->accept('contactermail', 'R');
			
			$UserId = 0;
			$regMember = false;  //订单与会员联系起来，根据手机号可以注册为会员
			if($regMember) {  //如果注册为会员
				$lockusername = explode(',', $this->CON['mem_lock']);
				$db_table2 = db_prefix . "member";
				$db_where = " WHERE username='$contacterphone' or email='$contactermail'";
				$countnum = $this->db_numrows($db_table2, $db_where);
				$ipadd = $this->fun->ip($_SERVER['REMOTE_ADDR']);
				$addtime = time();
				$isclass = ($this->CON['mem_isemail']) ? 2 : 1;
				if (!$countnum || !in_array($contacterphone, $lockusername)) {
					$db_field = 'username,password,email,question,answer,sex,birthday,country,province,city,district,alias,address,zipcode,tel,mobile,qq,msn,integral,visitcount,lastip,addtime,lasttime,mcid,isclass';
					$db_values = "'$contacterphone','".md5($contacterphone)."','$contactermail','','',0,0,0,0,0,0,'$contactername','',0,'','$contacterphone',0,'',0,0,$ipadd,$addtime,$addtime,1,$isclass";
					$this->db->query('INSERT INTO ' . $db_table2 . ' (' . $db_field . ') VALUES (' . $db_values . ')');
					$insert_id = $this->db->insert_id();
					$UserId = $insert_id;
				}
			}

			$guest = $contacter = array();
			$guest = array(
	            'Name' => $guestname,
	            'GenderCode' => "",
	            'Email' => "",
	            'Mobile' => "",
	            'IdTypeCode' => "",
	            'IdNumber' => "",
	            'Nationality' => "",
	            'Phone' => "",
	            'Fax' => ""
	        );
	        $Guests_Guest = addslashes(serialize($guest));
	        $Guest_Name = $guestname;
	        $Guest_Mobile = "";
	        $contacter = array(
	            'Name' => $contactername,
	            'GenderCode' => "",
	            'Email' => $contactermail,
	            'Mobile' => $contacterphone,
	            'IdTypeCode' => "",
	            'IdNumber' => "",
	            'Phone' => $contacterttel,
	            'Fax' => ""
	        );
			$Contacters_Contacter = addslashes(serialize($contacter));
			$Contacter_Name = $contactername;
			$Contacter_Mobile = $contacterphone;
			//CreditCard
			$CreditCard = "";
			$union_id = 0;
			$guaranteeType = $this->get_guaranteetype($union_id,$HotelId);   //是否信用卡担保
			if($guaranteeType == true) {
				$creditcard = $this->fun->accept('creditcard', 'R');
				$veryfyvode = $this->fun->accept('veryfyvode', 'R');
				$validyear = $this->fun->accept('validyear', 'R');
				$validmonth = $this->fun->accept('validmonth', 'R');
				$idtypecode = $this->fun->accept('idtypecode', 'R');
				$idnumber = $this->fun->accept('idnumber', 'R');
				$cardholdername = $this->fun->accept('cardholdername', 'R');
				$credit = array(
					'Number'=>$creditcard,
					'VeryfyCode'=>$veryfyvode,
					'ValidYear'=>$validyear,
					'ValidMonth'=>$validmonth,
					'CardHolderName'=>$cardholdername,
					'IdTypeCode'=>$idtypecode,
					'IdNumber'=>$idnumber
				);
				$CreditCard = addslashes(serialize($credit));
			}
/**
			$db_field = 'ordersn,userid,ordertype,osid,opid,shippingsn,paysn,consignee,country,province,city,district,address,
				zipcode,tel,mobile,email,sendtime,invpayee,invcontent,content,treatnote,paytime,shippingtime,productmoney,shippingmoney,
				paymoney,orderamount,discount,integral,addtime';
			$db_values = "'$ordersn',$userid,1,$osid,$opid,'','','$consignee',$country,$province,$city,$district,'$address',
				'$zipcode','$tel','$mobile','$email','$sendtime','$invpayee','$invcontent','$content','$treatnote',0,0,$productmoney,$shipprice,
				$payprice,$orderamount,$discountmoney,0,$addtime";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$insert_id = $this->db->insert_id();

			if ($this->CON['is_email'] == 1) {

				$this->ordermailsend('orderen', $insert_id);

				$this->ordermailsend('orderwarn', $insert_id);
			}
			$this->writelog($this->lng['ordermain_add_log'], $this->lng['log_extra_ok'] . ' OrderSN=' . $ordersn);
			$this->fun->setcookie("esp_order_didlist", null);
			$this->fun->setcookie("esp_order_tsn", null);
			$this->fun->setcookie("esp_order_amountlist", null);
			**/
			exit('true');
		} else if ($inputclass == 'edit') {
			$this->powercheck(135, 139);
			$ID = $this->fun->accept('id', 'R');
			$HotelOrderID = $this->fun->accept('hotelorderid', 'R');
			$OrderDatetime = strtotime($this->fun->accept('orderdatetime', 'R'));
			$HotelMembers = $this->fun->accept('hotelmembers', 'R');
			$OrderType = $this->fun->accept('ordertype', 'R');
			$UserId = $this->fun->accept('userid', 'R');
			$PaymentTypeCode = $this->fun->accept('paymenttypecode', 'R');  //支付方式
			$NoteofOrder = $this->fun->accept('noteoforder', 'R');
			$OrderState = $this->fun->accept('orderstate', 'R');
			$OrderState_log = $this->fun->accept('orderstate_log', 'R');
			$OrderUpNote = $this->fun->accept('orderupnote', 'R');
			
			$guestname = $this->fun->accept('guestname', 'R');
			$gendercode = $this->fun->accept('gendercode', 'R');
			$guesttel = $this->fun->accept('guesttel', 'R');
			$guestphone = $this->fun->accept('guestphone', 'R');
			$guestfax = $this->fun->accept('guestfax', 'R');
			$guestmail = $this->fun->accept('guestmail', 'R');
			$guestidtypecode = $this->fun->accept('guestidtypecode', 'R');
			$guestidnumber = $this->fun->accept('guestidnumber', 'R');
			$guestnationality = $this->fun->accept('guestnationality', 'R');
			$contactername = $this->fun->accept('contactername', 'R');
			$congendercode = $this->fun->accept('congendercode', 'R');
			$contacterttel = $this->fun->accept('contacterttel', 'R');
			$contacterphone = $this->fun->accept('contacterphone', 'R');
			$contacterfax = $this->fun->accept('contacterfax', 'R');
			$contactermail = $this->fun->accept('contactermail', 'R');
			$contacteridtypecode = $this->fun->accept('contacteridtypecode', 'R');
			$contacteridnumber = $this->fun->accept('contacteridnumber', 'R');
			
			$creditcard = $this->fun->accept('creditcard', 'R');
			$veryfyvode = $this->fun->accept('veryfyvode', 'R');
			$validyear = $this->fun->accept('validyear', 'R');
			$validmonth = $this->fun->accept('validmonth', 'R');
			$idtypecode = $this->fun->accept('idtypecode', 'R');
			$idnumber = $this->fun->accept('idnumber', 'R');
			$cardholdername = $this->fun->accept('cardholdername', 'R');
			
			$early = $this->fun->accept('arrivalearlytime', 'R');
			if(intval($early) < 9) {
				$ArrivalEarlyTime = strtotime(date('Y-m-d',($CheckInDate + 86400))." ".$early);
			} else {
				$ArrivalEarlyTime = strtotime($in." ".$early);
			}
			
			$guest = $contacter = array();
			$guest = array(
	            'Name' => $guestname,
	            'GenderCode' => $gendercode,
	            'Email' => $guestmail,
	            'Mobile' => $guestphone,
	            'IdTypeCode' => $guestidtypecode,
	            'IdNumber' => $guestidnumber,
	            'Nationality' => $guestnationality,
	            'Phone' => $guesttel,
	            'Fax' => $guestfax
	        );
	        $Guests_Guest = addslashes(serialize($guest));
	        $Guest_Name = $guestname;
	        $Guest_Mobile = $guestphone;
	        $contacter = array(
	            'Name' => $contactername,
	            'GenderCode' => $congendercode,
	            'Email' => $contactermail,
	            'Mobile' => $contacterphone,
	            'IdTypeCode' => $contacteridtypecode,
	            'IdNumber' => $contacteridnumber,
	            'Phone' => $contacterttel,
	            'Fax' => $contacterfax
	        );
			$Contacters_Contacter = addslashes(serialize($contacter));
			$Contacter_Name = $contactername;
			$Contacter_Mobile = $contacterphone;
			//CreditCard
			$credit = array(
				'Number'=>$creditcard,
				'VeryfyCode'=>$veryfyvode,
				'ValidYear'=>$validyear,
				'ValidMonth'=>$validmonth,
				'CardHolderName'=>$cardholdername,
				'IdTypeCode'=>$idtypecode,
				'IdNumber'=>$idnumber
			);
			$CreditCard = addslashes(serialize($credit));
			if(!$inputclass || !$ID) {
				exit("-1"); //参数错误
			}
			$db_where = 'ID=' . $ID;
			
			$db_set = "HotelOrderID='$HotelOrderID',HotelId='$HotelId',ConfirmTypeCode='$ConfirmTypeCode',OrderDatetime=$OrderDatetime,";
			if($this->getpower(136,250)==true && $OrderState_log !='1') {
				$HotelMembers_log = $this->fun->accept('hotelmembers_log', 'R');
				if($HotelMembers_log != $HotelMembers) {
					$logcontent = $this->lng['ordermain_edit_orderlog_content'];
					$user1_arr = $this->get_admember('', $HotelMembers_log, 'username,name');
					$user1 = empty($user1_arr['name']) ? $user1_arr['username'] : $user1_arr['name'];
					$user2_arr = $this->get_admember('', $HotelMembers, 'username,name');
					$user2 = empty($user2_arr['name']) ? $user2_arr['username'] : $user2_arr['name'];
					$logcontent = str_replace('{#user1#}',"<font color=red>".$user1."</font>",$logcontent);
					$logcontent = str_replace('{#user2#}',"<font color=red>".$user2."</font>",$logcontent);
					$db_set .= "HotelMembers=$HotelMembers,";
					$this->writelog($this->lng['ordermain_edit_orderlog'],$logcontent,'',$ID);
				}
			}
			$db_set .= "OrderType=$OrderType,UserId=$UserId,PaymentTypeCode=$PaymentTypeCode,
			           NoteofGuest='$NoteofGuest',NoteofOrder='$NoteofOrder',OrderState=$OrderState,";	
			if($OrderState_log != $OrderState) {
				$logtext = $this->lng['ordermain_edit_orderlog_content2'];
				$logtext = str_replace('{#order1#}',"<font color=red>".$this->get_ordertype($OrderState_log)."</font>",$logtext);
				$logtext = str_replace('{#order2#}',"<font color=red>".$this->get_ordertype($OrderState)."</font>",$logtext);
				if($OrderState_log == '1' && empty($HotelMembers)) { //新订单
					$HotelMembers = $this->esp_adminuserid;
					$OrderUpTime = strtotime('now');
					$db_set .= "HotelMembers=$HotelMembers,OrderUpTime=$OrderUpTime,";
					$this->writelog($this->lng['ordermain_edit_orderlog2'],$logtext,'',$ID);
				} else {  //管理员组长或者 是自己的订单则
					if($this->getpower(139,163)==true || ($this->getpower(139,251)==true && $this->esp_adminuserid==$HotelMembers)) {
						$OrderUpTime = strtotime('now');
						$db_set .= "OrderUpTime=$OrderUpTime,";
						if($this->CON['mem_isintegral'] == 1) {  //开启积分策略
							if($OrderState == 8 && $IsIntegral==0) {  //已离店并且没更新过积分
								$this->get_user_Integral($TotalPrice,$UserId,$HotelOrderID);
							}
						}
						$this->writelog($this->lng['ordermain_edit_orderlog2'],$logtext,'',$ID);
					} else {
						exit("-2");
					}
				}
			}
			$db_set .= "OrderUpNote='$OrderUpNote',HotelName='$HotelName',
					HotelStar=$HotelStar,HotelinProvince=$HotelinProvince,HotelinCity=$HotelinCity,
					HotelinArea=$HotelinArea,HotelAddr='$HotelAddr',HotelPhone='$HotelPhone',
					RoomTypeId=$RoomTypeId,HotelinCompany=$HotelinCompany,RoomTypeInfo='$RoomTypeInfo',
					CheckInDate=$CheckInDate,CheckOutDate=$CheckOutDate,ArrivalEarlyTime=$ArrivalEarlyTime,
					ArrivalLateTime=$ArrivalLateTime,RoomPrice=$RoomPrice,RoomAmount=$RoomAmount,
					GuestAmount=$GuestAmount,TotalPrice=$TotalPrice,CurrencyCode='$CurrencyCode',Contacter_Mobile='$Contacter_Mobile',
					Guest_Name='$Guest_Name',Guest_Mobile='$Guest_Mobile',Contacter_Name='$Contacter_Name',
					Guests_Guest='$Guests_Guest',Contacters_Contacter='$Contacters_Contacter',CreditCard='$CreditCard'";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['ordermain_log_success'],$this->lng['ordermain_log_success'],'',$ID);
			exit('true');
		}
	}

	function onordermode() {
		$this->powercheck(135, 163);
		$db_table = db_prefix . 'order';
		$oid = $this->fun->accept('oid', 'P');
		$value = $this->fun->accept('value', 'P');
		if (empty($oid)) exit('false');
		$db_set = "ordertype=$value";
		$db_where = "oid=$oid";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$this->writelog($this->lng['ordermain_edit_log'], $this->lng['log_extra_ok'] . ' oid=' . $oid);
		exit('true');
	}

	function ondel() {
		$this->powercheck(135, 138);
		$db_table = db_prefix . 'hotel_order';
		$selectinfoid = $this->fun->accept('orderselectinfoid', 'P');
		if (empty($selectinfoid)) exit('false');
		$infoarray = explode(',', $selectinfoid);
		$count = count($infoarray) - 1;
		if ($count <= 0) exit('false');
		$selectinfoid = $selectinfoid . '0';
		$db_where = "ID in ($selectinfoid)";
		$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		$this->writelog($this->lng['ordermain_del_log'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		exit('true');
	}

	function onshipprintselect() {
		parent::start_template();
		$oid = $this->fun->accept('oid', 'G');
		$array = $this->get_templates_array(0, $this->CON['is_lancode'], 2, 'print');
		$this->ectemplates->assign('oid', $oid);
		$this->ectemplates->assign('array', $array['list']);
		$this->ectemplates->display('order/order_shipprintselect');
	}

	function onprintlist() {
		parent::start_template();

		$title = $this->fun->accept('title', 'R');

		$othercontent = $this->fun->accept('othercontent', 'R');

		$oid = $this->fun->accept('oid', 'G');

		$printid = $this->fun->accept('printid', 'R');

		$db_table = db_prefix . 'order';
		$db_where = 'oid=' . $oid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);

		$read['province'] = $this->get_cityview($read['province'], 'cityname');
		$read['city'] = $this->get_cityview($read['city'], 'cityname');
		$read['district'] = $this->get_cityview($read['district'], 'cityname');

		$sread = array();
		$sread['order_companyname'] = $this->CON['order_companyname'];
		$sread['order_contact'] = $this->CON['order_contact'];
		$sread['order_province'] = $this->CON['order_province'];
		$sread['order_city'] = $this->CON['order_city'];
		$sread['order_add'] = $this->CON['order_add'];
		$sread['order_post'] = $this->CON['order_post'];
		$sread['order_tel'] = $this->CON['order_tel'];
		$sread['order_moblie'] = $this->CON['order_moblie'];
		$sread['admine_mail'] = $this->CON['admine_mail'];
		$sread['domain'] = $this->CON['domain'];

		$rstemp = $this->get_templates_view($printid);
		$tempcontent = stripslashes(htmlspecialchars_decode($rstemp['templatecontent']));
		;
		require admin_ROOT . adminfile . '/include/inc_print.php';
		foreach ($printinc as $key => $vlaue) {

			$tempcontent = str_replace($vlaue['title'], $vlaue['content'], $tempcontent);
		}
		$this->ectemplates->assign('templist', $tempcontent);
		$this->ectemplates->assign('pic', $rstemp['pic']);
		$this->ectemplates->display('order/order_shipprint');
	}

	function onprintorder() {
		parent::start_template();

		$class = $this->fun->accept('class', 'G');
		$oid = $this->fun->accept('oid', 'G');

		$db_table = db_prefix . 'order';
		$db_where = 'oid=' . $oid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);

		$read['payname'] = $this->get_payplug_view($read['opid'], 'payname');
		$read['shipname'] = $this->get_shipplug_view($read['osid'], 'title');

		$read['province'] = $this->get_cityview($read['province'], 'cityname');
		$read['city'] = $this->get_cityview($read['city'], 'cityname');
		$read['district'] = $this->get_cityview($read['district'], 'cityname');

		$productmoney = $read['productmoney'];

		$dis = 100 - ($read['discount'] / $productmoney) * 100;

		$db_table = db_prefix . 'order_info';
		$db_where = " WHERE oid=$oid";
		$sql = 'SELECT oiid,oid,did,tsn,title,oprice,bprice,countprice,amount,inventory FROM ' . $db_table . $db_where . ' ORDER BY oiid DESC';
		$rs = $this->db->query($sql);
		$arrayList = array();
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$didlist.=$rsList['did'] . ',';

			$endid = $rsList['did'];
			$array[] = $rsList;
		}

		$sread = array();
		$sread['order_companyname'] = $this->CON['order_companyname'];
		$sread['order_contact'] = $this->CON['order_contact'];
		$sread['order_province'] = $this->CON['order_province'];
		$sread['order_city'] = $this->CON['order_city'];
		$sread['order_add'] = $this->CON['order_add'];
		$sread['order_post'] = $this->CON['order_post'];
		$sread['order_tel'] = $this->CON['order_tel'];
		$sread['order_moblie'] = $this->CON['order_moblie'];
		$sread['admine_mail'] = $this->CON['admine_mail'];
		$sread['domain'] = $this->CON['domain'];

		$this->ectemplates->assign('dis', $dis);
		$this->ectemplates->assign('sread', $sread);
		$this->ectemplates->assign('order', $read);
		$this->ectemplates->assign('array', $array);
		if ($class == 1) $this->ectemplates->display('order/order_orderprint1');
		if ($class == 2) $this->ectemplates->display('order/order_orderprint2');
	}

}
?>