<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onsubjectlist() {
		$this->powercheck(74, 75);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}
		$db_table = db_prefix . 'subjectlist';

		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? ($this->CON['is_alonelng'] && !empty($this->CON['home_lng'])) ? $this->CON['home_lng'] : $this->CON['default_lng'] : $lng;
		if (!empty($lng)) {
			$db_where = ' WHERE lng=\'' . $lng . '\'';
		} else {
			$db_where = ' WHERE lng=\'' . $this->CON['default_lng'] . '\'';
		}
		$mid = $this->fun->accept('mid', 'R');
		if (!empty($mid)) {
			$db_where.=' AND mid=' . $mid;
		}
		$isclass = intval($this->fun->accept('isclass', 'R'));
		if (!empty($isclass)) {
			if ($isclass == 2) $isclass = 0;
			$db_where.=' AND isclass=' . $isclass;
		}

		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}

		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'sid' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;

		$sql = 'SELECT sid,pid,mid,lng,subjectname,keywords,description,content,subpic,dirname,purview,isclass,styleid,template,filenamestyle,dirpath,addtime FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$puvname = $this->get_member_purview($rsList['purview'], 'rankname');
			$modelname = $this->get_modelview($rsList['mid'], 'modelname');
			$rsList['glink'] = $this->get_link('subtype', $rsList, $rsList['lng']);
			$rsList['puvname'] = empty($puvname) ? $this->lng['puv_no'] : $puvname;
			$rsList['modelname'] = $modelname;
			$array[] = $rsList;
		}
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$this->ectemplates->display('article/subject_list');
	}

	function onsubadd() {
		include_once admin_ROOT . adminfile . '/include/command_templatesdir.php';
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? ($this->CON['is_alonelng'] && !empty($this->CON['home_lng'])) ? $this->CON['home_lng'] : $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);

		$memberpuv = $this->get_member_purview_array();
		$this->ectemplates->assign('memberpuvlist', $memberpuv['list']);

		$keytypearray = $this->get_keytype_array(0, $lng);
		$this->ectemplates->assign('keyarray', $keytypearray['list']);

		$modelarray = $this->get_model(0, $lng, 1);
		$this->ectemplates->assign('modelarray', $modelarray['list']);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->assign('upid', $upid);
		$this->ectemplates->assign('tempname', $TEMPNAMELIST);
		$this->ectemplates->display('article/subject_add');
	}

	function onsubedit() {
		include_once admin_ROOT . adminfile . '/include/command_templatesdir.php';
		parent::start_template();
		$db_table = db_prefix . 'subjectlist';
		$type = $this->fun->accept('type', 'G');
		$sid = intval($this->fun->accept('sid', 'G'));
		$db_where = 'sid=' . $sid;
		$subread = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);

		$memberpuv = $this->get_member_purview_array($subread['purview']);
		$this->ectemplates->assign('memberpuvlist', $memberpuv['list']);

		$keytypearray = $this->get_keytype_array(0, $lng);
		$this->ectemplates->assign('keyarray', $keytypearray['list']);

		$model = $this->get_modelview($subread['mid'], 'modelname');
		$this->ectemplates->assign('model', $model);
		$this->ectemplates->assign('pathdir', $this->CON['file_htmldir']);
		$this->ectemplates->assign('tab', 'true');
		$this->ectemplates->assign('subread', $subread);
		$this->ectemplates->assign('type', $type);
		$this->ectemplates->assign('tempname', $TEMPNAMELIST);
		$this->ectemplates->assign('is_alonelng', $this->CON['is_alonelng']);
		$this->ectemplates->display('article/subject_edit');
	}

	function onsubsave() {
		include_once admin_ROOT . adminfile . '/include/command_templatesdir.php';
		include_once admin_ROOT . 'public/class_pingying.php';
		parent::start_template();
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		$mid = $this->fun->accept('mid', 'P');
		$mid = empty($mid) ? 0 : $mid;
		$subjectname = $this->fun->accept('subjectname', 'P');
		$content = $this->fun->accept('content', 'P');
		$keywords = $this->fun->accept('keywords', 'P');
		$description = $this->fun->accept('description', 'P');
		$isdirname = $this->fun->accept('isdirname', 'P');
		$subpic = $this->fun->accept('subpic', 'P');
		$dirname = $this->fun->accept('dirname', 'P');
		$purview = $this->fun->accept('purview', 'P');
		$styleid = $this->fun->accept('styleid', 'P');
		$template = $this->fun->accept('template', 'P');
		if (empty($template)) {
			$template = ($styleid == 1) ? $TEMPNAMELIST['subjectindex'] : $TEMPNAMELIST['subjectlist'];
		}
		$filenamestyle = $this->fun->accept('filenamestyle', 'P');
		$db_table = db_prefix . 'subjectlist';
		$date = time();
		if ($inputclass == 'add') {
			$this->powercheck(74, 76);
			if ($isdirname) {
				$chinesespelit = new chineseSpell();
				$dirname = $chinesespelit->getFullSpell($subjectname);
			} else {
				if (!preg_match("/^[\w]+$/i", $dirname)) {
					exit('false');
				}
			}
			
			$db_table2 = db_prefix . 'typelist';
			$db_where = " WHERE dirname='$dirname' AND lng='$lng'";
			$countnum = $this->db_numrows($db_table, $db_where);
			if (!$isdirname) {
				if ($countnum > 0) {
					exit('false');
				} else {
					$countnum = $this->db_numrows($db_table2, $db_where);
					if ($countnum > 0) {
						exit('false');
					}
				}
			}else{
				if ($countnum > 0) {
					$dirname=$dirname . mt_rand(10,99);
				} else {
					$countnum = $this->db_numrows($db_table2, $db_where);
					if ($countnum > 0) {
						$dirname=$dirname . mt_rand(10,99);
					}
				}
			}

			$subpath = admin_ROOT . $this->CON['file_htmldir'];
			if (!$this->fun->filemode($subpath)) {
				exit('false');
			}

			if ($this->CON['is_alonelng']) {
				$subdir = $subpath . $dirname;
			} else {
				$subdir = $subpath . $lng . '/' . $dirname;
			}
			$dirpath = $dirname;
			if (!is_dir($subdir)) {
				if (!@mkdir($subdir, 0777, true)) exit('false');
			}
			$db_field = 'pid,mid,lng,subjectname,keywords,description,content,subpic,dirname,purview,isclass,styleid,template,filenamestyle,dirpath,addtime';
			$db_values = "50,$mid,'$lng','$subjectname','$keywords','$description','$content','$subpic','$dirname',$purview,1,$styleid,'$template','$filenamestyle','$dirpath',$date";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['subjectmanage_add_log'], $this->lng['log_extra_ok'] . ' subjectname=' . $subjectname);
			$this->dbcache->clearcache('subjectlist_array_' . $lng, true);
			exit('true');
		}elseif ($inputclass == 'edit') {
			$this->powercheck(74, 102);
			$sid = $this->fun->accept('sid', 'P');
			$db_where = 'sid=' . $sid;
			$db_set = "subjectname='$subjectname',keywords='$keywords',description='$description',content='$content',subpic='$subpic',purview=$purview,styleid=$styleid,template='$template',filenamestyle='$filenamestyle'";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['subjectmanage_edit_log'], $this->lng['log_extra_ok'] . ' subjectname=' . $typename . ' sid=' . $sid);
			$this->dbcache->clearcache('subjectlist_view_' . $sid, true);
			$this->dbcache->clearcache('subjectlist_array_' . $lng, true);
			exit('true');
		}
	}

	function onsubdel() {
		$this->powercheck(74, 103);

		$db_table = db_prefix . 'subjectlist';
		$sid = $this->fun->accept('sid', 'R');
		if (empty($sid)) exit('false');

		$subpath = admin_ROOT . $this->CON['file_htmldir'];
		if (!$this->fun->filemode($subpath)) {
			exit('false');
		}
		$db_where = 'sid=' . $sid;
		$subread = $this->get_subjectlist_purview($sid);
		if ($this->CON['is_alonelng']) {
			$dirpath = $subread['dirpath'];
		} else {
			$dirpath = $subread['lng'] . '/' . $subread['dirpath'];
		}

		if (!empty($dirpath)) {
			$subdir = $subpath . $dirpath;
			if ($this->fun->filemode($subdir)) {

				$this->fun->delfile($subdir);
			}
		}

		$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		$this->writelog($this->lng['subjectmanage_del_log'], $this->lng['log_extra_ok'] . ' sid=' . $sid);
		$this->dbcache->clearcache('subjectlist_view_' . $sid, true);
		$this->dbcache->clearcache('subjectlist_array', true);
		exit('true');
	}

	function onsort() {
		$this->powercheck(74, 104);
		$db_table = db_prefix . 'subjectlist';
		$id = $this->fun->accept('infoid', 'P');
		$pid = $this->fun->accept('pid', 'P');
		$idArray = explode(',', $id);
		$pidArray = explode(',', $pid);
		foreach ($idArray as $key => $value) {
			if (!empty($value)) {
				$db_where = "sid=$value";
				$pid = intval($pidArray[$key]);
				$db_set = "pid=$pid";
				$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
				$this->dbcache->clearcache('subjectlist_view_' . $value, true);
			}
		}
		$this->writelog($this->lng['subjectmanage_log_sort'], $this->lng['log_extra_ok']);
		$this->dbcache->clearcache('subjectlist_array', true);
		exit('true');
	}

	function onsubsetting() {
		$this->powercheck(74, 105);
		$db_table = db_prefix . 'subjectlist';
		$selectinfoid = $this->fun->accept('selectinfoid', 'P');
		$selectinfoid = $selectinfoid . '0';
		if (empty($selectinfoid)) exit('false');
		$value = $this->fun->accept('value', 'P');
		$dbname = $this->fun->accept('dbname', 'P');
		$db_set = "$dbname=$value";
		$db_where = "sid IN ( $selectinfoid )";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$this->writelog($this->lng['subjectmanage_log_istype'], $this->lng['log_extra_ok'] . ' id=' . $selectinfoid);
		$this->dbcache->clearcache('subjectlist_', true);
		exit('true');
	}

	function oncheckdirname() {
		$dirname = $this->fun->accept('dirname', 'R');
		$lng = $this->fun->accept('lng', 'R');
		if (empty($dirname) || empty($lng)) {
			exit('false');
		}
		if (!preg_match("/^[\w]+$/i", $dirname)) {
			exit('false');
		}
		$db_table = db_prefix . 'subjectlist';
		$db_table2 = db_prefix . 'typelist';
		$db_where = " WHERE dirname='$dirname' AND lng='$lng'";
		$countnum = $this->db_numrows($db_table, $db_where);
		if ($countnum > 0) {
			$exportAjax = 'false';
		} else {
			$countnum = $this->db_numrows($db_table2, $db_where);
			if ($countnum > 0) {
				$exportAjax = 'false';
			} else {
				$exportAjax = 'true';
			}
		}
		exit($exportAjax);
	}

}

?>