<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function ontemplatelist() {
		$this->powercheck(197, 214);
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}

		$listtype = $this->fun->accept('listtype', 'R');
		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? ($this->CON['is_alonelng'] && !empty($this->CON['home_lng'])) ? $this->CON['home_lng'] : $this->CON['default_lng'] : $lng;
		$db_where = ' WHERE styleclass=1 and lng=\'' . $lng . '\'';
		$typeclass = $this->fun->accept('typeclass', 'R');
		if (!empty($typeclass)) {
			$db_where.=" AND typeclass='$typeclass'";
		}
		$fileclass = $this->fun->accept('fileclass', 'R');
		if (!empty($fileclass)) {
			$db_where.=" AND fileclass='$fileclass'";
		}
		$lockin = $this->fun->accept('lockin', 'R');
		if (!empty($lockin)) {
			if ($lockin == 2)
				$lockin = 0;
			$db_where.=' AND lockin=' . $lockin;
		}

		$limitkey = $this->fun->accept('limitkey', 'R');
		$limitkey = empty($limitkey) ? 'tmid' : $limitkey;

		$limitclass = $this->fun->accept('limitclass', 'R');
		$limitclass = empty($limitclass) ? 'DESC' : $limitclass;
		$db_table = db_prefix . 'templates';
		if (!empty($countnum)) {
			$countnum = $this->db_numrows($db_table, $db_where);
			exit($countnum);
		}
		$sql = 'SELECT tmid,lng,templatename,templatecode,title,pic,typeclass,fileclass,styleclass,lockin,addtime FROM ' . $db_table . $db_where . ' ORDER BY ' . $limitkey . ' ' . $limitclass . ' LIMIT ' . $MinPageid . ',' . $MaxPerPage;
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$templatecode = ($rsList['fileclass'] == 'index' && $rsList['typeclass'] == 'public') ? $rsList['templatecode'] : $rsList['typeclass'] . '/' . $rsList['templatecode'];
			$templatefile = admin_ROOT . 'templates/' . $this->CON['default_templates'] . '/' . $rsList['lng'] . '/' . $templatecode . '.' . $this->CON['templates_fileex'];
			$rsList['dirfile'] = @is_file($templatefile) ? 1 : 0;
			$array[] = $rsList;
		}
		$this->fun->setcookie($this->fun->noncefile() . 'pgid', $page_id, 600);
		$this->ectemplates->assign('array', $array);
		$this->ectemplates->assign('sql', $sql);
		$templatesfile = ($listtype == 'tab') ? 'template/template_tab_list' : 'template/template_list';
		$this->ectemplates->display($templatesfile);
	}

	function onlisttab() {
		parent::start_template();

		$lng = $this->fun->accept('lng', 'R');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		$typeclass = $this->fun->accept('typeclass', 'R');
		$fileclass = $this->fun->accept('fileclass', 'R');
		$listfunction = $this->fun->accept('listfunction', 'R');

		$loadurl = "index.php?archive=templatemain&action=templatelist&lng=$lng&typeclass=$typeclass&fileclass=$fileclass&styleclass=1&lockin=&limitkey=&limitclass=&listtype=tab";
		$inputtext = $this->fun->accept('inputtext', 'R');
		$inputtext = empty($inputtext) ? 'order' : $inputtext;
		$this->ectemplates->assign('inputtext', $inputtext);
		$this->ectemplates->assign('listfunction', $listfunction);
		$this->ectemplates->assign('loadurl', $loadurl);
		$this->ectemplates->display('template/template_tab');
	}

	function ontemplateadd() {
		include_once admin_ROOT . adminfile . '/include/inc_formtypelist.php';
		$this->powercheck(197, 200);
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lnglist = $this->get_lng_array($lng);
		$typeclass = array();
		foreach ($TEMPLATETYPE as $key => $value) {
			$typeclassname = $this->lng[$value['name']];
			$typeclass[$key]['key'] = $value['key'];
			$typeclass[$key]['name'] = $typeclassname;
		}
		$fileclass = array();
		foreach ($PAGETYPE as $key => $value) {
			$fileclassname = $this->lng[$value['name']];
			$fileclass[$key]['key'] = $value['key'];
			$fileclass[$key]['name'] = $fileclassname;
		}
		$this->ectemplates->assign('lnglist', $lnglist['list']);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->assign('typeclass', $typeclass);
		$this->ectemplates->assign('fileclass', $fileclass);
		$this->ectemplates->display('template/template_add');
	}

	function ontemplateedit() {
		$this->powercheck(197, 217);
		include_once admin_ROOT . adminfile . '/include/inc_formtypelist.php';
		parent::start_template();
		$db_table = db_prefix . 'templates';
		$tmid = intval($this->fun->accept('tmid', 'G'));
		$type = $this->fun->accept('type', 'G');
		$db_where = 'tmid=' . $tmid;
		$read = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
		$templatecode = ($read['fileclass'] == 'index' && $read['typeclass'] == 'public') ? $read['templatecode'] : $read['typeclass'] . '/' . $read['templatecode'];
		$templatefile = admin_ROOT . 'templates/' . $this->CON['default_templates'] . '/' . $read['lng'] . '/' . $templatecode . '.' . $this->CON['templates_fileex'];

		if (@is_file($templatefile)) {
			$templatecotent = @file_get_contents($templatefile);
		} else {
			$templatecotent = '';
		}
		$typeclass = array();
		foreach ($TEMPLATETYPE as $key => $value) {
			$typeclassname = $this->lng[$value['name']];
			$typeclass[$key]['key'] = $value['key'];
			$typeclass[$key]['name'] = $typeclassname;
			$typeclass[$key]['selected'] = $read['typeclass'] == $value['key'] ? 'selected' : '';
		}
		$fileclass = array();
		foreach ($PAGETYPE as $key => $value) {
			$fileclassname = $this->lng[$value['name']];
			$fileclass[$key]['key'] = $value['key'];
			$fileclass[$key]['name'] = $fileclassname;
			$fileclass[$key]['selected'] = $read['fileclass'] == $value['key'] ? 'selected' : '';
		}
		$lnglist = $this->get_lng_array($read['lng']);
		$this->ectemplates->assign('content', htmlspecialchars($templatecotent));
		$this->ectemplates->assign('lnglist', $lnglist['list']);
		$this->ectemplates->assign('typeclass', $typeclass);
		$this->ectemplates->assign('fileclass', $fileclass);
		$this->ectemplates->assign('tab', 'true');
		$this->ectemplates->assign('read', $read);
		$tempfile = $type == 'edit' ? 'template/template_edit' : 'template/template_copy';
		$this->ectemplates->display($tempfile);
	}

	function onsave() {
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$templatename = $this->fun->accept('templatename', 'P');
		$templatecode = $this->fun->accept('templatecode', 'P');
		$templatecontent = $this->fun->accept('templatecontent', 'P');
		$pic = $this->fun->accept('pic', 'P');
		$typeclass = $this->fun->accept('typeclass', 'P');
		$fileclass = $this->fun->accept('fileclass', 'P');
		$styleclass = $this->fun->accept('styleclass', 'P');
		$db_table = db_prefix . 'templates';
		$date = time();
		if ($inputclass == 'add') {
			$this->powercheck(197, 200);
			$db_field = 'lng,templatename,templatecode,title,templatecontent,pic,typeclass,fileclass,styleclass,lockin,addtime';
			$db_values = "'$lng','$templatename','$templatecode','','$templatecontent','$pic','$typeclass','$fileclass',$styleclass,0,$date";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['templatemain_add_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			exit('true');
		} elseif ($inputclass == 'edit') {
			$this->powercheck(197, 200);
			$tmid = $this->fun->accept('tmid', 'P');
			$content = $this->fun->accept('content', 'P');
			if (empty($content)) {
				exit('false');
			}
			$db_where = 'tmid=' . $tmid;
			$db_set = "templatename='$templatename',templatecontent='$content'";
			$templatedir = ($fileclass == 'index' && $typeclass == 'public') ? '' : $typeclass . '/';

			$tempdirpath = admin_ROOT . 'templates/' . $this->CON['default_templates'] . '/' . $lng;

			$tempdirpathdir = $tempdirpath . '/' . $templatedir;

			if ($this->fun->filemode($tempdirpath)) {

				if (!is_dir($tempdirpathdir)) {
					if (!@mkdir($tempdirpathdir, 0777, true))
						exit('false');
				}
			}else {
				exit('false');
			}
			$templatefilename = $tempdirpathdir . $templatecode . '.' . $this->CON['templates_fileex'];
			$filecontent = stripslashes(htmlspecialchars_decode($content));
			if (!$this->fun->filewrite($templatefilename, $filecontent)) {
				exit('false');
			}
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			$this->writelog($this->lng['templatemain_edit_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			exit('true');
		} elseif ($inputclass == 'copy') {
			$this->powercheck(197, 218);
			$content = $this->fun->accept('content', 'P');
			$db_field = 'lng,templatename,templatecode,title,templatecontent,pic,typeclass,fileclass,styleclass,lockin,addtime';
			$db_values = "'$lng','$templatename','$templatecode','','$content','$pic','$typeclass','$fileclass',$styleclass,0,$date";

			$templatedir = ($fileclass == 'index' && $typeclass == 'public') ? '' : $typeclass . '/';

			$tempdirpath = admin_ROOT . 'templates/' . $this->CON['default_templates'] . '/' . $lng;

			$tempdirpathdir = $tempdirpath . '/' . $templatedir;

			if ($this->fun->filemode($tempdirpath)) {

				if (!is_dir($tempdirpathdir)) {
					if (!@mkdir($tempdirpathdir, 0777, true))
						exit('false');
				}
			}else {
				exit('false');
			}
			$templatefilename = $tempdirpathdir . $templatecode . '.' . $this->CON['templates_fileex'];
			$filecontent = stripslashes(htmlspecialchars_decode($content));
			if (!$this->fun->filewrite($templatefilename, $filecontent)) {
				exit('false');
			}
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$this->writelog($this->lng['templatemain_copy_log'], $this->lng['log_extra_ok'] . ' templatename=' . $templatename);
			exit('true');
		}
	}

	function ondel() {
		$this->powercheck(197, 219);
		$db_table = db_prefix . 'templates';
		$tmid = $this->fun->accept('tmid', 'R');
		if (empty($tmid))
			exit('false');
		$db_where = "tmid=$tmid and lockin=0";
		$typeclass = $this->fun->accept('typeclass', 'R');
		$templatecode = $this->fun->accept('templatecode', 'R');
		$lng = $this->fun->accept('lng', 'R');
		if (empty($templatecode) || empty($typeclass) || empty($lng)) {
			exit('false');
		}
		$templatedir = ($typeclass != 'public') ? $typeclass . '/' : '';

		$tempdirpath = admin_ROOT . 'templates/' . $this->CON['default_templates'] . '/' . $lng . '/' . $templatedir . $templatecode . '.' . $this->CON['templates_fileex'];
		if (is_file($tempdirpath)) {
			$this->fun->delfile($tempdirpath);
		}
		$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		$this->writelog($this->lng['templatemain_del_log'], $this->lng['log_extra_ok'] . ' id=' . $tmid);
		exit('true');
	}

	function oncheckcode() {

		$templatecode = $this->fun->accept('templatecode', 'R');
		$typeclass = $this->fun->accept('typeclass', 'R');
		$db_table = db_prefix . 'templates';
		$db_where = " WHERE templatecode='$templatecode' AND typeclass='$typeclass' AND styleclass=1";
		$countnum = $this->db_numrows($db_table, $db_where);
		if ($countnum > 0) {
			$exportAjax = 'false';
		} else {
			$exportAjax = 'true';
		}
		exit($exportAjax);
	}

	function onlabelcreat() {
		$this->powercheck(197, 244);
		parent::start_template();
		$tab = $this->fun->accept('tab', 'G');
		$tab = empty($tab) ? 'true' : $tab;
		$plugcode = $this->fun->accept('plugcode', 'R');
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;

		$lable = $this->fun->readplug(admin_ROOT . 'public/lable');
		$plugcode = empty($plugcode) ? $lable[0]['code'] : $plugcode;

		$modulesid = true;
		$modules = array();
		require admin_ROOT . 'public/lable/' . $plugcode . '.php';
		$lablelist = $modules[0];
		unset($modulesid);
		$this->ectemplates->assign('lable', $lable);
		$this->ectemplates->assign('lable_config', $lablelist['config']);
		$this->ectemplates->assign('lablelist', $lablelist);

		$lnglist = $this->get_lng_array($lng);
		$this->ectemplates->assign('lnglist', $lnglist['list']);

		$mid = $this->fun->accept('mid', 'R');
		$mid = empty($mid) ? 0 : $mid;
		$modelarray = $this->get_model(0, $lng, 1);
		$this->ectemplates->assign('modelarray', $modelarray['list']);
		$this->ectemplates->assign('tab', $tab);
		$this->ectemplates->display('template/template_label_creat');
	}

	function onlabeldb() {
		$inputclass = $this->fun->accept('inputclass', 'P');
		$lng = $this->fun->accept('lng', 'P');
		$labeltype = $this->fun->accept('labeltype', 'P');
		$mid = $this->fun->accept('mid', 'P');
		$tid = $this->fun->accept('tid', 'P');
		$sid = $this->fun->accept('sid', 'P');
		$dlid = $this->fun->accept('dlid', 'P');
		$blid = $this->fun->accept('blid', 'P');
		$btid = $this->fun->accept('btid', 'P');
		$inputvalue = $this->fun->accept('inputvalue', 'P');
		$inputname = $this->fun->accept('inputname', 'P');
		if (empty($labeltype)) {
			return false;
		}
		$otherarray = array('blid' => $blid, 'btid' => $btid);
		$newArray = array();
		if (is_array($inputname)) {
			foreach ($inputname as $key => $value) {
				$newArray[] = array($value => $inputvalue[$key]);
			}
		}
		include_once admin_ROOT . 'public/lable/' . $labeltype . '.php';
		$plugpay = new $labeltype();
		$lable = $plugpay->get_code($lng, $mid, $tid, $sid, $dlid, $newArray, $otherarray);
		if ($lable) {
			exit($lable);
		} else {
			exit('false');
		}
	}

	function onattrindex() {

		$plugcode = $this->fun->accept('code', 'G');
		$lng = $this->fun->accept('lng', 'G');
		$lng = empty($lng) ? $this->CON['default_lng'] : $lng;
		$lnglist = $this->get_lng_array($lng);

		$mid = $this->fun->accept('mid', 'R');
		$mid = empty($mid) ? 0 : $mid;
		$modelarray = $this->get_model(0, $lng, 1);

		$modulesid = true;
		$modules = array();

		include_once admin_ROOT . 'public/lable/' . $plugcode . '.php';
		$lablelist = $modules[0];
		unset($modulesid);
		$attrlist.='<table border="0" width="100%">
				<tr class="trstyle2">
					<td class="trtitle01">' . $this->lng['templatemain_add_label_str'] . '</td>
					<td class="trtitle02">' . $lablelist['desc'] . '</td>
				</tr>';

		if ($lablelist['lng'] == 1 && is_array($lnglist['list'])) {
			$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['article_doc_add_win_lng'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="lng" id="lng" onchange="javascript:selectlinkagelng(\'mid\',\'index.php?archive=connected&action=scmodellist&lng=\'+this.value);searchoption(1000000,\'' . urlencode($this->lng['all_botton']) . '\')">';
			foreach ($lnglist['list'] as $key => $value) {
				$attrlist.='<option ' . $value['selected'] . ' value="' . $value['lng'] . '">' . $value['lngtitle'] . '</option>';
			}
			$attrlist.='</select></td></tr>';
		}

		if ($lablelist['mid'] == 1 && is_array($modelarray['list'])) {
			$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['article_doc_add_win_model'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="mid" id="mid" onchange="javascript:searchoption(this.value,\'' . urlencode($this->lng['all_botton']) . '\')"><option value="0">' . $this->lng['typemanage_type_add_mid_option'] . '</option>';
			foreach ($modelarray['list'] as $key => $value) {
				$attrlist.='<option ' . $value['selected'] . ' value="' . $value['mid'] . '">' . $value['modelname'] . '</option>';
			}
			$attrlist.='</select></td></tr>';
		}

		if ($lablelist['tid'] == 1) {
			$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['article_doc_add_tid'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="tid" id="tid"><option value="0">' . $this->lng['all_botton'] . '</option>';
			$attrlist.='</select></td></tr>';
		}

		if ($lablelist['sid'] == 1) {
			$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['article_doc_add_sid'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="sid" id="sid"><option value="0">' . $this->lng['all_botton'] . '</option>';
			$attrlist.='</select></td></tr>';
		}

		if ($lablelist['dlid'] == 1) {
			$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['viewtype_botton'] . '</td>
				<td width="85%" class="trtitle02"><span id="dlidlist"><input type="radio" value="0" checked="checked" name="dlid"/> ' . $this->lng['all_botton'] . '</span></td></tr>';
		}

		if ($lablelist['btid'] == 1) {
			$bbstype = $this->get_bbstype_array(0, $lng);
			if (is_array($bbstype['list'])) {
				$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['templatemain_add_label_bbstype'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="btid" id="btid"><option value="0">' . $this->lng['all_botton'] . '</option>';
				foreach ($bbstype['list'] as $key => $value) {
					$attrlist.='<option ' . $value['selected'] . ' value="' . $value['btid'] . '">' . $value['typename'] . '</option>';
				}
				$attrlist.='</select></td></tr>';
			}
		}

		if ($lablelist['blid'] == 1) {
			$bbslabel = $this->get_bbslabel_array(0, $lng, 1);
			if (is_array($bbslabel['list'])) {
				$attrlist.='<tr class="trstyle2"><td width="15%" class="trtitle01">' . $this->lng['templatemain_add_label_bbslate'] . '</td>
				<td width="85%" class="trtitle02"><select size="1" name="blid" id="blid"><option value="0">' . $this->lng['all_botton'] . '</option>';
				foreach ($bbslabel['list'] as $key => $value) {
					$attrlist.='<option ' . $value['selected'] . ' value="' . $value['blid'] . '">' . $value['labelname'] . '</option>';
				}
				$attrlist.='</select></td></tr>';
			}
		}
		foreach ($lablelist['config'] as $key => $valuer) {
			if ($valuer['str']) {
				$str = '<span class="cautiontitle">' . $valuer['str'] . '</span>';
			} else {
				$str = null;
			}
			switch ($valuer['type']) {
				case 'text':
					$attrlist.='
					<tr class="trstyle2">
						<td width="15%" class="trtitle01">' . $valuer['botname'] . '</td>
						<td width="85%" class="trtitle02">
							<input type="text" name="inputvalue[]" maxlength="200" size="20" value="' . $valuer['value'] . '" class="infoInput">
							<input type="hidden" name="inputname[]" value="' . $valuer['name'] . '">
							' . $str . '
						</td>
					</tr>';
					break;
				case 'select':
					$attrlist.='<tr class="trstyle2">
						<td width="15%" class="trtitle01">' . $valuer['botname'] . '</td>
						<td width="85%" class="trtitle02"><select size=1 name="inputvalue[]">';
					foreach ($valuer['sevalue'] as $key2 => $valuer2) {
						$selected = ($key2 == $paylist['value']) ? 'selected' : '';
						$sevaluer.=$valuer2 . '|';
						$attrlist.='<option ' . $selected . ' value=' . $key2 . '>' . $valuer2 . '</option>';
					}
					$attrlist.='</select>
					<input type="hidden" name="inputname[]" value="' . $valuer['name'] . '">
					' . $str . '
					</td></tr>';
					break;
			}
			$sevaluer = '';
		}
		$attrlist.='</table>';
		exit($attrlist);
	}

}
?>