<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormQuery()
  ===================================================*/

  function ShowFormQuery() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form

    // vars messages

    // vars template

    DisplayTemplate($admin_template_path . "db_query.html");
  }


  /*===================================================
    ProcessFormQuery()
  ===================================================*/

  function ProcessFormQuery() {

    // vars global configuration
    global $dbConn, $admin_template_path;

    // vars url & form
    global $db_query;

    // vars messages
    global $msg;

    // vars template
    global $message;

    $tpl = new Template();

    $query = trim(stripslashes($db_query));
    $result = $dbConn->Execute($query);

    if ($result) {
      $message = $msg["20373"];
      if (preg_match("/^select|show|describe|explain/msi", $query)) {
        $num_field = $result->FieldCount();
        $i = 0;
        $query_result = '<br><br><table width="100%"  cellpadding="4" cellspacing="0"><tr>';
        while ($i < $num_field) {
          $field = $result->FetchField($i);
          $query_result .= '<td><strong>'.ucwords($field->name).'</strong></td>';
          $i++;
        }
        $query_result .= '</tr><tr><td colspan="'.$num_field.'"><hr size=1 color="Black"></td></tr>';
        $i = 0;
        while ($row = $result->FetchRow()) {
          if ($i % 2) {
            $tbl_class = "tbl_light";
          }
          else {
            $tbl_class = "tbl_light2";
          }
          $query_result .= '<tr class="'.$tbl_class.'">';
          $j = 0;
          while ($j < $num_field) {
            $field = $result->FetchField($j);
            $query_result .= '<td>'.htmlspecialchars($row[$field->name]).'</td>';
            $j++;
          }
          $query_result .= '</tr>';
          $i++;
        }
        $query_result .= '</table>';
        $message .= $query_result;
      }
      if (preg_match("/^insert|update|delete/msi", $query)) {
        if (preg_match("/^insert/msi", $query)) {
          $message .= $msg["20376"];
        }
        if (preg_match("/^update/msi", $query)) {
          $message .= $msg["20377"];
        }
        if (preg_match("/^delete/msi", $query)) {
          $message .= $msg["20378"];
        }
        $tpl->assign('affected_rows', $dbConn->AffectedRows());
        $message = $tpl->fetch('var:' . $message);
      }
    }
    else {
      $tpl->assign('mysql_error', $dbConn->ErrorMsg());
      $message = $tpl->fetch('var:' . $msg["20374"]);
    }

    DisplayTemplate($admin_template_path . "message.html","\$message");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  if (empty($pflag)) {
    ShowFormQuery();
  }
  elseif ($pflag == 'query') {
    ProcessFormQuery();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>