<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormReportBadLink()
  ===================================================*/

  function ShowFormReportBadLink() {

    // vars global configuration
    global $category_separator, $theme_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $link_id, $title, $url, $r_name, $r_email;

    $r_name    = stripslashes($r_name);

    $links_obj = new clsLink;
    $links_obj->table_name          = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->template_file       = $theme_path . "bad_link_form.html";
    $bad_link_form                  = $links_obj->BadLinkReport("display_form", $id);

    print $bad_link_form;
  }

  /*===================================================
    ProcessFormReportBadLink()
  ===================================================*/
  
  function ProcessFormReportBadLink() {

    // vars global configuration
    global $dbConn, $theme_path, $category_separator, $new_limit, $email_address;

    // vars url & form
    global $id, $r_name, $r_email, $type;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $category, $type_val;

    // verify input

    if (!empty($r_email) && !IsEmailAddress($r_email))
      $error_msg = $msg["10231"];

    if (empty($error_msg)) {

      // get field
      $links_obj = new clsLink;
        $links_obj->table_name          = "idx_link";
      $links_obj->category_table_name = "idx_category";
      $links_obj->editor_table_name   = "idx_editor";
      $links_obj->user_table_name     = "idx_users";
      $links_obj->bad_link_table_name = "idx_bad_link";
      $links_obj->BadLinkReport("process_form", $id, $r_name, $r_email, $type);

      DisplayTemplate($theme_path . "bad_link_ok.html");

      $users_obj = new clsUsers;
        $users_obj->table_name = "idx_users";

      // send email to all editors and admin

      $query    = "select category_id from idx_link where link_id = '$id'";
      $result   = $dbConn->Execute($query);
      $cat      = $result->Fields("category_id");
      $emails   = $links_obj->GetEditorEmail($cat);
      $emails[] = $email_address;

      while (list(, $v) = @each($emails)) {
        $body = EvalTemplate($theme_path . "mail/bad_link_editor.mail", $links_obj->email_template_fields);
        $from = $email_address;
        @mail($v, $msg["10241"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");
      }
    }
    else {
      ShowFormReportBadLink();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormReportBadLink();
  }
  elseif ($pflag == 'bad_link') {
    ProcessFormReportBadLink();
  }

  RunPostFilter(__FILE__);

?>