<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

function filter_gzip_compression($type = "pre", $file = "") {
  global $enable_page_compression;
  static $enable_filter_gzip_compression = null;

  if (is_null($enable_filter_gzip_compression)) {
    $enable_filter_gzip_compression = $enable_page_compression;
  }

  if ($type == 'pre') {
    if ($enable_filter_gzip_compression) {
      if (ini_get('zlib.output_compression')) {
        $enable_filter_gzip_compression = 0;
      }
      if ($enable_filter_gzip_compression) {
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'W3C_Validator') !== false 
          || strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') === false
          || (strtoupper($_SERVER["REQUEST_METHOD"]) == "POST")) {
          $enable_filter_gzip_compression = 0;
        }
      }
      if ($enable_filter_gzip_compression) {
        ob_start();
        ob_implicit_flush(0);
        header('Content-Encoding: gzip');
        return;
      }
    }
    ob_start();
  }

  if ($type == 'post') {
    if ($enable_filter_gzip_compression) {
      $gzip_contents = ob_get_contents();
      $gzip_contents .= "\n<!-- compressed page -->";
      ob_end_clean();
      $gzip_size = strlen($gzip_contents);
      $gzip_crc = crc32($gzip_contents);
      $gzip_contents = gzcompress($gzip_contents, 1);
      $gzip_contents = substr($gzip_contents, 0, strlen($gzip_contents) - 4);
      echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
      echo $gzip_contents;
      echo pack('V', $gzip_crc);
      echo pack('V', $gzip_size);
    }
    else{
      ob_end_flush();
    }
  }
}

?>
