<?php
function getIndexLink()
{
	switch (app_viewtype)
	{
		case 2:
			$funresult= app_installdir."index.".app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."index.php";
			break;
	} 
	return $funresult;
} 

function getMapLink()
{
	switch (app_viewtype)
	{
		case 2:
			$funresult=app_installdir."allvod.".app_htmlSuffix;
			break;
		case 3:
			$funresult=app_installdir."allvod.".app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."allvod.php";
			break;
	} 
	return $funresult;
} 

function getTopicLink($flag)
{
	if ($flag=="vod"){ $str="vodtopicindex";	}	else{ $str="arttopicindex"; } 
	switch (app_viewtype)
	{
		case 2:
			$funresult=app_installdir.$str."/index.".app_htmlSuffix;
			break;
		case 3:
			$funresult=app_installdir.$str."/index.".app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir.$str."/index.php";
			break;
	} 
	return $funresult;
} 

function getArtLink($id,$name,$enname,$typeid,$typename,$typeenname)
{
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."art/index.php?ID=".$id;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_artpath);
			$str = str_replace("{name}", repSpecialChar($name),$str );
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$str = str_replace("{typeid}",$typeid ,$str );
			$str = str_replace("{typename}",$typename,$str );
			$str = str_replace("{typeenname}",$typeenname,$str );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."art/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."art/?".$id.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getArtTypeLink($id,$name,$enname)
{
	if ($id==0){
		$funresult=app_installdir."artlist/index.php?ID=".$id;
		return $funresult;
	}
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."artlist/index.php?ID=".$id;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_artlistpath);
			$str = str_replace("{name}",$name,$str);
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."artlist/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."artlist/?".$id.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 


function getArtTopicLink($id,$name,$enname)
{
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."arttopic/index.php?topicid=".$id;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_arttopicpath);
			$str = str_replace("{name}",$name,$str);
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."arttopic/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."arttopic/?".$id.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getVodLink($id,$name,$enname,$typeid,$typename,$typeenname)
{
	
	if (app_playtype==1){	$funresult=getVodPlayUrl($id,$name,$enname,$typid,$typename,$typeenname,1,0); return $funresult;	} 
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."vod/index.php?ID=".$id;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_vodpath);
			$str = str_replace("{name}", repSpecialChar($name),$str );
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$str = str_replace("{typeid}",$typeid ,$str );
			$str = str_replace("{typename}",$typename,$str );
			$str = str_replace("{typeenname}",$typeenname,$str );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."vod/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."vod/?".$id.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getVodTypeLink($id,$name,$enname)
{
	if ($id==0){
		$funresult=app_installdir."vodlist/index.php?ID=".$id;
		return $funresult;
	}
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."vodlist/index.php?ID=".$id;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_vodlistpath);
			$str = str_replace("{name}",$name,$str);
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."vodlist/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."vodlist/?".$id.".".app_htmlSuffix;
			break;
	}
	
	return $funresult;
} 

function getVodTopicLink($id,$name,$enname)
{
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."vodtopic/index.php?ID=".$id;
			break;
		case 2:	  
			$str = str_replace("{id}",$id,app_vodtopicpath);
			$str = str_replace("{name}",$name,$str);
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir ."vodtopic/" . $id . "." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."vodtopic/?".$id.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getVodAfterLink($id,$typeid,$typename,$typeenname,$flag)
{
	global $db;
	$sql="select top 1 d_id,d_type,d_name,d_enname from tbl_vod where 1=1 ";
	if ($flag==1){
		$strSymbol=">"; $strOrder="asc";
	}
	else{
		$strSymbol="<"; $strOrder="desc";
	} 
	$sql=$sql." and d_id ".$strSymbol.$id;
	if (!isN($typeid)){
		$sql=$sql." and d_type=".$typeid;
	} 
	$sql=$sql." order by d_id asc";
	$rs=$db->query($sql);
	$funresult="#";
	if (!$rs->eof){
		$funresult= getVodLink($rs["d_id"],$rs["d_name"],$rs["d_enname"],$typeid,$typename,$typeenname);
	}
	return $funresult;
} 

function getVodPlayLink($id,$name,$enname,$typeid,$typename,$typeenname,$sort,$num)
{
	switch (app_viewtype)
	{
		case 1:
			$funresult=app_installdir."vodplay/index.php?id=".$id."&sort=1&num=0";
			break;
		case 2:
			$str = str_replace("{id}",$id,app_vodplaypath);
			$str = str_replace("{name}", repSpecialChar($name),$str );
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$str = str_replace("{typeid}",$typeid ,$str );
			$str = str_replace("{typename}",$typename,$str );
			$str = str_replace("{typeenname}",$typeenname,$str );
			if (app_makeplay==2) { $str .=  "-" . $sort ."-" . $num; }
			$funresult= app_installdir . $str . "." . app_htmlSuffix;
			break;
		case 3:
			$funresult = app_installdir . "vodplay/" . $id . "-1-0." . app_htmlSuffix;
			break;
		default:
			$funresult=app_installdir."vodplay/?".$id.",1,1.".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getVodPlayUrl($id,$name,$enname,$typeid,$typename,$typeenname,$sort,$num)
{
	if (app_playisopen==0){
		$strJSstart=""; $strJSend="";
	}
	else{
		$strJSstart="javascript:OpenWindow('"; $strJSend="',popenW,popenH);";
	}
	if (app_viewtype==2 && app_makeplay==0){
		$funresult=$strJSstart.app_installdir."vodplay/?".$id.",".$sort.",".$num.".".app_htmlSuffix.$strJSend;
		return $funresult;
	} 
	switch (app_viewtype)
	{
		case 1:
			$funresult = app_installdir."vodplay/index.php?id=".$id. "&sort=".$sort."&num=".$num;
			break;
		case 2:
			$str = str_replace("{id}",$id,app_vodplaypath);
			$str = str_replace("{name}", repSpecialChar($name),$str );
			$str = replaceStr( $str ,"{enname}", repSpecialChar($enname) );
			$str = str_replace("{typeid}",$typeid ,$str );
			$str = str_replace("{typename}",$typename,$str );
			$str = str_replace("{typeenname}",$typeenname,$str );
			if(app_makeplay==2){
				$str = $str . "-" . $sort ."-" . $num;
				$funresult= app_installdir . $str . "." . app_htmlSuffix;
			}
			else
			{$funresult= $strJSstart . app_installdir . $str . "." . app_htmlSuffix . "?" . $id . "," . $sort . "," . $num . $strJSend;}
			break;
		case 3:
			$funresult = app_installdir . "vodplay/" . $id . "-". $sort ."-". $num ."." . app_htmlSuffix;
			break;
		default:
			$funresult=$strJSstart.app_installdir."vodplay/?".$id.",".$sort.",".$num.".".app_htmlSuffix.$strJSend;
			break;
	} 
	return $funresult;
} 

function goViewStaticLink($querystr,$stype)
{
	global $db;
	if (strpos($querystr,"=")){
		$sarr = explode("&",$querystr);
		if (count($sarr)==1){
			$sid = replaceStr($sarr[0],"ID=","");
		}
	}
	else{
		$querystr = replaceStr($querystr,".".app_htmlSuffix,"");
		$sarr = explode("-",$querystr);
		$sid  = $sarr[0];
	}
	if (!isNum($sid)) { die(""); }
	
	if ($stype=="vod"){
		$row = $db->getRow("select d_id,d_name,d_enname,d_type from tbl_vod where d_id=".$sid);
		$arrVodType = getVodTypeByArrayByCache($row["d_type"]);
		$slink = getVodLink($sid,$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]);
	}
	else{
		$row = $db->getOne("select a_id,a_title,a_entitle,a_type from tbl_art where a_id=".$sid);
		$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
		
		$slink = getArtLink($sid,$row["a_title"],$row["a_entitle"],$row["a_type"],$arrArtType["t_name"],$arrArtType["t_enname"]);
	}
	redirect($slink);
}

function goTypeStaticLink($querystr,$stype)
{
	global $CurVodTypeid,$CurArtTypeid;
	$querystr = strtolower($querystr);
	if (strpos($querystr,"=")){
		$sarr = explode("&",$querystr);
		if (count($sarr)==1){
			$sid = replaceStr($sarr[0],"id=","");
			$spage = replaceStr($sarr[1],"page=","");
		}
	}
	else{
		$querystr = replaceStr($querystr,".".app_htmlSuffix,"");
		$sarr = explode("-",$querystr);
		$sid  = $sarr[0];
		$spage = $sarr[1];
		if(isN($spage)){$spage=1;}
	}
	if (!isNum($sid)) { die(""); }
	if($sid==0) { redirect("index.php?ID=0"); } 
	if($stype=="vodtypelist"){ $CurVodTypeid=$sid; } else{ $CurArtTypeid=$sid; }
	$slink = getPagelink($spage,$stype);
	redirect($slink);
}

function getVodCount($flag)
{
	global $db;
	$whereStr="";
	if ($flag=="day"){
		$whereStr=" where STR_TO_DATE(d_addtime,'%Y-%m-%d')='".date("Y-m-d")."'";
	}
	$dbresult=$db->getRow("select count(*) as cc from tbl_vod " .$whereStr);
	return $dbresult["cc"];
} 

function getUserCount($flag)
{
	global $db;
	if ($flag=="day"){
		$whereStr=" where STR_TO_DATE(u_regdate,'%Y-%m-%d')='".date("Y-m-d")."'";
	}
	$dbresult=$db->getRow("select count(*) as cc from tbl_user " .$awhere);
	return $dbresult["cc"];
} 

function getUserFlag($flag)
{
	switch ($flag)
	{
		case 1:
			$funresult="ʱ";
			break;
		case 2:
			$funresult="IP";
			break;
		default:
			$funresult="Ƶ";
			break;
	}
	return $funresult;
}

function getPlaySource($vodid,$flag)
{
	global $db;
	$rc=false;
	$rs=$db->query("select du_from from tbl_vod_url where du_vodid=".$vodid ."");
	if (!$rs){
		$funresult="δ֪";
	}
	else{
		while ($row = $db ->fetch_array($rs))
		{
			if($rc){ $funresult .=","; }
			$funresult .=$row["du_from"];
			if(!$flag){break;}
			$rc=true;
		}
	}
	return $funresult;
} 

function getDicName($table,$tablesname,$tablesid,$id)
{
	global $db;
	if (!isN($id)){
		$sql="select ".$tablesname." from ".$table." where ".$tablesid."=".$id;
		$dbresult=$db->getRow($sql);
		$funresult=$dbresult[$tablesname];
	}
	else{
		$funresult="";
	}
	return $funresult;
} 

function getDicCount($table,$tablesid,$id)
{
	global $db;
	if (!isN($id)){
		$dbresult=$db->getRow("select count(*) as cc from ".$table." where ".$tablesid." in(".$id.")");
		$funresult=$dbresult["cc"];
	}
	else{
		$funresult="0";
	} 
	return $funresult;
} 

function getKeywordToSqlLike($key,$colname)
{
	$key=replaceStr($key,"",",");
	$key=replaceStr($key," ",",");
	$key=replaceStr($key,",,",",");
	$tempArray=explode(",",$key);
	if(isN($key)){
		return $colname." ='' ";
	}
	if (count($tempArray)>=0){
		$strTemp=" or (";
	}
	
	for ($i=0; $i<=count($tempArray); $i=$i+1){
		if(!isN($tempArray[$i])){
			$strTemp=$strTemp.$colname." like '%".$tempArray[$i]."%' or ";
		}
	}
	if (substr($strTemp,strlen($strTemp)-(3))=="or "){
		$strTemp=substr($strTemp,0,strlen($strTemp)-3);
	} 
	if (count($tempArray)>=0){
		$strTemp=$strTemp.")";
	}
	
	$funresult=$strTemp;
	return $funresult;
} 

function getKeyLink($key,$ktype)
{
	return "<a target='_blank' href='". app_installdir . "search.php?keytype=".$ktype."&keyword=".$key."'>".$key."</a>";
}

function getKeysLink($key,$ktype)
{
	$tempArray = explode(" ",$key);
	for ($i=0;$i<count($tempArray);$i++){
		$strTemp .= "<a target='_blank' href='".app_installdir."search.php?keytype=".$ktype."&keyword=". $tempArray[$i]."'>".$tempArray[$i]."</a>&nbsp;&nbsp;";
	}
	return $strTemp;
}

function repSpecialChar($str)
{
	$str = str_replace("/","_",$str);
	$str = str_replace("\\","_",$str);
	$str = str_replace("[","",$str);
	$str = str_replace("]","",$str);
	return $str;
}

function repPse($txt,$id)
{
	global $root;
	$id = $id % 7;
	if (isN($txt)){ $txt=""; }
	$psecontent = getCacheFile("dim_pse2",$root. "inc/dim_pse2.txt" );
	if (isN($psecontent)){ $psecontent = ""; }
	$psecontent = replaceStr($psecontent,chr(10),"");
	$psearr = explode(chr(13),$psecontent);
	$i=count($psearr)+1;
	$j=strpos($txt,"<br>");
	
	if ($j==0){ $j=strpos($txt,"<br/>");}
	if ($j==0){ $j=strpos($txt,"<br />");}
	if ($j==0){ $j=strpos($txt,"</p>");}
	if ($j==0){ $j=strpos($txt,"")+1;}
	
	if ($j>0){
		$funresult= substring($txt,$j-1) . $psearr[$id % $i] . substring($txt,strlen($txt)-$j,$j);
	}
	else{
		$funresult= $psearr[$id % 1]. $txt;
	}
	return $funresult;
}

function badFilter($Str)
{
	$filters=app_filter;
	$badKeywordArr=explode(",",$filters);
	for ($s_i=0; $s_i<=count($badKeywordArr); $s_i=$s_i+1){
		$Str=str_replace($badKeywordArr[$s_i],"***",$Str);
	}
	$funresult=$Str;
	return $funresult;
} 


function GetPageNum($pagenow,$prepage,$pagecount,$linktype)
{
	global $keytype,$keyword;
	if ($prepage%2==0){
		$loopnum1=$prepage/2;
		$loopnum2=$prepage/2;
	}
	else{
		$loopnum1=intval($prepage/2)+1;
		$loopnum2=intval($prepage/2);
	}
	$i=$pagenow-$loopnum1+1;
	$j=$pagenow+$loopnum2;
	if ($i<1){
		$i=1; 
		$j=$prepage;
	} 
	if ($j>$pagecount){
		$i=$i+($pagecount-$j);
		$j=$pagecount;
		if ($i<1){
			$i=1;
		} 
	} 
	for ($p=$i; $p<=$j; $p=$p+1)
	{
		switch ($linktype)
		{
			case "vodtopiclist":
			case "arttopiclist":
			case "vodtypelist":
			case "arttypelist":
				if ($p==$pagenow){
					$looplink=$looplink."<span class=\"current\">".$p."</span> ";
				}
				else{
					$looplink=$looplink."<a href='".getPageLink($p,$linktype)."'>".$p."</a> ";
				} 
				break;
			case "vodsearchlist":
			case "artsearchlist":
				if ($p==$pagenow){
					$looplink=$looplink."<span class=\"current\">".$p."</span> ";
				}
				else{
					$looplink=$looplink."<a href='?page=".$p."&keyword=".$keyword."&searchtype=".replaceStr($linktype,"list","")."&keytype=".$keytype."'>".$p."</a> ";
				} 

				break;
			
			case "indexpagelist":
				if ($p==$pagenow){
					$looplink=$looplink."<span class=\"current\">".$p."</span> ";
				}
				else{
					$looplink=$looplink."<a href='".getIndexPageLink($p)."'>".$p."</a> ";
				}
			break;
		}
	}
	$funresult=$looplink;
	return $funresult;
} 

function getIndexPageLink($pagenum)
{
	if (intval($pagenum)==1) { $strTemp="" ;} else {$strTemp="?page=".$pagenum;}
	return   app_installdir."index.php".$strTemp;
}
	

function getPageLink($pagenum,$pageflag)
{
	global $CurVodTypeid,$CurArtTypeid,$CurVodTopicid,$CurArtTopicid;
	
	if ($pageflag=="vodtypelist"){
		$strPath="vodlist"; $strHtmlPath=app_vodlistpath; $strID=$CurVodTypeid;
	}
	elseif ($pageflag=="arttypelist"){
		$strPath="artlist"; $strHtmlPath=app_artlistpath; $strID=$CurArtTypeid;
	}
	elseif ($pageflag=="vodtopiclist"){
		$strPath="vodtopic"; $strHtmlPath=app_vodtopicpath; $strID=$CurVodTopicid;
	}
	elseif ($pageflag=="arttopiclist"){
		$strPath="arttopic"; $strHtmlPath=app_arttopicpath; $strID=$CurArtTopicid;	
	}
	
	if ($strID==0){
		if (intval($pagenum)==1){ $strTemp=""; }	else{ $strTemp="&page=".$pagenum; } 
		$funresult=app_installdir.$strPath."/index.php?ID=".$strID.$strTemp;
		return $funresult;
	}
	
	switch (app_viewtype)
	{
		case 1:
			if (intval($pagenum)==1){ $strTemp=""; }else{ $strTemp="&page=".$pagenum; } 
			$funresult=app_installdir.$strPath."/index.php?ID=".$strID.$strTemp;
			break;
		case 2:
			if ($pageflag=="vodtypelist"){
				$typePath= getVodTypeByArrayByCache($strID);
			}
			else if ($pageflag=="arttypelist"){
				$typePath=getArtTypeByArrayByCache($strID);
			}
			else if ($pageflag=="vodtopiclist"){
				$typePath= getTopicByArrayByCache($strID,"vod");
			}
			elseif ($pageflag=="arttopiclist"){
				$typePath= getTopicByArrayByCache($strID,"art");
			}
			$strHtmlPath = replaceStr($strHtmlPath,"{id}",$strID);
			$strHtmlPath = replaceStr($strHtmlPath,"{name}",$typePath["t_name"]);
			$strHtmlPath = replaceStr($strHtmlPath,"{enname}",$typePath["t_enname"]);
			if (intval($pagenum)==1){ $strTemp=""; } else{ $strTemp="_".$pagenum; }
			$funresult=app_installdir.$strHtmlPath.$strTemp.".".app_htmlSuffix;
			break;
		case 3:
			if (intval($pagenum)==1) {	$strTemp=""; } else{ $strTemp="-".$pagenum; } 
			$funresult=app_installdir.$strPath."/".$strID. $strTemp.".".app_htmlSuffix;
			break;
		default:
			if (intval($pagenum)==1) {	$strTemp=""; } else{ $strTemp="-".$pagenum; } 
			$funresult=app_installdir.$strPath."/?".$strID.$strTemp.".".app_htmlSuffix;
			break;
	} 
	return $funresult;
} 

function getTopicPage($pagenum,$pageflag)
{
	if ($pageflag=="vodtopicindex"){
		$strPath="vodtopicindex"; $strHtmlPath=app_vodtopicpath;
	}
	else if ($pageflag=="arttopicindex"){
		$strPath="arttopicindex"; $strHtmlPath=app_arttopicpath;
	} 
	switch (app_viewtype)
	{
		case 2:
			if (intval($pagenum)==1){ $pagenum=""; }
			$funresult=app_installdir.$strPath."/index".$pagenum.".".app_htmlSuffix;
			break;
		default:
			if (intval($pagenum)==1){ $strTemp=""; } else{ $strTemp="?page=".$pagenum; } 
			$funresult=app_installdir.$strPath."/index.php".$strTemp;
			break;
	} 
	return $funresult;
} 

function getPlayer()
{
	$funresult= "<script>var strUrlQS=getQS('".app_htmlSuffix."');getPlayer(strUrlQS[1],strUrlQS[2]);</script>";
	return $funresult;
} 

function getPlayInfo($VodID,$VodName)
{
	global $db;
	$sql="SELECT du_id,du_from,du_url,du_sort,du_serverid,ds_url FROM (tbl_vod_url LEFT OUTER JOIN tbl_vod_server ON tbl_vod_url.du_serverid = tbl_vod_server.ds_id) where du_vodid = ".$VodID." order by du_sort asc";

	$rs=$db->query($sql);
	if ($rs){
		$arrCount=$db->num_rows($rs);
	}
	else{
		$arrCount=-1;
	} 
	$playcount=0; $i=0;
	$urlStr="<script>"."\r\n";
	while ($row = $db ->fetch_array($rs))
	{
		$playcount = $playcount + 1;
		$num=$i+1; 
		$playtype="playtype".$num;
		$playlist="playlist".$num;
		$playserver="playserver".$num;
		$playlistval=$row["du_url"];
		$playlistval=str_replace(chr(13),"",$playlistval); 
		$playlistval=str_replace(chr(10),"",$playlistval);
		$playlistval=replaceStr($playlistval,"<server>",$row["ds_url"]);
		$playtypeval=$row["du_from"]; 
		$playserverval=$row["ds_url"];
		if (app_encrypt==1){
			$urlStr=$urlStr."var ".$playtype."= unescape('".escape($playtypeval)."');"."\r\n"."var ".$playlist." =unescape('".escape($playlistval)."');"."\r\n"."var ".$playserver."=unescape('".escape($playserverval)."');"."\r\n";
		}
		elseif (app_encrypt==2){
			$urlStr=$urlStr."var ".$playtype."= unescape(base64decode('".base64_encode(escape($playtypeval))	."'));"."\r\n"."var ".$playlist." = unescape(base64decode('".base64_encode(escape($playlistval))."'));"."\r\n"."var ".$playserver."= unescape(base64decode('".base64_encode(escape($playserverval))."'));"."\r\n";
		}
		else{
			$urlStr=$urlStr."var ".$playtype."= '".$playtypeval."';"."\r\n"."var ".$playlist." = '".$playlistval."';"."\r\n"."var ".$playserver."='".$playserverval."';"."\r\n";
		}
		$i++;
	}
	$funresult=$urlStr ."var playname='". $VodName ."'; \r\n var playcount= " .$playcount . "; \r\n </script>";
	return $funresult;
} 

function pagelist_manage($pagecount,$page,$recordcount,$pagesize,$url)
{
	if( $recordcount ==0 ){
		return "";	
	}
	$tempstr = "{<<} {ѭ} {>>} {ת} {}&nbsp;ÿҳ{ÿҳ}&nbsp; ҳ:{ǰҳ}/{ҳ}";
	$tempstr=str_replace("{ҳ}",$pagecount,$tempstr);
	$tempstr=str_replace("{}",$recordcount,$tempstr);
	$tempstr=str_replace("{ǰҳ}",$page,$tempstr);
	$tempstr=str_replace("{ÿҳ}",$pagesize,$tempstr);
	
	$tempstr=str_replace("{<<}","<a href=".str_replace("{p}",1,$url)." class='page'><<</a>",$tempstr);
	$tempstr=str_replace("{>>}","<a href=".str_replace("{p}",$pagecount,$url)." class='page'>>></a>",$tempstr);
	if ($page>1){
		$tempstr=str_replace("{<}","<a href=".str_replace("{p}",$page-1,$url)." class='page'><</a>",$tempstr);
	}
	else{
		$tempstr=str_replace("{<}","<span class='page'><</span>",$tempstr);
	} 
	if ($page<$pagecount){
		$tempstr=str_replace("{>}","<a href=".str_replace("{p}",$page+1,$url)." class='page'>></a>",$tempstr);
	}
	else{
		$tempstr=str_replace("{>}","<span class='page'>></span>",$tempstr);
	} 
	$jumpurl="<input name=\"page\" type=\"text\" id=\"page\" size=\"3\" onkeyup=\"this.value=this.value.replace(/[^\d]+/,'')\"><input name=\"go\" type=\"button\" id=\"go\" value=\"GO\" onclick=\"var intstr=/^\\d+$/;if(intstr.test(document.getElementById('page').value)&&document.getElementById('page').value<=".$pagecount."&&document.getElementById('page').value>=1){location.href='".str_replace("{p}","' + document.getElementById('page').value + '",$url)."';}\">";
	$tempstr=str_replace("{ת}",$jumpurl,$tempstr);
	$i=$page-4; 
	$j=$page+5;
	if ($i<1){
		$j=$j+(1-$i); 
		$i=1;
	} 
	if ($j>$pagecount){
		$i=$i+($pagecount-$j); 
		$j=$pagecount;
		if ($i<1){
			$i=1;
		} 
	} 
	$loopurl="";
	for ($m=$i; $m<=$j; $m=$m+1){
		if ($m==$page){
			$loopurl=$loopurl." <a href=".str_replace("{p}",$m,$url)." class='pagein'>".$m."</a>";
		}
		else{
			$loopurl=$loopurl." <a href=".str_replace("{p}",$m,$url)." class='page'>".$m."</a>";
		}
	}
	$tempstr=str_replace("{ѭ}",$loopurl,$tempstr);
	$funresult=$tempstr;
	return $funresult;
}
$span="";

function makeSelectParentAndChild($Tab,$TabID,$TabName,$TabParentID,$TabSort,$ParentID,$ByUrl,$separateStr,$TID)
{
	global $db,$span;
	if (isN($TID)){
		$TID=0;
	} 
	$sql="select ".$TabID.",".$TabName." from ".$Tab." where ".$TabParentID." = ".$ParentID." order by ".$TabSort." Asc";
	$rs=$db->query($sql);
 	 while ($row = $db ->fetch_array($rs))
	{
		if ($ParentID!=0){
			$span .=$separateStr;
		} 
		if (intval($TID)==$row[$TabID]){
			$strSelected=" selected";
		}
		else{
			$strSelected="";
		} 
		if (isN($ByUrl)){
			$strValue=$row[$TabID];
		}
		else{
			$strValue=$ByUrl."?".$Tab."=".$row[$TabID];
		} 
		$strTemp=$strTemp."<option value='".$strValue."' ".$strSelected.">".$span."&nbsp;|".$row[$TabName]."</option>";
		$strTemp=$strTemp.makeSelectParentAndChild($Tab,$TabID,$TabName,$TabParentID,$TabSort,$row[$TabID],$ByUrl,$separateStr,$TID);
	} 
	if (!isN($span)){
		$span=substr($span,0,strlen($span)-strlen($separateStr));
	}
	$funresult=$strTemp;
	return $funresult;
}

function makeSelect($Tab,$TabID,$TabName,$TabSort,$ByUrl,$separateStr,$TID)
{
	global $db,$span;
	if (!isN($TabSort)){
		$strOrder=" order by ".$TabSort." Asc";
	} 
	if (isN($TID)){
		$TID=0;
	} 
	$sql="select ".$TabID.",".$TabName." from ".$Tab.$strOrder;
	$rs=$db->query($sql);
	while($row = $db ->fetch_array($rs))
	{
		if (intval($TID)==$row[$TabID]){
			$strSelected=" selected";
		}
		else{
			$strSelected="";
		} 
		if (isN($ByUrl)){
			$strValue=$row[$TabID];
		}
		else{
			$strValue=$ByUrl;
			if(strpos($ByUrl,"?")){
				$strValue.="&";
			}
			else{
				$strValue.="?";
			}
			$strValue.= $Tab."=".$row[$TabID];
		}
		$strTemp=$strTemp."<option value='".$strValue."' ".$strSelected.">".$span."&nbsp;|".$row[$TabName]."</option>";
	} 
	if (!isN($span)){
		$span=substr($span,0,strlen($span)-strlen($separateStr));
	}
	$funresult=$strTemp;
	return $funresult;
}

//===============================================================

$typePopedom = null ;
function getTypeByPopedomByCache()
{
	global $db,$root,$typePopedom;
	$usergroup= $_SESSION["usergroup"];
	
	if (isN($usergroup)) { $cacheName="popedom_anonymous" ;}else {$cacheName="popedom_usergroup_".$usergroup;}
	if (chkCache($cacheName,'php')){
		$typePopedom = getCache($cacheName,"php");
	}
	else{
		if(!is_array($typePopedom)){
			$sql="select ug_type from tbl_user_group where ";
		    if (isN($usergroup)){
		      $sql.=" ug_popedom like '%,1,%' ";
		    }
		    else{
		     $sql.=" ug_id in(".getUserGroupByPopValueByCache(">").") and ug_id <> ".$usergroup;
		    }		    
		    $typePopedom = $db->queryarray($sql);
		    setcache($cacheName, $typePopedom,1,'php');
		}
	}
	$strTemp=",";
	foreach($typePopedom as $row){
		$strTemp = $strTemp . $row["ug_type"];
	}
	
	$strTemp=replaceStr($strTemp,",,",",");
	if (substr($strTemp,strlen($strTemp)-(1))==","){
		$strTemp=substr($strTemp,0,strlen($strTemp)-1);
	} 
	$funresult="0".$strTemp;
	return $funresult;
} 

$userGroupByPopValueA = null;
$userGroupByPopValueB = null;
function getUserGroupByPopValueByCache($flag)
{
	global $db,$userGroupByPopValueA,$userGroupByPopValueB;
	$flagstr = "";
	if($flag==">"){
		$flagstr = "a";
	}
	else{
		$flagstr = "b";
	}
	$usergroup= $_SESSION["usergroup"];
	if (isN($usergroup)) { return "0";} else { $cacheName="popvalue_usergroup_".$flagstr."_".$usergroup; }
	if (chkCache($cacheName,'php')){
		$userGroupByPopValue= getCache($cacheName,'php');
	}
	else{
		if($flag==">" && !is_array($userGroupByPopValueA)){
			$userGroupByPopValueA = $db->queryarray("select ug_id from tbl_user_group where ug_popvalue ".$flag." (select ug_popvalue from tbl_user_group where ug_id =".$usergroup.")");
			$userGroupByPopValue = $userGroupByPopValueA;
		}
		else{
			$userGroupByPopValueB = $db->queryarray("select ug_id from tbl_user_group where ug_popvalue ".$flag." (select ug_popvalue from tbl_user_group where ug_id =".$usergroup.")");
			$userGroupByPopValue = $userGroupByPopValueB;
		}
		setCache ($cacheName,$userGroupByPopValue,1,'php');
	}
	foreach($userGroupByPopValue as $row){
		$strTemp = $strTemp . "," .	$row["ug_id"];
	}
	return "0" . $strTemp;
}
function getUserPopedom($id,$ugroup,$flag)
{
	global $db;
	$userid= $_SESSION["userid"]; 
	$usergroup = $_SESSION["usergroup"]; 
	$result=false;
	$strWhere = " and  ug_popedom like '%,";
	if(isN($ugroup)){
		$ugroup=0;
	}
	if ($flag=="list"){
		$strWhere.="1";
	}
	elseif ($flag=="vod"){
		$strWhere.="2";
	}
	elseif ($flag=="play"){
		$strWhere .= "3";
	} 
	$strWhere.= ",%' ";
	
	
	
	
	if($ugroup>0){
		$popedom=$db->getOne("select ug_popvalue from tbl_user_group where ug_id =".$ugroup);
		if(  $_SESSION["ugpopvalue"] >= $popedom ){ $result=true; }
	}
	else{
		$popedom=$db->getRow("select count(*) as cc from tbl_user_group where ug_type like '%,".$id.",%' ".$strWhere);
		
		if (intval($popedom["cc"])>0){	$result=false;}	else{$result=true;}
		if (!isN($userid))
		{
			$popedom=$db->getRow("SELECT ug_type,ug_popedom FROM (tbl_user INNER JOIN tbl_user_group ON tbl_user.u_group = tbl_user_group.ug_id) where u_id=".$userid);
			$tmp = $popedom["ug_type"] . "||" . $popedom["ug_popedom"];
			
			$popedomarr = explode("||",$tmp);
			if ($flag=="list"){	
				
				if (strpos(",".$popedomarr[0],",".$id.",") && strpos(",".$popedomarr[1],",1,")){$result=true;}
			}
			elseif ($flag=="vod"){
				if (strpos(",".$popedomarr[0],",".$id.",") && strpos(",".$popedomarr[1],",2,")){$result=true;} 
			}
			elseif ($flag=="play"){
				if (strpos(",".$popedomarr[0],",".$id.",") && strpos(",".$popedomarr[1],",3,")){$result=true;} 
			} 
		}
	}
	$funresult=$result;
	return $funresult;
}


function getTypeIDS($TypeID,$TabName)
{
	$TabName=strtolower($TabName);
	if ($TabName=="tbl_vod_type"){
		$tmpArray = getVodTypeListByArrayByCache();
	}
	else{
		$tmpArray = getArtTypeListByArrayByCache();
	}
	$strResult="";
	if (($TypeID) >0) { $strResult= $TypeID; }
	for($i=0;$i<count($tmpArray);$i++){
		if($tmpArray[$i]["t_patentid"]==$TypeID){
			if (isN($strResult)){
				$strResult = getTypeIDS($tmpArray[$i]["t_id"],$TabName);
			}
			else{
				$strResult = $strResult .",". getTypeIDS($tmpArray[$i]["t_id"],$TabName);
			}
		}
	}
	return $strResult ;
} 
function getTypeIDSByCache($TypeID,$TabName,$TabID)
{
	global $root;
	$cacheName = "typeids_"  . $TabName . "_" . $TypeID;
	if (chkCache($cacheName)){
		$tlist= getCache($cacheName);
	}
	else{
		$tlist= getTypeIDS($TypeID,$TabName);
		setCache($cacheName,$tlist,0);
	}
	return $tlist;
}


function getValueByArray($tmparray,$tmpitem,$tmpvalue)
{
	$result="";
	foreach($tmparray as $row){
		if($row[$tmpitem] == $tmpvalue){
			$result =  $row;
			break;
		}
	}
	return $result;
}

$artTypeArray = array();
function getArtTypeListByArrayByCache()
{
	global $db,$artTypeArray;
	$cacheName="art_array_type";
	if (chkCache($cacheName,'php')){
		$artTypeArray= getCache($cacheName,'php');
	}
	else{
		if(empty($artTypeArray)){
		$artTypeArray= $db->queryarray("select t_id,t_name,t_enname,t_patentid,t_template,t_arttemplate from tbl_art_type order by t_sort asc");
		}
		setCache($cacheName,$artTypeArray,1,'php');
	}
	return $artTypeArray;
}
function getArtTypeByArrayByCache($t_id)
{
	$typeArray = getArtTypeListByArrayByCache();
	return getValueByArray($typeArray,"t_id",$t_id);
}

$vodTypeArray = array();
function getVodTypeListByArrayByCache()
{
	global $db,$vodTypeArray;
	$cacheName="vod_array_type";
	if (chkCache($cacheName,'php')){
		$vodTypeArray= getCache($cacheName,'php');
	}
	else{
		if(empty($vodTypeArray)){
			$vodTypeArray= $db->queryarray("select t_id,t_name,t_enname,t_patentid,t_template,t_vodtemplate,t_vodplaytemplate from tbl_vod_type order by t_sort asc");
		}
		setCache($cacheName,$vodTypeArray,1,'php');
	}
	return $vodTypeArray;
}
function getVodTypeByArrayByCache($t_id)
{
	$typeArray = getVodTypeListByArrayByCache();
	return getValueByArray($typeArray,"t_id",$t_id);
}


$topicVodArray = array();
$topicArtArray=array();
function getTopicListByArrayByCache($flag)
{
	global $db;
	$state = false;
	$cacheName= "topic" . $flag . "_array_topic";
	if (chkCache($cacheName,'php')){
		$topicArray= getCache($cacheName,'php');
	}
	else{
		if ($flag =="vod"){
			if(empty($topicVodArray)){$state=true;}else{$topicArray=$topicVodArray;}
		} 
		elseif($flag=="art"){
			if(empty($topicArtArray)){$state=true;}else{$topicArray=$topicArtArray;}
		}
		if($state){
			$topicArray= $db->queryarray("select t_id,t_name,t_enname,t_sort,t_template,t_pic,t_content from tbl_".$flag."_topic order by t_sort asc");
		}
		setCache($cacheName,$topicArray,1,'php');
	}
	return $topicArray;
}
function getTopicByArrayByCache($t_id,$flag)
{
	$topicArray = getTopicListByArrayByCache($flag);
	return getValueByArray($topicArray,"t_id",$t_id);
}


$vodAreaArray = array();
function getVodAreaListByArrayByCache()
{
	global $db,$vodAreaArray;
	$cacheName="vod_array_area";
	if (chkCache($cacheName,'php')){
		$vodAreaArray = getCache($cacheName,'php');
	}
	else{
		if(empty($vodAreaArray)){
			$vodAreaArray= $db->queryarray("select a_id,a_name from tbl_vod_area order by a_sort asc");
		}
		setCache($cacheName,$vodAreaArray,1,'php');
	}
	return $vodAreaArray;
}
function getVodAreaByArrayByCache($a_id)
{
	$areaArray = getVodAreaListByArrayByCache();
	return getValueByArray($areaArray,"a_id",$a_id);
}

$vodLanguageArray = array();
function getVodLanguageListByArrayByCache()
{
	global $db,$vodLanguageArray;
	$cacheName="vod_array_language";
	if (chkCache($cacheName,'php')){
		$vodLanguageArray= getCache($cacheName,'php');
	}
	else{
		if(empty($vodLanguageArray)){
			$vodLanguageArray= $db->queryarray("select l_id,l_name from tbl_vod_language order by l_sort asc");
		}
		setCache($cacheName,$vodLanguageArray,1,'php');
	}
	return $vodLanguageArray;
}
function getVodLanguageByArrayByCache($l_id)
{
	$languageArray = getVodLanguageListByArrayByCache();
	return getValueByArray($languageArray,"l_id",$l_id);
}
?>