<?php

class AppTemplate{
	var $html;
	function __construct()
	{
	}
	
	function ParametersToArray($attrStr)
	{
		$attrArray=explode(chr(32), $attrStr); 
		$strLen=count($attrArray);
		for($i=0; $i<$strLen; $i++){
			$singleAttr= explode(chr(61),$attrArray[$i]);
			$singleAttrKey=$singleAttr[0];
			$singleAttrValue=$singleAttr[1];
			$attrDictionary[$singleAttrKey]=$singleAttrValue;
		}
		return $attrDictionary;
	}
	function getLabelByLen($labelFlag,$labelName,$labelStr)
	{
		$labelRule ="\[".$labelFlag.":".$labelName."\s+len=(\d+)?\s*\]";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
		$tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++){
			$tempLen=$tmparr[1][$i];
			if(isN($tempLen) || (!isNum($tempLen))) {$tempLen=8;}
			$this->html=replaceStr($this->html,$tmparr[0][$i],substring($labelStr,$tempLen));
		}
	}
	function getPageListSize($str,$strtype)
	{
		$labelRule = "\{maccms:".$strtype."list[\s\S]+?num=([\d]+)[\s\S]*\}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$str,$tmparr);
		$tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$tempsize=$tmparr[1][$i];
			if(isN($tempsize) || (!isNum($tempsize))) {$tempsize=10;}
			return $tempsize;
		}
	}
	function getPageListSizeByCache($str,$strtype)
	{
		$appName = $strtype."_pagelistsize";
		if (chkCache($appName)){
			$tempSize = getCache($appName);
		}
		else{
			$tempSize = $this->getPageListSize($str,$strtype);
		}
		return $tempSize;
	}
	
	function replaceLabel()
    {
    	$this->replaceHeadAndFoot();
    	$this->replaceDimLabels();
		$this->replaceGlobal();
		
		$this->menulist("");
		$this->linklist();
		$this->typematrix();
		
		$this->vodlist();
		$this->artlist();
		$this->topiclist();
		
		$this->arealist();
		$this->languagelist();
    }
    
    function replaceLast()
    {
		$this->replaceifExp();
		$this->replaceTimming();
    }
    
	function replaceRunTime()
	{
		global $runstart;
		if (isDynamic()) {
			$this->html = replaceStr($this->html,"{maccms:runtime}",getRunTime($runstart));
		}
		else{
			$this->html = replaceStr($this->html,"{maccms:runtime}","");
		}
	}
	
	function replaceifExp()
	{
		if (!strpos(",".$this->html,"{if:")) { return; }
		$labelRule = buildregx("{if:(.*?)}(.*?){end if}","is");
		$labelRule2="{elseif";
		$labelRule3="{else}";
		preg_match_all($labelRule,$this->html,$iar);
		$arlen=count($iar[1]);
		$elseifFlag=false;
		for($m=0;$m<$arlen;$m++){
			$strif=$iar[1][$m];
			$strThen=$iar[2][$m];
			$strThen=replaceStr($strThen,"'","\'");
			
			if (strpos($strThen,$labelRule2)>0){
				$elseifArray=explode($labelRule2,$strThen);
				$elseifArrayLen=count($elseifArray);
				$elseifSubArray=explode($labelRule3,$elseifArray[$elseifArrayLen-1]);
				$resultStr=$elseifSubArray[1];
				
				eval("if($strif){\$resultStr='$elseifArray[0]';\$elseifFlag=true;}");
				
				if(!$elseifFlag){
					for($elseifLen=1;$elseifLen<$elseifArrayLen-1;$elseifLen++){
						$strElseif=getSubStrByFromAndEnd($elseifArray[$elseifLen],":","}","");
						$strElseifThen=getSubStrByFromAndEnd($elseifArray[$elseifLen],"}","","start");
						$strElseifThen=replaceStr($strElseifThen,"'","\'");
						eval("if($strElseif){\$resultStr='$strElseifThen'; \$elseifFlag=true;}");
						if ($elseifFlag) {break;}
					}
				}
				if(!$elseifFlag){
					$strElseif0=getSubStrByFromAndEnd($elseifSubArray[0],":","}","");
					$strElseifThen0=getSubStrByFromAndEnd($elseifSubArray[0],"}","","start");
					$strElseifThen0=replaceStr($strElseifThen0,"'","\'");
					eval("if($strElseif0){\$resultStr='$strElseifThen0';\$elseifFlag=true;}");
				}
				$this->html=str_replace($iar[0][$m],$resultStr,$this->html);
			}
			else{
				$ifFlag = false;
				if (strpos($strThen,"{else}")>0){
					$elsearray=explode($labelRule3,$strThen);
					$strThen1=$elsearray[0];
					$strElse1=$elsearray[1];
					eval("if($strif){\$ifFlag=true;}else{\$ifFlag=false;}");
					if ($ifFlag){ $this->html=str_replace($iar[0][$m],$strThen1,$this->html);} else {$this->html=str_replace($iar[0][$m],$strElse1,$this->html);}
				}
				else{
					eval("if($strif){\$ifFlag=true;}else{\$ifFlag=false;}");
					if ($ifFlag){ $this->html=str_replace($iar[0][$m],$strThen,$this->html);} else {$this->html=str_replace($iar[0][$m],"",$this->html);}
				 }
			}
		}
		unset($iar);
	}
	
	function replaceGlobal()
	{
		global $CurVodTypeid,$CurVodTypeParentid,$CurVodTopicid,$CurArtTypeid,$CurArtTypeParentid,$CurArtTopicid;
		
		$this->html = replaceStr($this->html,"{maccms:indexlink}",getIndexLink());
		$this->html = replaceStr($this->html,"{maccms:vodmaplink}",getMapLink());
		$this->html = replaceStr($this->html,"{maccms:vodtopiclink}",getTopicLink("vod"));
		$this->html = replaceStr($this->html,"{maccms:arttopiclink}",getTopicLink("art"));
		
		$this->html = replaceStr($this->html,"{maccms:url}",app_siteurl);
		$this->html = replaceStr($this->html,"{maccms:path}",app_installdir);
		$this->html = replaceStr($this->html,"{maccms:templatepath}",app_installdir . "template/" . app_templatedir . "/");
		$this->html = replaceStr($this->html,"{maccms:name}",app_sitename) ;
		$this->html = replaceStr($this->html,"{maccms:icp}",app_icp);
		$this->html = replaceStr($this->html,"{maccms:qq}",app_qq);
		$this->html = replaceStr($this->html,"{maccms:email}",app_email);
		
		$this->html = replaceStr($this->html,"{maccms:curvodtypeid}",$CurVodTypeid);
		$this->html = replaceStr($this->html,"{maccms:curvodtypeparentid}",$CurVodTypeParentid);
		$this->html = replaceStr($this->html,"{maccms:curvodtopicid}",$CurVodTopicid);
		$this->html = replaceStr($this->html,"{maccms:curarttypeid}",$CurArtTypeid);
		$this->html = replaceStr($this->html,"{maccms:curarttypeparentid}",$CurArtTypeParentid);
		$this->html = replaceStr($this->html,"{maccms:curarttopicid}",$CurArtTopicid);
		$this->html = replaceStr($this->html,"{maccms:visits}","<script type=\"text/javascript\" src=\"".app_installdir."js/tj.js\"></script>");
			
		if (strpos($this->html,"{maccms:artalllist}")){ 
			$this->html = replaceStr($this->html,"{maccms:artalllist}",getArtTypeLink(0,"",""));
		}
		if (strpos($this->html,"{maccms:vodalllist}")){ 
			$this->html = replaceStr($this->html,"{maccms:vodalllist}",getVodTypeLink(0,"",""));
		}
		if (strpos($this->html,"{maccms:allcount}")){ 
			$this->html = replaceStr($this->html,"{maccms:allcount}",getVodCount("all"));
		}
		if (strpos($this->html,"{maccms:daycount}")){
		 	$this->html = replaceStr($this->html,"{maccms:daycount}",getVodCount("day"));
		}
		$this->html = replaceStr($this->html,"{maccms:usergroupid}",$_SESSION["usergroup"]);
		
		if (strpos($this->html,"{maccms:usercount}")){
			$this->html = replaceStr($this->html,"{maccms:usercount}",getUserCount("all"));
		}
		if (strpos($this->html,"{maccms:userdaycount}")){
			$this->html = replaceStr($this->html,"{maccms:userdaycount}",getUserCount("day"));
		}
	}
	
	function replaceHeadAndFoot()
	{
		global $root;
		$this->html = replaceStr($this->html,"{maccms:head}",file_get_contents($root."template/".app_templatedir."/".app_htmldir."/head.html"));
		$this->html = replaceStr($this->html,"{maccms:foot}",file_get_contents($root."template/".app_templatedir."/".app_htmldir."/foot.html"));
	}
	
	function replaceTimming()
	{
		//global app_timming;
		//if (app_timming == 1) { $this->html = $this->html . timmingExe(); }
	}
	
	function replaceComment($cctype,$viewID)
	{
		if ($cctype==1) {$strLabel= "vodinfo";} else {$strLabel ="artinfo";}
		if (app_comment == 1){  
		$commentStr =  "<script type=\"text/javascript\" src=\"".app_installdir."plus/comment/comment.js\"></script><div id=\"comment\"><div style=\"padding:5px;text-align:center;\"><img src=\"".app_installdir."images/Loading.gif\"/>&nbsp;&nbsp;<strong>УԺ.....</strong></div></div><script language=\"javascript\">ajax.get('".app_installdir."plus/comment/?c_vid=".$viewID."&type=".$cctype."','comment');</script> ";
		}
		else{
			$commentStr = "۹ر...";
		}
		$this->html = replaceStr($this->html,"[".$strLabel.":comment]",$commentStr);
	}
	
	function replaceMood($moodtype,$moodvid)
	{
		if ($moodtype==1) { $strLabel= "vodinfo";} else {$strLabel ="artinfo";}
		if (app_mood== 1){
		$commentStr =  "<script type=\"text/javascript\" src=\"".app_installdir."plus/mood/mood.js\"></script><script language = \"JavaScript\" src =\"".app_installdir."plus/mood/?moodvid=".$moodvid."&moodtype=".$moodtype."\"></script>";
		}
		else{
			$commentStr = "ر...";
		}
		$this->html = replaceStr($this->html,"[".$strLabel.":mood]",$commentStr);
	 }
		
	function replaceDimLabels()
	{
		if (!strpos(",".$this->html,"{label:")) { return; }
		global $db;
		$sql = "select l_name,l_code from tbl_label";
		$rs=$db->query($sql);
		$Dictionarytemp= array();
		if ($rs){
			while ($row = $db ->fetch_array($rs)){
				$labelname = $row["l_name"];
				$labelcode = $row["l_code"];
				$Dictionarytemp[$labelname]=$labelcode;
			}
		}
		unset($rs);
		$labelRule = "{label:(.*?)}";
		$labelRule = buildregx($labelRule,"is");
		preg_match_all($labelRule,$this->html,$tmparr);
		$tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++){
			$labelName =  $tmparr[1][$i];
			$this->html = replaceStr($this->html,$tmparr[0][$i],$Dictionarytemp[$labelName]);
		}
		unset($Dictionarytemp);
	}
			
	 function menulist($regexPattern)
	 {
	 	if (!strpos(",".$this->html,"{maccms:menulist")) { return; }
	 	
	 	global $db;
		$labelRule ="{maccms:menulist".$regexPattern."(.*?)}(.*?){/maccms:menulist".$regexPattern."}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_type = $arrayParmenters["type"] ; $temp_parent =$arrayParmenters["parent"];
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			$temp_num = $arrayParmenters["num"] ;  $temp_table = $arrayParmenters["table"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) {$temp_table = "vod";}
			if ($temp_table=="art") {$temp_table="tbl_art_type";} else {$temp_table="tbl_vod_type";}
			if (!isN($temp_num) && isNum($temp_num)){ 
				$sql = "select top ". $temp_num ." t_id,t_name from ".$temp_table." where ";
			}
			else{
				$sql = "select t_id,t_name,t_enname,t_patentid from ".$temp_table." where ";
			}
			$aWhere = $aWhere . " and t_hide = 0 ";
			if (isN($temp_by)){ $temp_by = "sort";}
			if (isN($temp_order)) { $temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))   
			{        
				case "id" : $orderStr =" order by t_id " . $temp_order;break;
				default : $orderStr =" order by t_sort " . $temp_order;
			}
			
			if (!isN($temp_type) && $temp_type != "all") { $aWhere = $aWhere . " and t_id in(".$temp_type.")" ;}
			if (!isN($temp_parent)){
				if (isnum($temp_parent) and $temp_parent > 0){
					if ($temp_pid > 0) { $temp_parent = "select t_patentid from tbl_vod_type where t_id in(".$temp_parent.")"; }
				}
				$aWhere = $aWhere . " and t_patentid in(".$temp_parent.")";
			}
			
			if (isDynamic()){
				$popedomType = getTypeByPopedomByCache();
			    $aWhere = $aWhere . " and t_id not in(".$popedomType.")";
			}
			
			$rs = $db->query($sql . $aWhere . $orderStr);
			if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"menulistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[menulist".$regexPattern.":(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
	
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					
					switch (trim($tempfield))
					{
					case "num":
						$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$j);
						break;
					case "name":
						$tempName=$row["t_name"];
						$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
						$tempOperation= $tempArrayParmenters["len"];
						if (! isN($tempOperation) && strlen($tempName)>intval($tempOperation)){
								$tempName= substring($tempName,$tempOperation);
						}
						$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
						break;
					case "id":
						$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_id"]);
						break;
					case "link":
						if ($temp_table=="tbl_art_type"){ 
							$tempLink = getArtTypeLink($row["t_id"],$row["t_name"],$row["t_enname"]) ;
						}
						else{
							$tempLink = getVodTypeLink($row["t_id"],$row["t_name"],$row["t_enname"]);
						}
						$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempLink);
						break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;

			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	    if (strpos($this->html,"{maccms:menulistchild")){ $this->menulist("child"); }
	}
	
	function linklist()
	{
		if (!strpos(",".$this->html,"{maccms:linklist")) { return; }
		
		global $db;
		$labelRule ="{maccms:linklist(.*?)}(.*?){/maccms:linklist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
        for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
	    	$aWhere = " 1=1 ";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_type = $arrayParmenters["type"] ; $temp_num = $arrayParmenters["num"];
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			unset($arrayParmenters);
			
			if (isN($temp_by)) {$temp_by = "sort";}
			if (isN($temp_order)) { $temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{      
				case "id" : $orderStr =" order by l_id " . $temp_order;break;
				default : $orderStr =" order by l_sort " . $temp_order;
			}
			if (isN($temp_type)) { $temp_type = "all" ;}
			switch (trim($temp_type))
			{
				case "pic":		$aWhere = $aWhere . " and l_type = 'pic'";break;
				default:		$aWhere = $aWhere . " and l_type = 'font'";
			}
			if (isN($temp_num)){
				$temp_limit = "";
			}
			else {
				$temp_limit = " limit 0,".$temp_num;
			}
			$sql = "select l_id,l_name,l_type,l_url,l_logo from tbl_link where ";
			
		 	$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		 	if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"linklistǩ:");
				break;
			}
			
		 	$labelRuleField = buildregx("\[linklist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
			while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
	
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName= $row["l_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation));{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["l_id"]);
							break;
						case "link":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["l_url"]);
							break;
						case "pic":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["l_logo"]);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
	    }
	}
	
	function typematrix()
	{
		if (!strpos(",".$this->html,"{maccms:typematrix")) { return; }
		
		global $db;
		$labelRule ="{maccms:typematrix(.*?)}(.*?){/maccms:typematrix}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
        
        
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
	    	$aWhere = " 1=1 ";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_type = $arrayParmenters["type"] ; $temp_by = $arrayParmenters["by"];
			$temp_order = $arrayParmenters["order"] ; $temp_table = $arrayParmenters["table"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) { $temp_table= "vod";}
			if ($temp_table=="art"){ $temp_table="tbl_art_type";} else{ $temp_table="tbl_vod_type";}
			$sql = "select t_id,t_name,t_enname from ".$temp_table." where ";
			
			if (isN($temp_by)){ $temp_by = "sort";}
			if (isN($temp_order)) { $temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by t_id " . $temp_order;break;
				default : $orderStr =" order by t_sort " . $temp_order;
			}
			if (isN($temp_type)) { $temp_type="all";}
			if ($temp_type != "all"){ 
				$aWhere = $aWhere . " and t_id in(".$temp_type.")";
			}
			else{
				$aWhere = $aWhere . "";
			}
			
			$rs = $db->query($sql . $aWhere . $orderStr);
			if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"typematrixǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[typematrix:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			
			
			
			$j=1;
			 while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					
						
					
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					
				
					
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}					
					
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
						break;
						case "name":
							$tempName=$row["t_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempName)>intval($tempOperation)){
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_id"]);
							break;
						case "link":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodTypeLink($row["t_id"],$row["t_name"],$row["t_enname"]));
							break;
						case "count":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getDicCount("tbl_vod","d_type",getTypeIDSByCache($row["t_id"],$temp_table,"t_id")));
							break;
						default: break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
	    }
	}
	
	function vodlist()
	{
		
		if (!strpos(",".$this->html,"{maccms:vodlist")) { return; }
		
		global $db,$CurVodTypeid,$CurVodid,$CurVodTopicid;
		$labelRule ="{maccms:vodlist(.*?)}(.*?){/maccms:vodlist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_num = $arrayParmenters["num"] ; $temp_state =$arrayParmenters["state"];
			$temp_level = $arrayParmenters["level"] ;$temp_order =$arrayParmenters["order"];
			$temp_by = $arrayParmenters["by"] ; $temp_type =$arrayParmenters["type"];
			$temp_topic = $arrayParmenters["topic"] ;$temp_start =$arrayParmenters["start"];
			$temp_day = $arrayParmenters["day"]  ; $temp_similarity =$arrayParmenters["similarity"];
			$temp_pinyin = $arrayParmenters["pinyin"] ; $temp_starring =$arrayParmenters["starring"];
			unset($arrayParmenters);
			
			
			if (isN($temp_num) || (!isnum($temp_num))){ $temp_num = 10;}  else {$temp_num = intval($temp_num);}
			if (isN($temp_by)) { $temp_by = "time";}
			if (isN($temp_order)) { $temp_order = "desc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by d_id " . $temp_order;break;
				case "hit" : $orderStr =" order by d_hits " . $temp_order;break;
				case "level" : $orderStr =" order by d_level " . $temp_order;break;
				case "good" : $orderStr =" order by d_good " . $temp_order;break;
				case "bad" : $orderStr =" order by d_bad " . $temp_order;break;
				case "score" : $orderStr =" order by d_score " . $temp_order;break;
				case "scorecount" : $orderStr =" order by d_scorecount " . $temp_order;break;
				case "rnd" : $orderStr =" order by rand() " . $temp_order;break;
				default : $orderStr =" order by d_addtime " . $temp_order;
			}
			
			if (isN($temp_type)) { $temp_type="all";}
			
			if  ($temp_type != "all" && $CurVodTypeid != 0){
				if ($temp_type=="current"){
					$aWhere = $aWhere . " and d_type in (".getTypeIDSByCache($CurVodTypeid,"tbl_vod_type","t_id").")";
				}
				else{
					$aWhere = $aWhere . " and d_type in (".getTypeIDSByCache($temp_type,"tbl_vod_type","t_id").")";
				}
			}
			
			if ($temp_type == "[typematrix:id]"){ break;}
			if ($temp_state =="serialize") { $aWhere = $aWhere . " and d_state > 0";}
			
			if (!isN($temp_level)){ 
				if ($temp_level != "all"){
					$aWhere = $aWhere . " and d_level in(".$temp_level.")" ;
				}
				else{
					$aWhere = $aWhere . " and d_level >0";
				}
			}
			if (isN($temp_topic)) { $temp_topic = "all";}
			
			
				
			if (!isN($temp_day)){
				if (isNum($temp_day)){
					$aWhere = $aWhere . " and datediff(now(), d_addtime) <".$temp_day;
				}
			}
			if ($temp_similarity != ""){
				$rssimilarity = $db->getRow("select * from tbl_vod where d_id=" . $CurVodid); 
				if ($rssimilarity){
					$similarity_name = $rssimilarity["d_name"];
					$similarity_starring = $rssimilarity["d_starring"];
					$similarity_directed = $rssimilarity["d_directed"];
					$similarity_language = $rssimilarity["d_language"];
					$similarity_year = $rssimilarity["d_year"];
					$similarity_area = $rssimilarity["d_area"];
					
					$similaritynames = explode(",",$temp_similarity);
					$similaritycount = count($similaritynames);
					$similarity_where = "";
					if ($similaritycount >= 0) {$similarity_where1 = " and (";}
					for ($j=0 ;$j<$similaritycount;$j++){
						switch (trim($similaritynames[$j])) {
							case "name": $similarity_where = $similarity_where . " or d_name like '%".$similarity_name."%'";break;
							case "starring": $similarity_where = $similarity_where . getKeywordToSqlLike($similarity_starring,"d_starring");break;
							case "directed": $similarity_where = $similarity_where . getKeywordToSqlLike($similarity_directed,"d_directed");break;
							case "language": $similarity_where = $similarity_where . " or d_language = ".$similarity_language;break;
							case "year": $similarity_where = $similarity_where . " or d_year = '".$similarity_year."'";break;
							case "area": $similarity_where = $similarity_where . " or d_area = ".$similarity_area;break;
							default:break;
						}
					}
					
					if (substring($similarity_where, 3) == " or") { $similarity_where = substring($similarity_where, strlen($similarity_where)-3,4);  }
					if ($similaritycount >= 0 ){ $similarity_where1 = $similarity_where1 . $similarity_where . ")"; }
					$aWhere = $aWhere . $similarity_where1 . " and d_id <> " . $CurVodid;
					
				}
			}
			
			if ($temp_topic != "all" && $CurVodTopicid ==-100) { 
				$aWhere = $aWhere . " and d_topic in(".$temp_topic.")";
			}
			elseif ($CurVodTopicid != -100 ){
				$aWhere = $aWhere . " and d_topic in(".$CurVodTopicid.")";
			}
			
			if (!isN($temp_pinyin)){
				$aWhere = $aWhere . " and d_enname like '".$temp_pinyin."%'";
			}
			
			if (!isN($temp_starring)){
				$aWhere = $aWhere . " and d_starring like '%".$temp_starring."%'";
			}
			
			
			if (isDynamic() && app_user==1){
				$popedomType= getTypeByPopedomByCache();
				$aWhere = $aWhere . " and d_type not in(".$popedomType.")";
				$aWhere = $aWhere . " and d_usergroup in(".getUserGroupByPopValueByCache("<=").")";
				
			}
			
		   if (isN($temp_start)) { $temp_start=0;} else{ $temp_start = intval($temp_start);}
		    $startnum=$temp_start; //$temp_num= $temp_num + $startnum;
		   if ($temp_num >0){
		   	$temp_limit = " limit ".$startnum.",".$temp_num;
		   }
			
		   $sql =  " SELECT  d_id, d_name, d_enname, d_type,d_state,d_color, d_pic, d_starring,d_directed, d_area, d_year, d_language,d_level, d_stint, d_hits, d_topic, d_addtime, d_content, d_remarks,d_hide,d_good,d_bad,d_usergroup,d_score,d_scorecount FROM tbl_vod where ";
		   
		   $rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		   if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"vodlistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[vodlist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}

					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_id"]);
							break;
						case "name":
							$tempName=$row["d_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "enname":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_enname"]);
							break;
						case "ennamelink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeyLink($row["d_enname"],2));
							break;
						case "typeid":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_type"]);
							break;
						case "colorname":
							$d_color = $row["d_color"] ; $colorname=$row["d_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							 
							if (!isN($tempOperation) && strlen($colorname)>intval($tempOperation)) { 
								$colorname= substring($colorname,$tempOperation);
							}
							if (!isN($d_color)) { $colorname ="<font color='".$d_color."'>".$colorname."</font>";}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$colorname);
							break;
						case "state":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_state"]);
							break;
						case "pic":
							$d_pic = $row["d_pic"];
							if (!strpos(",".$d_pic,"http://")) { $d_pic = app_installdir.$d_pic;}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$d_pic);
							break;
						case "starring":
							$tempStarring=$row["d_starring"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempStarring)>intval($tempOperation))
							{
									$tempStarring= substring($tempStarring,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempStarring);
							break;
						case "starringlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeysLink($row["d_starring"],3));
							break;
						case "directed":
							$tempDirected=$row["d_directed"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempDirected)>intval($tempOperation))
							{
								$tempStarring= substring($tempDirected,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempDirected);
							break;
						case "directedlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeysLink($row["d_directed"],4));
							break;
						case "year":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_year"]);
							break;
						case "yearlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeyLink($row["d_year"],6));
							break;
						case "level":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_level"]);
							break;
						case "stint":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_stint"]);
							break;
						case "hit":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_hits"]);
							break;
						case "time"	:
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["style"];
							if (isN($tempOperation)) { $tempOperation = "m-d";}
							$tempLabelStr=replaceStr ($tempLabelStr,$matchfieldvalue,date($tempOperation,strtotime($row["d_addtime"])));
							break;
						case "des":
							$tempdes= strip_tags($row["d_content"]);
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempdes)>intval($tempOperation))
							{
									$tempdes= substring($tempdes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempdes);
							break;
						case "remarks":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_remarks"]);
							break;
						case "good":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_good"]);
							break;
					    case "bad":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_bad"]);
					    	break;
					    case "score":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_score"]);
					    	break;
					    case "scorecount":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_scorecount"]);
					    	break;
						case "typename":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$arrVodType["t_name"]);
							break;
						case "language":
							if ($row["d_language"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodLang= getVodLanguageByArrayByCache($row["d_language"]);
								$tempLabelStr =replaceStr($tempLabelStr,$matchfieldvalue,$arrVodLang["l_name"]);
							}
							break;
						case "languagelink":
							if ($row["d_language"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodLang= getVodLanguageByArrayByCache($row["d_language"]);
								$tempLabelStr =replaceStr($tempLabelStr,$matchfieldvalue,getKeyLink($arrVodLang["l_name"],7));
							}
							break;
						case "area":
							if ($row["d_area"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
								$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$arrVodArea["a_name"]);
							}
							break;
						case "arealink":
							if ($row["d_area"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
								$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,getKeyLink($arrVodArea["a_name"],5));
							}
							break;
						case "source":
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["showall"];
							if($tempOperation=="true"){ $tempSource=true; } else{ $tempSource=false;}
							$tempOperation = getPlaySource( $row["d_id"],$tempSource); 
							$D_Source="";
							$playarr1 = getPlayXml();
							$rc =false;
							for ($k=0 ;$k<count($playarr1);$k++){
								$playarr2=explode("__",$playarr1[$k]);
								
								if (strpos(",".$tempOperation,$playarr2[2])){
									if($rc){ $D_Source .= ","; }
									$D_Source .=$playarr2[0];
									$rc=true;
								}
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$D_Source);
							break;
						case "link":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodLink($row["d_id"],$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]));
							break;
						case "playlink":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodPlayUrl($row["d_id"],$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"],1,0));
							break;
						case "typelink":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodTypeLink($row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]));
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	
	function artlist()
	{
		if (!strpos(",".$this->html,"{maccms:artlist")) { return; }
		
		global $db,$CurArtTypeid;
		$labelRule ="{maccms:artlist(.*?)}(.*?){/maccms:artlist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_num = $arrayParmenters["num"] ; $temp_order =$arrayParmenters["order"];
			$temp_by = $arrayParmenters["by"] ; $temp_start =$arrayParmenters["start"];
			$temp_type =$arrayParmenters["type"];
			unset($arrayParmenters);
			if (isN($temp_num)) { $temp_num = 10;}
			if (!isNum($temp_num)) {$temp_num = 10;}
			$temp_num = intval($temp_num);
			
			if (isN($temp_by)){ $temp_by = "time";}
			if (isN($temp_order)){ $temp_order = "desc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{         
				case "id" : $orderStr =" order by a_id " . $temp_order;break;
				case "hit" : $orderStr =" order by a_hits " . $temp_order;break;
				default : $orderStr =" order by a_addtime " . $temp_order;
			}
			if (isN($temp_type)){ $temp_type="all";}
			if (isN($CurArtTypeid)) {$CurArtTypeid = -100;}
			if  ($temp_type !="all" && $CurArtTypeid != 0){
				if ($temp_type=="current"){
					$aWhere = $aWhere . " and a_type in (".getTypeIDSByCache($CurArtTypeid,"tbl_art_type","t_id").")";
				}
				else{
					$aWhere = $aWhere . " and a_type in (".getTypeIDSByCache($temp_type,"tbl_art_type","t_id").")";
				}
			}
			
			
			
			if (isN($temp_start)) { $temp_start=0;} else{ $temp_start = intval($temp_start);}
		    $startnum=$temp_start; //$temp_num= $temp_num + $startnum;
		    if ($temp_num >0){
		   		$temp_limit = " limit ".$startnum.",".$temp_num;
		   	}
		    
			$sql = "select a_id, a_title, a_entitle, a_type, a_content, a_author, a_color, a_addtime, a_hits from tbl_art where ";
			
			$rs = $db->query($sql . $aWhere . $orderStr . $temp_limit);
			if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"artlistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[artlist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName=$row["a_title"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							
							if (! isN($tempOperation) && strlen($tempName)>intval($tempOperation)){
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "enname":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_entitle"]);
							break;
						case "des":
							$tempdes= strip_tags($row["a_content"]);
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempdes)>intval($tempOperation))
							{
								$tempdes= substring($tempdes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempdes);
							break;
						case "author":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_author"]);
							break;
						case "colorname":
							$a_color = $row["a_color"] ; $colorname=$row["a_title"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($colorname)>intval($tempOperation)) { 
								$colorname= substring($colorname,$tempOperation);
							}
							if (!isN($a_color)) { $colorname ="<font color='".$a_color."'>".$colorname."</font>";}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$colorname);
							break;
						case "time"	:
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["style"];	
							if (isN($tempOperation)) { $tempOperation = "m-d";}
							$tempLabelStr=replaceStr ($tempLabelStr,$matchfieldvalue,date($tempOperation,strtotime($row["a_addtime"])));
							break;
						case "hit":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_hits"]);
							break;
						case "typename":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$arrArtType[0]);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_id"]);
							break;
						case "link":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getArtLink($row["a_id"],$row["a_title"],$row["a_entitle"],$row["a_type"],$arrArtType["t_name"],$arrArtType["t_enname"]));
							break;
						case "typelink":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getArtTypeLink($row["a_id"],$arrArtType["t_name"],$arrArtType["t_enname"]));
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	
	function topiclist()
	{
		if (!strpos(",".$this->html,"{maccms:topiclist")) { return; }
		
		global $db,$CurArtTopicid,$CurVodTopicid;
		$labelRule ="{maccms:topiclist(.*?)}(.*?){/maccms:topiclist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
		    $arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_id = $arrayParmenters["id"] ; $temp_table = $arrayParmenters["table"];
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			$temp_num = $arrayParmenters["num"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) { $temp_table= "vod";}
			if ($temp_table=="art"){ 
				$temp_table="tbl_art_topic";$temp_col="a_topic";$temp_curid=$CurArtTopicid;
			}
			else{ 
				$temp_table="tbl_vod_topic";$temp_col="d_topic";$temp_curid=$CurVodTopicid;
			}
			
			if (isN($temp_by)){ $temp_by = "sort";}
			if (isN($temp_order)){ $temp_order = "asc";}
			
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			
			switch (trim($temp_by))
			{        
				case "id" : $orderStr =" order by t_id " . $temp_order;break;
				default : $orderStr =" order by t_sort " . $temp_order;
			}

			if  ($temp_id != "all" && $temp_curid != 0){
				if ($temp_id=="current"){
					$aWhere = $aWhere . " and ".$temp_col." in(".$temp_curid.")";
				}
				else{
					$aWhere = $aWhere . " and ".$temp_col." in(".$temp_id.")";
				}
			}
				
			if ($temp_num >0){
		   	   $temp_limit = " limit 0,".$temp_num;
		    }
			
			$sql = "select t_id,t_name,t_enname,t_pic,t_content,(select count(*) from tbl_vod where ".$temp_col."=t.t_id) as cc from ".$temp_table." t where ";
			$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		   
		   if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"topiclistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[topiclist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					 
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName= $row["t_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation));
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "enname":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_enname"]);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_id"]);
							break;
						case "link":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodTopicLink($row["t_id"],$row["t_name"],$row["t_enname"]));
							break;
						case "count":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["cc"]);
							break;
						case "pic":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,app_installdir . $row["t_pic"]);
							break;
						case "des":
		                    $tempdes= strip_tags($row["t_content"]);
		                    $tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempdes)>intval($tempOperation))
							{
								$tempdes= substring($tempdes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempdes);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	
	function artpagelist()
	{
		global $db,$CurArtTypeid,$CurArtid,$CurArtTopicid,$page,$keytype;
		$labelRule ="{maccms:artpagelist(.*?)}(.*?){/maccms:artpagelist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			if (isN($page)) { $page =1;}
			$currentPage = intval($page);
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_num = $arrayParmenters["num"] ;$temp_order =$arrayParmenters["order"];
			$temp_by = $arrayParmenters["by"] ; $temp_type =$arrayParmenters["type"];
			$temp_topic = $arrayParmenters["topic"] ; $temp_day = $arrayParmenters["day"];
			unset($arrayParmenters);
			
			if (isN($temp_num)){$temp_num = 12;}  else {$temp_num = intval($temp_num);}
			if (isN($temp_by)) { $temp_by = "time";}
			if (isN($temp_order)) {$temp_order = "desc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc"; 
			}
			
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by a_id " . $temp_order;break;
				case "hit" : $orderStr =" order by a_hits " . $temp_order;break;
				default : $orderStr =" order by a_addtime " . $temp_order; 
			}
			if (isN($temp_type)) { $temp_type="";}
			if (isN($CurArtTypeid)) { $CurArtTypeid = -100;}
			if (isN($CurArtTopicid)) { $CurArtTopicid = -100;}
			
			if ($CurArtTypeid == 0) {
				$pageListType = "arttypelist";
			}
			elseif ($CurArtTypeid != -100) {
				$aWhere = $aWhere . " and ( a_type in(".$CurArtTypeid.") or a_type in (".getTypeIDSByCache($CurArtTypeid,"tbl_art_type","t_id")."))";
				$pageListType = "arttypelist";
				}
			elseif ($CurArtTopicid != -100) {
				$aWhere = $aWhere . " and a_topic in(".$CurArtTopicid.")";
				$pageListType = "arttopiclist";
			}
			elseif (!isN($keyword)) {
				 switch ($keytype)
				 {
					case 1 : $aWhere = $aWhere . " and ( a_title like '%".$keyword."%')";break;
				 	case 2 : $aWhere = $aWhere . " and ( a_author like '".$keyword."%')";break;
				 	default:
				 	$aWhere = $aWhere . " and (a_title like '%".$keyword."%' or a_author like '".$keyword."%' )";
				 }
		    	 $pageListType = "artsearchlist";
			}
			
			if (!isN($temp_day)){
				if (isNum($temp_day)){ 
					$aWhere = $aWhere . " and datediff(now(), a_addtime) <".$temp_day;
				}
			}
			
			if (!isN($temp_topic)){ 
				if ($temp_topic != "all"){ $aWhere = $aWhere . " and a_topic in(".$temp_topic.")";}
			}
			
			$sql = " SELECT a_id, a_title, a_entitle, a_type, a_topic, a_content,a_author, a_color, a_addtime, a_hits FROM tbl_art  WHERE  ";
			$temp_limit=" limit ".($temp_num * ($page-1)) .",".$temp_num;
			
			$rscount = $db->query($sql . $aWhere . $orderStr);
			$datacount=$db->num_rows($rscount);
			$pagecountstr=ceil($datacount/$temp_num);
			
			$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		   if (!$rs){
				$datacount=0;
				$pagecountst=1;
				$this->html = replaceStr($this->html,$LabelStr,"artpagelistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[pagelist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				
								
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					 
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName=$row["a_title"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "time":
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["style"];
							if (isN($tempOperation)){
								$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$row["a_addtime"]);
							}
							else{
							    $tempLabelStr=replaceStr ($tempLabelStr,$matchfieldvalue,date($tempOperation,strtotime($row["a_addtime"])));
							}
							break;
						case "colorname":
							$d_color = $row["a_color"] ; $colorname=$row["a_title"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($colorname)>intval($tempOperation)) { 
								$colorname= substring($colorname,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$colorname);
							break;
						case "hit":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_hits"]);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_id"]);
							break;
						case "author":
							$tempAuthor=$row["a_author"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempAuthor)>intval($tempOperation))
							{
								$tempName= substring($tempAuthor,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempAuthor);
							break;
						case "des":
							$tempDes=strip_tags($row["a_content"]);
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempDes)>intval($tempOperation));
							{
								$tempDes= substring($tempDes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempDes);
							break;
						case "typeid":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_type"]);
							break;
						case "typename":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$arrArtType["t_name"]);
							break;
						case "typeenname":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$arrArtType["t_enname"]);
							break;
						case "typelink":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getArtTypeLink($row["a_type"],$arrArtType["t_name"],$arrArtType["t_enname"]));
							break;
						case "link":
							$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getArtLink($row["a_id"],$row["a_title"],$row["a_entitle"],$row["a_type"],$arrArtType["t_name"],$arrArtType["t_enname"]));
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
		$this->pageModuleInfo($currentPage,$temp_num,$pagecountstr,$pageListType,$datacount);
	}
	
	function vodpagelist()
	{
		global $db,$CurVodTypeid,$CurVodid,$CurVodTopicid,$page,$searchtype,$keyword,$keytype,$keyids;
		$labelRule ="{maccms:vodpagelist(.*?)}(.*?){/maccms:vodpagelist}";
		$labelRule = buildregx($labelRule,"is");
		preg_match_all($labelRule,$this->html,$tmparr);
		$tmparrlen=count($tmparr[1]);
		$pageListType="";$pagecountstr="";$datacount=0;$temp_num="";$currentPage="";
		
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
			$tempstr = "";
			$aWhere = " 1=1 ";
			if (isN($page)) { $page =1;}
			$currentPage = intval($page);
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_num = $arrayParmenters["num"] ; $temp_state =$arrayParmenters["state"];
			$temp_level = $arrayParmenters["level"] ; $temp_order =$arrayParmenters["order"];
			$temp_by = $arrayParmenters["by"] ; $temp_type =$arrayParmenters["type"];
			$temp_topic = $arrayParmenters["topic"] ; $temp_day = $arrayParmenters["day"];
			unset($arrayParmenters);
			
			if (isN($temp_num)){$temp_num = 12;}  else {$temp_num = intval($temp_num);}
			if (isN($temp_by)) { $temp_by = "time";}
			if (isN($temp_order)) {$temp_order = "desc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by d_id " . $temp_order;break;
				case "hit" : $orderStr =" order by d_hits " . $temp_order;break;
				case "level" : $orderStr =" order by d_level " . $temp_order;break;
				case "good" : $orderStr =" order by d_good " . $temp_order;break;
				case "bad" : $orderStr =" order by d_bad " . $temp_order;break;
				default : $orderStr =" order by d_addtime " . $temp_order; 
			}
			
			if (isN($temp_type)) { $temp_type="";}
			if (isN($CurVodTypeid)) { $CurVodTypeid = -100;}
			if (isN($CurVodTopicid)) { $CurVodTopicid = -100;}
			
			
			if ($CurVodTypeid == 0) {
				$pageListType = "vodtypelist";
			}
			elseif ($CurVodTypeid != -100) { 
				$aWhere = $aWhere . " and d_type in (".getTypeIDSByCache($CurVodTypeid,"tbl_vod_type","t_id").")";
				$pageListType = "vodtypelist";
			}
			elseif ($CurVodTopicid != -100) {
				$aWhere = $aWhere . " and d_topic in(".$CurVodTopicid.")";
				$pageListType = "vodtopiclist";
			}
			elseif (!isN($keyword)){
				 $keyarr = explode("|",$keyword);
				 switch (trim($keytype))
				 {
				 case 1 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_name like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 case 2 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_enname like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 case 3 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_starring like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 case 4 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_directed like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 case 5 : 
				 	$keywhere = " and ( d_area in (select a_id from tbl_vod_area where ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " a_name like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " ))";
				 	$aWhere .= $keywhere;
				 	break;
				 case 6 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_year like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 case 7 : 
				 	$keywhere = " and ( d_language in (select l_id from tbl_vod_language where ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " l_name like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " ))";
				 	$aWhere .= $keywhere;
				 	break;
				 case 8 : 
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_enname like '".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				 default:
				 	$keywhere = " and ( ";
				 	foreach($keyarr as $key){
				 		$keywhere .= " d_name like '%".$key."%' or d_enname like '%".$key."%' or  d_starring like '%".$key."%' or d_directed like '%".$key."%' or";
				 	}
				 	if (substring($keywhere, 2,strlen($keywhere)-2) == "or") { $keywhere = substring($keywhere,strlen($keywhere)-2); }
				 	$keywhere .= " )";
				 	$aWhere .= $keywhere;
				 	break;
				}
		    	 $pageListType = "vodsearchlist";
		    }
		    elseif (!isN($keyids)){
	   			$aWhere = $aWhere . " and D_ID in( " . $keyids ." )";
	   			$pageListType = "vodsearchlist";
			}
			
			
			if ($temp_state=="serialize") { $aWhere = $aWhere . " and d_state > 0";}
			if (!isN($temp_level)) { 
				if ($temp_level != "all"){ 
					$aWhere =$aWhere . " and d_level in(".$temp_level.")" ;
				}
				else {
					$aWhere = $aWhere . " and d_level >0 " ;
				}
			}
			if (!isN($temp_day)){
				if (isNum($temp_day)){
					$aWhere = $aWhere . " and datediff(now(), d_addtime) <".$temp_day;
				}
			}
			if (!isN($temp_topic)){ 
				if ($temp_topic != "all"){ $aWhere = $aWhere . " and d_topic in(".$temp_topic.")";}
			}
			
			if (isDynamic() && app_user==1){
				$popedomType= getTypeByPopedomByCache();
				$aWhere = $aWhere . " and d_type not in(".$popedomType.")";
				$aWhere = $aWhere . " and d_usergroup in(".getUserGroupByPopValueByCache("<=").")";
			}
			$aWhere = $aWhere . " and d_type >0 ";
			
			$sql = " select d_id, d_name, d_enname, d_type,d_state,d_color, d_pic, d_starring,d_directed, d_area, d_year, d_language,d_level, d_stint, d_hits, d_topic, d_addtime, d_content, d_remarks,d_hide,d_good,d_bad,d_usergroup,d_score,d_scorecount FROM tbl_vod where " ;
			$temp_limit= " limit ".($temp_num * ($page-1)) .",".$temp_num;
			
			$rscount = $db->query($sql . $aWhere . $orderStr);
			$datacount=$db->num_rows($rscount);
			$pagecountstr=ceil($datacount/$temp_num);
			
			$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		    if (!$rs){
				$pagecountst=1;
				$this->html = replaceStr($this->html,$LabelStr,"vodpagelistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[pagelist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					 
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					 
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_id"]);
							break;
						case "name":
							$tempName=$row["d_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "enname":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_enname"]);
							break;
						case "ennamelink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeyLink($row["d_enname"],2));
							break;
						case "typeid":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_type"]);
							break;
						case "colorname":
							$d_color = $row["d_color"] ; $colorname=$row["d_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							 
							if (!isN($tempOperation) && strlen($colorname)>intval($tempOperation)) { 
								$colorname= substring($colorname,$tempOperation);
							}
							if (!isN($d_color)) { $colorname ="<font color='".$d_color."'>".$colorname."</font>";}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$colorname);
							break;
						case "state":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_state"]);
							break;
						case "pic":
							$d_pic = $row["d_pic"];
							if (!strpos(",".$d_pic,"http://")) { $d_pic = app_installdir.$d_pic;}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$d_pic);
							break;
						case "starring":
							$tempStarring=$row["d_starring"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempStarring)>intval($tempOperation)){
								$tempStarring= substring($tempStarring,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempStarring);
							break;
						case "starringlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeysLink($row["d_starring"],3));
							break;
						case "directed":
							$tempDirected=$row["d_directed"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempDirected)>intval($tempOperation)){
								$tempStarring= substring($tempDirected,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempDirected);
							break;
						case "directedlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeyLink($row["d_directed"],4));
							break;
						case "year":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_year"]);
							break;
						case "yearlink":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getKeyLink($row["d_year"],6));
							break;
						case "level":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_level"]);
							break;
						case "stint":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_stint"]);
							break;
						case "hit":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_hits"]);
							break;
						case "time"	:
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["style"];
							if (isN($tempOperation)) { $tempOperation = "m-d";}
							$tempLabelStr=replaceStr ($tempLabelStr,$matchfieldvalue,date($tempOperation,strtotime($row["d_addtime"])));
							break;
						case "des":
							$tempdes= strip_tags($row["d_content"]);
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempdes)>intval($tempOperation)){
								$tempdes= substring($tempdes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempdes);
							break;
						case "remarks":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_remarks"]);
							break;
						case "good":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_good"]);
							break;
					    case "bad":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_bad"]);
					    	break;
					    case "score":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_score"]);
					    	break;
					    case "scorecount":
					    	$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["d_scorecount"]);
					    	break;
						case "typename":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$arrVodType["t_name"]);
							break;
						case "language":
							if ($row["d_language"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodLang = getVodLanguageByArrayByCache($row["d_language"]);
								$tempLabelStr =replaceStr($tempLabelStr,$matchfieldvalue,$arrVodLang["l_name"]);
							}
							break;
						case "languagelink":
							if ($row["d_language"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodLang= getVodLanguageByArrayByCache($row["d_language"]);
								$tempLabelStr =replaceStr($tempLabelStr,$matchfieldvalue,getKeyLink($arrVodLang["l_name"],7));
							}
							break;
						case "area":
							if ($row["d_area"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
								$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,$arrVodArea["a_name"]);
							}
							break;
						case "arealink":
							if ($row["d_area"]==0) {
								$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,"");
							}
							else{
								$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
								$tempLabelStr = replaceStr($tempLabelStr,$matchfieldvalue,getKeyLink($arrVodArea["a_name"],5));
							}
							break;
						case "source":
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["showall"];
							if($tempOperation=="true"){ $tempSource=true; } else{ $tempSource=false;}
							$tempOperation = getPlaySource( $row["d_id"],$tempSource); 
							$D_Source="";
							$playarr1 = getPlayXml();
							$rc =false;
							For ($k=0 ;$k<count($playarr1);$k++){
								$playarr2=explode("__",$playarr1[$k]);
								if (strpos(",".$tempOperation,$playarr2[2])){ 
									if($rc){ $D_Source .= ","; }
									$D_Source .=$playarr2[0];
									$rc=true;
								}
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$D_Source);
							break;
						case "link":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodLink($row["d_id"],$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]));
							break;
						case "playlink":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodPlayUrl($row["d_id"],$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"],1,0));
							break;
						case "typelink":
							$arrVodType =getVodTypeByArrayByCache($row["d_type"]);
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,getVodTypeLink($row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]));
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
		$this->pageModuleInfo($currentPage,$temp_num,$pagecountstr,$pageListType,$datacount);
	}
	
	function topicpagelist()
	{
		global $db,$page;
		$labelRule ="{maccms:topicpagelist(.*?)}(.*?){/maccms:topicpagelist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			if (isN($page)) { $page =1;}
			$currentPage = intval($page);
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			$temp_num = $arrayParmenters["num"] ; $temp_table = $arrayParmenters["table"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) {$temp_table="vod";}
			$sql = "select t_id,t_name,t_enname,t_template,t_pic,t_content,(select count(*) from ";
			if ($temp_table=="art") {
				$sql.= " tbl_art where a_topic=t.t_id) as ccount from tbl_art_topic ";
			}
			else{
				$sql.=  " tbl_vod where d_topic=t.t_id) as ccount from tbl_vod_topic ";
			}
			$sql.= "t where ";
			if (isN($temp_num)) { $temp_num = 10;}
			if (!isnum($temp_num)){ $temp_num = 10;} else {$temp_num = intval($temp_num);}
			
			if (isN($temp_by)) { $temp_by = "sort";}
			if (isN($temp_order)) {$temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by t_id " . $temp_order;break;
				default : $orderStr =" order by t_sort " . $temp_order;
			}
			
			$temp_limit=" limit ".($temp_num * ($page-1)) .",".$temp_num;
			$rscount = $db->query($sql . $aWhere . $orderStr);
			$datacount=$db->num_rows($rscount);
			$pagecountstr=ceil($datacount/$temp_num);
			
			$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
			
			if (!$rs){
				$datacount=0;
				$pagecountst=1;
				$this->html = replaceStr($this->html,$LabelStr,"topicpagelistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[pagelist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					 
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName= $row["t_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "enname":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_enname"]);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["t_id"]);
							break;
						case "link":
							if ($temp_table=="art") {
								$TempLink = getArtTopicLink($row["t_id"],$row["t_name"],$row["t_enname"]);
							}
							else{
								$TempLink = getVodTopicLink($row["t_id"],$row["t_name"],$row["t_enname"]);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$TempLink);
							break;
						case "count":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["ccount"]);
							break;
						case "pic":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,app_installdir . $row["t_pic"]);
							break;
						case "des":
		                    $tempDes= strip_tags($row["t_content"]);
		                    $tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (! isN($tempOperation) && strlen($tempDes)>intval($tempOperation))
							{
									$tempDes= substring($tempdes,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempDes);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
		$this->pageModuleInfo($currentPage,$temp_num,$pagecountstr,$temp_table."topicindex",$datacount);
	}
	
	function arealist()
	{
		if (!strpos(",".$this->html,"{maccms:arealist")) { return; }
		
		global $db;
		$labelRule ="{maccms:arealist(.*?)}(.*?){/maccms:arealist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			if (isN($page)) { $page =1;}
			$currentPage = intval($page);
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			$temp_num = $arrayParmenters["num"] ; $temp_start =$arrayParmenters["start"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) {$temp_table="vod";}
			$sql = "select a_id,a_name,a_sort from tbl_vod_area where ";
		 	
			if (isN($temp_num)) { $temp_num = 10;}
			if (!isnum($temp_num)){ $temp_num = 10;} else {$temp_num = intval($temp_num);}
			
			if (isN($temp_by)) { $temp_by = "sort";}
			if (isN($temp_order)) {$temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by a_id " . $temp_order;break;
				default : $orderStr =" order by a_sort " . $temp_order;
			}
			
			if (isN($temp_start)) { $temp_start=0;} else{ $temp_start = intval($temp_start);}
			$startnum=$temp_start; //$temp_num= $temp_num + $startnum;
		    if ($temp_num >0){
		   		$temp_limit = " limit ".$startnum.",".$temp_num;
		   	}
			
			$rs = $db->query($sql . $aWhere . $orderStr . $temp_limit);
			if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"arealistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[arealist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName= $row["a_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["a_id"]);
							break;
						case "link":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,app_installdir."search.php?keytype=5&keyword=".$row["a_name"]);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	
	function languagelist()
	{
		if (!strpos(",".$this->html,"{maccms:languagelist")) { return; }
		
		global $db;
		$labelRule ="{maccms:languagelist(.*?)}(.*?){/maccms:languagelist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
			$aWhere = " 1=1 ";
			if (isN($page)) { $page =1;}
			$currentPage = intval($page);
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
			$temp_num = $arrayParmenters["num"] ; $temp_start =$arrayParmenters["start"];
			unset($arrayParmenters);
			
			if (isN($temp_table)) {$temp_table="vod";}
			$sql = "select l_id,l_name,l_sort from tbl_vod_language where ";
		 	
			if (isN($temp_num)) { $temp_num = 10;}
			if (!isnum($temp_num)){ $temp_num = 10;} else {$temp_num = intval($temp_num);}
			
			if (isN($temp_by)) { $temp_by = "sort";}
			if (isN($temp_order)) {$temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "desc" :  $temp_order = "desc";break;
				default : $temp_order = "asc";
			}
			switch (trim($temp_by))
			{
				case "id" : $orderStr =" order by l_id " . $temp_order;break;
				default : $orderStr =" order by l_sort " . $temp_order;
			}
			
			if (isN($temp_start)) { $temp_start=0;} else{ $temp_start = intval($temp_start);}
			$startnum=$temp_start; //$temp_num= $temp_num + $startnum;
		    if ($temp_num >0){
		   		$temp_limit = " limit ".$startnum.",".$temp_num;
		   	}
			
			$rs = $db->query($sql . $aWhere . $orderStr . $temp_limit);
			if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"languagelistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[languagelist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempName= $row["l_name"];
							$tempArrayParmenters = $this->ParametersToArray($fieldAttr);
							$tempOperation= $tempArrayParmenters["len"];
							if (!isN($tempOperation) && strlen($tempName)>intval($tempOperation))
							{
								$tempName= substring($tempName,$tempOperation);
							}
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$tempName);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["l_id"]);
							break;
						case "link":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,app_installdir."search.php?keytype=7&keyword=".$row["l_name"]);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	function pageModuleInfo($curpage,$perpagenum,$TotalPage,$linktype,$datacount)
	{
		global $searchtype,$keyword,$keytype,$keyids;
		
		$strTemp="";$strPagelast="";$strPageNext="";$strPagePre="";$strPagefirst="";
		$labelRule ="\[page:number(.*?)\]";
		$labelRule = buildregx($labelRule,"is");
		preg_match_all($labelRule,$this->html,$tmparr);
		$tmparrlen=count($tmparr[1]);
		
		for($i=0;$i<$tmparrlen;$i++)
		{
			if ($datacount == 0){
				$this->html = replaceStr($this->html,$tmparr[0][$i],"");
			}
			else{
				$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
				$arrayParmenters =  $this->ParametersToArray($LabelParameters);
				$prepage = $arrayParmenters["len"]; $slinktype = $arrayParmenters["linktype"];
				if (!isN($slinktype)) {$linktype = $slinktype;}
				if (isN($prepage)) {$prepage = 10;} else{ $prepage = intval($prepage);}
				$strpageNumber= GetPageNum($curpage,$prepage,$TotalPage,$linktype);
				$this->html = replaceStr($this->html,$tmparr[0][$i],$strpageNumber);
			}
		}
		
		if($datacount>0){
			$strSelect = "&nbsp;&nbsp;<select name=\"select\" size=\"1\" style=\"font-size: 12px\" onchange=\"javascript:window.location.href=this.options[this.selectedIndex].value\">";
			switch ($linktype)
			{
				case "vodsearchlist":
				case "artsearchlist":
					if ($curpage==1){  
						$strPagefirst="?page=1&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
						$strPagePre="?page=1&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
					}
					else{
						$strPagefirst="?page=1&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
						$strPagePre="?page=".($curpage-1)."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
					} 
					if ($curpage==$TotalPage) {
						$strPageNext="?page=".$curpage."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
						$strPagelast="?page=".$TotalPage."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
					}
					else{
						$strPageNext="?page=".($curpage+1)."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
						$strPagelast="?page=".$TotalPage."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype;
					}
					
					$strTemp = $strSelect;
					for ($i=1;$i<=$TotalPage;$i++)
					{
						$selected="";
						if (intval($curpage)==$i) { $selected=" selected";}
						$strTemp = $strTemp."<option".$selected." value=".app_installdir."search.php?page=".$i ."&keyword=".$keyword."&searchtype=".$searchtype."&keytype=".$keytype.">".$i."ҳ</option>";
					}
					$strTemp = $strTemp."</select>";
					break;
				case "vodtypelist":
				case "arttypelist":
				case "vodtopiclist":
				case "arttopiclist":
					if ($curpage==1){  
						$strPagefirst= getPageLink(1,$linktype); $strPagePre= getPageLink(1,$linktype);
					}
					else{
						$strPagefirst=getPageLink(1,$linktype); $strPagePre=getPageLink($curpage-1,$linktype);
					}
					if ($curpage==$TotalPage){ 
						$strPageNext=getPageLink($curpage,$linktype) ; $strPagelast=getPageLink($TotalPage,$linktype);
					}
					else{
						$strPageNext=getPageLink($curpage+1,$linktype) ; $strPagelast=getPageLink($TotalPage,$linktype);
					}
					$strTemp = $strSelect;
					
					for ($i=1;$i<=$TotalPage;$i++)
					{
						$selected="";
						if (intval($curpage)==$i){ $selected=" selected";}
				    	$strTemp = $strTemp."<option".$selected." value=".getPageLink($i,$linktype). ">".$i."ҳ</option>";
					}
					$strTemp = $strTemp."</select>";
					break;
				case "vodtopicindex":
				case "arttopicindex":
					if ($curpage==1){  
						$strPagefirst= getTopicPage(1,$linktype) ; $strPagePre= getTopicPage(1,$linktype);
					}
					else{
						$strPagefirst=getTopicPage(1,$linktype) ; $strPagePre=getTopicPage($curpage-1,$linktype);
					}
					if ($curpage==$TotalPage){ 
						$strPageNext=getTopicPage($curpage,$linktype) ; $strPagelast=getTopicPage($TotalPage,$linktype);
					}
					else{
						$strPageNext=getTopicPage($curpage+1,$linktype) ; $strPagelast=getTopicPage($TotalPage,$linktype);
					} 
					$strTemp = $strSelect;
					
					for ($i=1;$i<=$TotalPage;$i++)
					{
						$selected="";
						if (intval($curpage)==$i){ $selected=" selected";}
				    	$strTemp = $strTemp."<option".$selected." value=".getTopicPage($i,$linktype).">".$i."ҳ</option>"	;
					}
					$strTemp = $strTemp."</select>";
					break;
				case "indexpagelist":
					if ($curpage==1){ 
						$strPagefirst=  getIndexPageLink(1)  ; $strPagePre=  getIndexPageLink(1) ;
					}
					else{
						$strPagefirst=  getIndexPageLink(1)  ; $strPagePre=  getIndexPageLink($curpage-1);
					}
					if ($curpage==$TotalPage){
						$strPageNext= getIndexPageLink($curpage) ; $strPagelast= getIndexPageLink($TotalPage);
					}
					else{
						$strPageNext=getIndexPageLink($curpage+1) ; $strPagelast= getIndexPageLink($TotalPage);
					}
					$strTemp = $strSelect;
					for ($i=1;$i<=$TotalPage;$i++)
					{
						$selected="";
						if (intval($curpage)==$i){ $selected=" selected";}
						$strTemp = $strTemp."<option".$selected." value=".getIndexPageLink($i).">".$i."ҳ</option>";
					}
					$strTemp = $strTemp."</select>";
					break;
			}
		}
		else{
			$strPagelast="#";$strPageNext="#";$strPagePre="#";$strPagefirst="#";
		}
		
		$this->html = replaceStr($this->html,"{search:count}",$datacount);
		$this->html = replaceStr($this->html,"[page:totalcount]",$datacount);
		$this->html = replaceStr($this->html,"[page:perpage]",$perpagenum);
		$this->html = replaceStr($this->html,"[page:pagecount]",$TotalPage);
		$this->html = replaceStr($this->html,"[page:curpage]",$curpage);
		$this->html = replaceStr($this->html,"[page:first]",$strPagefirst);
		$this->html = replaceStr($this->html,"[page:pre]",$strPagePre);
		$this->html = replaceStr($this->html,"[page:next]",$strPageNext);
		$this->html = replaceStr($this->html,"[page:last]",$strPagelast);
		$this->html = replaceStr($this->html,"[page:select]",$strTemp);
	}
	
	function gbooklist()
	{
		global $db,$page;
		$labelRule ="{maccms:gbooklist(.*?)}(.*?){/maccms:gbooklist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
	    	$tempstr = "";
	    	$arrayParmenters =  $this->ParametersToArray($LabelParameters);
	    	$temp_order = $arrayParmenters["order"] ; $temp_by = $arrayParmenters["by"];
	    	unset($arrayParmenters);
	    	$pageListType="gbooklist";
			$aWhere = " 1=1 ";
			$currentPage = $page;
			
			if (isN($temp_by)) {$temp_by = "sort";}
			if (isN($temp_order)) { $temp_order = "asc";}
			switch (trim($temp_order))
			{
				case "asc" : $temp_order = "asc";break;
				default : $temp_order = "desc";
			}
			switch (trim($temp_by))
			{      
				case "id" : $orderStr =" order by b_id " . $temp_order;break;
				default : $orderStr =" order by b_replytime " . $temp_order;
			}
			if (isN($temp_num)) { $temp_num = 10;}  else {$temp_num = intval($temp_num);}
			$temp_limit = " limit ".($temp_num * ($page-1)).",".$temp_num;
			$sql = "select b_id,b_name,b_leaveword,b_reply,b_leavewordtime,b_replytime,b_ip from tbl_book where ";
			
			$rscount = $db->query($sql . $aWhere . $orderStr);
			$datacount=$db->num_rows($rscount);
			$pagecountstr=ceil($datacount/$temp_num);
			
			$rs = $db->query($sql . $aWhere . $orderStr. $temp_limit);
		   if (!$rs){
				$datacount=0;
				$pagecountst=1;
				$this->html = replaceStr($this->html,$LabelStr,"gbooklistǩ:");
				break;
			}
			
			$labelRuleField = buildregx("\[gbooklist:(.*?)\]","is");
			preg_match_all($labelRuleField,$LabelStr,$MatchesChild);
			$matchfieldarr=$MatchesChild[1];
			$matchfieldstrarr=$MatchesChild[0];
			
			$j=1;
	        while ($row = $db ->fetch_array($rs))
	        {
				$tempLabelStr = $LabelStr;
				foreach($matchfieldarr as $f=>$matchfieldstr)
				{
					$matchfieldvalue=$matchfieldstrarr[$f];
					$matchfieldstr = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$matchfieldstr));
					if (strpos($matchfieldstr," ")>0){
						$fieldtemparr=explode(" ",$matchfieldstr);
						$tempfield=$fieldtemparr[0];
						$fieldAttr =$fieldtemparr[1];
					}else{
						$tempfield=$matchfieldstr;
						$fieldAttr ="";
					}
					 
					switch (trim($tempfield))
					{
						case "num":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$j);
							break;
						case "name":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_name"]);
							break;
						case "leaveword":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_leaveword"]);
							break;
						case "reply":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_reply"]);
							break;
						case "id":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_id"]);
							break;
						case "leavewordtime":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_leavewordtime"]);
							break;
						case "replytime":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_replytime"]);
							break;
						case "ip":
							$tempLabelStr = replaceStr ($tempLabelStr,$matchfieldvalue,$row["b_ip"]);
							break;
					}
				}
				$j=$j+1;
				$tempstr = $tempstr . $tempLabelStr;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
	    }
	    $this->pageModuleInfo($currentPage,$temp_num,$pagecountstr,$pageListType,$datacount);
	}
	
	function serverlist($arrVodType)
	{
		global $db,$CurVodid,$CurVodName,$CurVodEnName,$CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName;
		$labelRule ="{maccms:serverlist(.*?)}(.*?){/maccms:serverlist}";
	    $labelRule = buildregx($labelRule,"is");
	    preg_match_all($labelRule,$this->html,$tmparr);
        $tmparrlen=count($tmparr[1]);
        
		for($i=0;$i<$tmparrlen;$i++)
		{
			$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr[1][$i]));
			$LabelStr =  $tmparr[2][$i];
			$tempstr = "";
			$arrayParmenters =  $this->ParametersToArray($LabelParameters);
			$temp_address = $arrayParmenters["address"];
			unset($arrayParmenters);
			
			if (isN($temp_address)) { $temp_address="all";}
			
			if($temp_address=="current"){
				if ($app_makeplay==0) { $aWhere = " and du_sort = " . $currentsrc; }
			}
			else if ($temp_address !="all"){ 
				$aWhere = " and du_sort in(" .$temp_address. ")";
			}
			else{
				$aWhere = "";
			}
			$sql = "SELECT d_id,d_type,du_from,du_serverid,du_sort,du_url FROM (tbl_vod INNER JOIN tbl_vod_url ON tbl_vod.d_id = tbl_vod_url.du_vodid) where d_id =". $CurVodid . $aWhere . " order by du_sort asc ";
			
			$rs = $db->query($sql . $aWhere . $orderStr);
		  
		   if ($rs){
				$rscount=$db->num_rows($rs);
			}
			else{
				$rscount=0;
				$this->html = replaceStr($this->html,$LabelStr,"serverlistǩ:");
				break;
			}
			$server_count = $rscount;
			$num=1;
			while ($row = $db ->fetch_array($rs))
			{
				$tempLabelStr = $LabelStr;
				$labelRule1 ="{maccms:urllist(.*?)}(.*?){/maccms:urllist}";
	    		$labelRule1 = buildregx($labelRule1,"is");
	    		preg_match_all($labelRule1,$tempLabelStr,$tmparr1);
        		$tmparrlen1=count($tmparr1[2]);
        		$tempLabelStr2="";
        		
        		for($j=0;$j<$tmparrlen1;$j++)
				{
					$tempLabelStr1= $tmparr1[2][$j];
					$LabelParameters = trim(preg_replace("/[ \r\n\t\f]{1,}/"," ",$tmparr1[1][$j]));
					$arrayParmenters =  $this->ParametersToArray($LabelParameters);
					$temp_order = $arrayParmenters["order"];
					unset($arrayParmenters);
					
					
					$server_source = $row["du_from"] ;
					$server_num = $num;
					$tempurllist1= "";
					$tempUrl = $row["du_url"];
					$url_count = explode("#",$tempUrl);
					if (isN($temp_order)){$temp_order="asc";}
					
					if ($temp_order=="desc"){
						for ($k=count($url_count) ;$k>=0;$k--)
						{
							$singleUrl = explode("$",$url_count[$k]);
							if (!isN($url_count[$k])){
								if (count($singleUrl) > 1){ 
									$urlname=$singleUrl[0];$urlpath=$singleUrl[1];
								}
								else{
									$urlname = "".($k+1)."";
									$urlpath=$singleUrl[0];
								}
								$tempurllist = replaceStr($tempLabelStr1,"[urllist:name]",$urlname);
								$typePath = $arrVodType["t_enname"];
								$tempurllist = replaceStr($tempurllist,"[urllist:link]",getVodPlayUrl($CurVodid,$CurVodName,$CurVodEnName,$CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName,$row["du_sort"],$k));
								$tempurllist = replaceStr($tempurllist,"[urllist:path]",$urlpath);
								$tempurllist1 = $tempurllist1 . $tempurllist;
							}
						}
					}
					else{
						for ($k=0 ;$k<count($url_count);$k++)
						{
							$singleUrl = explode("$",$url_count[$k]);
							if (!isN($url_count[$k])){
								$str1="";
								if (count($singleUrl) == 2){ 
									$urlname=$singleUrl[0];$urlpath=$singleUrl[1];
								}
								else{
									$urlname = "".($k+1)."";
									$urlpath=$singleUrl[0];
									
									/*
									If ($server_source == "qvod"){
	                                    $arr1 = explode("|",$urlpath);
	                                    If (count($arr1)==4){ $str1 = $arr1[2]; }
	                                }
	                                else if ($server_source == "baidu"){
	                                	$arr1 = explode("|",$urlpath);
	                                    If (count($arr1)==3){ $str1 = $arr1[2];}
	                                }
	                                else if ($server_source == "gvod"){
	                                    $arr1 = explode("/",$urlpath);
	                                    If (count($arr1) == 6){ $str1 = $arr1[5];}
	                                }
	                                else if ($server_source == "web9"){
	                                    $arr1 = explode("/",$urlpath);
	                                    $str1 = $arr1[count($arr1)-1];
	                                }
	                                else if ($server_source == "pvod"){
	                                    $arr1 = explode("/",$urlpath);
	                                    If (count($arr1) == 5) { $str1 = $arr1[4];}
	                                }
	                                
	                             	if (($str1 !="") && strpos($str1, ".") > 0) { $urlname = substring($str1, strripos($str1, ".") - 1,0);}
									*/
								}
								$tempurllist = replaceStr($tempLabelStr1,"[urllist:name]",$urlname);
								$typePath = $arrVodType["t_enname"];
								$tempurllist = replaceStr($tempurllist,"[urllist:link]",getVodPlayUrl($CurVodid,$CurVodName,$CurVodEnName,$CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName,$row["du_sort"],$k));
								$tempurllist = replaceStr($tempurllist,"[urllist:path]",$urlpath);
								$tempurllist1 = $tempurllist1 . $tempurllist;
							}
						}
					}
					if (app_playisopen==1){
						$tempurllist1 = replaceStr($tempurllist1,"target=\"_blank\"","target=\"_self\"");
					}
					$tempLabelStr2 =  replaceStr($tempLabelStr,$tmparr1[0][$j],$tempurllist1);
				}
				$num++;
				$tempLabelStr2 = replaceStr($tempLabelStr2,"[serverlist:num]",$server_num);
				$tempLabelStr2 = replaceStr($tempLabelStr2,"[serverlist:count]",$server_count);
				$tempLabelStr2 = replaceStr($tempLabelStr2,"[serverlist:source]",playText($server_source));
				$tempLabelStr2 = replaceStr($tempLabelStr2,"[serverlist:urlcount]",count($url_count));
				$tempstr = $tempstr . $tempLabelStr2;
			}
			unset($rscount);
			unset($rs);
			$this->html = replaceStr($this->html,$tmparr[0][$i],$tempstr);
		}
	}
	
	function ListShareLabel($CacheName,$CacheNameTempLate,$TempLatePath,$t_name,$strLink,$flag)
	{
		global $CurVodTypeid,$CurArtTypeid;
		$this->html =getCacheFile($CacheName,$TempLatePath);
		$this->replaceLabel();
		if ($flag=="vod"){
			$strID = $CurVodTypeid;
		}
		elseif ($flag=="art"){
			$strID = $CurArtTypeid;
		}
		$this->html = replaceStr($this->html,"{typepage:id}",$strID);
		$this->html = replaceStr($this->html,"{typepage:name}",$t_name);
		$this->html = replaceStr($this->html,"{typepage:link}",$strLink);
		setCache($CacheName,$this->html,0);
	}
	function ViewShareLabel($CacheName,$CacheNameTempLate,$TempLatePath,$strLink,$strTypeName)
	{
		global $CurVodTypeid;
		$this->html = getCacheFile($CacheName,$TempLatePath);
		$this->replaceLabel();
		$this->html = replaceStr($this->html,"[vodinfo:typeid]",$CurVodTypeid);
		$this->html = replaceStr($this->html,"[vodinfo:typelink]",$strLink);
		$this->html = replaceStr($this->html,"[vodinfo:typename]",$strTypeName);
		setCache($CacheName,$this->html,0);
	}
	
	function ArticleShareLabel($CacheName,$CacheNameTempLate,$TempLatePath,$strLink,$strTypeName)
	{
		global $CurArtTypeid;
		$this->html = getCacheFile($CacheName,$TempLatePath);
		$this->replaceLabel();
		$this->html = replaceStr($this->html,"[artinfo:typeid]",$CurArtTypeid);
		$this->html = replaceStr($this->html,"[artinfo:typelink]",$strLink);
		$this->html = replaceStr($this->html,"[artinfo:typename]",$strTypeName);
		setCache($CacheName,$this->html,0);
	}
	
	function TopicIndexShareLabel($CacheName,$CacheNameTempLate,$TempLatePath)
	{
		$this->html = getCacheFile($CacheName,$TempLatePath);
		$this->replaceLabel();
		setCache($CacheName,$this->html,0);
	}
	
	function TopicListShareLabel($CacheName,$CacheNameTempLate,$TempLatePath,$strTName,$strTpic,$strTContent,$flag)
	{
		global $CurVodTopicid,$CurArtTopicid;
		$this->html = getCacheFile($CacheName,$TempLatePath);
		$this->replaceLabel();
		if ($flag=="vod"){
			$strID = $CurVodTopicid;
		}
		elseif ($flag=="art") {
			$strID = $CurArtTopicid;
		}
		$this->html = replaceStr($this->html,"{topicpage:id}",$strID);
		$this->html = replaceStr($this->html,"{topicpage:name}",$strTName);
		$this->html = replaceStr($this->html,"{topicpage:pic}",$strTpic);
		$this->html = replaceStr($this->html,"{topicpage:des}",$strTContent);
		setCache($CacheName,$this->html,0);
	}
	
	function loadvod($row,$tflag,$arrVodType)
	{
		global $root,$currentnum;
		global $CurVodid,$CurVodName,$CurVodEnName,$CurVodTypeid,$CurVodTypeParentid,$CurVodTypeName,$CurVodTypeEnName;
		
		$CurVodTypeid =  $row["d_type"]; $CurVodTypeParentid=$arrVodType["t_patentid"]; 
		$CurVodTypeName=$arrVodType["t_name"]; $CurVodTypeEnName=$arrVodType["t_enname"];
		$CurVodid = $row["d_id"]; $CurVodName = $row["d_name"]; $CurVodEnName=$row["d_enname"];
		
		$d_name = $row["d_name"]; $d_starring = $row["d_starring"]; $d_content = $row["d_content"];
		$d_enname = $row["d_enname"]; $d_directed = $row["d_directed"]; $d_pic = $row["d_pic"];
		if (!strpos(",".$d_pic,"http://")) { $d_pic = app_installdir.$d_pic; }
		
		if ($tflag=="view") {
			$CacheName = "vod_".$CurVodTypeid;
			$CacheNameTempLate = "template_vod".$CurVodTypeid;
			$TempLatePath = $root."template/".app_templatedir."/".app_htmldir."/".$arrVodType["t_vodtemplate"];
		}
		elseif ($tflag=="play"){
			if (app_playisopen==1){ $playTemplateFile="openplay.html" ;} else { $playTemplateFile= $arrVodType["t_vodplaytemplate"];}
			$CacheName = "vodplay_".$CurVodTypeid;
			$CacheNameTempLate = "template_vodplay" .$CurVodTypeid;
			$TempLatePath = $root."template/".app_templatedir."/".app_htmldir."/" . $playTemplateFile;
		}
		
		
		
		if (chkCache($CacheName)){
			$this->html = getCache($CacheName);
		}
		else{
			$this->ViewShareLabel($CacheName,$CacheNameTempLate,$TempLatePath,getVodTypeLink($CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName),$CurVodTypeName);
		}
		
		$d_content = repPse($d_content,$row["d_id"]);
		
		
		$this->html = replaceStr($this->html,"[vodinfo:id]",$row["d_id"]);
		$this->html = replaceStr($this->html,"[vodinfo:name]",$d_name);
		$this->html = replaceStr($this->html,"[vodinfo:enname]",$row["d_enname"]);
		$this->html = replaceStr($this->html,"[vodinfo:ennamelink]",getKeyLink($row["d_enname"],2));
		$this->html = replaceStr($this->html,"[vodinfo:colorname]",getColorName($d_name,$row["d_color"]));
		$this->html = replaceStr($this->html,"[vodinfo:pic]",$d_pic);
		$this->html = replaceStr($this->html,"[vodinfo:starring]",$d_starring);
		$this->html = replaceStr($this->html,"[vodinfo:starringlink]",getKeysLink($d_starring,3));
		$this->html = replaceStr($this->html,"[vodinfo:directed]",$row["d_directed"]);
		$this->html = replaceStr($this->html,"[vodinfo:directedlink]",getKeysLink($row["d_directed"],4));
		$this->html = replaceStr($this->html,"[vodinfo:hit]","<em id=\"hit\"></em><script>getHit('vod','".$row["d_id"]."')</script>");
		$this->html = replaceStr($this->html,"[vodinfo:des]",$d_content);
		$d_contentnohtml = strip_tags($d_content);
		$this->html = replaceStr($this->html,"[vodinfo:desnohtml]",$d_contentnohtml);
		$this->html = replaceStr($this->html,"[vodinfo:time]",$row["d_addtime"]);
		$this->html = replaceStr($this->html,"[vodinfo:level]",$row["d_level"]);
		$this->html = replaceStr($this->html,"[vodinfo:state]",$row["d_state"]);
		$this->html = replaceStr($this->html,"[vodinfo:year]",$row["d_year"]);
		$this->html = replaceStr($this->html,"[vodinfo:yearlink]",getKeyLink($row["d_year"],6));
		$this->html = replaceStr($this->html,"[vodinfo:stint]",$row["d_stint"]);
		$this->html = replaceStr($this->html,"[vodinfo:remarks]",$row["d_remarks"]);
		$this->html = replaceStr($this->html,"[vodinfo:source]",getPlaySource($row["d_id"],true));
		$this->html = replaceStr($this->html,"[vodinfo:goodnum]",$row["d_good"]);
		$this->html = replaceStr($this->html,"[vodinfo:badnum]",$row["d_bad"]);
		$this->html = replaceStr($this->html,"[vodinfo:score]",$row["d_score"]);
		$this->html = replaceStr($this->html,"[vodinfo:scorecount]",$row["d_scorecount"]);
		$slink =getVodLink($row["d_id"],$row["d_name"],$row["d_enname"],$row["d_type"],$arrVodType["t_name"],$arrVodType["t_enname"]);
		$this->html = replaceStr($this->html,"[vodinfo:link]",$slink);
		
		$this->html = replaceStr($this->html,"[vodinfo:fav]","<a href=\"javascript:void(0)\" onclick=\"addFavorite('http://".app_siteurl.$slink."','".$d_name."߿');return false;\"/>Ҫղ</a>");
		$this->html = replaceStr($this->html,"[vodinfo:share]","<a href=\"javascript:void(0)\" onclick=\"copyData(document.title +'   ' + window.location.href);return false;\"/>Ҫ</a>");
		$this->html = replaceStr($this->html,"[vodinfo:scoremark]","<link rel=\"stylesheet\" href=\"".app_installdir."images/star_rating.css\" type=\"text/css\"  /><script>vodScoreMark(".$row["d_id"].",".$row["d_scorecount"].",".$row["d_score"].");</script>");
		$this->html=replaceStr($this->html,"[vodinfo:desktop]","<a target=\"_blank\" href=\"".app_installdir."inc/service.php?action=desktop&url=".$slink."&name=".$row["d_name"]."\">浽</a>");
		$this->html=replaceStr($this->html,"[vodinfo:good]","<span id=\"good_num\">".$row["d_good"]."</span><a href=\"javascript:void(0)\" onclick=\"vodGood(".$CurVodid.",'good_num');return false;\"/>һ</a>");
		$this->html=replaceStr($this->html,"[vodinfo:bad]","<span id=\"bad_num\">".$row["d_bad"]."</span><a href=\"javascript:void(0)\" onclick=\"vodBad(".$CurVodid.",'bad_num');return false;\"/>һ</a>");
		$this->html=replaceStr($this->html,"[vodinfo:error]","<a href=\"javascript:void(0)\" onclick=\"reportVodErr('".$CurVodid."');return false;\"/>Ҫ</a>");
		$this->html=replaceStr($this->html,"[vodinfo:userfavorite]","<a href=\"javascript:void(0)\" onclick=\"addUserFavorite('".$CurVodid."');return false;\"/>Աղ</a>");
		
		$this->html=replaceStr($this->html,"[vodinfo:history]","<script>history_New(window.location.href,'" .$d_name. "');</script>");
		
		if(strpos($this->html,"[vodinfo:language")){
			$arrVodLang= getVodLanguageByArrayByCache($row["d_language"]);
			$this->html = replaceStr($this->html,"[vodinfo:language]",$arrVodLang["l_name"]);
			
			$this->html = replaceStr($this->html,"[vodinfo:languagelink]",getKeyLink($arrVodLang["l_name"],7));
		}
		if(strpos($this->html,"[vodinfo:area")){
			$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
			$this->html = replaceStr($this->html,"[vodinfo:area]",$arrVodArea["a_name"]);
			$this->html = replaceStr($this->html,"[vodinfo:arealink]",getKeyLink($arrVodArea["a_name"],5));
		}
		if(strpos($this->html,"[vodinfo:previouslink]")){
			$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
			$this->html = replaceStr($this->html,"[vodinfo:previouslink]",getVodAfterLink($row["d_id"],$CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName,0));
		}
		if(strpos($this->html,"[vodinfo:nextlink]")){
			$arrVodArea= getVodAreaByArrayByCache($row["d_area"]);
			$this->html = replaceStr($this->html,"[vodinfo:nextlink]",getVodAfterLink($row["d_id"],$CurVodTypeid,$CurVodTypeName,$CurVodTypeEnName,1));
		}
		
		$this->serverlist($arrVodType);
		if ($tflag=="play"){
        	if (app_viewtype <2 || app_makeplay==0){ $this->html = replaceStr($this->html,"[playinfo:num]",$currentnum + 1);}
			$this->html = replaceStr($this->html,"[playinfo:info]",getPlayInfo($row["d_id"],$d_name));
			$this->html = replaceStr($this->html,"[playinfo:player]",getPlayer());
		}
		
		
		$this->getLabelByLen ("vodinfo","name",$d_name) ;
		$this->getLabelByLen ("vodinfo","starring",$d_starring);
		$this->getLabelByLen ("vodinfo","des",$d_content);
		$this->getLabelByLen ("vodinfo","desnohtml",$d_contentnohtml);
		
		$this->replaceLast();
		$this->replaceComment (1,$CurVodid);
		$this->replaceMood (1,$CurVodid);
		
	}
	
	function loadart($row)
	{
		global $root;
		global $CurArtTypeParentid,$CurArtTypeid,$CurArtTypeName,$CurArtTypeEnName,$CurArtid,$CurArtName,$CurArtEnName;
		
		$arrArtType = getArtTypeByArrayByCache($row["a_type"]);
		
		$CurArtTypeid = $row["a_type"]; $CurArtTypeParentid = $arrArtType["t_patentid"];
		$CurArtTypeName = $arrArtType["t_name"]; $CurArtTypeEnName = $arrArtType["t_enname"];
		$CurArtid = $row["a_id"]; $CurArtName = $row["a_title"]; $CurArtEnName = $row["a_entitle"];
		
		$a_name = $row["a_title"] ; $a_author = $row["a_author"]; $a_content = $row["a_content"] ;
		
		$CacheName = "art_".$CurArtTypeid;
		$CacheNameTempLate = "template_art";
		$TempLatePath = $root."template/".app_templatedir."/".app_htmldir."/" .$arrArtType["t_arttemplate"];
		if (chkCache($CacheName)){
			$this->html = getCache($CacheName);
		}
		else{
			$this->ArticleShareLabel ($CacheName,$CacheNameTempLate,$TempLatePath,getArtTypeLink($CurArtTypeid,$CurArtTypeName,$CurArtTypeEnName),$CurArtTypeName);
		}
		
		$this->html = replaceStr($this->html,"[artinfo:id]",$row["a_id"]);
		$this->html = replaceStr($this->html,"[artinfo:name]",$a_name);
		$this->html = replaceStr($this->html,"[artinfo:enname]",$row["a_entitle"]);
		$this->html = replaceStr($this->html,"[artinfo:colorname]",getColorName($a_name,$row["a_color"]));
		$this->html = replaceStr($this->html,"[artinfo:typeid]",$CurArtTypeid);
		$this->html = replaceStr($this->html,"[artinfo:typename]",$CurArtTypeName);
		$this->html = replaceStr($this->html,"[artinfo:typeenname]",$CurArtTypeEnName);
		$this->html = replaceStr($this->html,"[artinfo:typelink]",getArtTypeLink($CurArtTypeid,$CurArtTypeName,$CurArtTypeEnName));
		$this->html = replaceStr($this->html,"[artinfo:author]",$a_author);
		$this->html = replaceStr($this->html,"[artinfo:des]",$a_content);
		$this->html = replaceStr($this->html,"[artinfo:link]",getArtLink($row["a_id"],$row["a_title"],$row["a_entitle"],$row["a_type"],$CurArtTypeName,$CurArtTypeEnName));
		$this->html = replaceStr($this->html,"[artinfo:time]",$row["a_addtime"]);
		$this->html = replaceStr($this->html,"[artinfo:hit]","<span id=\"hit\"></span><script>getHit('art','".$row["a_id"]."')</script>");
		
		$this->getLabelByLen ("artinfo","name",$a_name);
		$this->getLabelByLen ("artinfo","author",$a_author);
		$this->getLabelByLen ("artinfo","des",$a_content);
		$this->replaceLast();
		$this->replaceComment (2,$CurArtid);
		$this->replaceMood (2,$CurArtid);
		
	}
}
?>