<?php
/**
 * 广告管理模块
 * @copyright reginx.com
 * $Id$
 */
class ads_mod extends admin_mod {

    /**
     * 架构函数
     *
     * @param unknown_type $param
     */
    public function __construct(&$param){
        parent::__construct($param);
        $this->assign('actype' , config_lib::$actype);
        $this->assign('alocal' , config_lib::$alocal);
    }

    /**
     * 广告列表
     *
     */
    public function listAct(){
        $this->assign('atitle' , '广告列表');
        $this->assign('list' , core::getobj('ads_tab')->fields('id,name,status,ctype,location,adate')->order('id desc')->getall());
        $this->display('ads/list.html');
    }

    /**
     * 新增广告
     *
     */
    public function addAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            $this->assign('ads' , core::getobj('ads_tab')->where("id = {$id}")->get());
        }
        $this->display('ads/add.html');
    }

    /**
     * 保存操作
     *
     */
    public function saveAct(){
        $obj = core::getobj('ads_tab');
        if($obj->load('ads')){
            $obj->data['status'] = $obj->data['status'] ? 1 : 0;
            $ret = $obj->save();
            if((int)$ret['code'] === 0){
                $this->showmsg('操作成功!' , core::url('ads-list') , 1 , 2);
            }
        }
        $this->showmsg($obj->geterr() , -1 , 1 , 2);
    }

    /**
     * 广告删除
     *
     */
    public function delAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            core::getobj('ads_tab')->where("id = $id ")->del();
            $this->showmsg('操作成功!' , core::url('ads-list') , 1 , 2);
        }
    }
}
?>