<?php
/**
 * 资讯管理模块
 * @copyright reginx.com
 * $Id$
 */
class art_mod extends admin_mod {


    /**
     * 列表页
     *
     */
    public function listAct(){
        $title = '资讯列表';
        $obj = OBJ('art_tab');
        $cat = $this->has('cat') ? intval($this->get('cat')) : null;
        $clist  = api_lib::getcatlist(1 , 0);
        if($cat !== null && isset($clist[$cat])){
            $title =  "[&nbsp;{$clist[$cat]['name']}&nbsp;]" . $title ;
            $obj->where("catid = $cat");
        }
        $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($this->get('pn' , 'R')) , 15);
        $obj->clear('fields')->order("status desc,id desc")->fields("id,name,sname,adate,status,views,cat")->limit($pobj->limit);
        if($pobj->rev){
            $obj->order("id asc");
        }
        $list = $obj->getall();
        $this->assign('cat' , $cat);
        $this->assign('stext' , config_lib::$astatus);
        $this->assign('list' , $pobj->rev ? array_reverse($list) : $list);
        $this->assign('catlist' , $clist);
        $this->assign('atitle' , $title);
        $this->assign('pobj' , $pobj->toarray());
        $this->display('art/list.html');
    }

    /**
     * 新增/修改
     *
     */
    public function addAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            $this->assign('art' , OBJ('art_tab')->where("id = $id")->get());
            $this->assign('desc' , OBJ('desc_tab')->where("refid = $id and ctype = 1")->get());
        }
        $this->assign('atitle' , '新增资讯');
        $this->assign('cats' , OBJ('cat_tab')->getslist( 0 , 1 , 1));
        $this->display('art/add.html');
    }

    /**
     * 保存
     *
     */
    public function saveAct(){
        $art  = $this->get('art' , 'P');
        $desc = $this->get('desc' , 'P');
        $dobj = OBJ('desc_tab');
        $aobj = OBJ('art_tab');
        $art['sname']  = ($art['sname'] == 'auto') ? py_lib::get($art['name']) : $art['sname'];
        $art['author'] = $art['source'] = 'mogdy.com';
        $art['hash']   = md5($art['name']);
        $tag  = $art['tag'] = $art['tag'] ? $art['tag'] : art_lib::gettags($art['name']);
        $art['key'] = $tag . ',' . mb_substr(filter::text($art['name']) , 0 , 36 , 'utf-8');
        $desc['sdesc'] = ga_lib::losetags($desc['sdesc']);
        if(empty($art['desc'])){
            $art['desc'] = mb_substr(preg_replace('/\s*/' , '' , filter::text(trim($desc['sdesc']))) , 0 , 80 , 'utf-8');
        }
        if($dobj->load($desc) && $aobj->load($art)){
            $artid = intval($aobj->data['id']);
            $ret = $aobj->save();
            if(!empty($ret) && (int)$ret['code'] === 0){
                $dobj->data['refid'] = $artid ? $artid : intval($ret['msg']);
                // 添加文章标签
                if(!empty($tag)){
                    tag_lib::add(5 , $artid , $tag);
                }
                $dobj->replace();
                $this->showmsg('操作成功' , core::url('art-list') , 1 ,2);
            }
        }
        $this->showmsg($aobj->geterr() + $dobj->geterr() , -1 , 1 , 2);

    }

    /**
     * 删除
     *
     */
    public function delAct(){
        $ids = $this->get('id' , 'p');
        $ids = empty($ids) ? $this->get('id') : $ids;
        if(is_array($ids)){
            $ids = join(',' , array_map('intval' , $ids));
            OBJ("art_tab")->where("id in( $ids )")->del();
            OBJ("desc_tab")->where("refid in ( $ids ) and ctype = 1")->del();
        }else{
            $this->ajaxout(OBJ("art_tab")->where("id = $ids")->set("status" , $v)->save());
            OBJ("desc_tab")->where("refid = $ids and ctype = 1")->del();
        }
        $this->showmsg('删除成功!' , NULL , 1 , 1);
    }

    /**
     * 审核
     *
     */
    public function setAct(){
        $v   = intval($this->get('v'));
        $ids = $this->get('id' , 'p');
        $ids = empty($ids) ? $this->get('id') : $ids;
        if(is_array($ids)){
            $ids = join(',' , array_map('intval' , $ids));
            OBJ("art_tab")->where("id in ($ids)")->set("status" , $v)->save();
            $this->redirect($_SERVER['HTTP_REFERER'] , 0);
        }else{
            $this->ajaxout(OBJ("art_tab")->where("id = $ids")->set("status" , $v)->save());
        }
        $this->showmsg('未指定的ID');
    }
}
?>