<?php
/**
 * 数据扩展标签
 * @copyright reginx.com
 * $Id$
 */
class block_mod extends admin_mod {

    /**
     * 列表
     *
     */
    public function listAct(){
        $this->assign('atitle' , '数据标签列表');
        $obj = core::getobj('block_tab');
        $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($this->get('pn')) , 10);
        $this->assign('pobj' , $pobj->toarray());
        $obj->clear('fields')->fields('name,skey,ttl,adate,tpl')->limit($pobj->limit)->order("adate " . ($pobj->rev ? 'asc' : 'desc'));
        $this->assign('list'   , $pobj->rev ? array_reverse($obj->getall()) : $obj->getall());
        $this->display('block/list.html');
    }

    /**
     * 新增/修改
     *
     */
    public function addAct(){
        $skey = $this->get('skey');
        $this->assign('block' , OBJ('block_tab')->where("skey = '$skey'")->get());
        $this->assign('atitle' , '新增数据标签');
        $this->assign('tpls' , tpl_lib::getlist());
        $this->display('block/add.html');
    }

    /**
     * 新增/修改
     *
     */
    public function delAct(){
        $skey = $this->get('skey');
        if(preg_match('/^\w+$/i' , $skey)){
            OBJ('block_tab')->where("skey = '{$skey}'")->del();
            block::rebuild();
        }
        $this->redirect('block-list' , 1);
    }

    /**
     * 保存
     *
     */
    public function saveAct(){
        $obj = OBJ('block_tab');
        if($obj->load()){
            if(block::secchk($obj->data['extra'])){
                $obj->data['skey'] = strtolower($obj->data['skey']);
                $obj->replace();
                block::rebuild();
                $this->showmsg('操作成功!' , core::url('block-list') , 1 , 2);
            }
            $this->showmsg('标签内容含有禁用的函数!' , -1 , 1 , 2);
        }else{
            $this->showmsg($obj->geterr() , -1 , 1 , 2);
        }
    }

    /**
     * 标签预览
     *
     */
    public function viewAct(){
        $skey = $this->get('skey');
        if(preg_match('/^\w+$/i' , $skey)){
            $this->assign('block' , OBJ('block_tab')->where("skey = '{$skey}'")->get());
            $this->assign('data' , call_user_func(array('block' , 'get' . $skey)));
        }
        $this->display('block/view.html');
    }

    /**
     * 字段信息
     *
     */
    public function filedsAct(){
        $this->nocache();
        $tab = $this->get('tab');
        if(preg_match('/^\w+\_tab$/i' , $tab)){
            $obj = OBJ($tab);
            $this->assign('ops' , config_lib::$blockop);
            $this->assign('fields' , $obj->getfileds());
            $this->display('block/opts.html');
        }
    }
}
?>