<?php
/**
 * 类别管理
 * @copyright reginx.com
 * $Id: cat.mod.php 7 2013-01-24 00:30:29Z reginx $
 */
class cat_mod extends admin_mod {

	/**
     * 分类类型
     *
     * @var unknown_type
     */
	public $ctype = 0;

	/**
     * cat table object
     *
     * @var unknown_type
     */
	public $obj = null;

	/**
     * 架构函数
     *
     * @param unknown_type $param
     */
	public function __construct(&$param){
		parent::__construct($param);
		$this->ctype = intval($this->get('ctype' , 'R'));
		$this->obj   = core::getobj('cat_tab');
		$this->cattype = config_lib::$ctype;
		$this->assign('ctype' , $this->ctype);
	}

	/**
     * 类别类别
     *
     */
	public function listAct(){
		$this->assign('list' , $this->obj->getslist( 0 , $this->ctype));
		$this->assign('atitle' , $this->cattype[$this->ctype]);
		$this->display('cat/list.html');
	}

	/**
     * 新增 & 修改
     *
     */
	public function addAct(){
		$id = intval($this->get('id'));
		$this->assign('atitle' , '新增类别');
		if($id){
			$cat = $this->obj->where("id = {$id}")->get();
			$this->ctype = $cat['ctype'];
			$this->assign('cat' , $cat);
			$this->assign('atitle' , '修改 ' .$cat['name']);
		}
		$plist = $this->obj->getslist( 0 , $this->ctype , 1);
		$this->assign('plist' , $plist);
		$this->assign('ctype' , $this->ctype);
		$this->display('cat/add.html');
	}

	/**
     * 删除类别
     *
     */
	public function delAct(){
		$id = intval($this->get('id'));
		if($id > 0){
			$row = core::getobj('cat_tab')->where("id = $id ")->get();
			if(!empty($row)){
				$ids = cat_lib::getsubids($id , $row['ctype']);
				if(count($ids) > 1){
					$this->showmsg('请先删除下属类别!' , NULL , 1 , 1);
				}
				$tab = $row['ctype'] == '2' ? 'vod_tab' : 'art_tab';
				if(!empty($ids)){
					$ids = join(',' , $ids);
					if(OBJ($tab)->where){}
					if($row['ctype'] == '2'){
						// 视频封面加入清除队列
						$sql = "insert into temp_tab(k , v)  select concat('rmimg_' , id) , cover from vod_tab where cat in ($ids) and cover != ''";
						core::getobj('cat_tab')->exec($sql);
						core::getobj('vod_tab')->where("cat in ($ids)")->del();
					}
					core::getobj('cat_tab')->where("id in ($ids)")->del();
				}
			}
		}
		$this->showmsg('操作成功!' , NULL , 1 , 1);
	}

	/**
     * 类别合并
     *
     */
	public function mergeAct(){
		if($this->has('target' , 'P')){
			$source = $this->get('source' , 'P');
			$target = intval($this->get('target' , 'P'));
			if(!empty($source) && !empty($target)){
				$source = explode(',' , $source);
				$source = array_unique(array_map('intval' , $source));
				if(!empty($source)){
				    $field = 'cat';
				    if($this->ctype == 3){
				        $field = 'region';
				    }
					core::getobj('vod_tab')->where("{$field} in (" . join(',' , $source) . ")")->set("{$field}", $target)->save();
					cat_lib::del($source);
					$this->showmsg('合并成功' , NULL , 1 , 2);
				}
			}
			$this->showmsg('未指定类别' , NULL , 1  , 2 );
		}
		$this->assign('list' , $this->obj->getslist( 0 , $this->ctype));
		$this->assign('atitle' , '类别合并');
		$this->display('cat/merge.html');
	}

	/**
     * 分类持久化
     *
     */
	public function saveAct(){
		if($this->obj->load()){
		    if(in_array($this->obj->data['sname'] , config_lib::$syscname)){
		        $this->showmsg('映射名称请勿于系统保留内容(' . join(',' , config_lib::$syscname) .' )重复' , -1 , 1 , 2);
		    }
			$ctype = $this->obj->data['ctype'];
			// refpath
			$oldpath = $newpath = ($this->obj->data['path'] ? $this->obj->data['path'] : '#0#') ;
			if($this->obj->data['parent']){
				$obj1 = new cat_tab();
				$parent = $obj1->where("id = {$this->obj->data['parent']}")->get();
				$newpath = $parent['path'] . $parent['id'] .'#';
			}else{
				$newpath = '#0#';
			}
			$this->obj->data['path'] = $newpath;
			$oldpath .= $this->obj->data['id'] . '#';
			$newpath .= $this->obj->data['id'] . '#';
			if($ret = $this->obj->save()){
				if($oldpath != $newpath){
					$this->obj->refpath($ctype , $oldpath , $newpath );
				}
				$this->showmsg('操作成功!' , core::url('cat-list-ctype-%d' , $ctype) , 1 , 1);
			}else{
				$this->showmsg($this->obj->geterr() , null , 1 , 1);
			}
		}else{
			$this->showmsg($this->obj->geterr() , null , 1 , 1);
		}
	}
	
	/**
	 * 修复模块文件
	 *
	 */
	public function repairAct(){
		cat_lib::repair();
		$this->showmsg('修复完成' , null , 1 , 1);
	}

	/**
     * 排序更新
     *
     */
	public function sortAct(){
		$id = intval($this->get('id'));
		$v  = intval($this->get('v'));
		core::getobj('cat_tab')->set("sort" , $v)->where("id = $id ")->save();
		$this->ajaxout(array('code' => 0));
	}

}
?>