<?php
/**
 * 备份恢复模块
 * @copyright reginx.com
 * $Id$
 */
class db_mod extends admin_mod {

	/**
	 * 备份页
	 *
	 */
	public function backupAct(){
		$this->assign('log' , db_lib::log());
		$this->assign('atitle' , '系统备份');
		if($this->has('tab')){
			$dblib = new db_lib($this->conf['db']);
			$this->assign('vsize' , core::byteslen($this->get('vsize' , 'P')));
			$this->assign('tabs' , $dblib->gettabs());
			$this->display('system/db_tabs.html');
		}
		$this->display('system/db_backup.html');
	}

	/**
	 * 导出sql文件
	 *
	 */
	public function exportAct(){
	    $this->nocache();
		$tabs = array();
		$tstr = '';
		$pn  = intval($this->get('pn'));
		$dir = $this->sobj->get('dir');
		$index = intval($this->get('i'));
		$vsize = intval($this->get('vsize' , 'P'));
		if(!$vsize){
			$vsize = intval($this->get('vsize'));
		}
		if($this->has('tstr')){
			$tstr = $this->get('tstr');
			if(preg_match('/^[\w\,\_]+$/' , $tstr)){
				$tabs = explode(',' , $tstr);
			}
		}else if($this->has('tab' , 'P')){
			$tabs = $this->get('tab' , 'P');
			$tstr = join(',' , $tabs);
		}else{
			$this->showmsg('未指定的操作');
		}
		$dblib = new db_lib($this->conf['db']);
		$tablist = $dblib->gettabs();
		if($index === 0 || empty($dir)){
			$dir = 'backup/' . core::randstr(8) . '_' . strtolower(date('YmdHis' , REQUEST_TIME));
			$this->sobj->set('dir' , $dir);
			$dblib->setdir($dir);
			$dblib->tabdump($tabs);
			$ret = $dblib->getsql($tabs[$index] , $tablist[$tabs[$index]] , $pn ? $pn : 1);
			if($ret['total'] > $ret['less']){
				$last = $ret['total'] - $ret['less'];
				$url = core::url('db-export-tstr-%s-i-%d-pn-%d-vsize-%d' , $tstr, $index , ++$pn , $vsize);
				$this->showmsg("表 {$tabs[$index]} 已备份 {$ret['less']} , 剩余 {$last}" , $url , 1 , 1);
			}else{
				$url = core::url('db-export-tstr-%s-i-%d-pn-%d-vsize-%d' , $tstr, $index+1 , 1 , $vsize);
				$next = $tabs[$index+1];
				$this->showmsg("表 {$tabs[$index]} 备份完毕  , 开始备份 {$next} ... " , $url , 1 , 2);
			}
		}else if($index > 0){
			if(isset($tabs[$index]) && isset($tablist[$tabs[$index]])){
				$dblib->setdir($this->sobj->get('dir'));
				$ret = $dblib->getsql($tabs[$index] , $tablist[$tabs[$index]] , $pn ? $pn : 1);
				if($ret['total'] > $ret['less']){
					$last = $ret['total'] - $ret['less'];
					$url = core::url('db-export-tstr-%s-i-%d-pn-%d-vsize-%d' , $tstr, $index , ++$pn , $vsize);
					$this->showmsg("表 {$tabs[$index]} 已备份 {$ret['less']} , 剩余 {$last}" , $url ,1 ,1);
				}else{
					$url = core::url('db-export-tstr-%s-i-%d-pn-%d-vsize-%d' , $tstr, $index+1 , 1 , $vsize);
					$next = $tabs[$index+1];
					$this->showmsg("表 {$tabs[$index]} 备份完毕  , 开始备份 {$next} ... " , $url , 1 , 2);
				}
			}else{
				$ret = $dblib->vol($this->sobj->get('dir') , $vsize);
				$log = db_lib::log();
				array_unshift($log , $dblib->vol($this->sobj->get('dir') , $vsize));
				db_lib::log($log);
				$this->sobj->del('dir');
				$this->showmsg('数据备份全部完成了!' , core::url('db-backup') , 1 ,3);
			}
		}

	}

	/**
	 * 删除备份
	 *
	 */
	public function delAct(){
		$id = intval($this->get('id'));
		$log = db_lib::log();
		if(isset($log[$id])){
			$dir = DATA_PATH . $log[$id]['dir'];
			if(is_dir($dir)){
				core::removeDir($dir);
			}
			unset($log[$id]);
			sort($log);
			db_lib::log($log);
			$this->showmsg('删除成功!' , NULL , 1 , 3);
		}
		$this->showmsg('备份不存在!' , NULL , 1 , 3);
	}

	/**
	 * 下载备份
	 *
	 */
	public function downloadAct(){
		$id = intval($this->get('id'));
		$log = db_lib::log();
		if(isset($log[$id])){
			$file = DATA_PATH . $log[$id]['dir'] . '/data.sql';
			if(file_exists($file)){
				$this->redirect(DATA_URL . $log[$id]['dir'] . '/data.sql' , 0);
			}
		}
		$this->showmsg('备份不存在!' , NULL , 1 , 3);
	}

	/**
	 * 恢复页
	 *
	 */
	public function restoreAct(){
		if($this->conf['close'] != 1){
			$this->showmsg('为保证数据完整 , 请先暂时关闭站点!' , core::url('system-config') , 1 , 2);
		}
		$id = intval($this->get('id'));
		$log = db_lib::log();
		$seek = intval($this->get('seek'));
		$lines = 4000;
		if(isset($log[$id])){
			$file = DATA_PATH . $log[$id]['dir'] . '/data.sql';
			if(file_exists($file)){
				$dblib = new db_lib($this->conf['db']);
				$ret = $dblib->restore($file , $lines , $seek);
				if($ret['seek'] == $ret['fsize']){
					$this->showmsg('数据恢复成功 , 请开启站点!' , core::url('system-config') , 1 , 2);
				}else{
					$proc = sprintf('%.1f' , $ret['seek'] / $ret['fsize'] * 100);
					$this->showmsg("正在恢复数据 , 已完成 {$proc} % ,  请耐心等待 ..." , core::url('db-restore-id-%d-seek-%d' , $id , $ret['seek']) , 1 , 1);
				}
			}
		}
		$this->showmsg('备份不存在!' , NULL , 1 , 3);
	}
}
?>