<?php
class deny_mod extends admin_mod {
    
    public function listAct(){
        $obj  = OBJ('deny_tab');
        $pobj = new page_lib($obj->count() , 'pn' , intval($this->get('pn')) , 20);
        $obj->order("adate " . $pobj->desc)->limit($pobj->limit);
        $this->assign('list' , $pobj->rev ? array_reverse($obj->getall()) : $obj->getall());
        $this->assign('dctype' , config_lib::$dctype);
        $this->assign('atitle' , '防水墙');
        $this->display('misc/deny.list.html');
    }
    
    /**
     * 新增Deny记录
     *
     */
    public function addAct(){
        $ctype = intval($this->get('ctype'));
        $ip    = intval($this->get('ip'));
        if($ip > 0){
            $out = OBJ("deny_tab")->set("ip" , $ip)->set('adate' , REQUEST_TIME)->set("ctype" , $ctype)->replace();
            $this->ajaxout($out);
        }else{
            $this->ajaxout(array('code'=>1 , 'msg' => '该ip不可用'));
        }
    }
    
    public function delAct(){
        $ip = intval($this->get('ip'));
        $ctype = intval($this->get('ctype'));
        OBJ('deny_tab')->where("ip = $ip and ctype = $ctype ")->del();
        $this->redirect('deny-list');
    }
}
?>