<?php
/**
 * Mogvs 采集管理模块
 * @copyright reginx.com
 * $Id$
 */
class gather_mod extends admin_mod{

    /**
     * 采集列表
     */
    public function listAct(){
        $this->assign('atitle', '采集列表');
        $this->assign('list', core::getobj('gather_tab')->fields('id,name,lastdate,adate,nums')->order('id asc')->getall());
        $this->display('gather/list.html');
    }

    /**
     * 新增采集
     */
    public function addAct(){
        if($this->has('ga', 'P')){
            $obj = core::getobj('gather_tab');
            if($obj->load('ga')){
                $id = intval($obj->data['id']);
                $ret = $obj->save();
                if((int)$ret['code'] === 0){
                    $id = $id ? $id : intval($ret['msg']);
                    $this->redirect("gather-mod-id-{$id}");
                }
            }
        }
        $id = intval($this->get('id'));
        if($id > 0){
            $this->assign('ga', core::getobj('gather_tab')->where("id = $id ")->get());
        }
        $this->assign('atitle', '新增采集');
        $this->display('gather/add.html');
    }

    /**
     * 采集列表规则页
     */
    public function modAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            $this->assign('gac', gather_lib::$rule);
            $this->assign('ga', gather_lib::get($id));
            $this->display('gather/mod.html');
        }
        $this->showmsg('未指定的采集');
    }

    /**
     * 采集详情
     *
     */
    public function detailAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            if($this->has('desc', 'P')){
                $desc = gather_lib::format($this->get('desc', 'P'));
                $desc['vmap'] = gather_lib::vmap($desc['vmap']);
                $row = gather_lib::get($id);
                $desc = array_merge($row['desc'], $desc);
                core::getobj('gather_tab')->where("id = {$id}")->set("desc", base64_encode(serialize($desc)))->save();
            }
            $this->assign('gac', gather_lib::$detail);
            $this->assign('ga', gather_lib::get($id));
            $this->display('gather/detail.html');
        }
        $this->showmsg('未指定的采集');
    }

    /**
     * 预采集
     */
    public function testAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            if($this->has('desc', 'P')){
                $desc = gather_lib::format($this->get('desc', 'P'));
                $row = gather_lib::get($id);
                $desc = array_merge($row['desc'], $desc);
                core::getobj('gather_tab')->where("id = {$id}")->set("desc", base64_encode(serialize($desc)))->save();
                $this->showmsg('操作成功,下一步进行采集测试 .', core::url('gather-test-id-%d', $id), 1, 2);
            }
            $ga = gather_lib::get($id);
            $regex = gather_lib::regex($ga['desc']);
            $this->assign('ga', $ga);
            $this->assign('gac', gather_lib::$detail);
            $this->assign('vod', gather_lib::getvod($ga['desc']['burl'] . str_replace('#数字#', mt_rand(100, 300), $ga['desc']['pvurl']), $regex));
            $this->display('gather/test.html');
        }
        $this->showmsg('未指定的采集');
    }

    /**
     * 抓取
     */
    public function execAct(){
        $id = intval($this->get('id'));
        $ga = gather_lib::get($id);
        // 尝试300次采集....|||-_-
        if(intval($this->sobj->get('fail' . $id)) > 300){
            $this->sobj->set('fail' . $id, 0);
            $this->showmsg('多次采集失败 , 请稍候再试');
        }
        $vid = intval($ga['nums']) + 1;
        $regex = gather_lib::regex($ga['desc']);
        $url = $ga['desc']['burl'] . str_replace('#数字#', $vid, $ga['desc']['pvurl']);
        $res = gather_lib::getvod($url, $regex);
        core::getobj('gather_tab')->where("id = {$id}")->set("nums", $vid)->set('lastdate', REQUEST_TIME)->save();
        if($res['code'] == '200' && count($res) > 2){
            // 更新状态
            if($ga['desc']['srimg']){
                if(strpos($res['cover'] , 'http://') !== false){
                    $res['cover'] = gather_lib::srimg($res['cover']);
                }else{
                    $res['cover'] = gather_lib::srimg($ga['desc']['burl'] . $res['cover']);
                }
            }
            unset($res['code']);
            unset($res['ref']);
            $res['key']    = "{$res['name']},{$res['name']}全集,{$res['name']}百度影音,{$res['name']}在线播放";
            $res['desc']   = mb_substr(filter::text($res['info']), 0, 80, "utf-8");
            $res['sname']  = py_lib::get($res['name']);
            $res['cat']    = gather_lib::getcat($res['cat'], $ga['desc']['vmap']);
            $res['region'] = gather_lib::getregion($res['region'], $ga['desc']['rmap']);
            $res['status'] = gather_lib::getstatus($res['status']);
            $res['udate']  = empty($res['udate']) ? REQUEST_TIME : strtotime($res['udate']);
            $res['release'] = intval($res['release']);
            $res['hash'] = md5($res['name']);
            $res['adate'] = REQUEST_TIME;
            $obj = core::getobj('vod_tab');
            $row = $obj->fields('id')->where("hash = '{$res['hash']}'")->get();
            if(!empty($row)){
                $res['id'] = intval($row['id']);
                $tempurl = core::getobj('vod_url_tab')->where("vid = '{$res['id']}'")->order("uid asc ")->getall();
                if(!empty($tempurl)){
                    foreach ($tempurl as $v){
                        if(array_search($v['url'] , $res['vpurl']) === false){
                            array_unshift($res['vpurl'] , $v['url']);
                        }
                    }
                }
                $tempurl = null; unset($tempurl);
            }
            if(!empty($res['vpurl']) && $obj->load($res)){
                $act = $obj->data['actor']    = preg_replace('/(\.|\s|\-)+/i', '_', $obj->data['actor']);
                $dir = $obj->data['director'] = preg_replace('/(\.|\s|\-)+/i', '_', $obj->data['director']);
                $vid = intval($obj->data['id']);
                $obj->data['hash'] = md5($obj->data['name']);
                $ret = $obj->save();
                if((int)$ret['code'] === 0){
                    $vid = $vid ? $vid : intval($ret['msg']);
                    vod_lib::addurl($vid, gather_lib::getpurl($res['vpurl']));
                    $dir != '' && tag_lib::add(2, $vid, $dir);
                    $act != '' && tag_lib::add(3, $vid, $act);
                    $this->showmsg('[ <a href="' . core::url('@view-%s', $res['sname']) . '" target="_blank">' . $res['name'] . '</a> ] 入库成功. <br/> 请等待自动跳转... <br/>' . ' 若页面长时间未跳转, 请 <a href="javascript:location.href=location.href">点击此处刷新</a> .' . ' <br/> 若要停止采集 , 请<a href="' . core::url('gather-list') . '">点击此处停止</a>', core::url('gather-exec-id-%d', $id), 1, 3);
                }
                $this->sobj->set('fail' . $id, 0);
            }else{
                $this->showmsg('[ ' . $res['name'] . '] 入库失败 , 已跳过...', core::url('gather-exec-id-%d', $id), 1, 3);
            }
        }
        $this->sobj->set('fail' . $id, intval($this->sobj->get('fail' . $id)) + 1);
        $this->showmsg('拉取数据失败... http返回码 : '. $res['code'] . "<br/>Url : " . $url , core::url('gather-exec-id-%d', $id), 1, 3);
    }

    /**
     * 规则导出
     */
    public function exportAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            $row = core::getobj('gather_tab')->where("id = $id ")->get();
            $row['nums'] = 1;
            header('Content-Type: application/force-download');
            header("Content-Disposition: attachment; filename=Ga-{$id}.RGX");
            $out = base64_encode(serialize($row));
            echo (chunk_split(base64_encode(md5($out)) . $out));
        }
    }

    /**
     * 规则导入
     */
    public function importAct(){
        if($this->has('rule', 'P')){
            $rule = $this->get('rule', 'P');
            $hash = substr($rule, 0, strpos($rule, '='));
            $ga = preg_replace('/\s+/', '', substr($rule, strpos($rule, '=') + 1));
            $hash = base64_decode($hash);
            if(empty($ga) || empty($hash) || strlen($hash) != 32 || md5($ga) != $hash){
                $this->showmsg('格式错误', -1, 1, 1);
            }
            $ga = unserialize(base64_decode($ga));
            if(!empty($ga)){
                $ga['adate'] = REQUEST_TIME;
                $ga['id'] = 0;
                $gobj = core::getobj('gather_tab');
                if($gobj->load($ga)){
                    $gobj->save();
                    $this->showmsg('操作成功 ', core::url('gather-list'), 1, 1);
                }
            }
        }
        $this->assign('atitle', '导入规则');
        $this->display('gather/import.html');
    }


    /**
     * 删除
     */
    public function delAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            core::getobj('gather_tab')->where("id = $id ")->del();
            $this->showmsg('删除成功', null, 1, 1);
        }
    }
    /**
     * 删除
     */
    public function resetAct(){
        $id = intval($this->get('id'));
        if($id > 0){
            core::getobj('gather_tab')->where("id = $id ")->set('nums' , 1)->save();
            $this->showmsg('操作成功', null, 1, 1);
        }
    }
}
?>