<?php
/**
 * 插件管理模块
 * @copyright reginx.com
 * $Id$
 */
class plugin_mod extends admin_mod {

    public function __construct(&$param = array()){
        parent::__construct($param);
        if(!defined('PLUGIN_EXEC')){
            define('PLUGIN_EXEC' , 1);
        }
    }
    
    /**
     * 列表页
     *
     */
    public function listAct(){
        $this->assign('atitle' , '插件列表');
        $this->assign('pconf' , config_lib::$pctype);
        $this->assign('list' , plugin_lib::getdirs(OBJ('plugin_tab')->rkey('dir')->getall()));
        $this->display('plugin/list.html');
    }

    /**
     * 插件管理
     *
     */
    public function cpAct(){
        $this->nocache();
        $dir = $this->get('dir');
        if(!empty($dir) && preg_match('/^\w+$/i' , $dir)){
            if(!file_exists(DATA_PATH . $dir . '.lock')){
                $this->showmsg('该插件尚未安装' , -1  , 1 , 2);
            }
            PLU($dir)->cp();
        }
        $this->showmsg('操作失败 , 插件未指定!' , NULL , 1 , 2);
    }

    /**
     * 插件关闭
     *
     */
    public function statusAct(){
        $dir = $this->get('dir');
        if(!empty($dir) && preg_match('/^\w+$/i' , $dir)){
            if(!file_exists(DATA_PATH . $dir . '.lock')){
                $this->showmsg('该插件尚未安装' , -1  , 1 , 2);
            }
            $v = intval($this->get('v'));
            core::getobj('plugin_tab')->where("dir = '{$dir}'")->set("status" , $v)->save();
            $plu = core::getobj('plugin_tab')->where("dir = '{$dir}'")->set("status" , $v)->get();
            $pobj  = PLU($dir);
            $config =  config_lib::load();
            if($v === 1 && $plu['status'] && !empty($pobj->hook)){
                foreach ($pobj->hook as $k => $hk){
                    $config['hooks'][$k][$dir] = $hk;
                }
            }else if($v === 0 && !empty($pobj->hook)){
                foreach ($pobj->hook as $k => $hk){
                    unset($config['hooks'][$k][$dir]);
                }
            }
            config_lib::store($config , 'config.ini.php' , 0);
            $this->showmsg('操作成功!' , NULL , 1 , 2);
        }
        $this->showmsg('操作失败 , 插件未指定!' , NULL , 1 , 2);
    }

    /**
     * 插件配置
     *
     */
    public function confAct(){
        $this->nocache();
        $dir = $this->get('dir');
        if($this->has('conf' , 'P')){
            if(PLU($dir)->conf($this->get('conf' , 'P'))){
                $this->showmsg('操作成功' , core::url('plugin-list') , 1 , 1);
            }
        }
        if(!empty($dir) && preg_match('/^\w+$/i' , $dir) && file_exists(DATA_PATH . $dir . '.lock')){
            $plu = PLU($dir)->conf();
        }
        $this->showmsg('操作失败 , 插件未指定!' , NULL , 1 , 2);
    }

    /**
     * 插件卸载
     *
     */
    public function uninstallAct(){
        $dir = $this->get('dir');
        if(!empty($dir) && preg_match('/^\w+$/i' , $dir)){
            if(!file_exists(DATA_PATH . $dir . '.lock')){
                $this->showmsg('该插件尚未安装' , -1  , 1 , 2);
            }
            $plu = PLU($dir);
            if($plu->uninstall()){
                OBJ('plugin_tab')->where("dir = '{$dir}'")->del();
                $config =  config_lib::load();
                if(!empty($config['hooks'])){
                    foreach ($config['hooks'] as $k => &$v){
                        if(isset($v[$dir])){
                            unset($v[$dir]);
                        }
                        if(empty($v)){
                            unset($config['hooks'][$k]);
                        }
                    }
                    config_lib::store($config , 'config.ini.php' , 0);
                }
                $this->showmsg('卸载成功!' , NULL , 1 , 2);
            }
            $this->showmsg('卸载失败了!' , NULL , 1 , 2);
        }
        $this->showmsg('操作失败 , 插件未指定!' , NULL , 1 , 2);
    }

    /**
     * 插件安装
     *
     */
    public function installAct(){
        $dir = $this->get('dir');
        if(!empty($dir) && preg_match('/^\w+$/i' , $dir)){
            if(file_exists(DATA_PATH . $dir . '.lock')){
                $this->showmsg('该插件已经安装过了' , -1  , 1 , 2);
            }
            $plu = PLU($dir);
            if($plu->install()){
                $obj = OBJ('plugin_tab');
                $obj->set("name"   , empty($plu->name) ? $dir : $plu->name)
                ->set("dir"    , $dir)->set('adate' , REQUEST_TIME)->set('status' , 0)
                ->set("ver"    , empty($plu->info['ver'])  ? 'v1.0' : $plu->info['ver'])
                ->set("conf"   , (isset($plu->info['conf']) && intval($plu->info['conf']))  ? 1 : 0 )
                ->set("supurl" , empty($plu->info['supurl']) ? 'http://www.reginx.com' : $plu->info['supurl'])
                ->set("author" , empty($plu->info['author']) ? 'ReGinX' : $plu->info['author'])
                ->set("ctype"  , intval($plu->ctype))
                ->set("extra"  , base64_encode(serialize(empty($plu->conf) ? array() : $plu->conf)))
                ->replace();
                $this->showmsg('安装成功!' , NULL , 1 , 2);
            }
            $this->showmsg('安装失败了!' , NULL , 1 , 2);
        }
        $this->showmsg('操作失败 , 插件未指定!' , NULL , 1 , 2);
    }

    /**
     * 在线插件中心
     *
     */
    public function storeAct(){
        $this->showmsg('暂未开放 , 敬请期待 ...');
    }
}
?>