<?php
class reply_mod extends admin_mod{

    /**
     * 默认列表页
     *
     */
    public function listAct(){
        $ctype = intval($this->get('ctype'));
        $obj = OBJ('reply_tab');
        $tab = ($ctype == 1 ? 'art_tab' : 'vod_tab');
        $obj->where("ctype = $ctype");
        $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($this->get('pn')) , 12);
        $obj->clear('fields')->fields('nick,id,ctype,adate,status,desc,vid,ip,' .$tab . '.name as refname,sname' );
        $obj->leftjoin($tab, 'vid' , 'id');
        $obj->order('id ' . ($pobj->rev ? 'asc' : 'desc'))->limit($pobj->limit);
        $this->assign('pobj' , $pobj->toarray());
        $this->assign('list' , $pobj->rev ? array_reverse($obj->getall()) : $obj->getall());
        $this->assign('atitle' , $ctype == 1 ? '资讯评论' : '影片评论');
        $this->assign('mod'    , $ctype == 1 ? 'art' : 'view');
        $this->display('vod/reply.list.html');
    }
    
    
    public function delAct(){
        $id = intval($this->get('id'));
        if($this->has('del' , 'P')){
            $ids = $this->get('del' , 'P');
            foreach ($ids as $v){
                $vid = intval($v);
            }
            $id = join(',' , $ids);
        }
        if(!empty($id)){
            OBJ('reply_tab')->where("ctype = 2 and id in ({$id})")->del();
        }
        $this->showmsg('操作成功' , NULL , 1 , 2);
    }
    
    
    public function recAct(){
        $id = intval($this->get('id'));
        $v  = intval($this->get('v'));
        if($this->has('del' , 'P')){
            $ids = $this->get('del' , 'P');
            array_map('intval' , $ids);
            if(!empty($ids)){
                OBJ('reply_tab')->set("status" , $v)->where("id in(" . join(',' , $ids) . ")")->save();
            }
        }
        if($id > 0){
            OBJ('reply_tab')->set("status" , $v)->where("id = $id ")->save();
        }
        $this->showmsg('操作成功' , NULL , 1 , 2);
    }
    

    /**
	 * 删除拉取失败的记录.
	 *
	 */
    public function dbfixAct(){
        if($this->conf['close'] != 1){
            //$this->showmsg('请先暂时关闭站点 , 再进行评论采集!' , core::url('system-config') , 1 , 2);
        }
        core::getobj('temp_tab')->where("v = '0' and k like 'reply_%'")->del();
        $this->redirect('reply-db-start-1');
    }

    public function dbexecAct(){
        if($this->conf['close'] != 1){
            //$this->showmsg('请先暂时关闭站点 , 再进行评论采集!' , core::url('system-config') , 1 , 2);
        }
        $obj = core::getobj('temp_tab');
        $row = $obj->where("v != '0' and k like 'reply_%'")->get();
        if(!empty($row)){
            $ret = reply_lib::get($row);
            if(intval($ret['code']) === 0){
                $obj->where("k = '{$row['k']}'")->del();
                $this->showmsg('抓取评论成功 , 剩余 '
                .  $obj->where("v != '0' and k like 'reply_%'")->count() . ' 条'
                . ' <br/> 请等待自动跳转... <br/>' . ' 若页面长时间未跳转, 请 <a href="javascript:location.href=location.href">点击此处刷新</a> .'
                . ' <br/> 若要停止评论采集 , 请<a href="' . core::url('reply-db') . '">点击此处停止</a>'  , core::url('reply-dbexec') , 1 ,2);
            }else{
                $obj->where("k = '{$row['k']}'")->del();
                $this->showmsg("拉取失败了 &nbsp; <a href='{$ret['msg']}'>点击查看目标地址</a>  , 继续下一条 ...", core::url('reply-dbexec'), 1, 2);
            }
        }
        $this->showmsg('影片评论数据采集完毕...' , core::url('reply-db') , 1 , 3);
    }

    /**
	 * 评论采集
	 *
	 */
    public function dbAct(){
        if($this->has('start')){
            if($this->conf['close'] != 1){
                //$this->showmsg('请先暂时关闭站点 , 再进行评论采集!' , core::url('system-config') , 1 , 2);
            }
            core::getobj('vod_tab')->where("not exists(select 1 from reply_tab where reply_tab.vid = vod_tab.id)");
            core::getobj('vod_tab')->where("not exists(select 1 from temp_tab where temp_tab.k = CONCAT('reply_' ,vod_tab.id))");
            $total = core::getobj('vod_tab')->keep()->count();
            $vod   = core::getobj('vod_tab')->clear("fields")->fields("id,sname,name")->order("id asc")->get();
            if(empty($vod)){
                $this->showmsg('预处理影片评论数据完毕' , core::url('reply-db') , 1 , 3);
            }
            $ret = reply_lib::loadurl($vod['id'] , $vod['name']);
            if(intval($ret['code']) === 0){
                $this->showmsg('[ <a href="' . core::url('@view-%s', $vod['sname']) . '" target="_blank">' . $vod['name']
                . '</a> ] 处理完成. 剩余 '
                . $total
                . ' <br/> 请等待自动跳转... <br/>' . ' 若页面长时间未跳转, 请 <a href="javascript:location.href=location.href">点击此处刷新</a> .'
                . ' <br/> 若要停止评论采集 , 请<a href="' . core::url('reply-db') . '">点击此处停止</a>', core::url('reply-db-start-1'), 1, 2);

            }else{
                $this->showmsg('[ <a href="' . core::url('@view-%s', $vod['sname']) . '" target="_blank">' . $vod['name']
                . '</a> ]'
                . "&nbsp; <a href='{$ret['msg']}'>点击查看目标地址</a>"
                .'处理失败了... 剩余 '
                . $total, core::url('reply-db-start-1'), 1, 2);
            }

        }
        $this->assign('unrepurl'  , core::getobj('temp_tab')->where(" v = '0' and k like 'reply_%'")->count());
        $this->assign('repurl' , core::getobj('temp_tab')->where(" v != '0' and k like 'reply_%'")->count());
        $this->assign('replys' , core::getobj('vod_tab')->where("exists(select 1 from reply_tab where reply_tab.vid = vod_tab.id)")->count());
        $this->assign('atitle' , '为影片采集豆瓣评论');
        $this->display('vod/reply.db.html');
    }

}
?>