<?php
/**
 * 系统管理模块
 * @copyright reginx.com
 * $Id: system.mod.php 7 2013-01-24 00:30:29Z reginx $
 */
class system_mod extends admin_mod {

    /**
     * 系统信息
     *
     */
    public function infoAct(){
        $this->assign('atitle' , '系统信息');
        $this->display('system/info.html');
    }

    /**
     * 注销登录
     *
     */
    public function logoutAct(){
        $this->sobj->remove();
        $this->redirect('login');
    }

    /**
     * iframe上传方式
     *
     */
    function uploadAct(){
        $this->nocache();
        $cb = $this->get('cb');
        $tw = intval($this->get('tw'));
        $th = intval($this->get('th'));
        if(!empty($_FILES)){
            $up  = new upload_lib('jpg|png|gif|jpeg|zip|rar',NUll,'8m');
            $tmp = $up->getFile();
            if($tmp){
                $tmp = array_shift($tmp);
                if($tmp['error'] === 0 || $tmp['error'] == '0'){
                    if($tmp['isimage']){
                        $tw = intval($this->get('tw' , 'P'));
                        $th = intval($this->get('th' , 'P'));
                        $tw = $tw ? $tw : $this->conf['thumb_width'];
                        $th = $th ? $th : $this->conf['thumb_height'];
                        image_lib::thumb($tmp['savePath'].$tmp['saveName'] , 'auto' , $tw , $th);
                        if($this->has('water' , 'P')){
                            image_lib::water($tmp['savePath'].$tmp['saveName'] , $this->conf['data_path'] . 'images/water.png','auto',3);
                        }
                    }
                    $this->assign('error','<span style="color:blue">操作成功!</span>');
                    $this->assign('ret',json_encode(array('url'=>$tmp['saveName'])));
                }else{
                    $this->assign('error',$tmp['error']);
                }
            }else{
                $this->assign('error',$tmp['error']);
            }
        }
        $this->assign('tw' , $tw);
        $this->assign('th' , $th);
        $this->assign('water' , (int)$this->get('water'));
        $this->assign('cb',$cb);
        $this->display('common/upload_' . intval($this->get('ctype')) . '.html');
    }

    /**
     * 管理帐号列表
     *
     */
    public function adminAct(){
        $this->assign('atitle' , '帐号密码');
        if($this->has('admin' , 'P')){
            $adm = $this->get('admin' , 'P');
            if(md5($adm['passwd']) != $this->login['passwd']){
                $this->showmsg('当前密码错误!' , -1 , 1 ,1);
            }
            if($adm['passwd1'] != $adm['passwd2'] || $adm['passwd1'] == ''){
                $this->showmsg('两次密码不一致!' , -1 , 1 ,1);
            }
            if(strlen($adm['passwd1']) < 8){
                $this->showmsg('密码长度请勿小于8' , -1 , 1 ,1);
            }
            $adm['passwd'] = md5($adm['passwd1']);
            $adm['id']  = $this->login['id'];
            $adm['uname'] = $this->login['uname'];
            if(!core::getobj('admin_tab')->load($adm)){
                $this->showmsg(core::getobj('admin_tab')->geterr() , -1 , 1 ,1);
            }
            $ret = core::getobj('admin_tab')->save();
            if((int)$ret['code'] === 0){
                $this->showmsg('操作成功!' , core::url('system-logout') , 1 ,1);
            }
        }
        $this->display('system/admin.html');
    }

    /**
     * 系统配置页
     *
     */
    public function confAct(){
        if($this->has('misc' , 'P')){
            $data = $this->get('misc' , 'P');
            array_walk($data , array('filter' , 'normal'));
            $obj = core::getobj('misc_tab');
            $obj->set('c' , 0)->set('k' , 'conf')->set('v' , base64_encode(serialize($data)))->replace();
            $this->showmsg('操作成功' , null , 1 , 1);
        }
        $this->assign('misc' , misc_lib::get('conf' , 0));
        $this->assign('atitle' , '站点配置');
        $this->display('system/conf.html');
    }


    /**
     * 缓存管理
     *
     */
    public function cacheAct(){
        if($this->has('ctype' , 'P')){
            $list = $this->get('ctype' , 'P');
            $list = array_map('intval' , $list);
            foreach ($list as $v){
                if(intval($v) === 1){
                    $GLOBALS['_CACHE']->clear();
                }
                if(intval($v) === 2){
                    core::cleartpl();
                }
                if(intval($v) === 3){
                    core::clearrunfile();
                }
                if(intval($v) === 4){
                    block::rebuild();
                }
            }
            $this->showmsg('操作成功' , null , 1 , 1);
        }
        $this->assign('atitle' , '更新缓存');
        $this->display('system/cache.html');
    }

    /**
     * 中文转换拼音 Ajax 接口
     *
     */
    public function getpyAct(){
        $this->nocache();
        $this->ajaxout(py_lib::get($this->get('cn' , 'P')) , 'text');
    }

    /**
     * 配置管理
     *
     */
    public function configAct(){
        $this->nocache();
        if($this->has('config' , 'P')){
            $config = $this->get('config' , 'P');
            if(!empty($config)){
                if(!empty($config['search'])){
                    $tmp = explode(',' , $config['search']);
                    $config['search'] = array();
                    foreach ((array)$tmp  as $v){
                        $v = trim($v);
                        if(preg_match('/\w{3,6}\-.+/i' , $v)){
                            $config['search'][] = explode('-' , $v);
                        }
                    }
                }
                config_lib::store($config);
            }
            $this->showmsg('操作成功!' , NULL , 1 , 3);
        }
        $this->assign('conf' , config_lib::load());
        $this->assign('atitle' , '系统配置');
        $this->display('system/config.html');
    }

    public function clearAct(){
        $cnt = core::getobj('temp_tab')->where("k like 'rmimg_%'")->count();
        $this->assign('cnt' , $cnt);
        if($this->has('rmimg' , 'P') || $this->has('rmimg')){
            $list = core::getobj('temp_tab')->rkey('k')->where("k like 'rmimg_%'")->limit(50)->getall();
            if(!empty($list)){
                foreach ($list as $v){
                    if(is_file(UPLOAD_PATH . $v['v'])){
                        unlink(UPLOAD_PATH . $v['v']);
                    }
                    // 删除缩略
                    if(is_file(UPLOAD_PATH . core::thumburl($v['v']))){
                        unlink(UPLOAD_PATH . core::thumburl($v['v']));
                    }
                }
                $kstr = join("','" , array_keys($list));
                core::getobj('temp_tab')->where("k in ('$kstr')")->del();
                $cnt = $cnt - 50;
                $cnt = $cnt > 0 ? $cnt : 0;
                if($cnt - 50 > 0){
                    $this->showmsg('成功删除了 50 张图片 , 剩余 ' . $cnt . " ..." , core::url('system-clear-rmimg-1') , 1 , 1);
                }else{
                    $this->assign('cnt' , $cnt);
                }
            }
        }
        $this->assign('atitle' , '附件清理');
        $this->display('system/clear.html');
    }
}
?>