<?php
/**
 * 标签管理模块
 * @copyright reginx.com
 * $Id$
 */
class tag_mod extends admin_mod {

    /**
     * Tag 类型
     *
     * @var unknown_type
     */
    private $ctype = 0;


    /**
     * 架构函数
     *
     * @param unknown_type $param
     */
    public function __construct(&$param){
        parent::__construct($param);
        $this->ctype = intval($this->get('ctype' , 'R'));
        $this->cattype = config_lib::$ttype;
        $this->assign('ctype' , $this->ctype);
    }

    /**
     * Tag列表
     *
     */
    public function listAct(){
        $py  = $this->get('py');
        $obj = core::getobj('tag_tab')->where('ctype = ' .$this->ctype);
        if(!empty($py)){
            $this->assign('py' , $py);
            $py = strtolower($py);
            $obj->where("pyh = '{$py}'");
        }
        $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($this->get('pn')) , 10);
        $this->assign('atitle' , config_lib::$ttype[$this->ctype]);
        $this->assign('pobj' , $pobj->toarray());
        $obj->clear('fields')->limit($pobj->limit)->order("id " . ($pobj->rev ? 'asc' : 'desc'));
        $this->assign('list'   , $pobj->rev ? array_reverse($obj->getall()) : $obj->getall());
        $this->display('tag/list.html');
    }

    /**
     * Tag 更新
     *
     */
    public function saveAct(){
        $obj = core::getobj('tag_tab');
        $id  = intval($this->get('id' , 'P'));
        $name = filter::text($this->get('name' , 'P'));
        if(!empty($name) || $name != ''){
            if($id === 0 && $obj->where("name = '{$name}'")->count() > 0){
                $this->ajaxout(array('code' => 1 , 'msg' => '该标签已经存在了'));
            }
            $py = py_lib::get($name , '');
            $obj->set('id' , $id)->set('name' , $name)->set('sname' , $py)->set('pyh' , substr($py , 0 , 1));
            $obj->set('ctype' , $this->ctype)->save();
            $this->ajaxout(array('code' => 0 , 'msg' => '成功'));
        }
        $this->ajaxout(array('code' => 1 , 'msg' => '名称不能为空'));
    }


    /**
     * Tag 删除
     *
     */
    public function delAct(){
        $id = intval($this->get('id'));
        core::getobj('tag_tab')->where("id = {$id}")->del();
        $this->showmsg('操作成功' , null , 1 , 1);
    }

    /**
     * 获取tag
     *
     */
    public function getAct(){
        $code = $this->has('code') ? strtolower($this->get('code' , 'R')) : 'A';
        $obj = core::getobj('tag_tab');
        $this->assign('cb' , $this->get('cb' , 'R'));
        $this->assign('ctype' , $this->ctype);
        $this->assign('code' , strtoupper($code));
        $this->assign('tags' , $obj->where("ctype = {$this->ctype} and pyh = '{$code}'")->order("sort desc")->getall());
        $this->display('tag/get.html');
    }

    /**
     * Tag详细介绍页
     *
     */
    public function infoAct(){
        $id = intval($this->get('id'));
        if($this->has('info' , 'P')){
            $iobj = OBJ('dainfo_tab');
            if($iobj->load('info')){
                $ret = $iobj->replace();
                if((int)$ret['code'] === 0){
                    $this->showmsg('操作成功' , null , 1 , 1);
                }
            }
            $this->show404($iobj->geterr() , -1 , 1 , 2);
        }
        if($id > 0){
            $tag  = OBJ('tag_tab')->where("id = $id ")->get();
            $info = OBJ('dainfo_tab')->where("tagid = $id ")->get();
            $this->assign('info' , OBJ('dainfo_tab')->where("tagid = $id ")->get());
            $this->assign('tag'  , $tag);
            $this->assign('atitle' , '[ ' .$tag['name'] . ' ] 简介');
            $this->display('tag/info.html');
        }
        $this->showmsg('未指定的标签!');
    }

}
?>