<?php
/**
 * 视频管理模块
 * @copyright reginx.com
 * $Id$
 */
class vod_mod extends admin_mod {

    /**
     * 视频搜索
     *
     */
    public function searchAct(){
        $name = $this->get('name' , 'P');
        if(!empty($name)){

        }else{
            $this->assign('atitle'  , '影视搜索');
        }
        $this->display('vod/search.html');
    }
    
    public function rankAct(){
        $obj = OBJ('vod_tab');
        if(!$this->get('ctype')){
            $this->assign('list' , $obj->fields('id,name,sname,views,adate,udate,plays,reply')->order('plays desc')->limit(20)->getall());
            $this->assign('active' , array(0=>'active'));
        }else{
            $this->assign('list' , $obj->fields('id,name,sname,views,adate,udate,plays,reply')->order('reply desc')->limit(20)->getall());
            $this->assign('active' , array(1=>'active'));
        }
        $this->assign('atitle' , '影片排行');
        $this->display('vod/rank.html');
    }

    /**
     * 新增视频
     *
     */
    public function addAct(){
        $this->assign('player' , config_lib::$player);
        $clist = core::getobj('cat_tab')->getslist( 0 , 2);
        $this->assign('thumb'  , array($this->conf['thumb_width'] , $this->conf['thumb_height']));
        $this->assign('clist'  , $clist);
        $this->assign('rlist'  , config_lib::$region);
        $id  = intval($this->get('id'));
        if($id > 0){
            $vod = core::getobj('vod_tab')->where("id = $id ")->get();
            $this->assign('vod' , $vod);
            $this->assign('url' , core::getobj('vod_url_tab')->where("vid = $id ")->order("uid asc")->getall());
        }
        $this->assign('vs' , config_lib::$vstatus);
        $this->assign('vlang' , config_lib::$vlang);
        $this->assign('player' , config_lib::$player);
        $this->assign('atitle' , '新增影视');
        $this->assign('tpls' , vod_lib::gettpl(0));
        $this->display('vod/add.html');
    }

    /**
     * 影视列表页
     *
     */
    public function listAct(){
        $obj = core::getobj('vod_tab');
        if($this->has('py')){
            $py = strtolower($this->get('py'));
            if(preg_match('/^[a-z]$/' , $py)){
                $obj->where("sname like '{$py}%'");
            }
            $this->assign('py' , $py);
        }
        if($this->has('name')){
            $str = urldecode($this->get('name'));
            $ie = strtolower(mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $str)) != 'utf-8';
            if($ie){
                $str = mb_convert_encoding($str, 'utf-8', mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $str));
            }
            $name = filter::ult($str);
            if(!empty($name)){
                $obj->where("name like '%{$name}%'");
            }
            $this->assign('name' , $name);
        }
        $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($this->get('pn' , 'R')) , 10);
        $obj->clear('fields')->fields("id,name,reply,udate,status,sname,rec,plays,cat,cat_tab.name as catname");
        $obj->order("id " . $pobj->desc)->leftjoin('cat_tab' , 'cat' , 'id')->limit($pobj->limit);
        $this->assign('vstatus' , config_lib::$vstatus);
        $this->assign('list' , $pobj->rev ? array_reverse($obj->getall()) : $obj->getall());
        $this->assign('atitle' , '影视列表');
        $this->assign('pobj' , $pobj->toarray());
        $this->display('vod/list.html');
    }

    /**
     * 保存
     *
     */
    public function saveAct(){
        $obj = core::getobj('vod_tab');
        if($obj->load('vod')){
            $obj->data['basename'] = empty($obj->data['basename']) ? vod_lib::getbasename($obj->data['name'])  : $obj->data['basename'];
            $act = $obj->data['actor']    = vod_lib::gettag($obj->data['actor']);
            $dir = $obj->data['director'] = vod_lib::gettag($obj->data['director']);
            $tag = $obj->data['basename'];
            $vid = $obj->data['id'];
            $obj->data['hash'] = vod_lib::gethash($obj->data['name']);
            $ret = $obj->save();
            if((int)$ret['code'] === 0){
                $vid = $vid ? $vid : intval($ret['msg']);
                vod_lib::addurl($vid , $this->get('url' , 'P'));
                $dir != '' && tag_lib::add(2 , $vid , $dir);
                $act != '' && tag_lib::add(3 , $vid , $act);
                $tag != '' && tag_lib::add(4 , $vid , $tag);
                $this->showmsg('操作成功' , NULL , 1 , 2);
            }
        }
        $this->showmsg($obj->geterr() , -1 , 1 , 2);
    }

    public function delAct(){
        $id = intval($this->get('id'));
        if($this->has('del' , 'P')){
            $ids = $this->get('del' , 'P');
            foreach ($ids as $v){
                $vid = intval($v);
                if($vid > 0){
                    vod_lib::del($vid);
                }
            }
        }
        if($id > 0){
            vod_lib::del($id);
        }
        $this->showmsg('操作成功' , NULL , 1 , 2);
    }
    
    
    public function recAct(){
        $id = intval($this->get('id'));
        $v  = intval($this->get('v'));
        if($this->has('del' , 'P')){
            $ids = $this->get('del' , 'P');
            array_map('intval' , $ids);
            if(!empty($ids)){
                OBJ('vod_tab')->set("rec" , $v)->where("id in(" . join(',' , $ids) . ")")->save();
            }
        }
        if($id > 0){
            OBJ('vod_tab')->set("rec" , $v)->where("id = $id ")->save();
        }
        $this->showmsg('操作成功' , NULL , 1 , 2);
    }

    /**
     * 播放地址批量新增mini页面
     *
     */
    public function urlAct(){
        $this->assign('player' , config_lib::$player);
        $this->display('vod/url.html');
    }

    /**
     * 杂项信息编辑mini页面
     *
     */
    public function miscAct(){
        $this->display('vod/misc.html');
    }

    /**
     * 演职员信息
     *
     */
    public function actorAct(){
        $this->assign('vs' , config_lib::$vstatus);
        $this->assign('vlang' , config_lib::$vlang);
        $this->display('vod/act.html');
    }
}
?>