// - 获取操作符号
function getop(str){
    var ops = { 'gt' : '<' ,'ge' : '<=' ,'lt' : '>' ,'le' : '>=' ,'eq' : '=' ,'ne' : '!=' ,'in' : 'in' };
    for(var i in ops){
        if(i == str){
            return ops[i];
        }
    }
}

$(function(){

    // - select onchange
    $('#bctype').bind('change' , function(){
        if($(this).val() != ''){
            $('#whereul').val('OBJ("' + $(this).val() + '")');
            $('#fields').load($(this).attr('ajaxurl') + $(this).val());
        }
    });

    // - where btn click
    $('#wherebtn').live('click' , function(){
        if($('#val').val() == ''){
            alert('请输入条件取值');
        }else{
            var op   = getop($('#opctype').val());
            var key  = $('#field').val() + ' ' + op;
            if(op == 'in'){
                key += ' (\'' + $('#val').val() + '\') ';
            }else{
                key += ' \'' + $('#val').val() + '\'';
            }
            $('#whereul').val($('#whereul').val() + "\n->where" + '(" ' + key + ' ")');
        }
    });

    // - limit btn click
    $('#limitbtn').live('click' , function(){
        var v = $.trim($('#limit').val());
        if(v.match(/\d+(\s*\,\s*\d+)?/)){
            var val = $('#whereul').val().replace(/\s*\-\>limit\(\"\d+(\s*\,\s*\d+)?\"\)/ , '') + "\n->limit(\"" + v + "\")";
            $('#whereul').val(val);
        }else{
            alert('格式错误!');
        }
    });

    // - field btn click
    $('#fieldbtn').live('click' , function(){
        var fds = [];
        $('#flist option:selected').each(function(){
            fds.push($.trim($(this).val()));
        });
        if(fds.length < 1){
            alert('请至少选择一项');
        }else{
            var val = $('#whereul').val().replace(/\s*\-\>fields\(\".+?\"\)/ , '') + "\n->fields(\"" + fds.join(',') + "\")";
            $('#whereul').val(val);
        }
    });

    // - order btn click
    $('#orderbtn').live('click' , function(){
        var v = $.trim($('#order').val());
        if(v != ''){
            var val = $('#whereul').val().replace(/\s*\-\>order\(\".+?\"\)/ , '') + "\n->order(\"" + v + "\")";
            $('#whereul').val(val);
        }else{
            alert('格式错误!');
        }
    });
    
});
