/*
 * jQuery Reginx slider
 * http://www.reginx.com
 *
    <div class="container">
        <div id="slides">
            <a href="#" title="第一个图片的说明"><img src="example-slide-1.jpg" width="720" height="360" border="0"/></a>
            <a href="#" title="第二个图片的说明"><img src="example-slide-2.jpg" width="720" height="360" border="0"/></a>
        </div>
    </div>
    $('#slides').rsli();
 */
;(function(){
    $.fn.rsli = function(opts){

        // config
        opts = jQuery.extend({
            'speed'     : 3500,
            'autoplay'  : true,
            'desc'      : true,
            'sfontsize' : '20px'
        },opts);
        
        // this
        _this = $(this);
        _this._int    = 0;
        _this._index  = 0;
        _this._imgs   = _this.find('img');
        _this._width  = _this.find('img:eq(0)').width();
        _this._height = _this.find('img:eq(0)').height();
        _this._animating = false;

        // add class
        if(!_this.hasClass('rsli-sliders')){

            _this.parent().css({
                'width'     : _this._width  + 'px',
                'height'    : _this._height + 'px',
                'overflow'  : 'hidden'
            });

            _this.addClass('rsli-sliders');

            _this.css({
                'width'     : _this._width  + 'px',
                'height'    : _this._height + 'px',
                'position'  : 'relative',
                'z-index'   : 90
            });

            _this._imgs.css({
                'display'           : 'none',
                'vertical-align'    : 'middle',
                'z-index'           : 90,
                'position'          : 'absolute'
            });

             _this._imgs.eq(0).fadeIn();
            
            // 是否显示描述
            if(opts.desc){
                _this.append('<div class="rsli-div-desc"><h1></h1></div>');

                _this._divdesc = $('.rsli-div-desc');

                _this._divdesc.css({
                    'display'   : 'none',
                    'opacity'   : .7,
                    'padding'   : '5px 0 0 10px',
                    'bottom'    : 0,
                    'position'  : 'absolute',
                    'list-style': 'none',
                    'width'     : _this._width - 10,
                    'z-index'   : 100,
                    'height'    : 48,
                    'left'      : 0,
                    'color'     : '#f9f9f9',
                    'background-color'  : '#111'
                });
                _this._divdesc.find('h1').css({
                    'position'  : 'absolute',
                    'z-index'   : 101,
                    'font-size' : opts.sfontsize
                }).html(_this.find('a:eq(0)').attr('title'));
                _this._divdesc.slideDown();
            }

            _this.append('<ul class="rsli-ul-nav"></ul>');

            _this._navul = $('.rsli-ul-nav');
            
            var appendhtml = '';

            for(var i = 1 ; i <= _this._imgs.length ; i++){
                appendhtml += '<li class="rsli-li-nav" title="查看第 '+ i +' 张">' + i + '</li>';
            }

            _this._navul.append(appendhtml); appendhtml = '';
            
            _this._navli = $('.rsli-li-nav');

            if($.browser.msie && $.browser.version == '7.0'){
                _this._navul.css({
                    'margin'    : 0,
                    'padding'   : '0 0 5px 10px',
                    'bottom'    : 5,
                    'position'  : 'absolute',
                    'list-style': 'none',
                    'right'     : 10,
                    'z-index'   : 101,
                    'display'   : 'none'
                });
            }else{
                _this._navul.css({
                    'margin'    : 0,
                    'padding'   : '0 0 5px 10px',
                    'bottom'    : 1,
                    'position'  : 'absolute',
                    'list-style': 'none',
                    'right'     : 10,
                    'z-index'   : 101,
                    'display'   : 'none'
                });
            }

            _this._navli.css({
                'display'   : 'block',
                'float'     : 'left',
                'color'     : '#f0f0f0',
                'cursor'    : 'pointer',
                'width'     : 14,
                'height'    : 6,
                'margin'    : 3,
                'over-flow' : 'hidden',
                'text-align': 'center',
                'font-size' : '12px',
                'line-height' : 'normal',
                'text-indent' : -9999,
                'background-color' : '#777'
            });

            _this._navli.eq(0).addClass('rsli-li-active').css({
                'background-color' : '#f0f0f0'
            });
            _this._navul.fadeIn('slow');
        }// init end
        
        _this._navli.hover(
            function(){
                $(this).css({
                    'background-color' : '#f0f0f0'
                });
            },
            function(){
                if(!$(this).hasClass('rsli-li-active')){
                    $(this).css({
                        'background-color' : '#999'
                    });
                }
            }
        );

        _this._navli.on('click' , function(){
            var next = $(this).index();
            var _thisli = $(this);
            if(_this._index != next && !_this._animating ){
                _this._animating = true;
                if(opts.desc){
                    _this._divdesc.hide();
                    _this._divdesc.find('h1').html(_this.find('a:eq(' + next + ')').attr('title'));
                    _this._divdesc.slideDown();
                }
                _this._navli.eq(_this._index).removeClass('rsli-li-active').css({
                    'background-color' : '#999'
                });
                $(this).addClass('rsli-li-active').css({
                    'background-color' : '#f0f0f0'
                });
                _this._imgs.eq(next).css({
                    'display'   : 'block',
                    'opacity'   : .7 , 
                    'z-index'   : 89
                });
                _this._imgs.eq(_this._index).stop().fadeOut(400 , function(){
                    _this._imgs.eq(next).fadeTo(200 , 1 , function(){
                        _this._index = next;
                        _this._imgs.eq(next).css({
                            'z-index'   : 90
                        });
                        _this._animating = false;
                        _this.autoplay();
                    })
                });
            }
        });

        _this.autoplay = function(){
            if(_this._int > 0){
                clearInterval(_this._int);
            }
            _this._int = setInterval(function(){
                var i = _this._index;
                if(i < _this._imgs.length - 1){
                    _this._navli.eq(i+1).trigger('click');
                }else{
                    _this._navli.eq(0).trigger('click');
                }
            } , opts.speed);
        }

        // auto play
        if(opts.autoplay){
            _this.autoplay();
        }
    }
})(jQuery);