<?php
/**
 * 演职员信息采集
 * @copyright reginx.com
 * $Id$
 */
class daga_plu extends plugin{

    /**
     * 插件名称
     *
     * @var unknown_type
     */
    public $name = '演职员信息抓取';

    /**
     * 插件类型 (HOOK位置)
     *
     * @var unknown_type
     */
    public $ctype = 1;

    /**
     * 注册钩子
     *
     * @var unknown_type
     */
    public $hook = array();

    /**
     * 插件配置信息
     *
     * @var unknown_type
     */
    public $info = array(
        'author'    => 'ReGinX',
        'supurl'    => 'http://www.reginx.com',
        'ver'       => '1.0',
        'conf'      => 1
    );


    public function conf($data = array()){
        $this->chkinstall();
        if(defined('PLUGIN_EXEC')){
            if(empty($data)){
                $this->mod->assign("da" , $this->get(1));
                $this->mod->assign('atitle' , '演职员信息采集设置');
                $this->mod->display('plugin@daga:admin/conf.html');
            }else{
                return $this->sconf($data);
            }
        }
        $this->mod->showmsg('尚未安装!');
    }

    /**
     * 播放
     *
     */
    public function show(){
        if(defined('PLUGIN_EXEC')){
            $param = func_get_args();
            $this->mod->assign('vod' , $param[0]);
            $this->mod->assign('ads' , $param[1]);
            echo($this->mod->fetchtpl('player.html' , false));
        }
    }

    /**
     * 管理
     *
     * @param unknown_type $exec
     */
    public function cp(){
        if(defined('PLUGIN_EXEC')){
            // - 验证
            if(intval($this->mod->get('doverify')) > 0){
                $url  = "http://verify.baidu.com/verify?url=";
                $url .= urlencode($this->mod->get('url' , 'P')) . "&vcode=";
                $url .= $this->mod->get('vcode' , 'P') . "&id=" . $this->mod->get('id' , 'P');
                $url .= "&di=" . $this->mod->get('di' , 'P') . "&verifycode=" . $this->mod->get('verifycode' , 'P');
                $param = array(
                    'gref'      => 'http://verify.baidu.com/vcode?' . urlencode($this->mod->get('url' , 'P')),
                    'gheader'   => 1,
                    'gcookie'   => DATA_PATH . "temp/baidu.cookie"
                );
                $res = curl_lib::gethtml($url , $param);
                if((int)$res['code'] !== 200){
                    $this->mod->showmsg("验证失败了, 请稍候再试!");
                    //$this->mod->showmsg("验证通过 , 继续下一条... " , core::url('plugin-cp-dir-%s-exec-1' , $this->code) , 1 , 2);
                }
                $res = null;
                unset($res);
            }
            
            
            $obj = OBJ('tag_tab');
            $total = $obj->where('ctype = 3')->count();
            $gets  = $obj->where('ctype = 3')->where("exists(select 1 from dainfo_tab where dainfo_tab.tagid = tag_tab.id)")->count();
            if(intval($this->mod->get('exec'))){
                if($gets < $total){
                    $actor = $obj->fields('id,name')->order('id asc')->where('ctype = 3')->where("not exists(select 1 from dainfo_tab where dainfo_tab.tagid = tag_tab.id)")->get();
                    $daobj = OBJ('dainfo_tab');
                    $daobj->set("tagid" , $actor['id']);
                    $daobj->set("name"  , $actor['name']);
                    $daobj->set("adate" , 0);
                    $daobj->set('desc' , '暂无简介');
                    if(!empty($actor)){
                        $name = urlencode(str_replace('_' , '·' , $actor['name']));
                        $url = "http://baike.baidu.com/search/word?word=" . $name . "&pic=1&sug=1&enc=utf8";
                        $res = curl_lib::gethtml($url , array('gheader'=>1 , 'gcookie'   => DATA_PATH . "temp/baidu.cookie"));
                        if((int)$res['code'] == 200){
                            
                            // - verify
                            $match = array();
                            preg_match('/src\=\"(http\:\/\/verify\.baidu\.com\/cgi\-bin\/genimg\?.+?)\"/i' , $res['html'] , $match);
                            if(isset($match[1]) && !empty($match[1])){
                                $verify = array();
                                $verify['verify'] = $match[1];
                                $verify['vcode']  = substr($match[1] , strpos($match[1] , '?') + 1);
                                $match  = array();
                                preg_match('/\<form.+?\>(.+?)\<\/form\>/is' , $res['html'] , $match);
                                $verify['form']   = $match[1];
                                $this->mod->settpldir('daga' , 1);
                                $this->mod->assign('verify' , $verify);
                                $this->mod->display('admin/verify.html');
                            }
                            
                            // - desc
                            $match = array();
                            preg_match("/card\-summary\-content.+?\>(.+?)\<\/div\>\<\/div\>\<\/div\>/is" , $res['html'] , $match);
                            if(isset($match[1]) && !empty($match[1])){
                                $desc = filter::text($match[1]);
                                // - 影片内链
                                $match = array();
                                preg_match_all('/《(.+?)》/is', $desc , $match);
                                $vobj = OBJ('vod_tab');
                                if(!empty($match[1])){
                                    foreach($match[1] as $v){
                                        $name = filter::ult($v);
                                        if($name != ''){
                                            $vod = $vobj->fields("id,name,sname")->where("name = '{$name}'")->order("id asc")->get();
                                            if(!empty($vod)){
                                                $href = "<a href=\"" 
                                                 . core::url("@view-%s" , $this->mod->conf['utype'] ? $vod['sname'] : $vod['id']) 
                                                 . "\" target=\"_blank\" title=\"{$vod['name']}在线播放\" class=\"avlink\">《{$name}》</a>";
                                                    $desc = str_replace("《{$v}》" , $href , $desc);
                                            }
                                        }
                                        $vod = null; unset($vod);
                                    }
                                    $daobj->set("adate" , REQUEST_TIME);
                                }
                                $daobj->set('desc' , $desc);
                            }
                            
                            // - image
                            $match = array();
                            preg_match("/card\-image.+?src=\"(.+?)\"/i" , $res['html'] , $match);
                            if(isset($match[1]) && !empty($match[1])){
                                $daobj->set('cover' , ga_lib::srimg($match[1] , 185 , 220));
                            }
                        }
                        $daobj->replace();
                        $this->mod->showmsg("[ {$actor['name']} ] 采集成功 , 剩余 " . ($total - $gets - 1) . " , 继续下一条 ... " , core::url('plugin-cp-dir-%s-exec-1' , $this->code) , 1 , 2);
                        die;
                    }
                    
                }
                $this->mod->showmsg('采集完成!');
            }else{
                //$this->mod->settpldir('daga' , 1);
                $this->mod->assign("total" , $total);
                $this->mod->assign("gets"  , $gets);
                $this->mod->assign("da" , $this->get(1));
                $this->mod->assign('atitle' , '演职员信息采集管理');
                $this->mod->display('plugin@daga:admin/cp.html');
            }
        }
    }

    /**
     * 安装
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function install(){
        if(!is_file(DATA_PATH . 'daga.lock') &&  defined('PLUGIN_EXEC')){
            file_put_contents(DATA_PATH . 'daga.lock' , 'ReGinX.com');
            return true;
        }
        return false;
    }

    /**
     * 卸载
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function uninstall(){
        if(is_file(DATA_PATH . 'daga.lock') && defined('PLUGIN_EXEC')){
            unlink(DATA_PATH . 'daga.lock');
            return true;
        }
        return false;
    }
}
?>