<?php
/**
 * 留言求片插件
 *
 */
class gbook_plu extends plugin{

    /**
     * 插件名称
     *
     * @var unknown_type
     */
    public $name = '留言求片';

    /**
     * 插件配置信息
     *
     * @var unknown_type
     */
    public $info = array(
    'author'    => 'ReGinX',
    'supurl'    => 'http://www.reginx.com',
    'ver'       => '1.0',
    'conf'      => 0
    );

    /**
     * 插件默认页
     *
     */
    public function index(){
        if(!is_file(DATA_PATH . 'gbook.lock')){
            $this->mod->show404(1 , "{$this->name} 尚未安装!");
        }
        $gobj = plugin::lib('gbook_tab');
        $msg = null;
        if($this->mod->has('verify' , 'P')){
            if($this->mod->vcode()){
                $gb = $this->mod->get('gb' , 'P');
                $gb = array_map('filter::ult' , $gb);
                if($gb['msg'] != '' && $gb['nick'] != ''){
                    $gobj->set("id" , 0)->set("nick" , $gb['nick'])->set("msg" , $gb['msg'])->set("adate" , REQUEST_TIME);
                    $gobj->set("udate" , REQUEST_TIME)->set("uid" , 0)->set("reply" , '')->set("status" , 0)->save();
                    $msg = "发布成功了, 请耐心等待管理员回复!";
                }else{
                    $msg = '请填写完整!';
                }
            }else{
                $msg = '验证码错误!';
            }
        }
        $this->mod->assign('msg' , $msg);
        $this->mod->assign('urhere', array(
        'cur' => $this->name
        ));
        $pn = intval($this->mod->get('pn'));
        $pn = $pn ? $pn : 1;
        $key = 'plugin#gbook' . $pn;
        $data = $GLOBALS['_CACHE']->get($key , '');
        if(empty($data) || IS_DEBUG){
            $pobj = new page_lib($gobj->where("status = 1")->keep()->count() , 'pn' , intval($this->mod->get('pn')));
            $data['list'] = $gobj->where("status = 1")->order("id " . $pobj->desc)->clear('fields')->fields('*')->limit($pobj->limit)->getall();
            $data['pobj'] = $pobj->toarray();
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($data)){
                $GLOBALS['_CACHE']->set($key, $data, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        $this->mod->assign("list" , $data['list']);
        $this->mod->assign("pobj" , $data['pobj']);
        $this->mod->assign("ptitle" , $this->name);
        $this->mod->display('plugin@gbook:index.html');
    }


    public function cp(){
        if(is_file(DATA_PATH . 'gbook.lock') && defined('PLUGIN_EXEC')){
            $op = $this->mod->get('op');
            $op = empty($op) ? 'list' : $op;
            if($op == 'list'){
                $this->admincp();
            }else if($op == 'save'){
                $id = intval($this->mod->get("id" , 'P'));
                $reply = filter::text($this->mod->get("reply" , 'P'));
                if($id <= 0 || empty($reply)){
                    $this->mod->showmsg("请输入回复内容" , -1 , 1 ,2);
                }else{
                    $obj = plugin::lib('gbook_tab');
                    $obj->set("reply" , $reply)->set("status" , 1)->where("id = {$id}")->save();
                    $this->mod->showmsg("回复成功!" , NULL , 1 ,1);
                }
            }else if($op == 'del'){
                $this->del();
            }
            $this->mod->showmsg('操作未指定!');
        }
        $this->mod->showmsg('尚未安装!');
    }

    private function del(){
        $id = $this->mod->get("del" , 'P');
        if(!empty($id)){
            $id = explode(',' , $id);
            $id = array_map('intval' , $id);
            $obj = plugin::lib('gbook_tab');
            $obj->where("id in (" . join(',' , $id) .")")->del();
            $this->mod->showmsg("删除成功!" , NULL , 1 ,1);
        }
        $this->mod->showmsg("请选择要删除的留言!" , NULL , 1 ,1);
    }

    private  function admincp(){
        $gb = plugin::lib('gbook_tab');
        $pobj = new page_lib($gb->count() , 'pn' , intval($this->mod->get('pn')),12);
        $this->mod->assign('list' , $gb->order("id " . $pobj->desc)->limit($pobj->limit)->getall());
        $this->mod->assign('atitle' , '留言求片列表');
        $this->mod->assign('pobj' , $pobj->toarray());
        $this->mod->display('plugin@gbook:admin/list.html');
    }

    /**
     * 安装
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function install(){
        if(!is_file(DATA_PATH . 'gbook.lock') && defined('PLUGIN_EXEC')){
            $dbobj = db_extra::getobj($this->mod->conf['db']);
            $sql   = "create table if not exists {$dbobj->_conf['pre']}gbook(
                   id                   int(11) not null auto_increment,
                   nick                 char(150) default null comment '昵称',
                   uid                  int(11) unsigned not null default 0 comment '用户ID',
                   udate                int(11) unsigned not null default 0 comment '更新日期',
                   adate                int(10) unsigned not null default 0 comment '添加日期',
                   status               tinyint(3) unsigned not null default 0 comment '状态',
                   msg                  text comment '内容',
                   reply                text comment '回复',
                   primary key (id),
                   key index_1 (adate, status)
                )ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言本';";
            $dbobj->query($sql);
            file_put_contents(DATA_PATH . 'gbook.lock' , 'ReGinX.com');
            return true;
        }
        return false;
    }

    /**
     * 卸载
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function uninstall(){
        if(is_file(DATA_PATH . 'gbook.lock') && defined('PLUGIN_EXEC')){
            $dbobj = db_extra::getobj($this->mod->conf['db']);
            $sql = "drop table if exists {$dbobj->_conf['pre']}gbook;";
            $dbobj->query($sql);
            unlink(DATA_PATH . 'gbook.lock');
            return true;
        }
        return false;
    }
}
?>