<?php
/**
 * 火车头入库插件
 * @copyright reginx.com
 * $Id$
 */
class locoy_plu extends plugin{

    /**
     * 插件名称
     *
     * @var unknown_type
     */
    public $name = '火车头采集入库';

    /**
     * 插件配置信息
     *
     * @var unknown_type
     */
    public $info = array(
    'author'    => 'ReGinX',
    'supurl'    => 'http://www.reginx.com',
    'ver'       => '1.0',
    'conf'      => 0
    );

    /**
     * 插件默认页
     *
     */
    public function index(){
        $this->chkinstall();
        $out = array('code' => 1 , 'msg' =>'');
        $sid = $this->mod->get('sid' , 'p');
        if($sid != $this->mod->conf['sid']){
            $out['msg'] = 'sid 错误';
            $this->mod->ajaxout($out);
        }
        $cset = $this->mod->get('charset' , 'P');
        $vod = $this->mod->get('vod' , 'P');
        if(empty($vod) ||  !is_array($vod)){
            $out['msg'] = '数据不能为空';
            $this->mod->ajaxout($out);
        }
        $msg = $this->mod->get('msg' , 'P');
        $url = $this->mod->get('url' , 'P');
        $vod['id']   = 0;
        $vod['name'] = filter::ult($vod['name']);
        if(empty($vod['name'])){
            $out['msg'] = '片名不能为空';
            $this->mod->ajaxout($out);
        }
        $vod['sname'] = filter::text($vod['sname']);
        if(empty($vod) || !preg_match('/^[\w\-\_]+/i' , $vod['sname'])){
            $vod['sname'] = py_lib::get($vod['name']);
        }
        if(empty($vod['sname'])){
            $out['msg'] = 'url字串处理失败';
            $this->mod->ajaxout($out);
        }
        $vod['cover'] = filter::text($vod['cover']);
        if(empty($vod['cover'])){
            $vod['cover'] = "images/null.gif";
        }
        $vod['region'] = ga_lib::getcat(filter::ult($vod['region']));
        $vod['key'] = filter::text($vod['key']);
        $vod['info'] = filter::text($vod['info']);
        if(empty($vod['key'])){
            $vod['key'] = $vod['name'] . '在线播放';
        }
        $vod['desc'] = filter::text($vod['key']);
        if(empty($vod['desc'])){
            $vod['desc'] = $vod['name'] . '在线播放' . (empty($vod['info']) ? '' : mb_substr($vod['info'], 0, 80, "utf-8"));
        }
        $vod['status']   = ga_lib::getstatus(filter::text($vod['status']));
        $vod['lang']     = ga_lib::getstatus(filter::text($vod['lang']));
        $vod['actor']    = preg_replace('/(\.|\s|\-)+/i', '_', filter::text($vod['actor']));
        $vod['director'] = preg_replace('/(\.|\s|\-)+/i', '_',  filter::text($vod['director']));
        $vod['release']  = intval(is_numeric($vod['release']) ? $vod['release'] : date('Y' , REQUEST_TIME));
        $vod['top']      = intval($vod['top']);
        $vod['tread']    = intval($vod['tread']);
        $vod['score']    = intval($vod['score']);
        $vod['plays']    = intval($vod['plays']);
        $vod['rec']      = intval($vod['rec']);
        $vod['mosaics']  = intval($vod['mosaics']);
        $vod['udate'] = filter::text($vod['udate']);
        if(preg_match('/^(\d{4}-\d{1,2}-\d{1,2}(?: \d{1,2}:\d{1,2}(?:\:\d{1,2})?)?)$/i' , $vod['udate'])){
            $vod['udate'] = strtotime($vod['udate']);
        }else{
            $vod['udate'] = REQUEST_TIME;
        }
        $vod['adate'] = REQUEST_TIME;
        $url = explode("\n" , $url);
        if(!empty($url)){
            foreach ($url as $k => &$v){
                $v = filter::text($v);
            }
        }else{
            $url = array();
        }
        $vod['hash'] = md5($vod['name']);
        $vobj = OBJ('vod_tab');
        $vrow = $vobj->fields('id,adate')->where("hash = '{$vod['hash']}'")->get();
        if(!empty($vrow)){
            $vod['id'] = $vrow['id'];
            $vod['adate'] = $vrow['adate'];
            $tempurl = core::getobj('vod_url_tab')->where("vid = '{$vod['id']}'")->order("uid asc ")->getall();
            if(!empty($tempurl)){
                foreach ($tempurl as $v){
                    if(array_search($v['url'] , $url) === false){
                        array_unshift($url , $v['url']);
                    }
                }
            }
            $tempurl = null; unset($tempurl);
        }
        $vrow = array();
        if(!empty($msg)){
            $temp = explode("\n" , $msg);
            $msg = array();
            foreach ($temp as $v){
                $v = filter::text($v);
                if(preg_match('/^.+?\#\#\#.+?\#\#\#.+?$/is' , $v)){
                    $msg[] = explode('###' , $v);
                }
            }
            $temp = array();unset($temp);
        }
        $vod['cat'] = ga_lib::getcat(filter::ult($vod['cat']));
        // add
        if($vobj->load($vod)){
            $ret = $vobj->save();
            if($ret['code'] === 0){
                $vod['id'] = intval($ret['msg']);
                // url
                vod_lib::addurl($vod['id'], ga_lib::getpurl($url));
                // actor tag
                if(!empty($vod['actor'])){
                    tag_lib::add(3, $vod['id'], $vod['actor']);
                }
                // dir tag
                if(!empty($vod['director'])){
                    tag_lib::add(2, $vod['id'], $vod['director']);
                }
                // reply
                if(!empty($msg)){
                    $robj = OBJ('reply_tab');
                    foreach ($msg as $v){
                        $robj->set("nick" , $v[0])->set("adate" , strtotime($v[1]))->set("desc" , filter::text($v[2]));
                        $robj->set('name' , 'reginx')->set("id" , 0)->set("vid" , $vod['id'])->set("parent" , 0)->save();
                    }
                }
                $out['code'] = 0;
                $out['msg'] = '入库成功';
                $this->mod->ajaxout($out);
            }
        }
        $out['msg'] = '入库失败';
        $this->mod->ajaxout($out);
    }


    /**
     * 插件管理页面
     *
     */
    public function cp(){
        $this->chkinstall();
        if(defined('PLUGIN_EXEC')){
            $this->mod->assign('atitle' , '火车头入库插件');
            $this->mod->settpldir('locoy' , 1);
            $this->mod->display('admin/info.html');
        }
        $this->mod->showmsg('尚未安装!');
    }

    /**
     * 安装
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function install(){
        if(defined('PLUGIN_EXEC')){
            if(!is_file(DATA_PATH . 'locoy.lock')){
                file_put_contents(DATA_PATH . 'locoy.lock' , 'ReGinX.com');
                return true;
            }
        }
        return false;
    }

    /**
     * 卸载
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function uninstall(){
        $this->chkinstall();
        if(is_file(DATA_PATH . 'locoy.lock')){
            unlink(DATA_PATH . 'locoy.lock');
            return true;
        }
        return false;
    }
}
?>