﻿set names utf8;
drop table if exists `pre_admin`;
create table `pre_admin` (
  `id` int(11) not null auto_increment comment '管理员id',
  `uname` char(50) not null default '' comment '帐号',
  `passwd` char(32) not null comment '密码',
  `uright` tinyint(4) not null default '0' comment '权限',
  `salt` char(10) not null default '0' comment '盐值',
  primary key (`id`),
  unique key `index_uniq_uname` (`uname`),
  key `index_admin` (`uname`,`passwd`)
) engine=myisam auto_increment=1 default charset=utf8 comment='管理员';
drop table if exists `pre_ads`;
create table `pre_ads` (
  `id` int(11) not null auto_increment,
  `name` char(100) not null comment '广告名称',
  `location` tinyint(3) unsigned not null default '0' comment '广告位置',
  `status` tinyint(3) unsigned not null default '0' comment '状态码',
  `ctype` tinyint(3) unsigned not null default '0' comment '广告类型',
  `adate` int(10) unsigned not null default '0' comment '添加日期',
  `stat` int(10) unsigned not null default '0' comment '统计',
  `desc` text comment '广告内容',
  primary key (`id`),
  key `index_1` (`location`,`status`,`ctype`,`adate`,`stat`)
) engine=myisam auto_increment=1 default charset=utf8 comment='广告';
drop table if exists `pre_art`;
create table `pre_art` (
  `id` int(11) not null auto_increment,
  `name` varchar(255) not null comment '标题',
  `cat` int(10) unsigned not null default '0' comment '类别',
  `status` tinyint(3) unsigned not null default '0' comment '状态',
  `sname` char(100) not null comment '映射名称',
  `source` char(100) default null comment '来源',
  `author` char(50) not null default 'anonymous' comment '作者',
  `adate` int(10) unsigned not null default '0' comment '添加日期',
  `tag` varchar(255) default null comment '标签',
  `key` varchar(255) default null comment '关键字',
  `desc` varchar(255) default null comment '描述信息',
  `extra` tinyint(4) not null default '0' comment '扩展字段',
  `sort` int(10) unsigned not null default '0' comment '排序',
  `views` int(11) unsigned not null default '0' comment '浏览数',
  `hash` char(32) not null default '',
  `cover` char(150) not null default 'null.gif',
  primary key (`id`),
  unique key `index_hash` (`hash`),
  key `index_category` (`cat`),
  key `index_sort` (`status`,`adate`,`sort`),
  key `index_mapping` (`sname`)
) engine=myisam auto_increment=1 default charset=utf8 comment='资讯';
drop table if exists `pre_block`;
create table `pre_block` (
  `skey` char(150) not null comment 'key',
  `name` char(150) not null comment '名称',
  `adate` int(10) not null comment '新增日期',
  `extra` text comment '配置内容',
  `ttl` int(11) unsigned not null default '86400',
  `ctype` char(30) not null default '1',
  `tpl` char(15) not null default 'default',
  `comment` varchar(255) default '无说明' comment '参数说明',
  primary key (`skey`),
  key `index_1` (`adate`),
  key `index_2` (`tpl`)
) engine=myisam default charset=utf8 comment='block表';

#
# source for table "pre_cat"
#

drop table if exists `pre_cat`;
create table `pre_cat` (
  `id` int(11) not null auto_increment,
  `name` char(150) not null comment '名称',
  `ctype` tinyint(4) not null default '0' comment '类型',
  `sname` char(150) default null comment '映射名',
  `parent` int(10) unsigned not null default '0' comment '所属类别',
  `path` char(255) not null default '' comment '关系路径',
  `sort` int(10) unsigned not null default '0' comment '排序',
  `cover` char(150) default null comment '封面图片',
  `key` char(255) default null comment 'seo关键字',
  `desc` char(255) default null comment 'seo描述',
  `extra` tinyint(3) unsigned not null default '0' comment '其他',
  `tpl` tinyint(3) unsigned not null default '0' comment '模板序号',
  primary key (`id`),
  key `index_mapping` (`sname`),
  key `index_sort` (`sort`),
  key `index_tree` (`parent`,`path`),
  key `index_name` (`name`),
  key `index_ctype` (`ctype`)
) engine=myisam auto_increment=1 default charset=utf8 row_format=fixed;
drop table if exists `pre_dainfo`;
create table `pre_dainfo` (
  `tagid` int(11) unsigned not null default '0' comment '对应tag',
  `name` char(155) not null default '' comment '名称',
  `cover` char(150) not null default 'images/null.gif' comment '封面',
  `desc` text comment '内容',
  `adate` int(11) unsigned not null default '0' comment '更新日期',
  primary key (`tagid`),
  key `index_0` (`adate`)
) engine=myisam default charset=utf8;

#
# source for table "pre_deny"
#

drop table if exists `pre_deny`;
create table `pre_deny` (
  `ip` int(11) unsigned not null default '0',
  `ctype` tinyint(3) unsigned not null default '0',
  `adate` int(11) unsigned not null default '0',
  primary key (`ip`,`ctype`)
) engine=myisam default charset=utf8 comment='限制';

#
# source for table "pre_desc"
#

drop table if exists `pre_desc`;
create table `pre_desc` (
  `refid` int(10) not null,
  `ctype` int(10) not null,
  `sdesc` text,
  primary key (`refid`,`ctype`)
) engine=myisam default charset=utf8 row_format=dynamic;

#
# source for table "pre_ga"
#

drop table if exists `pre_ga`;
create table `pre_ga` (
  `id` int(11) not null auto_increment,
  `name` char(150) not null default '',
  `host` char(150) not null default '',
  `status` tinyint(3) unsigned not null default '0',
  `adate` int(10) unsigned not null default '0',
  `lasts` int(11) unsigned not null default '0',
  `conf` text,
  `tab` char(50) not null default '',
  `catid` int(11) unsigned default '0',
  `udate` int(11) unsigned not null default '0',
  `maxpn` int(11) unsigned not null default '0',
  `srimg` tinyint(3) unsigned not null default '0',
  `total` int(11) unsigned not null default '0',
  `sort` tinyint(3) unsigned not null default '0',
  `pn` int(11) unsigned not null default '0',
  `listurl` char(150) not null default '',
  primary key (`id`)
) engine=myisam auto_increment=1 default charset=utf8;
drop table if exists `pre_galog`;
create table `pre_galog` (
  `hash` char(36) not null default '',
  `url` varchar(255) not null default '',
  `adate` int(10) unsigned not null default '0',
  `status` tinyint(3) unsigned not null default '0',
  `gaid` int(11) unsigned not null default '0',
  primary key (`hash`),
  key `index_gaid` (`gaid`),
  key `index_status` (`status`)
) engine=myisam default charset=utf8 row_format=fixed;

#
# source for table "pre_gatask"
#

drop table if exists `pre_gatask`;
create table `pre_gatask` (
  `gaid` int(11) unsigned not null default '0',
  `vid` int(11) unsigned not null default '0',
  `ctype` tinyint(3) unsigned not null default '0',
  `sdesc` varchar(255) not null default '',
  `extra` mediumint(6) unsigned not null default '0',
  primary key (`gaid`,`vid`,`ctype`,`extra`),
  key `index_extra` (`extra`)
) engine=myisam default charset=utf8;

#
# source for table "pre_gbook"
#

drop table if exists `pre_gbook`;
create table `pre_gbook` (
  `id` int(11) not null auto_increment,
  `nick` char(150) default null,
  `uid` int(11) unsigned not null default '0',
  `udate` int(11) unsigned not null default '0',
  `adate` int(10) unsigned not null default '0',
  `status` tinyint(3) unsigned not null default '0',
  `msg` text,
  `reply` text,
  primary key (`id`),
  key `index_1` (`adate`,`status`)
) engine=myisam default charset=utf8 comment='gbook';

#
# source for table "pre_info"
#

drop table if exists `pre_info`;
create table `pre_info` (
  `id` int(11) not null,
  `desc` text comment '内容',
  `ctype` tinyint(3) unsigned not null default '0' comment '类型',
  `extra` int(10) unsigned not null default '0' comment '扩展id',
  primary key (`id`),
  key `index_info` (`ctype`,`extra`)
) engine=myisam default charset=utf8 comment='内容';
drop table if exists `pre_link`;
create table `pre_link` (
  `id` int(11) not null auto_increment,
  `name` char(200) default '' comment '名称',
  `logo` char(255) default null comment 'logo',
  `url` char(150) default null comment '地址',
  `sort` tinyint(3) unsigned default '0' comment '排序',
  primary key (`id`),
  key `index_1` (`sort`)
) engine=myisam auto_increment=1 default charset=utf8;
drop table if exists `pre_misc`;
create table `pre_misc` (
  `k` char(50) not null comment '名称',
  `v` text comment '值',
  `c` tinyint(3) unsigned not null default '0' comment '类型',
  primary key (`k`),
  unique key `index_misc` (`k`,`c`)
) engine=myisam default charset=utf8 comment='杂项';

drop table if exists `pre_nav`;
create table `pre_nav` (
  `id` int(11) not null auto_increment,
  `name` char(150) not null comment '名称',
  `url` char(150) not null comment '地址',
  `ctype` tinyint(4) not null comment '类型',
  `sort` tinyint(3) unsigned not null default '0' comment '排序',
  `target` tinyint(3) unsigned not null default '0' comment '是否新窗口',
  `parent` int(10) unsigned not null default '0' comment '所属组别',
  primary key (`id`),
  key `index_1` (`ctype`,`sort`,`parent`)
) engine=myisam auto_increment=1 default charset=utf8 comment='导航表';
drop table if exists `pre_plugin`;
create table `pre_plugin` (
  `id` int(11) not null auto_increment,
  `name` char(200) not null default '' comment '名称',
  `ver` char(30) not null default '1.0' comment '版本',
  `author` char(100) not null default 'reginx.com' comment '作者',
  `supurl` char(150) not null default 'http://www.reginx.com' comment '作者地址',
  `adate` int(11) unsigned not null default '0' comment '添加日期',
  `status` tinyint(3) unsigned not null default '0' comment '状态',
  `dir` char(30) not null default 'rgx' comment '所在目录',
  `extra` text comment '扩展配置',
  `conf` tinyint(3) unsigned not null default '0' comment '是否启用配置导航',
  `ctype` tinyint(3) unsigned not null default '0' comment '类型',
  primary key (`id`),
  unique key `index_dir` (`dir`),
  key `index_0` (`status`)
) engine=myisam auto_increment=1 default charset=utf8;
drop table if exists `pre_py`;
create table `pre_py` (
  `cn` char(3) not null comment '中文',
  `py` char(6) not null comment '拼音',
  `pyh` char(1) not null comment '首字母',
  primary key (`cn`)
) engine=myisam default charset=utf8 comment='拼音库';

#
# source for table "pre_reply"
#

drop table if exists `pre_reply`;
create table `pre_reply` (
  `id` int(11) not null auto_increment,
  `uid` int(11) unsigned not null default '0' comment '用户id',
  `adate` int(10) unsigned not null default '0' comment '发布日期',
  `desc` text comment '排列内容',
  `name` varchar(225) not null default '' comment '标题',
  `vid` int(11) unsigned not null default '0' comment '视频id',
  `parent` int(11) unsigned not null default '0' comment '引用的评论id',
  `nick` varchar(150) not null default 'anonymous' comment '昵称',
  `ctype` tinyint(3) unsigned not null default '0' comment '0vod1art',
  `status` tinyint(3) unsigned not null default '0' comment '0',
  `ip` int(11) unsigned not null default '0',
  primary key (`id`),
  key `index_0` (`adate`),
  key `index_1` (`uid`,`vid`,`parent`),
  key `index_2` (`vid`),
  key `index_3` (`status`,`ctype`)
) engine=myisam auto_increment=1 default charset=utf8;
drop table if exists `pre_sess`;
create table `pre_sess` (
  `sessid` char(32) not null default '',
  `uid` int(10) unsigned not null default '0',
  `ip` int(11) unsigned not null default '0',
  `lastvisit` int(10) unsigned not null default '0',
  `extra` int(11) unsigned not null default '0',
  `sdata` mediumtext,
  primary key (`sessid`),
  key `index_1` (`lastvisit`)
) engine=myisam default charset=utf8 comment='session table';
drop table if exists `pre_tag`;
create table `pre_tag` (
  `id` int(10) unsigned not null auto_increment,
  `name` char(120) not null default '' comment '名称',
  `ctype` tinyint(3) unsigned not null default '0' comment '类型',
  `sort` smallint(5) unsigned not null default '0' comment '排序',
  `sname` char(150) not null default '' comment 'url映射',
  `pyh` char(1) not null default '0' comment '首字母',
  primary key (`id`),
  unique key `index_1` (`name`,`ctype`),
  key `index_3` (`pyh`),
  key `index_2` (`sname`)
) engine=myisam auto_increment=1 default charset=utf8 comment='标签';
drop table if exists `pre_tag_list`;
create table `pre_tag_list` (
  `refid` int(10) unsigned not null default '0' comment '外键id',
  `tagid` int(10) unsigned not null default '0' comment '标签id',
  `ctype` tinyint(3) unsigned not null default '0' comment '关系类型',
  unique key `index_1` (`tagid`,`refid`,`ctype`)
) engine=myisam default charset=utf8 comment='标签关系表';
drop table if exists `pre_temp`;
create table `pre_temp` (
  `k` char(50) not null default '' comment '名称',
  `v` char(255) default null comment '值',
  primary key (`k`)
) engine=myisam default charset=utf8;
drop table if exists `pre_user`;
create table `pre_user` (
  `id` int(11) not null auto_increment,
  `uname` char(50) not null default '' comment '帐号',
  `passwd` char(32) not null default '' comment '密码',
  `openid` char(32) not null default '0',
  `sex` tinyint(3) unsigned not null default '0',
  `lastlogin` int(11) unsigned not null default '0',
  `lastplay` int(11) unsigned not null default '0',
  `adate` int(11) unsigned not null default '0',
  `nick` char(150) not null default '' comment '昵称',
  primary key (`id`),
  unique key `index_uname` (`uname`),
  key `index_qc_openid` (`openid`)
) engine=myisam auto_increment=1 default charset=utf8 comment='会员表';
drop table if exists `pre_vod`;
create table `pre_vod` (
  `id` int(11) not null auto_increment,
  `name` char(150) not null comment '名称',
  `sname` char(150) not null default '0' comment 'url映射',
  `cover` char(100) not null default '' comment '封面',
  `lang` tinyint(3) unsigned not null default '0' comment '语言',
  `rec` tinyint(3) unsigned not null default '0' comment '推荐',
  `desc` char(255) default null comment '描述',
  `key` char(255) not null default '' comment '关键字',
  `mosaics` tinyint(3) unsigned not null default '0' comment '马赛克',
  `director` char(100) not null default '' comment '导演',
  `actor` char(255) not null default '' comment '演员',
  `region` int(10) unsigned not null default '0' comment '地区',
  `cat` int(10) unsigned not null default '0' comment '类别',
  `release` smallint(5) unsigned not null default '0' comment '上映日期',
  `udate` int(10) unsigned not null default '0' comment '更新日期',
  `status` tinyint(3) unsigned not null default '0' comment '状态',
  `info` text comment '介绍',
  `views` int(10) unsigned not null default '0' comment '查看数',
  `plays` int(10) unsigned not null default '0' comment '播放数',
  `tpl` tinyint(3) unsigned not null default '0' comment '模板',
  `top` int(10) unsigned not null default '0' comment '顶数',
  `tread` int(10) unsigned not null default '0' comment '踩数',
  `score` tinyint(3) unsigned not null default '0' comment '评分',
  `hash` char(32) not null comment 'hash值',
  `adate` int(11) unsigned not null default '0' comment '添加日期',
  `reply` int(3) unsigned not null default '0' comment '评论数',
  `basename` char(150) not null default '' comment '系列名',
  primary key (`id`),
  unique key `index_7` (`hash`),
  unique key `index_6` (`sname`),
  key `index_3` (`region`,`cat`,`release`,`udate`,`status`),
  key `index_5` (`adate`,`views`,`plays`),
  key `index_4` (`adate`),
  key `index_1` (`name`),
  key `index_2` (`basename`),
  key `index_8` (`reply`)
) engine=myisam auto_increment=1 default charset=utf8 comment='视频';

drop table if exists `pre_vod_url`;
create table `pre_vod_url` (
  `vid` int(10) unsigned not null default '0' comment '视频id',
  `url` varchar(255) default null comment '播放地址',
  `name` varchar(255) not null default '0' comment '剧集名称',
  `player` char(15) not null default '0' comment '播放类型',
  `uid` int(10) not null default '0' comment '排序id',
  `hash` char(32) not null default '',
  unique key `index_hash` (`hash`),
  unique key `index_1` (`vid`,`uid`,`player`)
) engine=myisam default charset=utf8 comment='视频地址';