<?php
/**
 * 数据获取接口
 * @copyright reginx.com
 * $Id$
 */
class api_lib{
    
    
    
   /**
    * 获取影片列表
    *
    * @param unknown_type $catid
    * @param unknown_type $fields
    * @param unknown_type $where
    * @param unknown_type $order
    * @param unknown_type $limit
    * @return unknown
    */
   public static function getvodlist($catid, $fields = 'id,sname,name,cover', $where = '1=1', $order = 'id desc', $limit = 10){
       $key = 'vod#' . md5($catid . $fields . strval($where) . $order . $limit);
       $ret = $GLOBALS['_CACHE']->get($key);
       if(empty($ret) || IS_DEBUG){
            $ret = vod_lib::getlist($fields , $where , $order , $limit);
            $ret && !IS_DEBUG && $GLOBALS['_CACHE']->set($key , $ret , 86400);
       }
       return $ret;
   }
   
    
   /**
    * 获取资讯列表
    *
    * @param unknown_type $catid
    * @param unknown_type $fields
    * @param unknown_type $where
    * @param unknown_type $order
    * @param unknown_type $limit
    * @return unknown
    */
   public static function getartlist($catid, $fields = 'id,sname,name,cover', $where = '1=1', $order = 'id desc', $limit = 10){
       $key = 'art#' . md5($catid . $fields . strval($where) . $order . $limit);
       $ret = $GLOBALS['_CACHE']->get($key);
       if(empty($ret) || IS_DEBUG){
            $ret = art_lib::getlist($fields , $where , $order , $limit);
            $ret && !IS_DEBUG && $GLOBALS['_CACHE']->set($key , $ret , 86400);
       }
       return $ret;
   }
    
    /**
     * 获取资讯分页数据
     *
     * @param unknown_type $sname
     * @param unknown_type $pn
     * @param unknown_type $where
     * @param unknown_type $order
     * @param unknown_type $psize
     * @return unknown
     */
    public static function getartpaged($sname, $pn = 1, $where = '1 = 1', $order = 'udate desc', $psize = 20){
        $ret = array();
        $key = 'page#' . md5($sname . $pn . serialize($where) . $order . $psize);
        $order = str_replace('desc', '#desc#', str_replace('asc', '#asc#', $order));
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $obj = core::getobj('art_tab');
            $obj->keep();
            if(is_array($where)){
                foreach($where as $v){
                    $obj->where($v);
                }
            }else{
                $obj->where($where);
            }
            $pobj = new page_lib($obj->count(), 'pn', $pn, $psize);
            $ret['pobj'] = $pobj->toarray();
            $obj->clear('fields')->fields('id,sname,name,cover,status,cat,adate,key,desc')->limit($pobj->limit);
            // 倒序分页
            if($pobj->rev){
                $obj->order(str_replace('#desc#', 'asc', str_replace('#asc#', 'desc', $order)));
            }else{
                $obj->order(str_replace('#', '', $order));
            }
            $ret['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
            if(!empty($ret['data'])){
                foreach($ret['data'] as &$v){
                    if(!empty($v['actor'])){
                        $tmp = explode(',', $v['actor']);
                        $v['actor'] = array_slice($tmp, 0, count($tmp) >= 3 ? 3 : count($tmp));
                        $tmp = array();
                    }
                }
            }
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        return $ret;
    }
    
    /**
     * 获取年份
     *
     * @return unknown
     */
    public static function getyears(){
        $ret = array();
        $key = 'vod#years';
        $ret = $GLOBALS['_CACHE']->get($key);
        if(empty($ret) || IS_DEBUG){
            $ret = OBJ('vod_tab')->fields("distinct(release) as year")->order("release desc")->getall();
            $GLOBALS['_CACHE']->set($key , $ret , 30 * 86400);
        }
        return $ret;
    }
    
    /**
     * 获取影片推荐
     *
     * @param unknown_type $limit
     * @return unknown
     */
    public static function getrec($limit = 10 , $actor = 0){
        $ret = array();
        $key = 'vod#rec-' . $limit . '-' . $actor;
        $ret = $GLOBALS['_CACHE']->get($key);
        if(empty($ret) || IS_DEBUG){
            $ret = OBJ("vod_tab")->where("rec > 0")->fields("id,sname,name,cover,key,adate,udate" . ($actor ? ',actor' : ''))->limit($limit)->getall();
            if($actor){
                foreach ((array)$ret as $k => $v){
                    $tmp = empty($v['actor']) ? array() : explode(',' , $v['actor']);
                    if(count($tmp) > 2){
                        $tmp = array_slice($tmp , 0 , 2);
                    }
                    $ret[$k]['actor'] = $tmp;
                }
            }
            $GLOBALS['_CACHE']->set($key , $ret , 86400);
        }
        return $ret;
    }
    
    
    /**
     * 获取杂项配置数据
     *
     * @param unknown_type $k
     * @param unknown_type $c
     * @return unknown
     */
    public static function getmisc($k , $c = 1){
        $key = 'misc#' . $k . '_' . $c;
        $ret = $GLOBALS['_CACHE']->get($key);
        if(empty($ret) || IS_DEBUG){
            $row = OBJ('misc_tab')->where("k = '{$k}' and c = {$c}")->get();
            if(!empty($row)){
                $ret = unserialize(base64_decode($row['v']));
                if(count($ret) > 10){
                    $ret = array_slice($ret , 0 , 10);
                }
            }
            $ret = is_array($ret) ? $ret : array();
            $GLOBALS['_CACHE']->set($key , $ret , 86400);
        }
        return $ret;
    }
    
    
    /**
     * 获取分类信息
     *
     * @param unknown_type $parent
     * @param unknown_type $ctype
     * @return unknown
     */
    public static function getclist($parent = 0 , $ctype = 0){
        $key = 'misc#catlst' . $ctype;
        $ret = $GLOBALS['_CACHE']->get($key);
        if(IS_DEBUG || empty($ret)){
            $ret = OBJ('cat_tab')->getlist($parent , $ctype , 1);
            $GLOBALS['_CACHE']->set($key , $ret , 86400);
        }
        return $ret;
    }
    
    
    /**
     * 获取分类信息
     *
     * @param unknown_type $ctype
     * @param unknown_type $cache
     * @return unknown
     */
    public static function getcatlist($ctype = 0 , $cache = 1){
        $ret = array();
        $key = 'misc#cat-ctype-' . $ctype;
        $ret = $GLOBALS['_CACHE']->get($key);
        if(empty($ret) || !$cache || IS_DEBUG){
            $ret = OBJ('cat_tab')->where("ctype = $ctype")->fields('id,name,sname,sort')->rkey('id')->getall();
            $GLOBALS['_CACHE']->set($key , $ret , 86400);
        }
        return $ret;
    }
    

    /**
     * 获取明星库
     *
     * @param unknown_type $py
     * @param unknown_type $psize
     * @param unknown_type $pn
     * @return unknown
     */
    public static function getactors($py = null , $pn = 1 , $psize = 24 ){
        $ret = array();
        $key = 'misc#actors-py-' . (empty($py) ? '0' : $py) . '-' . $pn;
        $ret = $GLOBALS['_CACHE']->get($key);
        if(empty($ret) || IS_DEBUG){
            $cache = false;
            $obj = OBJ('tag_tab');
            $obj->where("ctype = 3");
            if(preg_match('/^[a-z]$/' , $py)){
                $obj->where("pyh = '{$py}' ");
            }
            $pobj = new page_lib($obj->keep()->count() , 'pn' , intval($pn) , $psize);
            if($pn <= 3 || $pn >= $pobj->max - 3){
                $cache = true;   
            }
            $ret['pobj'] = $pobj->toarray();
            $obj->clear('fields')->limit($pobj->limit)->order("adate desc ,sname " . ($pobj->rev ? 'asc' : 'desc'));
            $obj->rkey('id')->fields("id,name,sname,dainfo_tab.desc,dainfo_tab.cover,dainfo_tab.adate")
                            ->leftjoin("dainfo_tab" , "id" , "tagid");
            $ret['data'] = $pobj->rev ? array_reverse($obj->getall() , 1) : $obj->getall();
            $tagids = array_keys($ret['data']);
            $tagids = empty($tagids) ? array(0) : $tagids;
            $obj = OBJ('tag_list_tab');
            $obj->fields('tagid,vod_tab.id as vid , vod_tab.sname , vod_tab.name');
            $vods = $obj->leftjoin('vod_tab', 'refid', 'id')->where("tagid in (" . join(',' , $tagids) . ") and ctype = 3")->getall();
            if(!empty($vods)){
                foreach ($vods as $v){
                    $ret['data'][$v['tagid']]['vod'][]  = $v;
                }
            }
            if(($pn <= 10 || ($pobj->max - $pn) <= 10 ) || ($GLOBALS['_APP']['cttl'] != 1 && !empty($ret) && $cache)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600);
            }
        }
        return $ret;
    }

    /**
     * 获取最新更新
     *
     * @param unknown_type $limit
     * @return unknown
     */
    public static function getlastupdate($limit=12){
        $key = 'misc#lastupdate' . $limit;
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $ret = core::getobj('vod_tab')->fields('id,name,sname,cover,key,desc,actor,cat,region,udate')->where("cover != ''")->order('adate desc')->limit($limit)->getall();
            if(!empty($ret)){
                if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
                    foreach ($ret as &$v){
                        $v['sname'] = $v['id'];
                    }
                }
                foreach ((array)$ret as $k => $v){
                    $tmp = empty($v['actor']) ? array() : explode(',' , $v['actor']);
                    if(count($tmp) > 2){
                        $tmp = array_slice($tmp , 0 , 2);
                    }
                    $ret[$k]['actor'] = $tmp;
                }
                if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                    $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
                }
            }
        }
        return $ret;
    }

    /**
	 * 获取演员的电影
	 *
	 * @param unknown_type $actor
	 * @param unknown_type $limit
	 * @return unknown
	 */
    public static function getactvod($actor , $vid = 0,  $limit = 6){
        $key = 'actor#' . md5($actor . $limit);
        $ret = $GLOBALS['_CACHE']->get($key , '');
        if(IS_DEBUG || empty($ret)){
            $actor = filter::ult($actor);
            $obj = core::getobj('vod_tab');
            $obj->fields('id,name,sname,key,cover,adate,udate')->leftjoin("tag_list_tab"  , "id" , "refid");
            $obj->leftjoin("tag_tab" , "tag_tab.id" , "tag_list_tab.tagid" );
            $obj->where("tag_list_tab.ctype = 3")->where("tag_tab.name = '{$actor}'")->where("id != $vid")->limit($limit);
            $ret = $obj->getall();
            if(!empty($ret) && isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
                foreach ($ret as &$v){
                    $v['sname'] = $v['id'];
                }
            }
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 86400, '');
            }
        }
        return $ret;
    }

    /**
	 * 获取随机数据
	 *
	 * @return unknown
	 */
    public static function getrand($ctype = 3600){
        $ret = array();
        $key = 'misc#seo_' .$ctype;
        $ret = $GLOBALS['_CACHE']->get($key , '');
        if(($ctype == 'robot' && IS_ROBOT ) || empty($ret)){
            $total = core::getobj('vod_tab')->count();
            if($total > 10){
                $ids = array();
                for($i = 0; $i < 10 ; $i++){
                    $ids[] = mt_rand(1 , $total);
                }
                if(!empty($ids)){
                    $ret = core::getobj('vod_tab')->fields('id,name,sname,key')->where("id in (" .join(',' , $ids). ")")->getall();
                }
            }
        }
        if(!empty($ret)){
            $GLOBALS['_CACHE']->set($key, $ret, $ctype == 'robot' ? 600 : intval($ctype));
        }
        return $ret;
    }

    /**
     * 获取所有指定类型
     * @param unknown_type $ctype
     * @return unknown
     */
    public static function getallcat($ctype){
        $key = 'misc#cat_c_' . $ctype;
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $ret = core::getobj('cat_tab')->where("ctype = {$ctype}")->rkey("id")->fields('id,name,sname')->getall();
        }
        if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
            $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
        }
        return $ret;
    }

    /**
     * 获取今日更新数
     *
     * @return unknown
     */
    public static function getupdates(){
        $key = 'mv#updates';
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $day = strtotime(date('Y-m-d', REQUEST_TIME));
            $nday = $day + 86400;
            $ret = core::getobj('vod_tab')->where("adate >= {$day} and adate < {$nday}")->count();
        }
        if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
            $GLOBALS['_CACHE']->set($key, $ret, $nday - REQUEST_TIME);
        }
        return $ret;
    }

    /**
     * 获取地区类别信息
     */
    public static function getregion(){
        $key = 'misc#region';
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $ret = core::getobj('cat_tab')->where("ctype = 3")->rkey("id")->fields('id,name,sname')->getall();
        }
        if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
            $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
        }
        return $ret;
    }

    /**
     * 获取分页数据
     *
     * @param unknown_type $sname
     * @param unknown_type $pn
     * @param unknown_type $where
     * @param unknown_type $order
     * @param unknown_type $psize
     * @return unknown
     */
    public static function getpaged($sname, $pn = 1, $where = '1 = 1', $order = 'udate desc', $psize = 20){
        $ret = array();
        $key = 'page#' . md5($sname . $pn . serialize($where) . $order . $psize);
        $order = str_replace('desc', '#desc#', str_replace('asc', '#asc#', $order));
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $obj = core::getobj('vod_tab');
            $obj->keep();
            if(is_array($where)){
                foreach($where as $v){
                    $obj->where($v);
                }
            }else{
                $obj->where($where);
            }
            $pobj = new page_lib($obj->count(), 'pn', $pn, $psize);
            $ret['pobj'] = $pobj->toarray();
            $obj->clear('fields')->fields('id,sname,name,cover,udate,key,actor,release,region,status,cat,desc')->limit($pobj->limit);
            // 倒序分页
            if($pobj->rev){
                $obj->order(str_replace('#desc#', 'asc', str_replace('#asc#', 'desc', $order)));
            }else{
                $obj->order(str_replace('#', '', $order));
            }
            $ret['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
            if(!empty($ret['data'])){
                foreach($ret['data'] as &$v){
                    if(!empty($v['actor'])){
                        $tmp = explode(',', $v['actor']);
                        $v['actor'] = array_slice($tmp, 0, count($tmp) >= 3 ? 3 : count($tmp));
                        $tmp = array();
                    }
                }
            }
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        return $ret;
    }

    /**
     * 导航分类
     *
     * @return unknown
     */
    public static function getnav($ctype = 0){
        $key = 'misc#nav_' . $ctype;
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $ret = core::getobj('nav_tab')->where("ctype = {$ctype}")->limit(10)->order('sort desc')->getall();
            foreach ($ret as &$v){
                if(substr($v['url'] , 0 ,1) == '@'){
                    $v['code'] = substr($v['url'] , 1);
                    $v['url'] = core::url($v['url']);
                }else{
                    $v['code'] = '#';
                }
                $v['target'] = $v['target'] ? 'target="_blank"' : ' ';
            }
            $GLOBALS['_CACHE']->set($key, $ret, 0);
        }
        return $ret;
    }

    /**
     * 链接
     *
     * @return unknown
     */
    public static function getlink(){
        $key = 'misc#link';
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $ret = core::getobj('link_tab')->limit(12)->order('sort desc')->getall();
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        return $ret;
    }

    /**
     * 获取广告
     *
     * @return mixed
     */
    public static function getads(){
        $key = 'misc#ads';
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $rows = core::getobj('ads_tab')->order('id desc')->where("status = 1")->getall();
            if(!empty($rows)){
                $ret = array();
                foreach($rows as $v){
                    $ret[$v['location']][] = $v;
                }
                $rows = null;
            }
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        return $ret;
    }
    

    /**
     * 获取类别视频
     *
     * @param string $cname
     * @param integer $limit
     * @return array
     */
    public static function getlistbycat($cname, $limit = 10){
        $key = md5($cname . $limit);
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(IS_DEBUG || empty($ret)){
            $cname = filter::text($cname);
            $cat = core::getobj('cat_tab')->where("name = '{$cname}'")->get();
            if(!empty($cat)){
                $scat = join(',', cat_lib::getsubids($cat['id'], $cat['ctype']));
                $ret = core::getobj('vod_tab')->fields('id,sname,name,cover,desc,key')->where("cover != ''")->order("udate desc")->where("cat in ({$scat})")->limit($limit)->getall();
                if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
                    foreach ($ret as &$v){
                        $v['sname'] = $v['id'];
                    }
                }
                if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                    $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
                }
            }
        }
        return $ret;
    }

    /**
     * 获取类别信息
     *
     * @param unknown_type $sname
     * @return unknown
     */
    public static function getcat($sname){
        $key = 'cat#' . md5($sname);
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(empty($ret) || IS_DEBUG){
            if(is_numeric($sname)){
                $ret = core::getobj('cat_tab')->where("id = '{$sname}'")->get();
            }else{
                $ret = core::getobj('cat_tab')->where("sname = '{$sname}'")->get();
            }
            if(!empty($ret)){
                $ret['scat'] = cat_lib::getsubs($ret['id'], $ret['ctype']);
                $ret['pcat'] = self::getparents($ret['path']);
                if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                    $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
                }
            }
        }
        return $ret;
    }

    /**
     * 获取父类
     *
     * @param unknown_type $pstr
     * @return unknown
     */
    public static function getparents($pstr){
        $key = 'cat#' . md5('parents' . $pstr);
        $pstr = str_replace('#', ',', substr($pstr, 1, -1));
        $ret = $GLOBALS['_CACHE']->get($key, '');
        if(empty($ret) || IS_DEBUG){
            $ret = core::getobj('cat_tab')->fields('id,name,sname')->where("id in ({$pstr})")->rkey('sname')->getall();
            if($GLOBALS['_APP']['cttl'] != 1 && !empty($ret)){
                $GLOBALS['_CACHE']->set($key, $ret, isset($GLOBALS['_APP']['cttl']) ? $GLOBALS['_APP']['cttl'] : 3600, '');
            }
        }
        return $ret;
    }
}

?>