<?php
class art_lib{
    

    /**
     * 获取列表
     *
     * @param unknown_type $sname
     * @param unknown_type $order
     * @param unknown_type $limit
     * @param unknown_type $ttl
     * @return multitype:
     */
    public static function getlist($fields = 'id,sname,name,cover', $where = '1=1', $order = 'id desc', $limit = 10){
        $obj = core::getobj('art_tab');
        if(is_array($where) && !empty($where)){
            foreach($where as $v){
                $obj->where($v);
            }
        }else{
            $obj->where($where);
        }
        $ret = $obj->fields($fields)->order($order)->rkey("id")->limit($limit)->getall();
        if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
            foreach ($ret as &$v){
                $v['sname'] = $v['id'];
            }
        }
        return $ret;
    }
    
    /**
     * 获取上下条
     *
     * @param unknown_type $artid
     * @param unknown_type $catid
     * @return unknown
     */
    public static function getnp($artid , $catid = 0){
        $ret = array();
        $ret['next'] = OBJ("art_tab")->fields("id,name,sname,key")->where("cat = $catid and id > $artid")->order("id asc")->get();
        $ret['prev'] = OBJ("art_tab")->fields("id,name,sname,key")->where("cat = $catid and id < $artid")->order("id desc")->get();
        return $ret;
    }
    
    
    /**
     * 获取一条资讯
     *
     * @param unknown_type $sname
     * @return unknown
     */
    public static function get($sname){
        $ret = array();
        $obj = OBJ('art_tab')->where("sname = '$sname' and desc_tab.ctype = 1")->fields("art_tab.*,desc_tab.sdesc");
        $obj->leftjoin("desc_tab" , "id" , "refid");
        $ret = $obj->get();
        return $ret;
    }
    
    /**
     * 获取Tag相关的资讯列表
     *
     * @param unknown_type $name
     * @return unknown
     */
    public static function getlistbytag($id = 0 , $limit = 10){
        $ret = array();
        if(!is_numeric($id) && !is_array($id)){
            $id = filter::text($id);
            $row = OBJ('tag_tab')->fields("id")->where("name = '$id'")->get();
            $id  = array(intval(isset($row['id']) ? $row['id'] : 0));
        }else if(is_numeric($id)){
            $id = array($id);
        }
        if(!empty($id)){
            foreach ((array)$id as $k => $v){
                if(!is_numeric($v)){
                    $tmp = OBJ('tag_tab')->fields("id")->where("name = '$v'")->get();
                    if(!empty($tmp)){
                        $id[$k] = intval($tmp['id']);
                    }else{
                        unset($id[$k]);
                    }
                }
            }
            $idstr = join(',' , $id);
            $obj = OBJ('tag_list_tab');
            $obj->fields('art_tab.id,art_tab.name,art_tab.sname,art_tab.adate,art_tab.cover');
            $obj->where("tagid in( $idstr ) and ctype = 5")->rkey("id")->innerjoin('art_tab' , 'refid' , 'id');
            $ret = $obj->order("art_tab.adate desc")->limit($limit)->getall();
        }
        return $ret;
    }
    
    
    /**
     * 获取 Tag 关键字 (取前3个tag)
     *
     * @param unknown_type $title
     * @param unknown_type $content
     * @return unknown
     */
    public static function gettags($title){
        $ret = '';
        $kws = ga_lib::getkeywords($title);
        if(!empty($kws)){
            $ret = join(',' , array_slice($kws , 0 , 3));
        }
        return $ret ? $ret : '';
    }
    
    
    /**
     * 采集入库接口
     *
     * @param unknown_type $data
     */
    public static function addnew($data , $ga){
        $ret = array();
        $data['sname'] = py_lib::get(filter::text($data['name']));
        if(isset($data['rimage'])){
            $data['cover'] = $data['rimage'];
        }else{
            $data['cover'] = 'null.gif';
        }
        $data['id']     = 0;
        $data['author'] = $data['source'] = 'mogdy.com';
        $data['status'] = 0;
        $data['hash'] = md5($data['name']);
        $tag  = $data['tag'] = $data['tag'] ? $data['tag'] : self::gettags($data['name']);
        $data['key'] = $tag . ',' . mb_substr(filter::text($data['name']) , 0 , 36 , 'utf-8');
        $desc = $data['sdesc'] = ga_lib::losetags($data['sdesc']);
        $data['desc'] = mb_substr(preg_replace('/\s*/' , '' , filter::text(trim($desc))) , 0 , 80 , 'utf-8');
        if(!empty($data['cat'])){
            // 若开启了自动创建类别
            if($ga['conf']['autocat']){
                $cat = ga_lib::getcat($data['cat'] , $ga['catid'] , 1);
            }
            // 使用采集设置
            else if($ga['catid'] > 0){
                $cat = OBJ('cat_tab')->where("id = {$ga['catid']}")->get();
            }
            // 使用默认分类
            else{
                $cat = ga_lib::getcat('其它资讯' , $ga['catid'] , 1);
            }
        }else{
            if($ga['catid'] > 0){
                $cat = OBJ('cat_tab')->where("id = {$ga['catid']}")->get();
            }else{
                $cat = ga_lib::getcat('其它资讯' , $ga['catid'] , 1);
            }
        }
        $data['cat'] = $cat['id'];
        $dobj = OBJ('desc_tab');
        $aobj = OBJ("art_tab");
        $row  = $aobj->where("hash = '{$data['hash']}'")->get();
        if(!empty($row)){
            $data['cover'] = $data['cover'] == 'null.gif' ? $row['cover'] : $data['cover'];
            $data['cover'] = $data['cover'] ?  $data['cover'] : 'null.gif';
            $data['id']    = $row['id'];
            $data['views'] = $row['views'];
            $data = array_merge($row , $data);
            
        }
        $dobj->set("sdesc" , $desc);
        if($aobj->load($data) && !empty($data['desc'])){
            $ret = $aobj->save();
            if($ret && (int)$ret['code'] === 0){
                $dobj->set("refid" , $ret['msg'])->set("ctype" , 1)->replace();
                if(!empty($tag)){
                    tag_lib::add(5 , $ret['msg'] , $tag);
                }
            }
        }
        return $ret;
    }
}
?>