<?php
/**
 * 类别操作库
 * @author Administrator
 *
 */
class cat_lib{
    
    
    /**
     * 获取顶级分类
     *
     * @param unknown_type $ctype
     * @param unknown_type $parent
     * @param unknown_type $limit
     * @return unknown
     */
    public static function gettoplist($parent = 0 , $ctype ,  $limit = 3){
        $obj = OBJ('cat_tab');
        $ret = $obj->fields('id,name,sname,key')->where("ctype = $ctype and parent = $parent ")->order("sort desc")->limit($limit)->getall();
        foreach ((array)$ret as $k => $v){
            $ret[$k]['subcat'] = $obj->fields('id,name,sname,key')->where("parent = {$v['id']}")->order("sort desc")->getall();
        }
        return $ret;
    }
    
    
    /**
     * 新增类别
     *
     * @param unknown_type $name
     * @param unknown_type $ctype
     * @return unknown
     */
    public static function addnew($name , $ctype = 0 , $parent = 0){
        $ret = array();
        $obj = OBJ('cat_tab');
        $cat['id']     = 0;
        $cat['path']   = '#0#';
        $cat['parent'] = $parent;
        if($parent > 0){
            $parent = $obj->where("id = $parent ")->get();
            if(!empty($parent)){
                $cat['path'] = $parent['path'] . $parent['id'] .'#';
            }
        }
        $cat['name']  = filter::text($name);
        $cat['ctype'] = $ctype;
        $cat['sort']  = 0;
        $cat['cover'] = 'images/null.gif';
        $cat['key']   = $cat['name'];
        $cat['desc']  = $cat['name'];
        $cat['sname'] = py_lib::get($cat['name'] , '');
        if($obj->load($cat)){
            $ret = $obj->save();
            if((int)$ret['code'] === 0){
                $ret = intval($ret['msg']);
            }
        }
        return $ret;
    }

    /**
     * 获取下属类别id(含当前id)
     *
     * @param unknown_type $catid
     * @param unknown_type $ctype
     * @return unknown
     */
    public static function getsubs($catid, $ctype = 0){
        $catid = intval($catid);
        $ctype = intval($ctype);
        return core::getobj('cat_tab')->fields('id,name,sname')->rkey('id')->where("ctype = $ctype ")->where("id = {$catid} or instr(path , '#{$catid}#')")->getall();
    }

    /**
     * 类别删除
     *
     * @param unknown_type $list
     */
    public static function del($ids){
        $list = core::getobj('cat_tab')->where("id in (" . join(',' , $ids) . ")")->getall();
        foreach ($list as $v){
            $modfile = BASE_PATH . 'include' . DIR_SEP . 'mod' . DIR_SEP . $v['sname'] . '.mod.php';
            if(file_exists($modfile)){
                unlink($modfile);
            }
        }
        core::getobj('cat_tab')->where("id in (" . join(',' , $ids) . ")")->del();
    }

    /**
     * 获取下属类别
     *
     * @param unknown_type $catid
     * @param unknown_type $ctype
     * @return unknown
     */
    public static function getsubids($catid, $ctype = 0){
        $catid = intval($catid);
        $ctype = intval($ctype);
        $ret = core::getobj('cat_tab')->fields('id')->rkey('id')->where("ctype = $ctype ")->where("id = $catid or instr(path , '#{$catid}#')")->getall();
        return array_keys($ret);
    }

    /**
     * 创建类别入口文件
     *
     * @param string $sname
     */
    public static function create($sname , $ctype = 0){
        $file = BASE_PATH . 'include' . DIR_SEP . 'mod' . DIR_SEP . $sname . '.mod.php';
        if(preg_match('/^[a-z]+$/i', $sname) && !file_exists($file)){
            $tpl = "<?php" . PHP_EOL . "/**" . PHP_EOL . " * {$sname} 模块" . PHP_EOL . " * @time " . date('Y-m-d H:i:s', REQUEST_TIME) . PHP_EOL;
            $tpl .= " * @copyright reginx.com" . PHP_EOL . " * \$Id$" . PHP_EOL . " */". PHP_EOL;
            $tpl .= "class {$sname}_mod extends base_mod {" . PHP_EOL . PHP_EOL;
            $tpl .= "   public function __construct(\$param = array()){" . PHP_EOL;
            $tpl .= "       parent::__construct(\$param , $ctype);" . PHP_EOL;
            $tpl .= "   }" . PHP_EOL . PHP_EOL;
            $tpl .= "}?>";
            file_put_contents($file, $tpl , LOCK_EX);
        }
    }

    /**
     * 修复类别模块, 检测模块文件是否存在. 不存在, 重新创建之.
     *
     */
    public static function repair($ctype = null){
        core::getobj('cat_tab')->fields('sname,ctype');
        if($ctype !== null){
            core::getobj('cat_tab')->where("ctype = $ctype ");
        }
        $list = core::getobj('cat_tab')->getall();
        foreach ($list as $v){
            $modfile = BASE_PATH . 'include' . DIR_SEP . 'mod' . DIR_SEP . $v['sname'] . '.mod.php';
            if(!file_exists($modfile)){
                self::create($v['sname'] , $v['ctype']);
            }
        }
    }
}
?>