<?php
/**
 * 配置
 * @copyright reginx.com
 * $Id: config.lib.php 155 2013-03-05 06:54:52Z reginx $
 */
class config_lib {
	
    /**
     * deny types
     *
     * @var array
     */
    public static $dctype = array(
        0   => '管理登录',
        1   => '内容搜索',
        2   => '发表评论',
        3   => '会员登录'
    );
    
    public static $astatus = array(
        0   => '默认',
        1   => '推荐'
    );
    
    /**
     * 插件/钩子 类型
     *
     * @var unknown_type
     */
    public static $pctype = array(
	   0   => '默认',
	   1   => '播放',
	   2   => '播放页tips',
	);
	
	
	/**
	 * 安装配置
	 *
	 * @var unknown_type
	 */
    public static $ins = array(
        0    => array(
                'text'    => '环境检测',
                'list'    => array(
                       'gd_info'      => 'GD 图像处理库支持',
                       'mb_substr'    => 'MB 多字节字符处理支持',
                       'curl_exec'    => 'CURL 扩展支持  ',
                )
        ),
        1    => array(
                'text'    => '权限检测',
                'list'    => array(
                       'dp'    => '资源目录权限',
                       'ip'    => '模块目录权限',
                 )
       ),
    );

    /**
     * 广告位置
     *
     * @var unknown_type
     */
    public static $alocal = array(
        0   => '全站',
        1   => '全站横幅',
        2   => '首页新片下侧',
        3   => '首页电影下侧',
        4   => '首页电视剧下侧',
        5   => '全站底部',
        7   => '内容页/播放页右侧',
        8   => '内容页/播放页热门下侧',
        9   => '播放缓冲页',
        10  => '播放暂停页',
        11  => '播放结束页',
        12  => '播放器下侧',
        13  => '演员页右侧'

    );

    /**
     * 广告类型
     *
     * @var unknown_type
     */
    public static $actype = array(
        0   => '文字链接',
        1   => '图片链接',
        2   => '脚本代码',
        3   => '脚本文件',
    );


    /**
     * 类别
     *
     * @var unknown_type
     */
    public static $ctype = array(
        1   => '资讯类别',
        2   => '视频类别',
        3   => '地区类别',
    );

    public static $region = array(
        1   => '大陆',
        2   => '港台',
        3   => '日韩',
        4   => '欧美',
        5   => '新马泰'
    );

    /**
     * Tag类别
     *
     * @var unknown_type
     */
    public static $ttype = array(
        2   => '导演标签',
        3   => '演员标签',
        4   => '片名标签',
        5   => '资讯标签'
    );

    public static $nav = array(
        0   => array(
            'text'  => '快捷菜单',
            'list'  => array(
                'system-info'       => '管理首页',
                'nav-list'          => '导航管理',
                'ads-list'          => '广告列表',
                'plugin-list'       => '插件列表',
            )
        ),
        1   => array(
            'text'  => '资讯管理',
            'list'  => array(
                'cat-list-ctype-1'  => '资讯类别',
                'art-list'          => '资讯列表',
                'tag-list-ctype-5'  => '资讯标签',
                'reply-list-ctype-1'=> '资讯评论',
                'ga-list-ctype-1'   => '资讯采集',
            )
        ),
        2   => array(
            'text'  => '影片管理',
            'list'  => array(
                'cat-list-ctype-2'  => '视频类别',
                'cat-list-ctype-3'  => '地区类别',
                'vod-list'          => '影片列表',
                'vod-rank'          => '影片排行',
                'tag-list-ctype-2'  => '导演标签',
                'tag-list-ctype-3'  => '演员标签',
                'tag-list-ctype-4'  => '片名标签',
                'ga-list-ctype-2'   => '影片采集',
                'reply-list-ctype-2'=> '影片评论',
                'reply-db'          => '影评采集',
            )
        ),
        5   => array(
            'text'  => '其他管理',
            'list'  => array(
                'others-slider'     => '首页轮播',
                'user-list'         => '会员管理',
                'tpl-list'          => '模板管理',
                'block-list'        => '数据标签',
                'stat-list'         => '数据统计',
                'link-list'         => '友情链接',
                'system-clear'      => '附件清理',
                'db-backup'	        => '系统备份',
                'plugin-store'      => '扩展中心',
                'deny-list'         => '防水墙',
            )
        ),
    );
    
    /**
     * 导航位置配置
     *
     * @var unknown_type
     */
    public static $nctype = array(
    	0			=> '头部',
    	1			=> 'seo',
    	2           => '底部',
    	3           => '快捷菜单'
    );
    
    /**
     * 系统保留的模块名称
     *
     * @var unknown_type
     */
    public static $syscname = array(
        'actor' , 'ad' , 'art' , 'base' , 'dir' , 'index' , 'install' , 'login' , 'mogvs' ,
        'player' , 'plugin' , 'reg' , 'search' , 'tag' , 'user' , 'view'
    );

    /**
     * 播放器
     *
     * @var unknown_type
     */
    public static $player = array(
        'default'   => array(
            'name'  => '默认播放',
            'ext'   => '.flv,.f4v,'
        ),
        'bdhd'      => array(
            'name'    => '百度影音',
            'pre'     => 'bdhd',
            'ext'     => '.rvmb,.avi,.wmv'
        ),
        'ftp'      => array(
            'name'    => 'ftp',
            'pre'     => 'ftp,http'
        ),
        'qvod'      => array(
            'name'    => 'QVOD快播',
            'pre'     => 'qvod'
        ),
        'thunder'   => array(
            'name'    => '迅雷下载',
            'pre'     => 'thunder'
        ),
        'Flashget'  => array(
            'name'    => 'Flashget',
            'pre'     => 'Flashget'
        ),
        'qqdl'      => array(
            'name'    => '旋风下载',
            'pre'     => 'qqdl'
        ),
        'ed2k'       => array(
            'name'  => '电驴下载',
            'pre'   => 'ed2k'
        ),
        'swf'       => array(
            'name'  => 'Flash播放',
            'ext'   => 'swf'
        )
    );

    /**
     * 播放器
     *
     * @var unknown_type
     */
    public static $vstatus = array(
        0   => '全集',
        1   => '连载中',
    );

    /**
     * 语言
     *
     * @var unknown_type
     */
    public static $vlang = array(
        0   => '未知',
        1   => '国语中字',
        2   => '粤语中字',
        3   => '中英双语',
    );

    public static $gastep = array(
        array('name' , 'url' , 'gctype')
    );

    /**
     * 修改配置项
     *
     * @param unknown_type $key
     * @param unknown_type $v
     */
    public static function mod($key , $v){
        $conf = self::load();
        if(isset($conf[$key])){
            $conf[$key] = $v;
            self::store($conf);
        }
    }
    
    /**
     * 持久化用户自定义配置文件
     *
     * @param unknown_type $config
     * @param unknown_type $configfile
     * @return unknown
     */
    public static function store($config = array() , $configfile = 'config.ini.php' , $merge = true){
        if(!empty($config)){
            foreach ($config as &$v){
                if($v == 'false' || $v == 'true'){
                    $v = filter_var($v, FILTER_VALIDATE_BOOLEAN);
                }else if(is_numeric($v)){
                    if(($v = filter_var($v , FILTER_VALIDATE_INT)) === false){
                        $v = filter_var($v , FILTER_VALIDATE_FLOAT);
                    }
                }else{
                    if(!is_array($v)){
                        $v = filter::code($v);
                    }
                }
            }
            if($merge){
                $config = array_merge(self::load($configfile) , $config);
            }
            $str  = "<?php\r\n/**\r\n";
            $str .= " *  @Created By Reginx v".REGINX_VERSION." user config file\r\n";
            $str .= " *  @Time:" . date('Y-m-d H:i:s' , REQUEST_TIME) . "\r\n */";
            $str .= "\r\nreturn " . var_export($config , true) .  ";\r\n?>";
        }
        return file_put_contents(DATA_PATH . $configfile , $str , LOCK_EX);
    }

    /**
     * 读取自定义配置文件信息
     *
     * @param unknown_type $configfile
     * @return unknown
     */
    public static function load($configfile = 'config.ini.php'){
        $ret = array();
        if(is_file(DATA_PATH . $configfile)){
            $ret = include(DATA_PATH . $configfile);
        }
        return empty($ret) ? array() : $ret;
    }
}
?>