<?php
/**
 * CURL封装类
 * @copyright reginx.com
 * $Id: curl.lib.php 146 2013-01-22 09:59:59Z reginx.com@gmail.com $
 */
class curl_lib {

    /**
     * UA
     *
     * @var unknown_type
     */
    static $ua  = 'Mozilla/5.0 (Windows NT 6.1; rv:21.0) Gecko/20100101 Firefox/21.0';

    /**
     * 引用地址
     *
     * @var unknown_type
     */
    static $ref = 'http://www.baidu.com/';

    /**
     * ip
     *
     * @var unknown_type
     */
    static $ip  = '60.28.17.47';

    /**
     * 抓取远程内容
     *
     * @param unknown_type $url
     */
    static function get($url , $param = array()){
        $s = curl_init();
        curl_setopt($s , CURLOPT_URL , $url);
        curl_setopt($s , CURLOPT_TIMEOUT , 15);
        curl_setopt($s , CURLOPT_RETURNTRANSFER , 1);
        curl_setopt($s , CURLOPT_REFERER     , self::$ref);
        curl_setopt($s , CURLOPT_USERAGENT   , self::$ua);
        curl_setopt($s , CURLOPT_FOLLOWLOCATION , 1);
        //curl_setopt($s , CURLOPT_HTTPHEADER  , self::getHeaders());
        $ret = curl_exec($s);
        curl_close($s);
        return $ret;
    }

    /**
     * 抓取远程图片
     *
     * @param unknown_type $url
     */
    static function getimage($url , $param = array()){
        $s = curl_init();
        $url = str_replace(' ' , '%20' , $url);
        curl_setopt($s , CURLOPT_URL , $url);
        curl_setopt($s , CURLOPT_TIMEOUT , 15);
        curl_setopt($s , CURLOPT_RETURNTRANSFER , 1);
        curl_setopt($s , CURLOPT_USERAGENT   , self::$ua);
        if(isset($param['gref'])){
            curl_setopt($s , CURLOPT_REFERER     , $param['gref']);
        }else{
            curl_setopt($s , CURLOPT_REFERER     , self::$ref);
        }
        if(isset($param['gcookie'])){
            curl_setopt($s, CURLOPT_COOKIEJAR  , $param['gcookie']);
            curl_setopt($s, CURLOPT_COOKIEFILE , $param['gcookie']);
        }
        curl_setopt($s , CURLOPT_FOLLOWLOCATION , 1);
        $ret = curl_exec($s);
        if(curl_getinfo($s , CURLINFO_HTTP_CODE) != '200' || !preg_match('/image\/(jpg|jpeg|gif|png|bmp)/i' , curl_getinfo($s , CURLINFO_CONTENT_TYPE))){
            $ret = false;
        }
        curl_close($s);
        return $ret;
    }

    static function gethtml($url , $param = array()){
        $ret = array();
        $s = curl_init();
        curl_setopt($s , CURLOPT_URL , $url);
        curl_setopt($s , CURLOPT_TIMEOUT , 25);
        curl_setopt($s , CURLOPT_RETURNTRANSFER , 1);
        curl_setopt($s , CURLOPT_USERAGENT   , self::$ua);
        // gzip
        if(isset($param['gzip'])){
            curl_setopt($s, CURLOPT_ENCODING, 'gzip');
        }
        // post
        if(isset($param['post'])){
            curl_setopt($s, CURLOPT_POST, 1);
            curl_setopt($s, CURLOPT_POSTFIELDS, $param['post']);
        }
        if(isset($param['header']) && is_array($param['header'])){
            curl_setopt($s , CURLOPT_HTTPHEADER , $param['header']);
        }
        if(isset($param['gref'])){
            curl_setopt($s , CURLOPT_REFERER     , $param['gref']);
        }else{
            curl_setopt($s , CURLOPT_REFERER     , self::$ref);
        }
        if(isset($param['gheader'])){
            curl_setopt($s , CURLOPT_HEADER , 1);
        }
        if(isset($param['gcookie'])){
            curl_setopt($s, CURLOPT_COOKIEJAR  , $param['gcookie']);
            curl_setopt($s, CURLOPT_COOKIEFILE , $param['gcookie']);
        }
        curl_setopt($s , CURLOPT_FOLLOWLOCATION , 1);
        $ret['html'] = curl_exec($s);
        $rheader = curl_getinfo($s);
        $ret['code'] = $rheader['http_code'];
        $ret['header'] = $rheader;
        // http header 获取编码设置
        if(!empty($rheader['content_type'])){
            $charset = array();
            preg_match('/charset=([\w\-]+)/i' , $rheader['content_type'] , $charset);
            $ret['charset'] = empty($charset[1]) ? false : $charset[1];
        }
        // html代码获取编码设置
        if(!$ret['charset'] && !empty($ret['html'])){
            preg_match('/<meta.+?charset=[^\w]?([-\w]+)/is' , $ret['html'] , $m);
            $ret['charset'] = $m[1];
        }
        // 转码
        if(!empty($ret['charset']) && $ret['charset'] != 'utf-8'){
            $ret['charset'] = $ret['charset'] == 'gb2312' ? 'gbk' : $ret['charset'];
            $ret['html'] = mb_convert_encoding($ret['html'] , 'utf-8'  , $ret['charset']);
        }
        curl_close($s);
        return $ret;
    }

    static function getHeaders(){
        $ip = mt_rand(90 ,  90).'.'.mt_rand(20 ,  90).'.'.mt_rand(20 ,  90).'.'.mt_rand(20 ,  90);
        return array('X-FORWARDED-FOR:'.$ip , 'CLIENT-IP:'.$ip  ,  'REMOTE-ADDR:' . $ip);
    }
}
?>