<?php
/**
 * 采集类库
 * @copyright reginx.com
 * $Id$
 */
class gather_lib{

    public static $detail = array(
        'name'     => array(
            'key'       => 'name',
            'name'      => '影片名称',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片名称匹配规则',
            'errmsg'    => '请输入影片名称匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'cat'      => array(
            'key'       => 'cat',
            'name'      => '影片类别',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片类别匹配规则',
            'errmsg'    => '请输入影片类别匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'region'   => array(
            'key'       => 'region',
            'name'      => '影片地区',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片地区匹配规则',
            'errmsg'    => '请输入影片地区匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'status'   => array(
            'key'       => 'status',
            'name'      => '影片状态',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片状态匹配规则',
            'errmsg'    => '请输入影片状态匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'cover'    => array(
            'key'       => 'cover',
            'name'      => '影片封面',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片封面匹配规则',
            'errmsg'    => '请输入影片封面匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'actor'     => array(
            'key'       => 'actor',
            'name'      => '影片主演',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片主演匹配规则',
            'errmsg'    => '请输入影片主演匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'director'      => array(
            'key'       => 'director',
            'name'      => '影片导演',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片导演匹配规则',
            'errmsg'    => '请输入影片导演匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'release'      => array(
            'key'       => 'release',
            'name'      => '上映时间',
            'rule'      => 'require',
            'nullmsg'   => '请输入上映时间匹配规则',
            'errmsg'    => '请输入上映时间匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'udate'    => array(
            'key'       => 'udate',
            'name'      => '更新时间',
            'rule'      => 'require',
            'nullmsg'   => '请输入更新时间匹配规则',
            'errmsg'    => '请输入更新时间匹配规则',
            'desc'      => '例如: &lt;b&gt;#时间#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'info'     => array(
            'key'       => 'info',
            'name'      => '影片介绍',
            'rule'      => 'require',
            'nullmsg'   => '请输入影片介绍匹配规则',
            'errmsg'    => '请输入影片介绍匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        ),
        'vpurl'     => array(
            'key'       => 'vpurl',
            'name'      => '播放地址',
            'rule'      => 'require',
            'nullmsg'   => '请输入播放地址匹配规则',
            'errmsg'    => '请输入播放地址匹配规则',
            'desc'      => '例如: &lt;b&gt;#内容#&lt;/b&gt;',
            'ptag'      => true,
            'radio'     => false
        )
    );
    /**
     * 采集规则配置条目
     *
     * @var unknown_type
     */
    public static $rule = array(
        array(
            'key'       => 'burl',
            'name'      => '目标地址',
            'rule'      => 'url',
            'nullmsg'   => '请输入目标地址',
            'errmsg'    => '请输入正确的目标地址',
            'desc'      => '例如: http://hao.uoso.net/ , 以 / 结尾',
            'ptag'      => false,
            'radio'     => false,
        ),
        array(
            'key'       => 'desc',
            'name'      => '简单采集',
            'ptag'      => false,
            'radio'     => true ,
        ),
        array(
            'key'       => 'srimg',
            'name'      => '存储远程图片',
            'ptag'      => false,
            'radio'     => true ,
        ),
        array(
            'key'       => 'pexp',
            'name'      => '分页表达式',
            'rule'      => 'require',
            'nullmsg'   => '请输入分页表达式',
            'errmsg'    => '请输入正确的分页表达式',
            'desc'      => '例如: ?s=vod-show-id-#数字#.html , 不带域名',
            'ptag'      => false,
            'radio'     => false,
        ),
        array(
            'key'       => 'pvurl',
            'name'      => '详情页地址表达式',
            'rule'      => 'require',
            'nullmsg'   => '请输入详情页地址表达式',
            'errmsg'    => '请输入正确的详情页地址表达式',
            'desc'      => '例如: ?s=vod-read-id-#数字#.html , 不带域名',
            'ptag'      => false,
            'radio'     => false,
        ),
    );

    /**
     * 格式化表达式
     *
     * @param unknown_type $desc
     * @return unknown
     */
    public static function format($desc = array()){
        if(!empty($desc)){
            foreach ($desc as $k => &$v){
                if($k == 'burl'){
                    if(substr($v , -1) != '/'){
                        $v .= '/';
                    }
                }else{
                    if(strpos($v , 'http://' ) !== false){
                        $v = str_replace($desc['burl'] , '' , $v);
                    }
                    $v = filter::html($v);
                }
            }
        }
        return $desc;
    }

    /**
     * 处理regex 表达式
     *
     * @param unknown_type $desc
     * @return unknown
     */
    public static function regex($desc){
        $repl = array(
        array('#数字#' , '#内容#' , '#时间#'),
        array('(\d+)' , '(.+?)'  , '(\d{4}(?:-|\/)\d{1,2}(?:-|\/)\d{1,2}(?: \d{1,2}:\d{1,2}(?:\:\d{1,2})?)?)')
        );
        if(!empty($desc)){
            foreach ($desc as $k => &$v){
                if($k != 'burl' && is_string($v)){
                    $v = str_replace($repl[0] , $repl[1] , preg_quote(html_entity_decode($v , ENT_QUOTES) , '/'));
                }
            }
        }
        return $desc;
    }

    public static function unquote($desc){
        if(!empty($desc)){
            foreach ($desc as $k => &$v){
                if($k != 'burl'){
                    $v = str_replace('\\' , '' , $v);
                }
            }
        }
        return $desc;
    }

    /**
     * 获取采集记录
     *
     * @param unknown_type $id
     * @return unknown
     */
    public static function get($id , $cache = false){
        $ret = array();
        $key = 'ga@' . $id;
        // 读取缓存
        if($cache && !IS_DEBUG){
            $ret = $GLOBALS['_CACHE']->get($key , '');
        }
        if(empty($ret)){
            $ret = core::getobj('gather_tab')->where("id = $id")->get();
            $ret['desc'] = $ret['desc'] ? unserialize(base64_decode($ret['desc'])) : array();
            $cache && $GLOBALS['_CACHE']->set($key , $ret , 3600 , '');
        }
        return $ret;
    }

    public static function getvod($url , $regex){
        $ret = array();
        $ret['ref'] = $url;
        $res  = curl_lib::gethtml($url);
        $ret['code'] = $res['code'];
        if(!empty($regex) && $res['code'] == '200'){
            $list = array_keys(self::$detail);
            foreach ($list as $v){
                if(!empty($regex[$v])){
                    $match = array();
                    preg_match_all('/' .$regex[$v] . '/is' , $res['html'] , $match);
                    if(!empty($match[1][0])){
                        if(count($match[1]) > 1){
                            array_map(array('filter' , 'text') , $match[1]);
                            $ret[$v] = preg_replace('/(　)+/' , '' , $match[1]);
                        }else{
                            if($v == 'actor' || $v == 'director'){
                                $match[1][0] = preg_replace('/(\s|\&nbsp\;)+/' , ',' , trim($match[1][0]));
                            }
                            $ret[$v] = preg_replace('/(　)+/' , '' , filter::text($match[1][0]));
                        }
                    }
                }
            }
        }
        $res = null;
        return $ret;
    }

    /**
     * 保存远程图片
     *
     * @param unknown_type $url
     * @param unknown_type $tw
     * @param unknown_type $th
     * @return unknown
     */
    public static function srimg($url ,$tw = 0 , $th = 0){
        $sfile  = date('Y-m-d',REQUEST_TIME) . '/';
        if(!is_dir(UPLOAD_PATH . $sfile)){
            core::makedir(UPLOAD_PATH . $sfile);
        }
        $sfile .= 'http_' . REQUEST_TIME . mt_rand(100,999) . '.jpg';
        $image  = curl_lib::getimage($url);
        if(!empty($image) && file_put_contents(UPLOAD_PATH . $sfile , $image  , LOCK_EX) !== false){
            $tw = $tw ? $tw : $GLOBALS['_APP']['thumb_width'];
            $th = $th ? $th : $GLOBALS['_APP']['thumb_height'];
            image_lib::thumb(UPLOAD_PATH . $sfile , 'auto' , $tw , $th);
        }else{
            $sfile = '';
        }
        return $sfile;
    }

    /**
     * 映射
     *
     * @param unknown_type $map
     * @return unknown
     */
    public static function vmap($map){
        if(!empty($map)){
            $map = explode("\n" , $map);
            $obj = core::getobj('cat_tab');
            for ($i=0;$i<count($map);$i++){
                $temp = explode(':' , $map[$i]);
                $cat  = trim(filter::text($temp[1]));
                if(!is_numeric($cat)){
                    $row = $obj->where("name = '{$cat}'")->fields('id')->get();
                    if(empty($row)){
                        unset($map[$i]);   
                    }else{
                        $catstr  = filter::text($temp[0] . ':' . ($row['id'] ? $row['id'] : $temp[1]));
                        $map[$i] = preg_replace('/\s+/' , '' , $catstr);
                    }
                    $row = null;
                }
            }
        }
        return $map;
    }


    /**
     * 获取本地对应类别
     *
     * @param unknown_type $cat
     * @param unknown_type $map
     * @return unknown
     */
    public static function getcat($cat , $map = array()){
        $cat = filter::text($cat);
        $obj = core::getobj('cat_tab');
        $catid = 0;
        if(!empty($map)){
            foreach ($map as $v){
                if(strpos($v , $cat . ":") !== false){
                    $catid = intval(str_replace($cat . ":" , '' , $v));
                }
            }
        }
        if($catid === 0){
            $row = $obj->where(" ctype = 2 and name = '{$cat}'")->get();
            if(empty($row)){
                $ret = $obj->set("id" , 0)->set("sname" , py_lib::get($cat , ''))->set('parent' , 0)->set("path" , '#0#')->set('ctype' , 2)->set("name" , $cat)->save();
                //die;
                $row['id'] = intval($ret['msg']);
            }
            $catid = $row['id'];
        }
        return $catid;
    }


    public static function getregion($region , $map = array()){
        $cat = filter::text($region);
        $obj = core::getobj('cat_tab');
        $catid = 0;
        if(!empty($map)){
            foreach ($map as $v){
                if(strpos($v , $cat . ":") !== false){
                    $catid = intval(str_replace($cat . ":" , '' , $v));
                }
            }
        }
        if($catid === 0){
            $row = $obj->where("ctype = 3 and name = '{$cat}'")->get();
            if(empty($row)){
                $ret = $obj->set("id" , 0)->set("sname" , py_lib::get($cat , ''))->set('parent' , 0)->set("path" , '#0#')->set('ctype' , 3)->set("name" , $cat)->save();
                $row['id'] = intval($ret['msg']);
            }
            $catid = $row['id'];
        }
        return $catid;
    }

    /**
     * 获取状态码
     *
     * @param unknown_type $status
     * @return unknown
     */
    public static function getstatus($status){
        if(strpos(filter::text($status) , '连') !== false){
            return 1;
        }
        return 0;
    }
    
    

    /**
     * 获取语言
     *
     * @param unknown_type $status
     * @return unknown
     */
    public static function getlang($status){
        return intval(array_search($lang , config_lib::$vlang));
    }

    public static function getpurl($url){
        $temp = $ret =  array();
        if(is_array($url)){
            foreach ($url as $k => $v){
                $match = array();
                //preg_match('/^(\w+?)\:\/\//i' , $v , $match);
                $player = vod_lib::getplayer($v);
                $temp[$player][] = $v;
            }
            foreach ($temp as &$v){
                foreach ($v as $k => &$sv){
                    $ret[] = ($k+1) .'#'. $sv;
                }
            }
        }else{
            $ret = '1#' . $url;
        }
        return $ret;
    }
}
?>