<?php
/**
 * 分页类
 * @copyright reginx.com
 * $Id: page.lib.php 76 2013-02-17 14:15:51Z reginx $
 */
class page_lib{

    /**
     * 最大页数
     *
     * @var unknown_type
     */
    public $max = 0;

    /**
     * 每页显示条数
     *
     * @var unknown_type
     */
    public $psize = 10;

    /**
     * 当前页码
     *
     * @var unknown_type
     */
    public $pn = 1;

    /**
     * 共计条数
     *
     * @var unknown_type
     */
    public $total = 0;

    /**
     * sql limit
     *
     * @var unknown_type
     */
    public $limit = 0;

    /**
     * url 页码变量名称
     *
     * @var unknown_type
     */
    public $varName   = 'pn';

    /**
     * 是否反转排序 (倒序分页法)
     *
     * @var unknown_type
     */
    public $rev  = false;

    /**
     * 页面url
     *
     * @var unknown_type
     */
    public $url  = '';

    /**
     * 倒序分页排序方式
     *
     * @var unknown_type
     */
    public $desc = 'desc';

    /**
     * 前后页变量 , 内容为pn
     *
     * @var unknown_type
     */
    public $link = array();

    /**
     * 架构函数
     *
     * @param Integer $total
     * @param String $varName
     * @param Integer $pid
     * @param Integer $psize
     * @param String $desc
     */
    function __construct($total = 0 , $var = 'pn' , $pid=1 , $psize = 10 , $desc='desc' , $size = 3 , $url = null){
        $this->var      = $var;
        $this->total    = $total;
        $this->psize    = $psize;
        $this->pn       = $pid;
        $this->desc     = $desc;
        $this->url      = $url;
        if(!$this->url){
            $this->url      = preg_replace('/\-?'.preg_quote($var) . '(\-|\_|\=)\d+/i' , "" , core::geturl());
        }
        $this->init();
        $this->link($size);
    }

    /**
     * 初始化
     *
     */
    function init(){
        //初始化总页数
        if($this->total % $this->psize==0){
            $this->max = $this->total / $this->psize;
        }else{
            $this->max = intval($this->total / $this->psize)+1;
        }
        //页码控制
        if($this->pn >= $this->max){
            $this->pn = $this->max;
        }elseif($this->pn <= 0){
            $this->pn = 1;
        }
        //初始化SQL参数
        $this->limit = ($this->pn - 1) * $this->psize.",".$this->psize;
        if($this->total <= 0){
            $this->limit = "0,0";
        }
        //使用倒序分页法
        if($this->pn >= intval($this->max / 2) && $this->max > 100){
            $this->limit = (($this->max - $this->pn) * $this->psize ) . "," . $this->psize;
            $this->desc = $this->desc == 'desc' ? 'asc' : 'desc';
            $this->rev  = TRUE;
        }
    }

    /**
     * 获取前后页
     *
     * @param unknown_type $size
     */
    public function link($size){
        $m = ceil($size / 2);
        $start = ($this->pn - $m >= 2) ? ($this->pn - $m + 1) : 2;
        $end   = ($this->pn + $size - $m) < $this->max ? $start + $size : $this->max;
        $end   = $end < $this->max ? $end : $this->max;
        if($end - $start < $size ){
            $start = $start- ($size - $end + $start);
        }
        $start = $start > 1 ? $start : 2;
        if($start > 2){
            $this->link[] = '...';
        }
        for($i = $start ; $i < $end ; $i++){
            $this->link[$i] = $i;
        }
        if($end <= $this->max - 1){
            $this->link[] = '..';
        }
    }

    /**
     * 转换成数组
     *
     * @return unknown
     */
    function toarray(){
        return get_object_vars($this);
    }

}
?>