<?php
/**
 * QQ 互联操作库
 * @copyright reginx.com
 * $Id$
 */
class qc_lib{
    
    /**
     * 获取token地址
     *
     * @var unknown_type
     */
    private static $tokenurl = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&";
    
    
    /**
     * 登录验证地址
     *
     * @var unknown_type
     */
    private static $loginurl = 'https://graph.qq.com/oauth2.0/authorize?';
    
    
    /**
     * 获取 QC 登录跳转地址
     *
     * @param unknown_type $appid
     * @param unknown_type $appkey
     * @return unknown
     */
    public static function login($appid ,  $scope , $state , $ref = ''){
        $req['state'] = $state;
        $req['scope'] = $scope;
        $req['whick'] = 'Login';
        $req['client_id'] = $appid;
        $req['response_type'] = 'code';
        $ref = $ref ? $ref : base64_encode(core::url('index'));
        $req['redirect_uri'] = core::url('login-cb-skey-qc-ref-%s-ret-|false' , $ref);
        return self::$loginurl . http_build_query($req);
    }
    
    /**
     * 获取Access Token && OpenID
     *
     * @param unknown_type $appid
     * @param unknown_type $appkey
     * @param unknown_type $code
     * @param unknown_type $state
     * @return unknown
     */
    public static function gettoken($appid , $appkey , $code , $state){
        $ret = array('code' => 1 , 'msg' => 'unkown error');
        $req['state'] = $state;
        $req['code']  = $code;
        $req['client_id'] = $appid;
        $req['client_secret'] = $appkey;
        $req['redirect_uri'] = core::url('login-cb-skey-qc-ret-|false');
        $url = self::$tokenurl . http_build_query($req);
        $res = file_get_contents($url);
        if(strpos($res, "callback") !== false){
             $lpos = strpos($res, "(");
             $rpos = strrpos($res, ")");
             $res  = substr($res, $lpos + 1, $rpos - $lpos -1);
             $ret  = json_decode($res , 1);
        }else{
            $param = array();
            parse_str($res, $params);
            $url = "https://graph.qq.com/oauth2.0/me?access_token=" . $params['access_token'];
            $res = file_get_contents($url);
            if(strpos($res, "callback") !== false){
                 $lpos = strpos($res, "(");
                 $rpos = strrpos($res, ")");
                 $res  = substr($res, $lpos + 1, $rpos - $lpos -1);
            }
            $ret = json_decode($res , 1);
            $ret['code'] = isset($ret['code']) ? $ret['code'] : 0;
            $ret['token'] = $params['access_token'];
            $ret['appid'] = $appid;
        }
        return $ret;
    }
    
    /**
     * 获取用户信息
     *
     * @param unknown_type $param
     * @return unknown
     */
    public static function getuser($param){
        $url = 'https://graph.qq.com/user/get_user_info?access_token=%s&oauth_consumer_key=%s&openid=%s';
        $url = sprintf($url , $param['token'] , $param['appid'] , $param['openid']);
        $ret =  json_decode(file_get_contents($url) , 1);
        return array_merge($ret , $param);
    }
    
}// End Class
?>