<?php
/**
 * 评论库
 * @copyright reginx.com
 * $Id$
 */
class reply_lib{

	/**
	 * url 配置
	 *
	 * @var unknown_type
	 */
	public static $conf = array(
		'db'	=> 'http://movie.douban.com/subject_search?cat=1002&search_text='
	);
	

	/**
	 * 拉取短评信息
	 *
	 * @param unknown_type $row
	 * @return unknown
	 */
	public static function get($row){
		$ret = array('code' => 1 , 'msg' => '');
		$vid = substr($row['k'] , strpos($row['k'] , '_') + 1);
		if(is_numeric($vid)){
			$res = curl_lib::gethtml("http://movie.douban.com/subject/{$row['v']}/comments?sort=time");
			$reply = $match = array();
			if($res['code'] == '200'){
				preg_match_all('/comment\-info"\>\s+?\<.+?\>(.+?)\<.+?class=""\>\s*([\d\-]+)\s*\<.+?\<p class="">(.+?)\</is' , $res['html'] , $match);
				if(!empty($match[1])){
					$obj = core::getobj('reply_tab');
					foreach ($match[1] as $k => $v){
						if($k >= 10){
							break;
						}
						$obj->set("id" , 0)->set("nick" , filter::ult($v))->set("desc" , filter::ult(filter::text($match[3][$k])));
						$obj->set("adate" , strtotime($match[2][$k]))->set("uid" , 0)->set("name" , "豆瓣短评");
						$obj->set("parent" , 0)->set('vid' , $vid)->save();
					}
					$ret['code'] = 0;
				}
			}else{
                $ret['msg'] = "http://movie.douban.com/subject/{$row['v']}/comments?sort=time";
            }
		}
		return $ret;
	}

	/**
	 * 拉取电影评论详细页地址
	 *
	 * @param unknown_type $id
	 * @param unknown_type $name
	 * @param unknown_type $ctype
	 * @return unknown
	 */
	public static function loadurl($id , $name , $ctype = 'db'){
		$ret = array('code' => 1 , 'msg' => '');
		$name = filter::text($name);
		$pos = strpos($name , '/');
		if($pos !== false){
			$name = substr($name , 0 ,  $pos);
		}
		if(isset(self::$conf[$ctype])){
			$obj = core::getobj('temp_tab');
			$obj->set("k" , 'reply_' . $id);
			if($ctype == 'db'){
				$match = array();
				$res = curl_lib::gethtml(self::$conf[$ctype] . urlencode($name));
				if($res['code'] == '200'){
					$ret = true;
					preg_match('/subject\/(\d+)\/"\s*onclick\=(?:.+?)moreurl\(this/i' , $res['html'] , $match);
                    $res = array(); unset($res);
                    $subjectid = !empty($match[1]) && is_numeric($match[1]) ? intval($match[1]) : 0;
                    $obj->set("v" , $subjectid);
                    $obj->save();
                    $ret['code'] = 0;
				}else{
                    $ret['msg'] = self::$conf[$ctype] . urlencode($name);
                }
			}
		}
		return $ret;
	}
}
?>