<?php
/**
 * 模板类库
 * @copyright reginx.com
 * $Id$
 */
class tpl_lib {
    
    /**
     * 模板标识(对应 目录名称)
     *
     * @var unknown_type
     */
    public $code = 'default';
    
    /**
     * 模板名称
     *
     * @var unknown_type
     */
    public $name = '默认模板';
    
    /**
     * 模板作者
     *
     * @var unknown_type
     */
    public $author = 'ReGinx';
    
    /**
     * 作者主页
     *
     * @var unknown_type
     */
    public $homepage = 'http://www.reginx.com';
    
    /**
     * 模板缩略图
     *
     * @var unknown_type
     */
    public $thumb = '';
    
    
    
    /**
     * 获取模板介绍信息
     *
     * @return unknown
     */
    public function getdesc(){
        return get_object_vars($this);
    }
    
    
    /**
     * 更新模板所有的Block标签至文件
     *
     * @param unknown_type $name
     */
    public final static function update($name){
        $obj = OBJ('block_tab');
        $list = $obj->where("tpl = '{$name}'")->getall();
        $blockfile = BASE_PATH . 'template/' . $name . '/config/' . $name . '.block.php';
        $data = "<?php\r\n/**\r\n *  @Created By Reginx v" . REGINX_VERSION . " Tpl Block Tags\r\n *  @Time:" . date('Y-m-d H:i:s', REQUEST_TIME) . "\r\n */";
        $data .= "\r\nreturn " . var_export($list, true) . ";\r\n?>";
        file_put_contents($blockfile , $data);
        $data = null; unset($data);
    }
    
    
    /**
     * 模板数据标签安装
     *
     * @return unknown
     */
    public final static  function install($name){
        $ret = array('msg' => '安装失败了');
        $blockfile = BASE_PATH . 'template/' . $name . '/config/' . $name . '.block.php';
        $lockfile  = BASE_PATH . 'template/' . $name . '/config/install.lock';
        if(file_exists($lockfile)){
            $ret['msg'] = '已经安装过了';
        }
        // 导入 Tag 包
        else{
            if(file_exists($blockfile)){
                $blocks = include($blockfile);
                $obj = OBJ('block_tab');
                $ret['total'] = count($blocks);
                foreach ((array)$blocks as $v){
                    $v['id'] = 0;
                    if($obj->load($v)){
                        if(block::secchk($obj->data['extra'])){
                            $obj->data['skey'] = strtolower($obj->data['skey']);
                            $obj->replace();
                        }
                    }
                }
            }
            $ret['msg'] = '安装成功';
            file_put_contents($lockfile , ' ');
            block::rebuild();
        }
        return $ret;
    }
    
    /**
     * 模板数据标签卸载
     *
     * @return unknown
     */
    public final static function uninstall($name){
        $ret = array('msg' => '卸载失败了');
        $lockfile  = BASE_PATH . 'template/' . $name . '/config/install.lock';
        if(!file_exists($lockfile)){
            $ret['msg'] = '尚未安装';
        }
        // 删除 Tag 包
        else{
            OBJ('block_tab')->where("tpl = '{$name}'")->del();
            $ret['msg'] = '卸载成功';
            unlink($lockfile);
            block::rebuild();
        }
        return $ret;
    }
    
    /**
     * 获取模板列表
     *
     * @return unknown
     */
    public final static function getlist(){
       $ret = array();
       clearstatcache();
       foreach (glob(BASE_PATH . 'template/*') as $v){
           if(is_dir($v)){
               $code = basename($v);
               $desc = self::gettpldesc($code);
               if(!empty($desc)){
                   $desc['install'] = false;
                   if(file_exists(BASE_PATH . 'template/' . $code .'/config/install.lock')){
                       $desc['install'] = true;
                   }
                   $ret[$code] = $desc;
               }
           }
       }
       return $ret;
    }
    
    /**
     * 获取模板介绍信息
     *
     * @param unknown_type $name
     * @return unknown
     */
    public final static function gettpldesc($name){
        $ret = array();
        $file = BASE_PATH . 'template/' . $name . '/config/' . $name . '.tpl.php';
        if(file_exists($file)){
            include($file);
            $class = $name . '_tpl';
            if(class_exists($class , false)){
                $obj = new $class();
                if(is_subclass_of($obj , 'tpl_lib')){
                    $ret = $obj->getdesc();
                }
            }
        }
        return $ret;
    }
}
?>