<?php
/**
 * 视频操作库
 * @copyright reginx.com
 * $Id$
 */
class vod_lib {
    
    /**
     * 通过 类别 ID 获取 影片列表
     *
     * @param unknown_type $cat
     * @param unknown_type $fields
     * @param unknown_type $where
     * @param unknown_type $order
     * @param unknown_type $limit
     * @return unknown
     */
    public static function getlistbycat($catid , $limit = 10 , $fields = 'id,sname,name,cover,desc,key,actor' , $where = '1=1' , $order = 'id desc' ){
        $ret = array();
        if(is_numeric($catid)){
            // cat id
            $catid = intval($catid);
            $cat = core::getobj('cat_tab')->where("id = '{$catid}'")->get();
        }else{
            // cat name
            $catid = filter::text($catid);
            $cat = core::getobj('cat_tab')->where("name = '{$catid}'")->get();
        }
        if(!empty($cat)){
            $scat = join(',', cat_lib::getsubids($cat['id'], $cat['ctype']));
            $obj = OBJ('vod_tab');
            if(!empty($where) && $where != '1=1'){
                $obj->where($where);
            }
            $ret = $obj->fields($fields)->order($order)->where("cat in ({$scat})")->limit($limit)->getall();
            foreach ($ret as $k => $v){
                $ret[$k]['actor'] = explode(',' , $v['actor']);
                if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
                    $ret[$k]['sname'] = $v['id'];
                }
            }
        }
        return $ret;   
    }
    
    /**
     * 获取推荐影片列表
     *
     * @param unknown_type $catid
     * @param unknown_type $ctype
     * @param unknown_type $limit
     * @return unknown
     */
    public static function getreclist($catid = 0 , $ctype = 2 , $actor = 0 , $limit = 10){
        $obj = OBJ('vod_tab')->fields('id,sname,name,key,desc,cover,udate,adate,views,actor')->where("rec > 0");
        if($catid > 0){
            $subcats = cat_lib::getsubs($catid , $ctype);
            $obj->where(($ctype == 2 ? 'cat' : 'region') ." in (" . join(',' , array_keys($subcats)) . ')');
        }
        $ret = $obj->order("udate desc")->limit($limit)->getall();
        if($actor){
            foreach ((array)$ret as $k => $v){
                $tmp = empty($v['actor']) ? array() : explode(',' , $v['actor']);
                if(count($tmp) > $actor){
                    $tmp = array_slice($tmp , 0 , $actor);
                }
                $ret[$k]['actor'] = $tmp;
            }
        }
        return $ret;
    }
    
    /**
     * 获取热门影片列表
     *
     * @param unknown_type $catid
     * @param unknown_type $ctype
     * @param unknown_type $limit
     * @return unknown
     */
    public static function gethotlist($catid = 0 , $ctype = 2 , $actor = 0 , $limit = 10){
        $obj = OBJ('vod_tab')->fields('id,sname,name,key,desc,cover,udate,adate,views,actor');
        if($catid > 0){
            $subcats = cat_lib::getsubs($catid , $ctype);
            $obj->where(($ctype == 2 ? 'cat' : 'region') ." in (" . join(',' , array_keys($subcats)) . ')');
        }
        $ret = $obj->order("views desc")->limit($limit)->getall();
        if($actor){
            foreach ((array)$ret as $k => $v){
                $tmp = empty($v['actor']) ? array() : explode(',' , $v['actor']);
                if(count($tmp) > $actor){
                    $tmp = array_slice($tmp , 0 , $actor);
                }
                $ret[$k]['actor'] = $tmp;
            }
        }
        return $ret;
    }

    /**
     * 获取视频列表
     *
     * @param unknown_type $sname
     * @param unknown_type $order
     * @param unknown_type $limit
     * @param unknown_type $ttl
     * @return multitype:
     */
    public static function getlist($fields = 'id,sname,name,cover', $where = '1=1', $order = 'id desc', $limit = 10){
        $obj = core::getobj('vod_tab');
        if(is_array($where) && !empty($where)){
            foreach($where as $v){
                $obj->where($v);
            }
        }else{
            $obj->where($where);
        }
        $ret = $obj->fields($fields)->order($order)->rkey("id")->limit($limit)->getall();
        if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
            foreach ($ret as &$v){
                $v['sname'] = $v['id'];
            }
        }
        return $ret;
    }

    /**
     * 获取Tag相关的列表
     *
     * @param unknown_type $name
     * @return unknown
     */
    public static function getlistbytag($id = 0 , $limit = 10){
        $ret = array();
        if(!is_numeric($id) && !is_array($id)){
            $id = filter::text($id);
            $row = OBJ('tag_tab')->fields("id")->where("name = '$id'")->get();
            $id  = array(intval(isset($row['id']) ? $row['id'] : 0));
        }else if(is_numeric($id)){
            $id = array($id);
        }
        if(!empty($id)){
            foreach ((array)$id as $k => $v){
                if(!is_numeric($v)){
                    $tmp = OBJ('tag_tab')->fields("id")->where("name = '$v'")->get();
                    if(!empty($tmp)){
                        $id[$k] = intval($tmp['id']);
                    }else{
                        unset($id[$k]);
                    }
                }
            }
            $idstr = join(',' , $id);
            $obj = OBJ('tag_list_tab');
            $obj->fields('vod_tab.id,vod_tab.name,vod_tab.sname,vod_tab.adate,vod_tab.cover,vod_tab.udate,vod_tab.desc,vod_tab.key');
            $obj->where("tagid in( $idstr ) and ctype > 1 and ctype < 5")->rkey("id")->innerjoin('vod_tab' , 'refid' , 'id');
            $ret = $obj->order("vod_tab.udate desc")->limit($limit)->getall();
        }
        return $ret;
    }


    /**
     * 排序函数
     * @param unknown_type $a
     * @param unknown_type $b
     * @return number
     */
    public static function cmp($a, $b){
        if(intval($a['name']) == intval($b['name'])){
            return 0;
        }
        return (intval($a['name']) < intval($b['name'])) ? -1 : 1;
    }

    /**
     * 获取视频展示页模板列表
     *
     * @param unknown_type $cache
     * @return unknown
     */
    public static function gettpl($cache = 1){
        $ret = array();
        $key = 'reginx@vod-tpl-list';
        $ret = $GLOBALS['_CACHE']->get($key , '');
        if(!$ret || !$cache){
            $tpldir = BASE_PATH . 'template/default/vod/';
            foreach (glob($tpldir . '*') as $v){
                $basename = basename($v);
                if(is_file($v) && preg_match('/^vshow\_\d+\.html$/i' , $basename)){
                    $ret[] = $basename;
                }
            }
        }
        $cache && $ret && $GLOBALS['_CACHE']->set($key , $ret , 0 , '');
        return $ret;
    }

    /**
     * 删除影视
     *
     * @param unknown_type $id
     */
    public static function del($id){
        $row = core::getobj('vod_tab')->fields("cover")->where("id = $id ")->get();
        // 删除url记录
        core::getobj('vod_url_tab')->where("vid = $id ")->del();
        // 删除影视记录
        core::getobj('vod_tab')->where("id = $id ")->del();
        // 删除导演tag关系
        tag_lib::dellist($id , 1);
        // 删除演员tag关系
        tag_lib::dellist($id , 2);
        // 删除相关评论
        OBJ('reply_tab')->where("vid = $id and ctype = 2")->del();
        // 删除封面图片
        $cover = UPLOAD_PATH . $row['cover'];
        is_file($cover) && unlink($cover);
        // 删除封面缩略图
        $thumb = core::thumburl($cover);
        is_file(core::thumburl($thumb)) && unlink($thumb);
    }

    /**
     * 添加视频播放地址
     *
     * @param unknown_type $vodid
     * @param unknown_type $url
     */
    public static function addurl($vodid , $url){
        $vodid = intval($vodid);
        $obj = core::getobj('vod_url_tab');
        $obj->where("vid = {$vodid}")->del();
        $player = config_lib::$player;
        if(!empty($url)){
            if(!is_array($url)){
                $url = explode("\n" , $url);
            }
            $list = array();
            $id   = 0;
            foreach ($url as $k => $v){
                $v = explode('#' , trim($v));
                if(count($v) == 2){
                    $list[] = $v;
                    $id = intval($v[0]);
                }else if(count($v) == 1 && $v[0] != ''){
                    $list[] = array($id + 1, $v[0]);
                    $id++;
                }
            }
            foreach ((array)$list as $k => $v){
                $player = self::getplayer($v[1]);
                if($player == 'bdhd' || $player == 'qvod'){
                    $hash = md5(substr($v[1] , 0 , strrpos($v[1] , '|')));
                }else{
                    $hash = md5($v[1]);
                }
                $obj->set("vid"  , $vodid);
                $obj->set("name" , filter::text(!empty($v[0]) ? $v[0] : $k));
                $obj->set('url'  , filter::text($v[1]));
                $obj->set('uid'  , $k + 1);
                $obj->set('hash' , $hash);
                $obj->set('player' , $player);
                $obj->replace();
            }
        }
    }

    /**
     * 获取播放类型
     *
     * @param unknown_type $url
     * @return unknown
     */
    public static function getplayer($url){
        $ret = 0;
        $player = config_lib::$player;
        foreach ($player as $k => $v){
            // - 后缀判断
            $ext = isset($v['ext']) ? explode(',' , $v['ext']) : array();
            if(!empty($ext)){
                foreach ($ext as $p){
                    if(@strpos($url , $p) !== false){
                        $ret = $k;
                    }
                }
            }
            if($ret){
                //break;
            }
            // - 前缀判断
            $pre = isset($v['pre']) ? explode(',' , $v['pre']) : array();
            if(!empty($pre)){
                foreach ($pre as $p){
                    if(strpos($url , $p . '://') !== false){
                        $ret = $k;
                        break;
                    }
                }
            }
        }
        return $ret;
    }


    /**
     * 获取一条视频记录(参数可为id,或sname)
     *
     * @param unknown_type $sname
     * @return unknown
     */
    public static function get($sname){
        $obj = core::getobj('vod_tab');
        if(!is_numeric($sname)){
            $obj->where("sname = '{$sname}'");
        }else{
            $sname = intval($sname);
            $obj->where("id = '{$sname}'");
        }
        $ret = $obj->get();
        if(!empty($ret)){
            if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype'] ){
                $ret['sname'] = $ret['id'];
            }
            $ret['reply'] = core::getobj('reply_tab')->where("vid = {$ret['id']} and ctype = 2 and status = 1")->limit(20)->order("adate desc")->getall();
            if(!empty($ret['actor'])){
                if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype']){
                    $act = "'" . join("','" , explode(',' , $ret['actor'])) . "'";
                    $ret['actor'] = core::getobj('tag_tab')->where("ctype = 3 and name in ($act)")->order("field(tag_tab.name,$act)")->getall();
                    $act = null; unset($act);
                }else{
                    $ret['actor'] = explode(',' , $ret['actor']);
                }
            }
            if(!empty($ret['director'])){
                if(isset($GLOBALS['_APP']['utype']) && !$GLOBALS['_APP']['utype']){
                    $dir = "'" . join("','" , explode(',' , $ret['director'])) . "'";
                    $ret['director'] = core::getobj('tag_tab')->where("ctype = 2 and name in ($dir)")->order("field(tag_tab.name,$dir)")->getall();
                    $dir = null; unset($dir);
                }else{
                    $ret['director'] = explode(',' , $ret['director']);
                }
            }
            // 整理
            $player = core::getobj('vod_url_tab')->where("vid = '{$ret['id']}'")->order("uid asc")->getall();
            foreach ($player as $k => $v){
                if(empty($ret['player'][$v['player']])){
                    $ret['player'][$v['player']] = array();
                }
                $v['playid'] = str_replace($v['vid'] . '_' , '' , $v['uid']);
                if($v['player'] == 'thunder' || $v['player'] == 'qqdl' || $v['player'] == 'Flashget'){
                    $v['name'] = '下载' . (is_numeric($v['name']) ? ('第' . intval($v['name']) . '集') : $v['name']);
                }else{
                    $v['name']   = is_numeric($v['name']) ? ('第' . intval($v['name']) . '集') : $v['name'];
                }
                $ret['player'][$v['player']][] = $v;
            }
            $player = null;
            unset($player);
        }
        return $ret;
    }

    /**
     * 获取片名 hash 值
     *
     * @param unknown_type $name
     * @return unknown
     */
    public static function gethash($name){
        $spos =  strpos($name , '/');
        $spos = $spos === false ? strlen($name) : $spos;
        return md5(substr($name , 0 , $spos));
    }
    
    /**
     * 获取格式化之后的Tag内容
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function gettag($str){
        $str = str_replace(array('-' , '.') , '_' , filter::text($str));
        $str = preg_replace('/(\s|　|、|，)+?/' , ',' , $str);
        $str = str_replace(array('（' , '）') , array('(' , ')') , $str);
        $str = preg_replace('/\(.+?\)/' , '' , $str);
        return empty($str) ? '佚名' : $str;
    }
    
    /**
     * 采集入库接口
     *
     * @param unknown_type $data
     * @param unknown_type $ga
     * @return unknown
     */
    public static function addnew($data , $ga = array()){
        $ret = array();
        $ret['vid'] = intval($data['id']);
        $data['name'] = filter::text($data['name']);
        // 片名散列
        $ret['hash'] = $data['hash'] = self::gethash($data['name']);
        $data['udate'] = $data['udate'] ? strtotime($data['udate']) : REQUEST_TIME;
        $data['adate'] = REQUEST_TIME;
        $vobj = OBJ('vod_tab');
        $vod  = $vobj->where("hash = '{$data['hash']}'")->get();
        if(empty($vod)){
            $data['id']    = 0;
            $data['lang']  = self::getlang($data['lang']);
            $data['release']  = intval(str_replace('年' , '' , $data['release']));
            // 基本名
            $data['basename'] = self::getbasename($data['name']);
            // 介绍
            $data['info']  = trim(filter::text($data['info']));
            // 演员标签处理
            $data['actor'] = self::gettag($data['actor']);
            // 导演标签处理
            $data['director'] = self::gettag($data['director']);
            // 类别信息
            $cat = $region = array();
            // cat mapping
            foreach ((array)$ga['conf']['cmap'] as $v){
                if(trim($data['cat']) == $v[0]){
                    $data['mapid'] = intval($v[1]);
                }
            }
            if(isset($data['mapid']) && $data['mapid'] > 0){
                $data['cat'] = $data['mapid'];
            }
            // 创建类别
            else{ 
                if(!empty($data['cat'])){
                    // 若开启了自动创建类别
                    if($ga['conf']['autocat']){
                        $cat = ga_lib::getcat($data['cat'] , $ga['catid'] , $ga['tab'] == 'vod' ? 2 : 1);
                    }
                    // 使用采集设置
                    else if($ga['catid'] > 0){
                        $cat = OBJ('cat_tab')->where("id = {$ga['catid']}")->get();
                    }
                    // 使用默认分类
                    else{
                        $cat = ga_lib::getcat('其它类别' , $ga['catid'] , $ga['tab'] == 'vod' ? 2 : 1);
                    }
                }else{
                    if($ga['catid'] > 0){
                        $cat = OBJ('cat_tab')->where("id = {$ga['catid']}")->get();
                    }else{
                        $cat = ga_lib::getcat('其它类别' , $ga['catid'] , $ga['tab'] == 'vod' ? 2 : 1);
                    }
                }
                $data['cat'] = $cat ? $cat['id'] : 0;
            }
            // 地域信息
            if(empty($data['region'])){
                $region = ga_lib::getcat('其它地区' , 0 , 3);
            }else{
                $region = ga_lib::getcat($data['region'] , 0 , 3);
            }
            // 剧集信息
            $data['status']   = self::getstatus($data['status']);
            // 地域信息
            $data['region']   = $region ? $region['id'] : 0;
            // 关键字
            $data['key']      = mb_substr(trim(str_replace('#片名#' , $data['name'] , $GLOBALS['_APP']['vnskey'])) , 0 , 84 , 'utf-8');;
            
            // 描述信息
            if(empty($data['desc'])){
                $data['desc'] = str_replace('#类别#' , $cat['name']  , str_replace('#片名#' , $data['name'] , $GLOBALS['_APP']['vsdesc']));
                $data['desc'] = mb_substr(str_replace('#描述#' , trim(filter::text($data['info'])) , $data['desc']) , 0 , 82 , 'utf-8');
                $data['desc'] = preg_replace('/(\s|　)+/' , '' , $data['desc']);
            }
            $data['sname'] = py_lib::get($data['name'] , '');
            if($vobj->load($data)){
                $ret['msg'] = '× 数据验证失败';
                $res = $vobj->save();
                if($res && (int)$res['code'] === 0){
                    $ret['vid'] = intval($res['msg']);
                    $ret['msg'] = '√ 播放地址待处理';
                    $data['actor']      != '' && tag_lib::add(3 , $ret['vid'] , $data['actor']);
                    $data['basename']   != '' && tag_lib::add(4 , $ret['vid'] , $data['basename']);
                    $data['director']   != '' && tag_lib::add(2 , $ret['vid'] , $data['director']);
                }else{
                    $ret['msg'] = '× 入库失败';
                }
            }
        }
        // 对于存在的记录 , 则更新 [更新时间]
        else{
            $ret['vid'] = $vod['id'];
            $vobj->where("hash = '{$data['hash']}'");
            $vobj->set('status' , self::getstatus($data['status']));
            $vobj->set('udate' , $data['udate'])->save();
            $ret['msg'] = '√ 已更新';
        }
        $data = null; unset($data);
        return $ret;
    }
    
    /**
     * 格式化播放地址信息
     *
     * @param unknown_type $url 播放地址
     * @param unknown_type $sname 剧集名称
     * @param unknown_type $vname 视频名称
     * @param unknown_type $vsname 存储格式
     * @return unknown
     */
    public static function geturl($url , $sname , $vname  , $vsname){
        $name = str_replace('#剧集#' , $sname , $vsname);
        return  empty($url) ? array($sname , 'null' , md5(REQUEST_TIME)) : array( $sname , substr($url , 0 , strrpos($url , '|')) . '|'
            . str_replace('#片名#' , $vname , $name)
            . substr($url , strrpos($url , '.')),
            md5(substr($url , 0 , strrpos($url , '|')))
        );
    }
    

    /**
     * 获取影片基本名称(去除系列号 , 版本号等)
     *
     * @param unknown_type $name
     * @return unknown
     */
    public static function getbasename($name){
        $ret = '';
        $repl = array(
            array( '0' , 'Ⅰ' , 'Ⅱ' , 'Ⅲ' , 'Ⅳ' , 'Ⅴ' , 'Ⅵ' , 'Ⅶ' , 'Ⅷ' , 'Ⅸ' , 'Ⅹ' , 'Ⅺ' , 'Ⅻ'),
            array('零' , '壹' , '贰' , '叁' , '肆' , '伍' , '陆' , '柒' , '捌' , '玖'),
            array('0' , '1' , '2' , '3' , '4' , '5' , '6' , '7' , '8' , '9'),
            array('/' , '(' , ':' , '-' , '_' , '之' , ' ' , 'dvd' , '：')
        );
        $tag = str_replace(
            array(',' , '～' , ' ' , '\'' , '"' , '!' , '，' , '。' , '？' , '、' , '`' , '！' , '.'),
            '',
            str_replace($repl[1] , $repl[2] , str_replace($repl[0] , $repl[2] , $name))
        );
        $tag = str_replace(
            array('（' , '）' , '【' , '】' , '[' , ']' , '<' , '>'),
            array('(' , ')' , '(' , ')' , '(' , ')' , '(' , ')'),
            $tag
        );
        foreach($repl[3] as $v){
            if(stripos($tag , $v) !== false){
                $tag = substr($tag , 0 , stripos($tag , $v));
            }
        }
        $tag = preg_replace('/^(第)?\d+?(年|界|届)/' , '' , $tag);
        $ret = preg_split('/(\d+|第[^第]+?(部|季|界|届))/' , $tag);
        return empty($ret[0]) ? $tag : $ret[0];
    }

    /**
     * 获取状态码
     *
     * @param unknown_type $status
     * @return unknown
     */
    public static function getstatus($status){
        if(strpos(filter::text($status) , '连') !== false){
            return 1;
        }
        return 0;
    }
    
    /**
     * 获取语言
     *
     * @param unknown_type $lang
     * @return unknown
     */
    public static function getlang($lang){
        $ret = array_search($lang , config_lib::$vlang);
        return ($ret === null || $ret === false) ? 0 : $ret;
    }
    
    /**
     * 格式化资源站匹配出来的播放地址
     *
     * @param unknown_type $list
     * @param unknown_type $vod
     * @param unknown_type $vsname
     * @return unknown
     */
    public static function formatjsurl($list , $vname  , $vsname){
        $ret = array();
        if(!empty($list)){
            // 按播放类型归档
            foreach ($list as $v){
                $v['player'] = self::getplayer($v[1]);
                $i = count($ret[$v['player']]);
                $v['id'] = $i;
                $ret[$v['player']][$i] = $v;
            }
            unset($v , $list);
            // 处理
            foreach ($ret as  &$v){
                foreach ($v as $sk => &$sv){
                    $sinfo = self::getpinfo($sv[1] , $sk + 1);
                    if(!empty($sinfo['def']) && $sinfo['lang']){
                        // 含有清晰度及语言描述文字的播放地址会被认为是电影, 其他是电视剧
                        $sv['uid']   = $sv['id'] + 1;
                        $sv['sname'] = $sv['uid'] . '_' . $sinfo['lang'] . '_' . $sinfo['def'] . (empty($sinfo['extra']) ? '' : ('_' . join('_' , $sinfo['extra'])));
                    }else{
                        $sv['sname'] = $sinfo['uid'] ? ('第' . $sinfo['uid'] . '集') : filter::text($sv[0]);
                        $sv['uid']   = $sinfo['uid'];
                    }
                    if($sv['player'] == 'bdhd' || $sv['player'] == 'qvod'){
                        $tmp = self::geturl($sv[1] , $sv['sname'] , $vname , $vsname);
                        $sv['url']  = $tmp[1];
                        $sv['hash'] = $tmp[2];
                        unset($tmp);
                    }else{
                        $sv['url'] = $sv[1];
                        $sv['hash'] = md5($sv['url']);
                    }
                    unset($sv[0] , $sv[1]);
                }
            }
        }
        return $ret;
    }
    
    /**
     * 根据资源片名获取剧集信息
     *
     * @param unknown_type $str
     * @param unknown_type $index
     * @return unknown
     */
    private static function getpinfo($str , $index = 0){
        $ret = array();
        $str = trim($str);
        $str = substr($str , strrpos($str , '|') + 1 , strrpos($str , '.'));
        $ret['ext'] = substr($str , strrpos($str , '.'));
        $str = substr($str , 0 , strrpos($str , '.'));
        $str = str_replace( array('无水印') , '' , $str);
        $def = array(
            '/\d{3,4}x(\d{3,4})/i',
            '/\d{3,4}p/i',
            '/DVD/i',
            '/(?:bd|hd)(?:\d{4})/i',
            '/(bd|hd)([^\d]+?)(\d{4})/i',
        );
    
        $mts = array();
        // 清晰度
        foreach($def as $k => $v){
            preg_match($v , $str , $m);
            if(!empty($m)){
                if($k == 4){
                    $ret['def'] = $m[1] . $m[3];
                }else{
                    if($k == 0){
                        if((int)$m[1] < 3000){
                            $ret['def'] = (int)$m[1] > 300 ? ($m[1] . 'p') : '';
                        }else{
                            $m[1] = intval(substr($m[1] , 1));
                            $ret['def'] = (int)$m[1] > 300 ? ($m[1] . 'p') : '';
                        }
                    }else{
                        $ret['def'] = $m[0];
                    }
                }
            }
        }
    
        // 语言及字幕
        $m = array();
        preg_match('/(粤|法|中|英|双|字|国|语|配|音|幕){2,4}/i' , $str , $m);
        $ret['lang'] = empty($m) ? '' : $m[0];
        $ret['lang'] = ($ret['lang'] == '语中字') ? '中文字幕' : $ret['lang'];
    
        // 扩展信息
        $extra = array(
            '未剪切版' , '未删减版' , '剪辑版'   , '完整版' , '加长版' , '收藏版' ,
            '完全版'   , '美国版'   , '美版'     , '剧场版' , '终极版' , '动画版' ,
            '修复版'   , '网络版'   , '未分级版' , '抢鲜版' , '重映版'
        );
        foreach($extra as $v){
            if(strpos($str , $v) !== false){
                $ret['extra'][] = $v;
            }
        }
        $point = array('/' , '(' , ':' , '-' , '_'  , ' ' , 'dvd' , '：');
        foreach($point as $v){
            if(stripos($str , $v) !== false){
                $str = substr($str , 0 , stripos($str , $v));
            }
        }
        $str = str_replace($ret['def'] , '' , str_replace($ret['lang'] , '' , $str));
        $mts = array();
        preg_match('/\d+(?:集|话)?$/' , $str , $mts);
        $ret['uid'] = intval($mts[0]);
        $ret['uid'] = $ret['uid'] ? $ret['uid'] : ($index);
        return $ret;
    }
    
    
    /**
     * 格式化资源站匹配出来的播放地址 unescape
     *
     * @param unknown_type $list
     * @param unknown_type $vod
     * @param unknown_type $vsname
     * @return unknown
     */
    public static function formatjsescurl($list , $vname  , $vsname){
        $ret = array();
        if(!empty($list)){
            // 按播放类型归档
            foreach ($list as $v){
                $v['player'] = self::getplayer($v[1]);
                $ret[$v['player']][] = $v;
            }
            unset($v , $list);
            // 处理
            foreach ($ret as  &$v){
                foreach ($v as $sk => &$sv){
                    $sinfo = self::getpinfo($sv[1] , $sk + 1);
                    if(!empty($sinfo['def']) && $sinfo['lang']){
                        // 含有清晰度及语言描述文字的播放地址会被认为是电影, 其他是电视剧
                        $sv['uid']   = $sv['id'] + 1;
                        $sv['sname'] = $sv['uid'] . '_' . $sinfo['lang'] . '_' . $sinfo['def'] . (empty($sinfo['extra']) ? '' : ('_' . join('_' , $sinfo['extra'])));
                    }else{
                        $sv['sname'] = $sinfo['uid'] ? ('第' . $sinfo['uid'] . '集') : filter::text($sv[0]);
                        $sv['uid']   = $sinfo['uid'];
                    }
                    if($sv['player'] == 'bdhd' || $sv['player'] == 'qvod'){
                        $tmp = self::geturl($sv[1] , $sv['sname'] , $vname , $vsname);
                        $sv['url']  = $tmp[1];
                        $sv['hash'] = $tmp[2];
                        unset($tmp);
                    }else{
                        $sv['url'] = $sv[1];
                        $sv['hash'] = md5($sv['url']);
                    }
                    unset($sv[0] , $sv[1]);
                }
            }
        }
        return $ret;
    }

}
?>