<?php
/**
 * 类别基类
 * @copyright reginx.com
 * $Id$
 */
class base_mod extends mogvs_mod{

    /**
     * 类别码
     *
     * @var unknown_type
     */
    public $code = '';

    /**
     * 类型码
     *
     * @var unknown_type
     */
    public $ctype = 0;

    /**
     * 架构函数
     *
     * @param unknown_type $p
     */
    public function __construct($p = array() , $ctype = 0){
        parent::__construct($p);
        $this->ctype = $ctype;
        $this->code = str_replace('_mod', '', get_class($this));
        if($this->code == 'base'){
            $this->show404();
        }
    }
    
    /**
     * 分发
     *
     */
    public function indexAct(){
        // 资讯列表页
        if($this->ctype == '1' ){
            $this->art();
        }else{
            $this->vod();
        }
    }
    
    /**
     * 资讯
     *
     */
    private function art(){
        $cat = api_lib::getcat($this->code);
        if(empty($cat)){
            $this->show404();
        }
        $this->ctype = $cat['ctype'];
        $ptitle = $cat['name'];
        $active = $urhere = $skey = array();
        if(empty($cat['pcat'])){
            $active = $this->code;
            $urhere[$this->code] = $cat['name'];
        }
        foreach($cat['pcat'] as $k => $v){
            if(empty($active)){
                $active = $k;
            }
            $ptitle .= '_' . $v['name'];
            $urhere[$k] = $v['name'];
        }
        if(!isset($urhere[$this->code])){
            $urhere['cur'] = $cat['name'];
        }
        // page number
        $pn     = intval($this->get('pn'));

        // 通用部分
        $where = array();
        $this->assign('cat', $cat);
        $where[0] = "cat in (" . $cat['id']. ")";
        if(!empty($cat['scat'])){
            $where[0] = "cat in (" . join(',', array_keys($cat['scat'])) . ")";
        }
        $this->assign('lastupdate', api_lib::getartlist($cat['id'], 'id,key,sname,name,adate,cover', $where));
        $skey[] = $cat['key'];
        $sdesc  = $cat['desc'];
        // 子类别
        $subcat = $this->get('cat');
        $subcat = $subcat == 'null' ? null : $subcat;
        if(preg_match('/^\w+$/i', $subcat) && !empty($subcat)){
            $subcat = api_lib::getcat($subcat);
            if(empty($subcat)){
                $this->show404();
            }
            $skey[] = $subcat['key'];
            $sdesc  .= ',' .$subcat['desc'];
            $ptitle = $subcat['name'] . '_' . $ptitle;
            $this->assign('subcat', $subcat);
            $where[0] = "cat in (" . join(',', array_keys($subcat['scat'])) . ")";
            $urhere[$cat['sname']] = $cat['name'];
            if(isset($urhere['cur'])){
                unset($urhere['cur']);
            }
            $urhere['cur'] = $subcat['name'];
        }
        $this->assign('skey', join(',' , $skey));
        $this->assign('sdesc', $sdesc);
        $this->assign('ptitle', $ptitle);
        $this->assign('active', $active);
        $this->assign('urhere', $urhere);
        $this->assign('cats' , api_lib::getcatlist(1));
        $this->assign('list' , api_lib::getartpaged($cat['sname'], $pn ? $pn : 1, $where , 'id desc'));
        $this->display('art/cat.tpl.html');
    }

    /**
     * 默认列表首页
     */
    private function vod(){
        $cat = api_lib::getcat($this->code);
        if(empty($cat)){
            $this->show404();
        }
        $this->ctype = $cat['ctype'];
        $ptitle = $cat['name'];
        $active = $urhere = $skey = array();
        if(empty($cat['pcat'])){
            $active = $this->code;
            $urhere[$this->code] = $cat['name'];
        }
        foreach($cat['pcat'] as $k => $v){
            if(empty($active)){
                $active = $k;
            }
            $ptitle .= '_' . $v['name'];
            $urhere[$k] = $v['name'];
        }
        if(!isset($urhere[$this->code])){
            $urhere['cur'] = $cat['name'];
        }
        // page number
        $pn     = intval($this->get('pn'));

        // 通用部分
        $where = array();
        $this->assign('cat', $cat);
        $where[0] = ($this->ctype == '2' ? 'cat ' : 'region ') ." in (" . $cat['id']. ")";
        if(!empty($cat['scat'])){
            if($this->ctype == '2'){
                $where[0] = "cat in (" . join(',', array_keys($cat['scat'])) . ")";
            }else{
                $where[0] = "region in (" . join(',', array_keys($cat['scat'])) . ")";
            }
        }
        $this->assign('lastupdate', api_lib::getvodlist($cat['sname'], 'id,key,sname,name,udate,cover', $where , 'udate desc'));
        $skey[] = $cat['key'];
        $sdesc  = $cat['desc'];
        // 子类别
        $subcat = $this->get('cat');
        $subcat = $subcat == 'null' ? null : $subcat;
        if(preg_match('/^\w+$/i', $subcat) && !empty($subcat)){
            $subcat = api_lib::getcat($subcat);
            if(empty($subcat)){
                $this->show404();
            }
            $skey[] = $subcat['key'];
            $sdesc  .= ',' .$subcat['desc'];
            $ptitle = $subcat['name'] . '_' . $ptitle;
            $this->assign('subcat', $subcat);
            $where[0] = "cat in (" . join(',', array_keys($subcat['scat'])) . ")";
            $urhere[$cat['sname']] = $cat['name'];
            if(isset($urhere['cur'])){
                unset($urhere['cur']);
            }
            $urhere['cur'] = $subcat['name'];
        }

        // 年份筛选
        $year = intval($this->get('year'));
        if($year >= 1900 && $year <= intval(date('Y', REQUEST_TIME))){
            $ptitle = $year . '年_' . $ptitle;
            $where[] = "release = '{$year}'";
            $skey[]  = $year . '年电影';
            $this->assign('year', $year);
        }

        // 地区
        $reg = $this->get('region');
        $reg = $reg == 'null' ? null : $reg;
        if(preg_match('/^\w+$/i', $reg) && !empty($reg)){
            $reg = api_lib::getcat($reg);
            if(!empty($reg)){
                $sdesc  .= ',' . $reg['name'] . '地区';
                $ptitle  = $reg['name'] . '_' . $ptitle;
                $where[] = "region in (" . join(',', array_keys($reg['scat'])) . ")";
                $this->assign('reg', $reg);
                if(isset($urhere['cur'])){
                    unset($urhere['cur']);
                }
                $urhere['cur'] = $reg['name'];
                $skey[]  = $reg['key'];
            }
        }
        $this->assign('skey', join(',' , $skey));
        $this->assign('sdesc', $sdesc);
        $this->assign('ptitle', $ptitle);
        $this->assign('active', $active);
        $this->assign('urhere', $urhere);
        $this->assign('list', api_lib::getpaged($cat['sname'], $pn ? $pn : 1, $where , 'id desc'));
        $this->assign('region', api_lib::getregion());
        $this->assign('vstatus', config_lib::$vstatus);
        $this->assign('years'  , api_lib::getyears());
        $this->assign('cats' , api_lib::getcatlist(2));
        $this->assign('regions' , api_lib::getcatlist(3));
        $this->display('vod/cat.tpl.html');
    }

    /**
     * list Act alias
     */
    public function listAct(){
        $this->indexAct();
    }
}
?>