<?php
/**
 * 会员登录模块
 * @copyright reginx.com
 */
class login_mod extends mod {

    /**
     * 默认登录页
     *
     */
    public function indexAct(){
        if($this->conf['memopen']){
            $this->display('user/login.tpl.html');
        }
        die('Closed');
    }
    
    /**
     * 登录验证
     *
     */
    public function submitAct(){
        $user = $this->get('user' , 'P');
        $this->opensess();
        $out = array('code' => 1 , 'msg' => '会员功能关闭了');
        if($this->vtoken(1) && $this->conf['memopen']){
            $obj = OBJ('user_tab');
            if(preg_match(filter::$rules['email'] , $user['uname'])){
                $login = $obj->where("uname = '{$user['uname']}'")->get();
                if(!empty($login)){
                    if($login['passwd'] == misc_lib::getpasswd($user['passwd'])){
                        $this->sobj->set("login" , $login);
                        $this->rmtoken();
                        $out['code'] = 0;
                    }else{
                        $out['msg'] = '密码错误';
                    }
                }else{
                    $out['msg'] = '该帐号不存在';
                }
            }else{
                $out['msg'] = '邮箱帐号错误了';
            }
        }else{
            $out['msg'] = '请求已过期!';
        }
        $this->ajaxout($out);
    }
    
    /**
     * 输出验证码
     *
     */
    public function verifyAct(){
        $code = strtolower(core::randstr());
        $this->opensess($this->_conf['sess']);
        $this->sobj->set('verify' , md5($code));
        @ob_end_clean();
        image_lib::verify($code,54,27);
    }
    
    
    /**
     * 安全退出
     *
     */
    public function outAct(){
        $this->opensess();
        $this->sobj->remove();
        $this->redirect('index');
    }
    
    
    /**
     * 获取用户登录状态
     *
     */
    public function userAct(){
        if($this->conf['memopen']){
            $this->opensess();
            if($this->sobj->has('login')){
                $this->nocache();
                $this->assign('login' , $this->sobj->get("login"));
            }
            $this->display('user/logined.tpl.html');
        }
    }
    
    /**
    * QQ Connect 登录
    *
    */
    public function qcAct(){
        if($this->conf['memopen'] && $this->conf['mqcappid']){
            $state  = md5(uniqid(rand(), TRUE));
            $refurl = $this->get('ref');
            $this->opensess();
            $this->sobj->set('state' , $state);
            $this->redirect(qc_lib::login($this->conf['mqcappid']  , $this->conf['mqcscope'] , $state , $refurl) , 0);
        }
        die('Closed');
    }
    
    /**
     * 登录回跳接口
     *
     */
    public function cbAct(){
        $this->opensess();
        if($this->sobj->get('state') == $this->get('state',  'G')){
            $ref = $this->get('ref');
            if(!empty($ref)){
                $ref = filter_var(base64_decode($ref) , FILTER_VALIDATE_URL);
                $ref = $ref ? $ref : core::url('index');
            }
            $ret = qc_lib::gettoken($this->conf['mqcappid'] , $this->conf['mqcappkey'] , $this->get('code' , 'G') , $this->get('state' , 'G'));
            if((int)$ret['code'] === 0 && preg_match('/^\w{32}$/i' , $ret['openid'])){
                $ret = qc_lib::getuser($ret);
                $this->sobj->set('openid' , $ret['openid']);
                $uobj = OBJ('user_tab');
                $user = $uobj->where("openid = '{$ret['openid']}'")->get();
                if(empty($user)){
                    $uobj->set("uname" , 'qq@' . $ret['openid'] . '.com')->set("adate" , REQUEST_TIME);
                    $uobj->set('passwd' , md5($ret['openid'] . REQUEST_TIME))->set("lastlogin" , REQUEST_TIME);
                    $ret = $uobj->set("id" , 0)->set("sex" , $ret['gender'] == '男' ? 0 : 1)->set("openid" , $ret['openid'])->set("nick" , $ret['nickname'])->save();
                    if((int)$ret['code'] === 0){
                        $this->redirect($ref , 0);
                    }
                }else{
                    $this->sobj->set("login" , $user);
                    $this->redirect($ref , 0);
                }
            }
        }
        $this->showmsg('error');
    }

}// End Class
?>