<?php
/**
 * 演员模块
 * @author reginx.com
 * $Id$
 */
class search_mod extends mogvs_mod {

    /**
     * 请求源ip
     *
     * @var unknown_type
     */
    private $_ip = null;
    
    /**
     * 架构函数
     *
     * @param unknown_type $p
     */
    public function __construct($p = array()){
        parent::__construct($p);
        $this->assign('nav', api_lib::getnav());
        $this->assign('sconf', $this->conf);
        $dobj = OBJ('deny_tab');
        $this->_ip   = sprintf('%u',ip2long(core::getip()));
        $row  = $dobj->where("ip = {$this->_ip} and ctype = 1")->get();
        if(!empty($row) && $row['adate'] > REQUEST_TIME - $this->conf['slimit']){
            $this->assign('msg' , "您搜索的请求太过频繁了, 请 {$this->conf['slimit']} 秒后再试 !");
            $this->display('search/default.tpl.html');
        }
    }
    
    
    /**
     * 添加搜索日志
     *
     */
    private function addlog(){
        OBJ('deny_tab')->set("ip" , $this->_ip )->set("ctype" , 1)->set("adate" , REQUEST_TIME)->replace();
    }
    
    /**
     * 获取搜索关键字
     *
     * @return unknown
     */
    private function getkey(){
        $ret = $this->get('key');
        $ret = str_replace(' ' , '' , $ret);
        $ie = strtolower(mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $ret)) != 'utf-8';
        if($ie){
            $ret = mb_convert_encoding($ret, 'utf-8', mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $ret));
        }
        if(!preg_match('/^[\w\_\x{4e00}-\x{9fa5}\·\-]+$/ui', $ret)){
            $ret = '';
        }
        return $ret;
    }
    
    /**
     * 资讯搜索
     *
     */
    public function artAct(){
        $str = $this->getkey();
        if(empty($str)){
            $this->assign('msg' , '请输入搜索关键字');
            $this->display('search/default.tpl.html');
        }
        $pn  = intval($this->get('pn'));
        $this->assign('ptitle', $str . '_资讯_搜索结果');
        $obj = OBJ('art_tab');
        $obj->where("name like '%{$str}%'")->keep();
        $pobj = new page_lib($obj->count(), 'pn', $pn, 12);
        $obj->clear('fields')->fields('id,name,sname,cover,adate,key,desc,cat')->rkey('id')->limit($pobj->limit);
        $obj->order('id ' . ($pobj->rev ? 'asc' : 'desc'));
        $ret['pobj'] = $pobj->toarray();
        $ret['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
        $this->assign('list', $ret);
        $this->assign('urhere', array(
            'cur' => "资讯搜索 [&nbsp;" . $str . "&nbsp;] "
        ));
        $this->assign('stype' , '资讯');
        $this->assign('surl'  , '@search-art-key-|false');
        $this->assign('keywords', $str);
        $this->assign('sdesc' , $str . '的相关资讯');
        $this->assign('skey'  , $str . '的相关资讯');
        $this->assign('cats', api_lib::getallcat(1));
        $this->conf['slimit'] && $pn <= 1 && $this->addlog();
        $this->display('search/art.tpl.html');
    }
    
    /**
     * 演员搜索
     *
     */
    public function actorAct(){
        $str = $this->getkey();
        if(empty($str)){
            $this->assign('msg' , '请输入搜索关键字');
            $this->display('search/default.tpl.html');
        }
        $pn  = intval($this->get('pn'));
        $obj = core::getobj('tag_tab');
        $obj->where("ctype = 3 and name like '%{$str}%'")->keep();
        $pobj = new page_lib($obj->count(), 'pn', $pn, 12);
        $obj->clear('fields');
        $obj->fields('id , tag_tab.name , sname,cover,desc , adate')->rkey('id')->limit($pobj->limit);
        $obj->order('id ' . ($pobj->rev ? 'asc' : 'desc'));
        $obj->leftjoin('dainfo_tab' , 'id' , 'tagid');
        $ret['pobj'] = $pobj->toarray();
        $ret['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
        $tagids = array_keys($ret['data']);
        if(!empty($tagids)){
            $tobj = OBJ('tag_list_tab');
            $tobj->fields('tagid,vod_tab.id as vid , vod_tab.sname , vod_tab.name');
            $vods = $tobj->leftjoin('vod_tab', 'refid', 'id')->where("tagid in (" . join(',' , $tagids) . ") and ctype = 3")->getall();
            if(!empty($vods)){
                foreach ($vods as $v){
                    if(count($ret['data'][$v['tagid']]['vod']) < 10){
                        $ret['data'][$v['tagid']]['vod'][]  = $v;
                    }
                }
            }
        }
        $this->assign('list', $ret);
        $this->assign('keywords', $str);
        $this->assign('urhere', array(
            'cur' => "演员搜索 [&nbsp;" . $str . "&nbsp;] "
        ));
        $this->assign('ptitle', $str . '_演员_搜索结果');
        $this->assign('sdesc' , $str . '的全部电影');
        $this->assign('skey'  , $str . '的全部电影');
        $this->conf['slimit'] && $pn <= 1 && $this->addlog();
        $this->assign('stype' , '演员');
        $this->assign('surl'  , '@search-actor-key-|false');
        $this->display('search/actor.tpl.html');
        
    }
    
    /**
     * 导演搜索
     *
     */
    public function dirAct(){
        $str = $this->getkey();
        if(empty($str)){
            $this->assign('msg' , '请输入搜索关键字');
            $this->display('search/default.tpl.html');
        }
        $pn  = intval($this->get('pn'));
        $obj = core::getobj('tag_tab');
        $obj->where("ctype = 2 and name like '%{$str}%'")->keep();
        $pobj = new page_lib($obj->count(), 'pn', $pn, 12);
        $obj->clear('fields');
        $obj->fields('id , tag_tab.name , sname,cover,desc , adate')->rkey('id')->limit($pobj->limit);
        $obj->order('id ' . ($pobj->rev ? 'asc' : 'desc'));
        $obj->leftjoin('dainfo_tab' , 'id' , 'tagid');
        $ret['pobj'] = $pobj->toarray();
        $ret['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
        $tagids = array_keys($ret['data']);
        if(!empty($tagids)){
            $tobj = OBJ('tag_list_tab');
            $tobj->fields('tagid,vod_tab.id as vid , vod_tab.sname , vod_tab.name');
            $vods = $tobj->leftjoin('vod_tab', 'refid', 'id')->where("tagid in (" . join(',' , $tagids) . ") and ctype = 2")->getall();
            if(!empty($vods)){
                foreach ($vods as $v){
                    if(count($ret['data'][$v['tagid']]['vod']) < 10){
                        $ret['data'][$v['tagid']]['vod'][]  = $v;
                    }
                }
            }
        }
        $this->assign('list', $ret);
        $this->assign('keywords', $str);
        $this->assign('urhere', array(
            'cur' => "导演搜索 [&nbsp;" . $str . "&nbsp;] "
        ));
        $this->assign('ptitle', $str . '_导演_搜索结果');
        $this->conf['slimit'] && $pn <= 1 && $this->addlog();
        $this->assign('stype' , '导演');
        $this->assign('sdesc' , $str . '的影片');
        $this->assign('skey'  , $str . '的影片');
        $this->assign('surl'  , '@search-dir-key-|false');
        $this->display('search/dir.tpl.html');
        
    }

    
    /**
     * 演员页
     *
     * @param unknown_type $p1
     * @param unknown_type $p2
     */
    public function vodAct(){
        $str = $this->getkey();
        if(empty($str)){
            $this->assign('msg' , '请输入搜索关键字');
            $this->display('search/default.tpl.html');
        }
        $pn  = intval($this->get('pn'));
        $obj = core::getobj('vod_tab');
        $obj->where("name like '%{$str}%'")->keep();
        $pobj = new page_lib($obj->count(), 'pn', $pn, 12);
        $obj->clear('fields');
        $obj->fields('id,sname ,name,region,release,cover,cat,actor,desc,udate,adate')->limit($pobj->limit);
        $obj->order('udate ' . ($pobj->rev ? 'asc' : 'desc'));
        $list = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
        foreach ((array)$list as $k => $v){
            if(!empty($v['actor'])){
                $list[$k]['actor'] = explode(',' , $v['actor']);
            }
        }
        $ret['pobj'] = $pobj->toarray();
        $ret['data'] = $list;
        $this->assign('list', $ret);
        $this->assign('keywords', $str);
        $this->assign('skey', $str . '在线播放');
        $this->assign('sdesc', $str . '在线播放');
        $this->assign('urhere', array(
            'cur' => $str
        ));
        $this->assign('regions', api_lib::getregion());
        $this->assign('cats', api_lib::getallcat(2));
        $this->assign('ptitle', $str . '_影片_搜索结果');
        $pn <= 1 && $this->addlog();
        $this->display('search/vod.tpl.html');
    }
}
?>