<?php
/**
 * 演员模块
 * @author reginx.com
 * $Id$
 */
class tag_mod extends mogvs_mod {

    /**
     * 默认
     *
     */
    public function indexAct(){
        //$this->redirect('actor-list');
    }

    /**
     * 演员库
     *
     */
    public function listAct(){
        $ptitle = '明星库';
        $py = '';
        if($this->has('py')){
            $py = strtolower($this->get('py'));
            if(preg_match('/^[a-z]$/' , $py)){
                $ptitle .= '_' . strtoupper($py) ;
                $this->assign('py' , strtoupper($py));
            }
        }
        $data = api_lib::getactors($py , intval($this->get('pn')) , 24);
        $this->assign('ptitle', $ptitle);
        $this->assign('list'   , $data);
        $this->assign('active' , 'actor');
        $this->display('tag/actor.list.html');
    }

    /**
     * 演员页
     *
     * @param unknown_type $p1
     * @param unknown_type $p2
     */
    public function __call($p1, $p2){
        $str = urldecode(substr($p1, 0, -3));
        // 检测内容编码,确定浏览器类型
        $ie = strtolower(mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $str)) != 'utf-8';
        // 浏览器提交中文方式适配
        if($ie){
            $str = mb_convert_encoding($str, 'utf-8', mb_convert_variables('utf-8', 'utf-8,gbk,gb2312,cp936', $str));
        }
        $str = filter::text($str);
        // 格式验证
        if(!preg_match('/^[\w\_\x{4e00}-\x{9fa5}\·\-]+$/ui', $str)){
            $this->show404(1 , '参数错误了...');
        }
        
        core::getobj('tag_tab')->fields("id,name,sname,dainfo_tab.cover,dainfo_tab.desc,dainfo_tab.adate")->where("name = '$str'")->leftjoin("dainfo_tab" , "id" , "tagid");
        $tag = core::getobj('tag_tab')->where( (is_numeric($str) ? 'id' : 'name' ) . " = '$str'")->get();
        // 不存在
        if(empty($tag)){
            $this->show404(1 , '未找到该记录');
        }
        $pn  = intval($this->get('pn'));
        $obj = OBJ('tag_list_tab');
        $obj->keep()->where("tagid = {$tag['id']} and ctype = 5");
        $pobj = new page_lib($obj->count() , 'pn' , $pn , 18);
        $obj->clear('fields')->fields('art_tab.id,art_tab.name,art_tab.sname,art_tab.adate,art_tab.cover,art_tab.desc,art_tab.key,art_tab.cat');
        $obj->rkey("id")->leftjoin('art_tab' , 'refid' , 'id')->order("art_tab.adate " . ($pobj->rev ? ' asc ' : ' desc '));
        $obj->limit($pobj->limit);
        $list['pobj'] = $pobj->toarray();
        $list['data'] = $pobj->rev ? array_reverse($obj->getall()) : $obj->getall();
        $this->assign('list' , $list);
        $this->assign('skey', $actor['name'] . ',' . $actor['name'] . '电影,' . $actor['name'] . '最新电影');
        $this->assign('sdesc', $actor['name'] . '的电影 ,' . $actor['name'] . '主演的电影');
        $this->assign('urhere', array(
            'cur' => "资讯标签 [&nbsp;" . $actor['name'] . "&nbsp;]"
        ));
        $this->assign('region', api_lib::getregion());
        $this->assign('cat', api_lib::getallcat(1));
        $this->assign('active' , 'tag');
        $this->assign('tag' , $tag);
        $this->assign('pn'  , $pn);
        $this->assign('ptitle', $tag['name'] . '_标签库');
        $this->display('tag/tag.tpl.html');
    }
}
?>