<?php
/**
 * 用户模块
 * @copyright reginx.com
 * $Id$
 */
class user_mod extends mod {

    /**
     * 是否是 ajax 请求
     *
     * @var unknown_type
     */
    private $_isajax = false;
    
    private $_login = null;
    
    /**
     * 架构函数
     *
     * @param unknown_type $param
     */
    public function __construct($param = array()){
        parent::__construct($param);
        $this->nocache();
        if(!$this->conf['memopen']){
            if($this->_isajax){
                $this->ajaxout(array('code' => -1 , 'msg' => '会员系统已关闭'));
            }else{
                die('会员系统已关闭');
            }
        }
        $this->opensess($this->conf['sess']);
        $this->_isajax = intval($this->get('isajax'));
        if(!$this->sobj->has('login')){
            if($this->_isajax){
                $this->ajaxout(array('code' => -2 , 'msg' => '请先登录'));
            }else{
                die('请先登录');
            }
        }
        $this->_login = $this->sobj->get("login");
        $this->assign('login' , $this->_login);
    }
    
    /**
     * 评论操作
     *
     */
    public function replyAct(){
        $this->nocache();
        if(!$this->conf['mropen']){
            if($this->_isajax){
                $this->ajaxout(array('code' => -1 , 'msg' => '评论功能已关闭'));
            }else{
                die('评论功能已关闭');
            }
        }
        $vid = intval($this->get('vid'));
        if($vid === 0){
            die('unkown id ');
        }
        $ip = sprintf('%u',ip2long(core::getip()));
        $out = array('code' => 1 , 'msg' => '评论失败了');
        if($this->has('desc' , 'P')){
            if($row = misc_lib::vuserip($ip , 2)){
                $out['msg'] = '您已经被禁言了';
                $this->ajaxout($out);
            }
            $desc = filter::text($this->get('desc', 'P'));
            if(empty($desc)){
                $out['msg'] = '请输入评论内容';
            }
            // 请求验证
            else if(!$this->vtoken(1)){
                $out['msg'] = '请求失效了';
            }
            else if(intval($this->sobj->get('reply')) + 20 > REQUEST_TIME){
                $out['msg'] = '您评论的太快了';
            }
            // 入库
            else{
                $reply = array();
                $reply['id']     = 0;
                $reply['name']   = '评论';
                $reply['desc']   = $desc;
                $reply['uid']    = $this->_login['id'];
                $reply['nick']   = $this->_login['nick'];
                $reply['adate']  = REQUEST_TIME;
                $reply['vid']    = $vid;
                $reply['parnet'] = 0;
                $reply['ctype']  = 2;
                $reply['ip']     = $ip;
                $obj = OBJ('reply_tab');
                $this->sobj->set('reply' , REQUEST_TIME);
                if($obj->load($reply)){
                   $out =  $obj->save();
                }
            }
            $this->ajaxout($out);
        }
        $this->assign('vid' , $vid);
        $this->display('user/reply.tpl.html');
    }
    
    
}// End Class
?>