<?php
/**
 * block tab
 * @copyright reginx.com
 * $Id$
 */
class block_tab extends tab {
    
    /**
     * 验证规则
     *
     * @var unknown_type
     */
    public $validate = array(
        array(
            'key'       => 'skey',
            'type'      => 1,
            'rule'      => '/^[a-zA-Z][0-9a-zA-Z\_]+$/i',
            'msg'       => 'key格式错误,首字必须为字母!'
        ),
        array(
            'key'       => 'name',
            'type'      => 0,
            'rule'      => 'require',
            'msg'       => '请输入名称!'
        ),
        array(
            'key'       => 'extra',
            'type'      => 0,
            'rule'      => 'require',
            'msg'       => '请输入标签内容!'
        )
    );
    
    /**
     * 默认值
     *
     * @var unknown_type
     */
    public $default = array(
        'ttl'       => 86400,
        'adate'     => REQUEST_TIME
    );
    
    /**
     * 过滤规则
     *
     * @var unknown_type
     */
    public $filter = array(
        'adate'   => array('filter' , 'timestamp'),
        'ttl'     => array('filter' , 'int'),
        'name'    => array('filter' , 'text'),
        'extra'   => array('filter' , 'html'),
        'comment' => array('filter' , 'html'),
    );
    
}
?>