<?php
/**
 * 数据过滤
 * @copyright reginx.com
 * $Id: filter.class.php 67 2013-02-10 14:14:55Z reginx $
 */
class filter{

    /**
     * 数据验证规则
     *
     * @var unknown_type
     */
    public static $rules = array(
            // 键名小写
            'require' => '/^.+$/s',
            'email' => '/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/',
            'phone' => '/^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/',
            'mobile' => '/^((\(\d{2,3}\))|(\d{3}\-))?1\d{10}$/',
            'url' => '/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/',
            'currency' => '/^\d+(\.\d+)?$/',
            'number' => '/^\d+$/',
            'zip' => '/^[1-9]\d{5}$/',
            'qq' => '/^[1-9]\d{4,12}$/',
            'integer' => '/^[-\+]?\d+$/',
            'double' => '/^[-\+]?\d+(\.\d+)?$/',
            'english' => '/^[A-Za-z]+$/',
            'uid' => '/^[A-Za-z0-9_]{2,30}$/',
            'passwd' => '/^[^\s]{2,37}$/',
            'all' => '/^.*$/',
            'price' => '/^\d+(\.\d+)?$/'
    );

    /**
     * 原始内容
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function source($str){
        return $str;
    }
    
    /**
     * 获取安全文本
     *
     * @param unknown_type $str
     */
    public static function text($str){
        $str = trim($str);
        if($str != ''){
            $str = htmlspecialchars(preg_replace('/\&.+?\;/i', '', self::loseTags($str)), ENT_QUOTES, $GLOBALS['_APP']['charset']);
        }
        return $str;
    }

    /**
     * 过滤html标签
     *
     * @param unknown_type $str
     */
    public static function loseTags($str){
        if(empty($str) && $str != '0'){
            return '';
        }
        $str = htmlspecialchars_decode($str);
        $str = strip_tags($str);
        $str = preg_replace('/\<style(.*?)>.*?\<\/style\>/is', '', $str);
        $str = preg_replace('/\<script(.*?)>.*?\<\/script\>/is', '', $str);
        $str = preg_replace('/\<iframe(.*?)>.*?\<\/iframe\>/is', '', $str);
        return trim($str);
    }

    /**
     * 默认html过滤
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function html($str){
        $str = htmlspecialchars_decode($str);
        $str = preg_replace('/\<style(.*?)>.*?\<\/style\>/is', '', $str);
        $str = preg_replace('/\<script(.*?)>.*?\<\/script\>/is', '', $str);
        $str = preg_replace('/javascript\:.*?[\"\']?/is', '#', $str);
        $str = htmlspecialchars($str, ENT_QUOTES, $GLOBALS['_APP']['charset']);
        return $str;
    }

    /**
     * 默认过滤
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function normal($str){
        return htmlspecialchars(self::loseTags($str), ENT_QUOTES, $GLOBALS['_APP']['charset']);
    }

    /**
     * 转换成整数
     *
     * @param unknown_type $str
     */
    public static function int($str){
        return intval($str);
    }

    /**
     * 转换成时间戳
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function timestamp($str){
        if(!is_numeric($str) && ($str = strtotime($str)) === false){
            $str = 0;
        }
        return $str;
    }

    /**
     * 原始数据
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function code($str){
        return htmlspecialchars(htmlspecialchars_decode(trim($str)), ENT_QUOTES , $GLOBALS['_APP']['charset']);
    }
    
    /**
     * 安全过滤
     *
     * @param unknown_type $str
     * @return unknown
     */
    public static function ult($str){
        return preg_replace('/(\s|\"|\#|\$|\%|\&|\'|\*|\+|\,|\.|\/|\;|\<|\=|\>|\@|\\\|\^|\`|\||\~)+/' , '' ,  self::text($str));
    }
}
?>