<?php
/**
 * 模块应用类
 * @copyright reginx.com
 * $Id: mod.class.php 112 2013-02-22 05:53:41Z reginx $
 */
class mod{

    /**
     * session object
     *
     * @var unknown_type
     */
    public $sobj = null;

    /**
     * module name
     *
     * @var unknown_type
     */
    public $mod = null;

    /**
     * action name
     *
     * @var unknown_type
     */
    public $act = null;

    /**
     * 配置信息
     *
     * @var unknown_type
     */
    public $conf = null;

    /**
     * 模板操作对象
     *
     * @var unknown_type
     */
    public $tpl = null;

    /**
     * 构造函数
     */
    function __construct(&$param){
        $this->conf = &$param;
        $this->mod  = $GLOBALS['_MOD'];
        $this->act  = $GLOBALS['_ACT'];
        $this->tpl  = &$GLOBALS['_TPL'];
        $this->tpl->assign('_MOD', $this->mod);
        $this->tpl->assign('_ACT', $this->act);
    }

    /**
     * 开启会话
     */
    public function opensess($conf = array()){
        if($this->sobj === null){
            $this->sobj = sess_extra::getobj(!empty($conf) ? $conf : $this->conf['sess']);
        }
    }

    /**
     * 设置模板风格
     */
    public function settpldir($dir = '' , $plu = false){
        if(substr($dir , -1) != '\\' || substr($dir , -1) != '/'){
            $dir .= '/';
        }
        if(!$plu){
            $this->conf['tpl'] = basename($dir);
            $this->conf['ctpl_url'] = $this->conf['curtpl_url'] = $this->conf['app_url'] . 'template/' . $dir;
            $this->conf['ctpl_url'] = $this->conf['curtpl_url'] = $this->conf['app_url'] . 'template/' . $this->conf['tpl'] . '/';
        }else{
            $this->conf['ctpl_url'] = $this->conf['curtpl_url'] = $this->conf['app_url'] . "data/plugin/{$dir}/template/";
        }
        $this->tpl->settpldir($dir , $plu);
    }

    /**
     * 获取参数
     *
     * @param unknown_type $k
     * @return unknown
     */
    public function get($k, $type = 'R'){
        return core::getgpc($k, $type);
    }

    /**
     * 是否存在参数
     *
     * @param unknown_type $k
     * @param unknown_type $type
     * @return boolean
     */
    public function has($k, $type = 'R'){
        return core::hasgpc($k, $type);
    }

    /**
     * 404 页面
     */
    public function show404($mod = false , $msg = ''){
        header('HTTP/1.1 404 Not Found');
        $this->setcurm($mod ? $mod : 'common');
        $this->assign('msg' , $msg);
        $this->display($this->conf['mod_404']);
    }

    /**
     * 输出消息
     *
     * @param Mixed $msg
     * @param String $url
     * @param Boolean $auto
     * @param Integer $time
     */
    public function showmsg($msg, $url = null, $auto = false, $time = 3){
        $url = empty($url) ? (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : $this->conf['app_url']) : $url;
        $this->setcurm('common');
        $this->assign("url", $url);
        $this->assign('msg', $msg);
        $this->assign('time', $auto ? $time : 0);
        $this->display($this->conf['mod_msg']);
    }

    /**
     * 设置当前模板缓存文件所属mod
     *
     * @abstract 防止重复生成404/msg模板缓存文件
     *
     * @param unknown_type $mod
     */
    private function setcurm($mod = false){
        $this->tpl->setcurm($mod);
    }

    /**
     * 模板变量赋值
     *
     * @param unknown_type $k
     * @param unknown_type $v
     */
    public function assign($k, $v){
        $this->tpl->assign($k, $v);
    }

    /**
     * 输出模板
     *
     * @param unknown_type $tplfile
     * @param unknown_type $style
     */
    public function display($tplfile, $doctype = 'text/html' , $cdbuf = true){
        $this->tpl->display($tplfile, $doctype , $cdbuf);
    }

    /**
     * 禁止客户端缓存当前页
     */
    public function nocache(){
        header("Last-Modified: " . gmdate("D, d M Y H:i:s", 0) . "GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
    }

    /**
     * 重定向
     *
     * @param unknown_type $url
     * @param unknown_type $parse
     */
    public function redirect($url, $parse = true){
        header("HTTP/1.1 303 See Other");
        header("Location: " . ($parse ? core::url($url) : $url));
        exit();
    }

    /**
     * 转发
     *
     * @param unknown_type $class
     * @param unknown_type $method
     */
    public function forward($class, $method, &$extra = array()){
        $class = $class . '_mod';
        if(empty($extra)){
            $extra = & $this->conf;
        }
        call_user_func(array(
                new $class($extra),
                $method . 'Act'
        ));
    }

    /**
     * Ajax输出
     *
     * @abstract 默认不缓存
     * @param unknown_type $data
     * @param unknown_type $type
     */
    function ajaxout($data, $type = 'json'){
        $this->nocache();
        if($type == 'json'){
            header('Content-Type: application/json; charset=utf-8');
            die(json_encode($data));
        }else{
            header('Content-Type: text/html; charset=utf-8');
            die($data);
        }
    }

    /**
     * 获取模板html
     *
     * @param unknown_type $tplFile
     * @return unknown
     */
    public function &fetchtpl($tplfile , $cdbuf = true){
        return $this->tpl->fetch($tplfile, $this->conf['charset'], 'text/html', false , $cdbuf);
    }

    /**
     * 设置是否开启输出缓冲
     * @param unknown_type $bool
     */
    public function setob($bool){
        $this->tpl->setob($bool);
    }

    /**
     * Token 验证
     */
    public function vtoken($ajax = false){
        // 是否开启了 token
        if(!$this->conf['token']){
            return true;
        }
        // 开启会话
        $this->opensess();
        if($this->sobj->has($this->conf['token_var'])){
            if($this->sobj->get($this->conf['token_var']) != $this->get($this->conf['token_var'], 'P')){
                if(!$ajax){
                    $this->showMsg('请求已失效!', $_SERVER['HTTP_REFERER'], 1, 3);
                }else{
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    /**
     * 清除表单令牌
     *
     * @return unknown
     */
    public function rmtoken(){
        if($this->conf['token']){
            $key = $this->conf['token_var'];
            $this->opensess();
            $this->sobj->del($key);
        }
    }

    /**
     * 验证提交的验证码是否正确
     *
     * @return unknown
     */
    public function vcode(){
        $this->opensess($this->conf['sess']);
        $ret = $this->sobj->get('verify') == md5(strtolower($this->get('verify', 'P')));
        $this->sobj->del('verify');
        return $ret;
    }
}
?>