<?php
/**
 * 插件基类
 * @copyright reginx.com
 * $Id$
 */
class plugin{
    
    /**
     * 插件信息
     *
     * @var unknown_type
     */
    public $info = array(
        'author'    => 'ReGinX.com', // - 作者
        'supurl'    => 'http://www.reginx.com', // - 插件官网
        'ver'       => '1.0', // - 插件版本
        'conf'      => true   // - 插件管理是否需要自定义配置
    );
    
    /**
     * 插件默认配置信息
     *
     * @var unknown_type
     */
    public $conf = array();

    /**
     * 显示名称
     *
     * @var unknown_type
     */
    public $name = null;

    /**
     * 模块对象
     *
     * @var unknown_type
     */
    protected $mod  = null;

    /**
     * 插件目录
     *
     * @var unknown_type
     */
    public $dir  = null;
    
    /**
     * 插件类型
     *
     * @var unknown_type
     */
    public $ctype = 0;
    
    /**
     * 钩子列表
     *
     * @var unknown_type
     */
    public $hooks = array();

    /**
     * 插件目录名
     *
     * @var unknown_type
     */
    public $code = null;
    
    /**
     * 架构函数
     *
     * @param unknown_type $mod
     */
    public function __construct(&$mod){
        $this->mod  = $mod;
        $this->code = str_replace('_plu' , '' , get_class($this));
        $this->dir = PLUGIN_PATH . $this->code . DIR_SEP;
    }

    /**
     * 安装检查
     *
     */
    protected  function chkinstall(){
        if(!is_file(DATA_PATH . $this->code . '.lock')){
            $this->mod->show404(1 , "{$this->name} 尚未安装!");
        }
    }
    
    /**
     * 获取插件信息
     *
     * @param unknown_type $exec
     * @return unknown
     */
    public function get($exec = 0){
        $ret = array();
        if($exec){
            $ret = OBJ("plugin_tab")->where("dir = '{$this->code}'")->get();
            if(!empty($ret)){
                $ret['extra'] = unserialize(base64_decode($ret['extra']));
            }
        }
        return $ret;
    }
    
    /**
     * 配置信息持久化
     *
     * @param mixed $data
     * @return boolean
     */
    public function sconf($data = array()){
        if(!empty($data)){
            $ret = OBJ("plugin_tab")->where("dir = '{$this->code}'")->set("extra" , base64_encode(serialize($data)))->save();
            return (int)$ret['code'] === 0;
        }
        return false;
    }

    /**
     * 安装
     *
     * @return unknown
     */
    public function install(){
        return true;
    }

    /**
     * 卸载
     *
     * @return unknown
     */
    public function uninstall(){
        return true;
    }

    /**
     * 管理
     *
     */
    public function cp(){}

    /**
     * 默认操作 
     *
     */
    public function index(){
        $this->mod->show404(1 , '该资源不存在!');
    }

    /**
     * 运行 Hook 
     *
     * @param unknown_type $ctype
     */
    public static final function runhook(){
        $param = func_get_args();
        $ctype = intval(array_shift($param));
        if(isset($GLOBALS['_APP']['hooks'][$ctype]) && !empty($GLOBALS['_APP']['hooks'][$ctype])){
            if(!defined('PLUGIN_EXEC')){
                define('PLUGIN_EXEC' , 1);
            }
            foreach ($GLOBALS['_APP']['hooks'][$ctype] as $k => $v){
                call_user_func_array(array(self::load($k) , $v ) , $param);
                // 播放插件只执行第一个
                if($ctype === 1){
                    break;
                }
            }
        }
    }

    /**
     * 加载插件文件
     *
     * @param unknown_type $dir
     */
    public static final  function load($dir){
        $dir  = str_replace('_plu' , '' , $dir);
        static $pobjlist = array();
        if(!isset($pobjlist[$dir])){
            $file = PLUGIN_PATH . $dir . '/' . $dir . '.plu.php';
            if(!is_file($file)){
                ERR(LANG('no-plugin-file' , $dir));
            }
            include_once($file);
            $clsname = $dir . '_plu';
            $pobjlist[$dir] = new $clsname($GLOBALS['_CURMOD']);
        }
        return $pobjlist[$dir];
    }


    /**
     * 加载插件类库
     *
     * @param unknown_type $dir
     * @param unknown_type $class
     * @param unknown_type $extra
     * @return unknown
     */
    public static final function lib( $class , $extra = array()){
        static $pliblist = array();
        $cls   = $class;
        $class = explode("_", $class);
        if(count($class) != 2){
            ERR(lang('no-class' , join('_' , $class)));
        }
        list($name , $ext) = $class;
        $file  = PLUGIN_PATH . $name . '/include' . DIR_SEP . "{$ext}" . DIR_SEP . "{$name}.{$ext}.php";
        
        if(!isset($pliblist[$cls])){
            if(!is_file($file)){
                ERR(LANG('no-plugin-file' , $cls));
            }
            include_once($file);
            if(!class_exists($cls , false)){
                ERR(LANG('no-class' , $cls));
            }
            $pliblist[$cls] = new $cls($extra);
        }
        return $pliblist[$cls];
    }

}
?>