<?php
/**
 * CLI 运行
 * @copyright reginx.com
 * $Id: cli.php 112 2013-02-22 05:53:41Z reginx $
 */
if(php_sapi_name() != 'cli'){
    die('Only run from command line');
}

phpversion() < 5.2  &&  exit("PHP版本最低要求:5.2");
class cli {
    /**
     * 核心变量
     *
     * @var unknown_type
     */
    private $_core = null;

    /**
     * 构造函数
     *
     * @param unknown_type $file
     */
    public function __construct($file , $argv){

        $GLOBALS['_MISC']['STIME'] = microtime(TRUE);

        /**
         * 加载运行所需文件
         */
        $this->init();

        /**
         * 生成核心对象
         */
        $GLOBALS['_CORE'] = $this->_core =  new core($file , include_once(BASE_PATH.'config/default.php'));

        array_shift($argv);
        if(!$argv){
            die("eg : php cli.php index-cli-id-2");
        }
        $str = array_shift($argv);
        if($str == ''){
            die("eg : php cli.php index-cli-id-2");
        }
        $str = explode('-' , $str);
        $GLOBALS['_MOD'] = empty($str) ? $GLOBALS['_APP']['default_mod'] : array_shift($str);
        $GLOBALS['_ACT'] = empty($str) ? $GLOBALS['_APP']['default_act'] : array_shift($str);
        $GLOBALS['_RG']  = $str;

        cli::exe($GLOBALS['_MOD'] , $GLOBALS['_ACT']);

    }

    public static function exe($mod , $act){
        $mod = $mod.'_mod';
        $act = $act.'Act';
        $GLOBALS['_CURMOD'] = new $mod($GLOBALS['_APP']);
        if(!method_exists($GLOBALS['_CURMOD'] , $act) && !method_exists($GLOBALS['_CURMOD'] , '__call')){
            die(core::L('not-found' , $act));
        }else{
            $GLOBALS['_CURMOD']->$act();
        }
    }

    /**
     * 初始化 加载运行类库文件
     *
     */
    private function init(){
        //ob_start();
        define('IS_CLI' , php_sapi_name() == 'cli');
        define('REGINX_VERSION' , '1.1.0');
        define('REGINX_RELEASE' , '20130922');
        define('REGINX_URL'     , 'http://www.reginx.com/');
        define('REGINX_PATH'    , dirname(__FILE__) . '/');
        define('CACHE_PATH'     , BASE_PATH . 'data/cache/');
        include_once(REGINX_PATH . 'class/mod.class.php');
        include_once(REGINX_PATH . 'class/core.class.php');
        include_once(REGINX_PATH . 'class/tab.class.php');
        include_once(REGINX_PATH . 'class/tpl.class.php');
        include_once(REGINX_PATH . 'class/filter.class.php');
        include_once(REGINX_PATH . 'class/block.class.php');
        include_once(REGINX_PATH . 'extra/db.extra.php');
        include_once(REGINX_PATH . 'extra/sess.extra.php');
        include_once(REGINX_PATH . 'extra/cache.extra.php');
        include_once(REGINX_PATH . 'extra/lang.extra.php');

        /**
         * autoload
         */
        if(function_exists('spl_autoload_register')){
            spl_autoload_register(array('core' , 'loader'));
        }else{
            function __autoload($class){
                return core::loader($class);
            }
        }
    }
}

?>